--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch  = true
    --初始图缩放大小
    self._scaleSize = 0.58
    --春联类型
    self._propIndex = 0
    --放置类型 1:春联 2:灯笼
    self._putType   = self:getScene()._putType
    --直接放春联
    self._test = self:getScene()._test
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载背景
    self:loadBg()
    -- 加载结点
    self:loadPageNode()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    if self._test then
        --游戏开始
        self:gameBegin()
    else
        --开门
        self._door:openDoor()
    end
end

--加载背景
function M:loadBg()
    local bg = U.loadNodeMask({
        contentSize = CCSize(V.w + 30, V.h + 30),
        color       = ccc3(218, 244, 254),
        opacity     = 255,
    }):pc():to(self, 1)
    --远景
    local bgNodeFar = U.loadNode():to(self, 2):bindTouch()
    self._bgNodeFar = bgNodeFar
    --中景
    local bgNodeMid = U.loadNode():to(self, 4):bindTouch()
    self._bgNodeMid = bgNodeMid
    --近景
    local bgNodeNear = U.loadNode():to(self, 6):bindTouch()
    self._bgNodeNear = bgNodeNear
    --超近景
    local bgNodeNear2 = U.loadNode():to(self, 8)--:bindTouch()
    self._bgNodeNear2 = bgNodeNear2
    --加载近景
    self:loadNearBg()
    --加载远景
    self:loadFarBg()
    --加载中景
    self:loadMidBg()
    --雪花
    Tools:loadSnows(self, 5, nil, 3)
    Tools:loadSnows(self, 10, nil)
end

--加载近景
function M:loadNearBg()
    local smallSize = 0.9
    local door = import("app.tfdoor.node.Door").new({
        layer  = self,
        parent = self._bgNodeNear,
        smallSize = 0.9,
        scaleSize = self._scaleSize
    }):to(self._bgNodeNear):p(V.w_2, 395):scale( self._scaleSize / smallSize):bindTouch()
    self._door = door
    --加载梅花
    self:loadFlower()
end

--加载梅花
function M:loadFlower()
    local flower1 = D.img("tfdoor/flower/1.png"):to(self._bgNodeNear2):p(980.2 + X_OFFSET * 2, 400.1):scale(self._scaleSize):anchor(cc.p(0.8,0.2))
    local flower2 = D.img("tfdoor/flower/2.png"):to(self._bgNodeNear2):p(1000.2 + X_OFFSET* 2, 500.1):scale(self._scaleSize):anchor(cc.p(0.9, 0.1))
    commonAct:breathing(flower1, self._scaleSize)
    commonAct:breathing(flower2, self._scaleSize)
end

--加载远景
function M:loadFarBg()
    --山
    local mountainPosTb = { cc.p(91.4, 415.3), cc.p(567.8, 461.2), cc.p(990.4, 447.3),}
    for i, v in ipairs(mountainPosTb) do
        local mountain = D.img("tfdoor/mountain/" .. i .. ".png"):to(self._bgNodeFar, 2):p(v):scale(self._scaleSize)
    end
end

--加载中景
function M:loadMidBg()
    local pointsL = {cc.p(156.6 + X_OFFSET, 416.8), cc.p(-30.0 + X_OFFSET, 406.9)} 
    for i, v in ipairs(pointsL) do
        local roomL = D.img("tfdoor/room/left/"..i..".png"):to(self._bgNodeMid,2):p(v):scale(self._scaleSize)
        if i==2 then
            commonAct:breathing(roomL, self._scaleSize)
        end
    end
    local pointsR = { cc.p(955 + X_OFFSET, 415.1), cc.p(838.8 + X_OFFSET, 402.3) }
    for i, v in ipairs(pointsR) do
        local roomR = D.img("tfdoor/room/right/" .. i .. ".png"):to(self._bgNodeMid):p(v):scale(self._scaleSize)
        if i == 1 then
            commonAct:breathing(roomR, self._scaleSize)
        end
    end
    --加载竹子
    local points = { cc.p(-26.2 + X_OFFSET, 300.1), cc.p(60 + X_OFFSET, 300.1) }
    local anchorTb = {cc.p(0.5, 0), cc.p(0.5, 0)}
    for i, v in ipairs(points) do
        local roomR = D.img("tfdoor/bamboo/" .. i .. ".png"):to(self._bgNodeMid,1):p(v):scale(self._scaleSize):anchor(anchorTb[i])
        commonAct:breathing(roomR, self._scaleSize, nil, 0.5)
    end
end

-- 加载结点
function M:loadPageNode()
    --加载递出的手
    self:loadHand()
    -- --加载道具
    -- self:loadProp()
    -- -- --加载爸爸
    -- self:loadDad()
    -- -- --加载妙妙
    -- self:loadMm()
    --加载妈妈
    self:loadMom()
    --加载奇奇
    self:loadQq()
end


--加载爸爸
function M:loadDad()
    local enterPos = cc.p(880 + X_OFFSET, 175)
    local dad = import("app.tfdoor.node.AniDad").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._bgNodeNear2,100):scale(0.8):p(enterPos.x, enterPos.y):flipX(true)
    self._dad = dad

    self._dad:breathAni()
end

--加载妙妙
function M:loadMm()
    local enterPos = cc.p(708 + X_OFFSET, 90)
    local mm  = import("app.tfdoor.node.AniMm").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._bgNodeNear2, 100):scale(0.8):p(enterPos.x, enterPos.y)
    self._mm = mm
end

--奇奇和妈妈进场
function M:qqAndMomEnter()
    -- 播放音效[sfx05703026]奇奇和妈妈进场
    soundEffect:playEffectsfx05703026()
    --走入屏幕
    self._mom:show():walkIntoScreen()
    self._qq:show():walkIntoScreen()
end

--加载妈妈
function M:loadMom()
    local enterPos = cc.p(73 + X_OFFSET, 175)
    local mom = import("app.tfdoor.node.AniMom").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._bgNodeNear2, 100):scale(0.8):p(enterPos.x - 450, enterPos.y):flipX(true):hide()
    self._mom = mom
end

--加载奇奇
function M:loadQq()
    local enterPos = cc.p(210 + X_OFFSET, 90)
    local qq = import("app.tfdoor.node.AniQq").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._bgNodeNear2, 100):scale(0.8):p(enterPos.x - 450, enterPos.y):flipX(true):hide()
    self._qq = qq
end

--走入屏幕
function M:walkIntoScreen()
    --走入屏幕
    self._dad:walkIntoScreen()
    self._mm:walkIntoScreen()
end

--游戏开始
function M:gameBegin()
    -- 镜头拉近
    self:zoomIn()
    --摸妙妙的头
    -- self._dad:touchMmHead()
end

--加载门粒子
function M:loadDoorParticle()
    local pos = cc.p(self._door:cw() / 2, self._door:ch() / 2 - 60)
    local particle = P.newParticle("particle/door_jili.plist"):p(pos):to(self._door, 110):scale(1/self._door:scale())
    Tools:insertParticleTb(self, particle)
end

--游戏结束激励
function M:gameEnd()
    self._particle = Tools:newParticle("particle/mm_bighappy.plist", V.w_2, V.h_2 + 200):to(self, 1000)
    Tools:insertParticleTb(self, self._particle)

    -- 播放音效[sfx05700013]全屏星星粒子
    soundEffect:playEffectsfx05700013()
    -- 播放音效[sfx05707013]奇妙欢呼（复用）
    soundEffect:playEffectsfx05707013()
    -- 播放音效[sfx05707012]爸妈欢呼（复用）
    soundEffect:playEffectsfx05707012()
    --激励
    self._qq:excitationAni()
    self._mm:excitationAni()
    self._dad:excitationAni()
    self._mom:excitationAni()

    self:line({
        {"Delay", 3},
        {"fn", function ()
            --进入下个场景
            self:enterNextScene()
        end}
    })
end

--加载下一道具
function M:loadNextProp()
    local maxRound = self._putType ~= 1 and 2 or 3
    if self._propIndex >= maxRound then
        if self._putType == 1 then
            self._putType = 2
            self._propIndex = 0
        else
            --镜头拉远
            self:zoomOut()
            return
        end
    end
    self._propIndex = self._propIndex + 1
    --加载道具
    self:loadProp()
end

--加载道具
function M:loadProp()
    if self._putType == 1 then
        --加载手上的春联
        self:loadHandCouplets()
    else
        --加载手上的灯笼
        self:loadHandLantern()
    end
end

--加载手上的春联
function M:loadHandCouplets()
    local size = 1.4
    local prop = import("app.tfdoor.node.Couplets").new({
        layer  = self,
        isHand = true,
        type   = self._propIndex,
        scaleSize = size
    }):to(self._hand, 999):scale(size)

    --获取手心中心点的位置
    local handPos = self._hand:getCenterPos()
    local offsetX = self._propIndex ~= 3 and 0 or 80
    local offsetY = self._propIndex ~= 3 and -110 or 25
    prop:p(handPos.x + offsetX, handPos.y + offsetY)


    self._hand._handThing = prop
    self._hand:enter(function ()
        --手指引导
        self._hand._handThing:handGuide()
    end)
end

--播放春联语音
function M:playCoupletsVoice()
    -- 播放配音[v057014]这叫上联
    -- 播放配音[v057015]这叫下联
    -- 播放配音[v057016]最后是横批哟
    local voiceTb = { "v057014", "v057015", "v057016",}
    soundVoice["playEffect" .. voiceTb[self._propIndex]](soundVoice)
end

--加载手上的灯笼
function M:loadHandLantern()
    local prop = import("app.tfdoor.node.HandLantern").new({
        layer  = self,
    }):to(self._hand, 999) 
    --获取手心中心点的位置
    local handPos = self._hand:getCenterPos()
    local offsetX = 0
    local offsetY = 85
    prop:p(handPos.x + offsetX, handPos.y + offsetY)

    self._hand._handThing = prop
    self._hand:enter(function ()
        --手指引导
        self._hand._handThing:handGuide()
    end)
end

--加载递出的手
function M:loadHand()
    local hand = import("app.common.node.BaseHand").new({
        layer = self,
    }):to(self, 998)
    self._hand = hand
end

--获取当前放置的位置
function M:getNowPutArea()
    local areaTb = {}
    if self._putType == 1 then
        local area = self._door._coupletsAreaTb[self._propIndex]
        table.insert(areaTb, area)
    else
        for k, area in pairs(self._door._lanternAreaTb) do
            if area._canPut then
                table.insert(areaTb, area)
            end
        end
    end
    return areaTb
end

--当前位置闪烁
function M:putAreaFlash()
    --获取当前放置的位置
    local areaTb = self:getNowPutArea()
    for k, area in pairs(areaTb) do
        --闪烁动画
        if not tolua.isnull(area) and not area._flashAction then
            area:show()
            local time2 = 0.7
            area._flashAction = A.cycle({
                { "fadeTo", time2, 255 },
                { "fadeTo", time2, 0 },
            }):at(area) 
        end
    end
end

--停止当前放置位置闪烁
function M:stopPutAreaFlash()
    --获取当前放置的位置
    local areaTb = self:getNowPutArea()
    for k, area in pairs(areaTb) do
        if not tolua.isnull(area) and area._flashAction then
            area:hide()
            area:opacity(0)
            area:stopAction(area._flashAction)
            area._flashAction = nil
        end
    end
end

--镜头拉近
function M:zoomIn()
    local time = 1
    self._door:line({
        { "union", {
            { "scaleto", time, 1 },
            { "moveto", time, cc.p(V.w_2, 370 + Y_OFFSET) }
        } },
        { "fn", function()
            --加载下一道具
            self:loadNextProp()
        end }
    })
    self._bgNodeMid:line({
        { "union", {
            { "scaleto", time, 1.2 },
            { "moveto", time, cc.p(-100, -120+ Y_OFFSET) }
        } }
    })
    self._bgNodeNear2:line({
        { "union", {
            { "scaleto", time, 1.3 },
            { "moveto", time, cc.p(300, -150+ Y_OFFSET) }
        } }
    })
end

--镜头拉远
function M:zoomOut()
    local time = 1
    self._door:line({
        { "union", {
            { "scaleto", time, self._scaleSize / 0.9 },
            { "moveto", time, cc.p(V.w_2, 395) }
        } },
        { "fn", function()
            --奇奇和妈妈进场
            self:qqAndMomEnter() 
        end }
    })
    self._bgNodeMid:line({
        { "union", {
            { "scaleto", time, 1 },
            { "moveto", time, cc.p(0, 0) }
        } }
    })
    self._bgNodeNear2:line({
        { "union", {
            { "scaleto", time, 1 },
            { "moveto", time, cc.p(0, 0) }
        } }
    })
end

--手指移动引导
function M:handeGuide(startPos, endPos, offsetX, offsetY, startCallBack, endCallBack)
    if self._isHandGuide or self._isOver then return end
    self._isHandGuide = true
    Tools:handMoveGuide(self, startPos, endPos, offsetX, offsetY, nil, startCallBack, endCallBack)
end

-- 移除手指移动引导
function M:removeHandGuide()
    if not self._isHandGuide then return end
    self._isHandGuide = false
    --移除手指移动引导
    Tools:removeHandMoveGuide(self)
end

--进入下个场景
function M:enterNextScene()
    umengOP.recordTFEnd()
    --增加完成的数目
    Tools:addDoneNum()
    game:enterScene("evekitchen", {}, "fade", 0.5, COLOR3_WHITE)
end

-- 加载其他
function M:loadRenderOtherwise()

end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)

end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
