--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 爸爸类
----------------------
local M     = class("AniDad", import("app.common.node.BaseDad"))
M.TAG       = "AniDad"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)

end

-- 正面走
function M:walkFrontAni()
    self:play("qmb_zou1")
end

-- 正常呼吸
function M:breathFrontAni()
    self:play("qmb_hx2")
end

--走入屏幕
function M:walkIntoScreen()
	-- 正面走
	self:walkFrontAni()
	self:line({
		{"delay", 0.5},
		{"fn", function ()
			self:z(20)
		end}
	})
    self:line({
		{"union", {
			{ "moveby", 1, cc.p(0, -50) },
			{ "scaleto", 1, 0.85 },
		}},
		{"fn", function ()
			--走路
			self:walkAni()
		end},
		{ "union", {
			{ "moveto", 2, self._enterPos },
			{ "scaleto", 1, 0.8/ self:getParent():scale()},
		} },
		{ "fn", function()
			Tools:resetParent(self,self._layer._bgNodeNear2, 100)
			self:flipX(true)
            -- 呼吸
			self:breathAni()
        end }
    })
end

--走入屏幕
function M:walkIntoScreen1()
	--走路
	self:walkAni()
	self:line({
		{"moveto", 2, self._enterPos},
		{"fn", function ()
			-- 呼吸
			self:breathAni()
		end}
	})
end

-- “真聪明，过年的时候，人们会在门上贴对联、贴福字、挂灯笼，预示新的一年红红火火。”
function M:talkEvent()
	-- 播放配音[v057013]真聪明，人们在大门贴对联、挂灯笼，为了新的一年呀 可以红红火火的
	soundVoice:playEffectv057013()
	-- 说话2（开始）
	self:talkAni2_1()
	local time1 = soundVoice:soundDuration("v057013", 7)/2
	local time2 = time1
	self:line({
		{ "delay", time1 },
		{ "fn", function()
			-- 说话2（结束）
			self:talkAni2_3()
		end },
		{ "delay", time2 },
		{ "fn", function()
			-- 说话2（结束）
			self:talkAni2_5()
		end },
	})
end

--隐藏扫把
function M:hideBroom()
	self._armature:getBone("cqmb_sb"):hide()
end

--摸妙妙的头
function M:touchMmHead()
	--隐藏扫把
	self:hideBroom()
	-- 摸头说话（开始）
	self:touchedTalkAni1()
	self._layer._mm:z(self:z()-1)
	self._layer._mm:flipX(true)
	-- 被摸（开始）
	self._layer._mm:beTouched1_1()
	local time = 2
	self:line({
		{"Delay", time},
		{"fn", function ()
			-- 摸头说话（结束）
			self:touchedTalkAni3()
			-- 被摸（结束）
			self._layer._mm:beTouched1_3()
		end}
	})
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "qmb_csh2" then
			-- 说话2（循环）
			self:talkAni2_2()
		elseif __moveId == "qmb_csh2_2" then
			-- 说话2（循环）
			self:talkAni2_4()
		elseif __moveId == "qmb_csh2_4" then
			-- 呼吸
			self:breathAni()
			--游戏开始
			self._layer:gameBegin()
		elseif __moveId == "qmb_csh3" then
   			-- 摸头说话（循环）
			self:touchedTalkAni2()
		elseif __moveId == "qmb_csh3_2" then
			self:play("qmb_chx2")
		elseif __moveId == "qmb_jl" then
			-- 呼吸
			self:breathAni()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
