--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
--妙妙类
----------------------
local M     = class("AniMm", import("app.common.node.BaseMm"))
M.TAG       = "AniMm"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(780 + X_OFFSET, 90))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	--换装
	self:changeClose()
	-- 正常呼吸
	self:breathFrontAni()
end

--换装
function M:changeClose()
	self._armature:getBone("cmm_wq"):hide()
end

-- 正面走
function M:walkFrontAni()
    self:play("mm_zou1")
end

-- 正常呼吸
function M:breathFrontAni()
    self:play("mm_hx2")
end

--走入屏幕
function M:walkIntoScreen()
    -- 正面走
    self:walkFrontAni()
    self:line({
        { "delay", 0.5 },
        { "fn", function()
            self:z(20)
        end }
    })
    self:line({
        { "union", {
            { "moveby", 1, cc.p(0, -45) },
            { "scaleto", 1, 0.85 },
        } },
		{ "fn", function()
			self:flipX(true)
            --走路
            self:walkAni()
        end },
        { "union", {
            { "moveto", 2, self._enterPos },
            { "scaleto", 1, 0.8 / self:getParent():scale() },
        } },
		{ "fn", function()
			Tools:resetParent(self, self._layer._bgNodeNear2, 100)
			self:flipX(false)
			--显示蝴蝶结
			self:showBowknotL()
			self:hideBowknotR()
            -- 呼吸
			self:breathAni()
			-- “我知道了，咱们的大门还是空着的！”
			self:talkEvent()
			-- self:getScene():getMainLayer()._mm:breathAni()
        end }
    })
end

--走入屏幕
function M:walkIntoScreen1()
	-- 走路
	self:walkAni()
	self:line({
		{ "moveto", 2, self._enterPos },
		{ "fn", function()
			-- 呼吸
			self:breathAni()
			-- “我知道了，咱们的大门还是空着的！”
			self:talkEvent()
		end }
	})
end

-- “我知道了，咱们的大门还是空着的！”
function M:talkEvent()
	-- 播放配音[v057011]我知道了，咱们的大门还是空着的！
	soundVoice:playEffectv057011()
	-- 开心说话（开始）
	self:talkAni3_1()
	local time = soundVoice:soundDuration("v057011", 4)
	self:line({
		{"delay",time},
		{"fn", function ()
			-- 开心说话（结束）
			self:talkAni3_3()
		end}
	})
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "mm_csh3" then
			-- 开心说话（循环）
			self:talkAni3_2()
		elseif  __moveId == "mm_csh3_2" then
			-- 眯眼呼吸
			self:breathWinkAni()
			-- “真聪明，过年的时候，人们会在门上贴对联、贴福字、挂灯笼，预示新的一年红红火火。”
			self._layer._dad:talkEvent()
		elseif __moveId == "mm_bm1" then
   			-- 被摸（循环）
			self:beTouched1_2()
		elseif __moveId == "mm_bm1_2" then
			-- 眯眼呼吸
			self:breathWinkAni()
		elseif __moveId == "mm_jl" then
			-- 眯眼呼吸
			self:breathWinkAni()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
