--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
--妈妈类
----------------------
local M     = class("AniMom", import("app.common.node.BaseMom"))
M.TAG       = "AniMom"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)

end

--走入屏幕
function M:walkIntoScreen()
	--走路拿着扫把
	self:walkBroomAni()
	self:line({
		{"moveto", 2, self._enterPos},
		{"fn", function ()
			--加载门粒子
			self._layer:loadDoorParticle()
			--看门
			self:watchDoorAni()
		end}
	})
end

--讲话事件 “今天咱们一家人都辛苦啦，尤其是两位宝贝！”
function M:talkEvent()
	-- 播放配音[v057018]今天咱们一家人都辛苦啦，尤其是两位宝贝！
	soundVoice:playEffectv057018()
	-- 对奇奇说话（开始）
	self:lookTalkAni1_1()
    local time = soundVoice:soundDuration("v057018", 4)
    self:line({
        { "delay", time },
        { "fn", function()
			-- 对奇奇说话（结束）
			self:lookTalkAni1_3()
        end }
    })
end


function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "qmm_km" then
			-- 呼吸（拿着扫把）
			self:breathBroomAni()
		elseif __moveId == "qmm_csh1" then
			-- 对奇奇说话（循环）
			self:lookTalkAni1_2()
		elseif __moveId == "qmm_csh1_2" then
			--激励
			-- self:excitationAni()
			--游戏结束激励
			self._layer:gameEnd()
		elseif __moveId == "qmm_jl" then
			-- 呼吸（拿着扫把）
			self:breathBroomAni()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
