--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 春联 类
----------------------
local M = class("Couplets", import("app.common.node.BaseNode"))
M.TAG       = "Couplets"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    -- 层
    self._layer = params.layer
    -- 父节点
    self._parent= params.parent
    -- 触控
    self._canTouch = false
    -- 对联类型 1、2为上联和下联  3为横批
    self._type = ifnil(params.type, 1)
    --遮罩初始偏移距离
    self._initOffset = 0
    --是否为手拿着的状态
    self._isHand     = ifnil(params.isHand, false)
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    local typeName = {"left", "right", "mid"}
    --房子主题
    self:display("tfdoor/couplets/"..typeName[self._type]..".png"):opacity(0)
end

-- 加载结点
function M:loadPageNode()
    --加载裁切
    self:loadClip()
    --加载触控区域
    self:loadTouchArea()
end

--加载触控区域
function M:loadTouchArea()
    if not self._isHand then return end
    local pos  = self._type ~= 3 and cc.p(32.5, 232.2) or cc.p(20.8, 32.2)
    local rect = self._type ~= 3 and CCSize(self: cw() + 5, 50) or CCSize(50, self:ch() + 5)
    local touchArea = U.loadMaskNode({ 
        contentSize = rect, 
        color       = ccc3(0, 0, 255) 
    }):to(self, 9999):p(pos):opacity(0)
    :bindTouch(
        {rectFactorX = 2,
        rectFactorY = 2,
    })
    self._touchArea = touchArea

    local this = self
    function touchArea:onTouchBegan(x, y, touches)
        return this:touchBeganEvent(x, y)
    end
    function touchArea:onTouchMoved(x, y, touches)
        this:touchMoveEvent(x, y) 
    end
    function touchArea:onTouchEnded(x, y, touches)
        this:touchEndEvent(x, y)
    end
end

--手指引导
function M:handGuide()
    local startPos = self._touchArea:worldpoint()
    local putArea = self._layer:getNowPutArea()
    local endPos = putArea[1]:worldpoint()
    local startHandler = function ()
        --获取当前放置的位置
        local areaTb = self._layer:getNowPutArea()
        for i, v in ipairs(areaTb) do
            v:line({
                {"show"},
                {"fadeTo", 0.3, 255}
            })
        end
    end
    local endHandler = function()
        --获取当前放置的位置
        local areaTb = self._layer:getNowPutArea()
        for i, v in ipairs(areaTb) do
            v:line({
                { "fadeTo", 0.3, 0 },
                { "hide" },
            })
        end
    end
    --手指移动引导
    self._layer:handeGuide(startPos, endPos, -5, -10, startHandler, endHandler)
end

--停止手指引导
function M:stopHandGuide()
    -- 移除手指移动引导
    self._layer:removeHandGuide()
    --获取当前放置的位置
    local areaTb = self._layer:getNowPutArea()
    for i, v in ipairs(areaTb) do
        v:stopAllActions():hide():opacity(0)
    end
end

function M:touchBeganEvent(x, y)
    if self._layer._canTouch then
        if self._canTouch then
            self._canTouch = false
            --停止手指引导
            self:stopHandGuide()
            --当前位置闪烁
            self._layer:putAreaFlash()
            --停止引导
            self:stopGuide()
            -- 缩放动作
            self:scaleAction()
            self._layer._hand:quit()
            local anchorNum = self._type ~= 3 and cc.p(1.1, 0.8) or cc.p(0.3, 0)
            Tools:changeAnchorP(self, anchorNum)
            -- Tools:adjustAnchor(self)
            return true
        end
    end
end

function M:touchMoveEvent(x, y)
    self:p(x, y)
    --判断离框框的距离
    self:judgeDis()
    if self._type == 3 then
        bb.si.Tool.limitRectMove({
            node = self,
            boundingRect = cc.rect(0, 0, 45, self:size().height + 5)
        })
        bb.si.Tool.limitButtonMove({node = self})
    else
        bb.si.Tool.limitRectMove({
            node = self,
            boundingRect = cc.rect(0, 210, self:size().width + 5, 45)
        })
        bb.si.Tool.limitButtonMove({node = self})
    end

end

function M:touchEndEvent(x, y)
    --判断是否贴到正确的位置
    self:judgeRight()
end

--判断离框框的距离
function M:judgeDis()
    local putAreaTb = self._layer:getNowPutArea()
    local pos = putAreaTb[1]:worldpoint()
    local dis = bb.UPoint.distance(self:point(), pos)
    local size = 1 + (dis / 700)
    size = size > self._scaleSize * 1.1 and self._scaleSize * 1.1 or size
    size = size < 1 and 1 or size
    self:scale(size)
end

--判断是否贴到正确的位置
function M:judgeRight()
    Tools:changeAnchorP(self, cc.p(0.5, 0.5))
    --停止当前放置位置闪烁
    self._layer:stopPutAreaFlash()
    local putAreaTb = self._layer:getNowPutArea()
    for i, putArea in pairs(putAreaTb) do
        local result = ND.detectCollision({ node1 = putArea, node2 = self._touchArea })
        if result then
            print("正确区域")
            --放置上去
            self:putOn(putArea)
            return
        end
    end
    self._layer._hand:enter()
    -- 回到手上
    self:goBack(self._handPos, function ()
        --手指引导
        self:handGuide()
    end)
end

--放置上去
function M:putOn(putArea)
    local pos = putArea:worldpoint()
    local size = 1
    self:line({
        { "union", {
            { "moveTo", 0.2, cc.p(pos.x, pos.y + 30) },
            { "scaleTo", 0.2, size * 1.1 },
        } },
        { "union", {
            { "easing", "backin", { "moveTo", 0.1, pos },},
            { "scaleTo", 0.1, size },
        } },
        {"remove"},
        {"fn", function ()
            --播放春联语音
            self._layer:playCoupletsVoice()
            -- 播放音效[sfx05703018]春联放到指定区域
            soundEffect:playEffectsfx05703018()
            putArea:hide()
            putArea._couplets:show()
            --春联预览动作
            putArea._couplets:previewAct()
        end}
    })
end

--加载裁切
function M:loadClip()
    self._initOffset = self._type ~= 3 and (self:ch() - 30) or (-self:cw() + 30)
    local rect = self._type ~= 3 and cc.rect(0, self._initOffset, self:cw(), self:ch() + 10) or cc.rect(self._initOffset, 0, self:cw(), self:ch() + 10)
    local clipping = CCNodeExtend.extend(cc.ClippingRectangleNode:create(rect)):to(self, 10)
    local typeName = { "left", "right", "mid" }
    local couplets = D.img("tfdoor/couplets/" .. typeName[self._type] .. ".png"):to(clipping):p(self:cw()/2, self:ch()/2)
    self._cliping  = clipping

    --加载春联那个把把
    self:loadHold()
end

--加载春联那个把把
function M:loadHold()
    local angle = self._type ~= 3 and 0 or -90
    local pos   = self._type ~= 3 and cc.p(33.3, self:ch() - 29) or cc.p(28, 33)
    local hold = import("app.tfdoor.node.CoupletsHold").new({
        layer  = self._layer,
        parent = self,
        type   = self._type,
    }):to(self, 20):anchor(cc.p(0.5, 0.34)):p(pos):rotate(angle)
    hold._initP = pos.y
    if self._type == 3 then
        hold._initP = pos.x
    end
    self._hold = hold
    --增加触控范围
    self._hold:expandTouchRange()
end

--春联预览动作
function M:previewAct()
    self._hold:previewAct()
end

--打开更新事件
function M:loadUpdateMove()
    self:scheduleUpdateWithPriorityLua(handler(self, self.updateMoveEvent) , 1)
end

--关闭更新事件
function M:closeIpdateMove()
    self:unscheduleUpdate()
end

--更新事件
function M:updateMoveEvent()
    local offset = self._type ~= 3 and (self._hold._initP - self._hold:py()) or (self._hold._initP - self._hold:px())
    --设置显示区域
    self:setShowRect(offset)
end


--设置显示区域
function M:setShowRect(offset)
    local newy    = self._type ~= 3 and (self._initOffset - offset)                 or (self._initOffset - offset)
    local newRect = self._type ~= 3 and cc.rect(0, newy, self:cw(), self:ch() + 10) or cc.rect(newy, 0, self:cw(), self:ch() + 10)
    self._cliping:setClippingRegion(newRect)
end

--最终动作
function M:finishAct()
    local offsetP1 = self._type ~= 3 and cc.p(0, 0) or cc.p(0, 0)
    local offsetP2 = self._type ~= 3 and cc.p(0, 0) or cc.p(0, 0)
    --停止音效
    self._hold:stopTouchEffect()
    -- 播放音效[sfx05703020]贴完一个春联
    soundEffect:playEffectsfx05703020()

    self:line({
        { "union", {
            { "moveby", 0.2, offsetP1 },
            { "easing", "BACKOUT", { "scaleto", 0.2, 1.15 },},
        } },
        { "union", {
            { "moveby", 0.1, offsetP2 },
            { "scaleto", 0.1, 0.95 },
        } },
        {"fn", function ()
            local name = self._type == 3 and "hengpi" or "duilian"
            local pos = self:worldpoint()
            local particle = Tools:newParticle("particle/"..name..".plist", pos.x, pos.y):to(self._layer, 100)
            Tools:insertParticleTb(self._layer, particle)
        end},
        { "scaleto", 0.1, 1.05 },
        { "scaleto", 0.1, 1 },
        { "fn", function ()
            --加载下一道具
            self._layer:loadNextProp()
        end}
    })
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    -- if self._layer._canTouch then
    --     if self._canTouch then
    --         return true
    --     end
    -- end
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
