--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 春联的那个把把 类
----------------------
local M     = classSpriteTouch("CoupletsHold")
M.TAG       = "CoupletsHold"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    -- 层
    self._layer    = params.layer
    -- 父节点
    self._parent   = params.parent
    -- 触控
    self._canTouch = false
    --当前帧
    self._imgIndex = 1
    --移动总距离
    self._moveCount= 0
    --是否结束
    self._isFinish = false
    -- 对联类型 1、2为上联和下联  3为横批
    self._type     = ifnil(params.type, 1)
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("tfdoor/couplets/hold/1.png")
end

--增加触控范围
function M:expandTouchRange()
    if self._type == 3 then
        self:bindTouch(
        {   rectFactorX = 1.5,
            rectFactorY = 1.5,
        })
    end
end

-- 加载结点
function M:loadPageNode()

end

--预览动作
function M:previewAct()
    --打开更新事件
    self._parent:loadUpdateMove()
    local offsetP = cc.p(0, -20)
    if self._type == 3 then
        offsetP = cc.p(10, 0)
    end
    self:line({
        { "easing", "sinein", { "moveby", 0.3,  offsetP}, },
        { "fn", function()
            self:openGuide()
            self._canTouch = true
        end}, 
        self:springback1(),
        { "fn", function ()
            --关闭更新事件
            self._parent:closeIpdateMove()
        end}
    })
end

--回弹
function M:springback1()
    local action = A.line({
        { "moveby", 0.1, cc.p(0, 6) },
        { "moveby", 0.1, cc.p(0, -6) },
        { "moveby", 0.1, cc.p(0, 4) },
        { "moveby", 0.1, cc.p(0, -4) },
        { "moveby", 0.05, cc.p(0, 2) },
        { "moveby", 0.05, cc.p(0, -2) },
    })
    if self._type == 3 then
        action = A.line({
            { "moveby", 0.1, cc.p(6, 0) },
            { "moveby", 0.1, cc.p(-6, 0) },
            { "moveby", 0.1, cc.p(4, 0) },
            { "moveby", 0.1, cc.p(-4, 0) },
            { "moveby", 0.05, cc.p(2, 0) },
            { "moveby", 0.05, cc.p(-2, 0) },
        })
    end
    return action
end

--延迟引导
function M:delayGuide()
    if self._delayGuideAct then return end
    self._delayGuideAct = A.line({
        { "Delay", 2 },
        { "fn", function()
            --开启引导
            self:openGuide()
        end }
    }):at(self)
end

--关闭延迟引导
function M:closeDelayGuide()
    if self._delayGuideAct then
        self:stopAction(self._delayGuideAct)
        self._delayGuideAct = nil
    end
end

--开启引导
function M:openGuide()
    if self._handGuideAct then return end
    local pos = self:worldpoint()
    self._guideStartP = self:point()
    local startP = cc.p(pos.x + 5, pos.y + 10)
    local endP = cc.p(pos.x + 5, pos.y - 50)
    local offsetX = 0
    local offsetY = -8
    local action = A.cycle({
        { "Delay", 0.3 },
        { "moveby", 0.5, cc.p(0, -10) },
        { "moveby", 0.1, cc.p(0, 10) },
        { "moveby", 0.1, cc.p(0, 6) },
        { "moveby", 0.1, cc.p(0, -6) },
        { "moveby", 0.1, cc.p(0, 4) },
        { "moveby", 0.1, cc.p(0, -4) },
        { "Delay", 1.5 },
    })
    if self._type == 3 then
        action = A.cycle({
            { "Delay", 0.3 },
            { "moveby", 0.5, cc.p(10, 0) },
            { "moveby", 0.1, cc.p(-10, 0) },
            { "moveby", 0.1, cc.p(6, 0) },
            { "moveby", 0.1, cc.p(-6, 0) },
            { "moveby", 0.1, cc.p(4, 0) },
            { "moveby", 0.1, cc.p(-4, 0) },
            { "Delay", 1.5 },
        })
        startP  = cc.p(pos.x, pos.y + 5)
        endP    = cc.p(pos.x + 30, pos.y + 5)
        offsetX = 0
        offsetY = -8
    end
    --手指移动引导
    self._layer:handeGuide(startP, endP, offsetX, offsetY)
    self._handGuideAct = action
    self:runAction(action)
end

--关闭引导
function M:closeGuide()
    -- 移除手指移动引导
    self._layer:removeHandGuide()
    if self._handGuideAct then
        self:stopAction(self._handGuideAct)
        self._handGuideAct = nil
        self:p(self._guideStartP)
    end
end


--判断是否切帧
function M:judgeChange(dis, type)
    local count = 30
    if self._type == 3 then
        count = 15
    end
    local index = math.ceil(dis / count)
    if index ~= self._imgIndex then
        if self._imgIndex <= 7 and self._imgIndex > 0 then
            if type == 1 then
                self._imgIndex = self._imgIndex + 1
            else
                self._imgIndex = self._imgIndex - 1
            end
            if self._imgIndex <= 0 then self._imgIndex = 1 end
            self:display("tfdoor/couplets/hold/" .. self._imgIndex .. ".png") 
            if self._imgIndex == 8 then
                --最终动作
                self:finishAct()
            end
        end
    end
end

--最终动作
function M:finishAct()
    --结束
    self._isFinish = true
    self:unbindTouch()
    --打开更新事件
    self._parent:loadUpdateMove()
    local pos = cc.p(self:px(), 0)
    if self._type == 3 then
        pos = cc.p(self._parent:cw(), self:py())
    end
    self:line({
        { "easing", "sinein", { "moveto", 0.2,  pos},},
        { "fn", function()
            --关闭更新事件
            self._parent:closeIpdateMove()
            --最终动作
            self._parent:finishAct()
            self:hide()
        end },
    })
end

--移动事件
function M:moveEvent(moveP)
    local play = true
    if self._type == 3 then
        local dis = moveP.x - self._touch.x
        local newDis = dis * 0.7
        local newX = self:px() + newDis
        self._touch = moveP

        if newX < (self._initP + 10) then
            play = false
        end
        newX = newX < (self._initP + 10) and (self._initP + 10) or newX
        newX = newX > (self._initP + 110) and (self._initP + 110) or newX
        local type = newDis > 0 and 1 or 2
        self:px(newX)
        --判断是否切帧
        self:judgeChange(newX - self._initP, type)
        self._parent:setShowRect(self._initP - newX)
    else
        local dis = moveP.y - self._touch.y
        local newDis = dis * 0.7
        local newY = self:py() + newDis
        self._touch = moveP

        if newY > (self._initP - 20) then
            play = false
        end
        newY = newY > (self._initP - 20) and (self._initP - 20) or newY
        newY = newY < (self._initP - 220) and (self._initP - 220) or newY
        local type = newDis < 0 and 1 or 2
        self:py(newY)
        --判断是否切帧
        self:judgeChange(self._initP - newY, type)
        self._parent:setShowRect(self._initP - newY) 
    end
end

--播放音效
function M:playTouchEffect()
    if self._effectAct then
        return
    end
    self._effectAct = A.line({
        {"fn", function ()
            -- 播放音效[sfx05703019]拖拽贴春联
            self._touchEffect = soundEffect:playEffectsfx05703019() 
        end},
        { "delay", 0.5 },
        {"fn", function ()
            self._effectAct = nil
        end}
    }):at(self)
end

--停止音效
function M:stopTouchEffect()
    if self._touchEffect then
        sound.stopSound(self._touchEffect)
        self._touchEffect = nil
    end
end


--加载触控区域
function M:loadTouchArea()
 
end

function M:touchBeganEvent(x, y)
    if self._isFinish then return end
    if self._canTouch then
        self._canTouch = false
        self._touch = cc.p(x, y)
        if self._touchEndP then
            self:p(self._touchEndP)
        end
        self:stopAllActions()
        --关闭延迟引导
        self:closeDelayGuide()
        --关闭引导
        self:closeGuide()
        self._isPlay = true
        return true
    end
end

function M:touchMoveEvent(x, y)
    if self._isFinish then return end
    --移动事件
    self:moveEvent(cc.p(x, y))
    if self._isPlay then
        self._isPlay = false
        --播放音效
        self:playTouchEffect()
    end
end

function M:touchEndEvent(x, y)
    if self._isFinish then return end
    self._canTouch = true
    self._touchEndP = self:point()
    --回弹
    self:runAction(self:springback1())
    --延迟引导
    self:delayGuide()
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    return self:touchBeganEvent(x, y)
end

function M:onTouchMoved(x, y, touches)
    self:touchMoveEvent(x, y)
end

function M:onTouchEnded(x, y, touches)
    self:touchEndEvent(x, y)
end



----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
