--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 大门 类 
----------------------
local M     = classSpriteTouch("Door")
M.TAG       = "Door"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer     = params.layer
    --触控
    self._canTouch  = false
    --父节点
    self._parent    = params.parent
    --缩小倍数
    self._scaleSize = ifnil(params.scaleSize, 0.58)
    --图片缩小倍数（超过2048， 缩小了0.9）
    self._smallSize = ifnil(params.smallSize, 0.9)
    --春联放置区域
    self._coupletsAreaTb = {}
    --灯笼放置区域
    self._lanternAreaTb = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    --房子主题
    self:display("tfdoor/door/base.png")
end

--加载结点
function M:loadPageNode()
    --加载屋顶雪
    self:loadSnow()
    --加载地面
    self:loadGround()
    --加载台阶
    self:loadSteps()
    --加载门框
    self:loadbox()
    --加载门
    self:loadDoor()
    --加载墙壁
    self:loadWall()
    --加载春联
    self:loadCouplets()
    --加载灯笼
    self:loadLantern()
end

--加载地面
function M:loadGround()
    --地面
    local ground = D.img("tfdoor/bg/ground.png"):to(self, -1)
    :scale(BG_SCALE / self._scaleSize):anchor(cc.p(0.5, 0.26)):p(self:cw() / 2, 45)
end

--加载台阶
function M:loadSteps()
    local steps = D.img("tfdoor/door/steps.png"):to(self, 10):p(self:cw() / 2 + 2, 27 - 7):scale(self._smallSize)
end

--加载门框
function M:loadbox()
    local box = D.img("tfdoor/door/box.png"):to(self, 5):p(self:cw() / 2 - 1, 210):scale(self._smallSize)
    local inside = D.img("tfdoor/door/inside.png"):to(self, 2):p(self:cw() / 2 - 1, 210):scale(self._smallSize)
end

--加载门
function M:loadDoor()
    local doorL = import("app.tfdoor.node.DoorPage").new({
        layer = self._layer,
        direction = "right"
    }):to(self, 4):p(302, 64.5):anchor(cc.p(0, 0)):scale(self._smallSize * 0.708)
    local doorR = import("app.tfdoor.node.DoorPage").new({
        layer = self._layer,
        direction = "left",
        pageImg  = "tfdoor/door/door2.png"
    }):to(self, 4):p(710, 64.5):anchor(cc.p(1, 0)):scale(self._smallSize * 0.708)
    self._doorL = doorL
    self._doorR = doorR

    --加载爸爸
    self:loadDad()
    --加载妙妙
    self:loadMm()
end

--加载屋顶雪
function M:loadSnow()
    local posTab = { ccp(285.3, 731), ccp(540.1, 728), ccp(671.1, 731.4), cc.p(326.8, 529.7)}
    for i, v in ipairs(posTab) do
        local snow = D.img("nyvisit/home1/snow/" .. i .. ".png"):to(self, 10):anchor(cc.p(0.5, 1)):p(posTab[i]):scale(1.3)
        snow._size = 1.3
        self:snowAct(snow)
    end
end

-- 雪的动作
function M:snowAct(node)
    local num = math.random(110, 120) / 100
    local time = 1.4
    self._snowAct = A.line({
        { "scaleTo", time, node._size, node._size * num },
        { "scaleTo", time, node._size },
        { "scaleTo", time, node._size, node._size * num },
        { "scaleTo", time, node._size },
        { "fn", function()
            return self:snowAct(node)
        end }
    }):at(node)
end

--加载爸爸
function M:loadDad()
    local enterPos = cc.p(1128.4, 72.5)
    local dad = import("app.tfdoor.node.AniDad").new({
        layer    = self._layer,
        enterPos = enterPos
    }):to(self, 3):scale(self._smallSize * 0.65):p(560, 230.5)
    self._dad = dad
    self._layer._dad = dad
    -- 正常呼吸
    self._dad:breathFrontAni()
end

--加载妙妙
function M:loadMm()
    local enterPos = cc.p(858.9, -59.9)
    local mm = import("app.tfdoor.node.AniMm").new({
        layer    = self._layer,
        enterPos = enterPos
    }):to(self, 3):scale(self._smallSize * 0.65):p(435, 181.5)
    self._mm = mm
    self._layer._mm = mm
    -- 正常呼吸
    self._mm:breathFrontAni()
end

--开门
function M:openDoor()
    self:line({
        { "delay", 0.5 },
        { "fn", function()
            self._dad:walkIntoScreen()
            self._mm:walkIntoScreen()
            --关门
            -- self:closeDoor()      
        end }
    })
    -- 播放音效[sfx05703030]大门打开爸妙走出
    soundEffect:playEffectsfx05703030()
    self._doorL:turnPage("open", function ()
        self:line({
            {"Delay", 0.2},
            {"fn", function ()
                --关门
                self:closeDoor()
            end}
        })
    end)
    self._doorR:turnPage("open")
end

--关门
function M:closeDoor()
    self._doorL:turnPage("close")
    self._doorR:turnPage("close")
end

--加载墙壁
function M:loadWall()
    local wallR = D.img("tfdoor/wall/wall.png"):to(self, -2):p(1164, 215):scale(self._smallSize)
    local snowR = D.img("tfdoor/wall/r_snow.png"):to(wallR):p(344, 379)
    local wallL = D.img("tfdoor/wall/wall.png"):to(self, -2):p(-127, 215):flipX(true):scale(self._smallSize)
    local snowL = D.img("tfdoor/wall/l_snow.png"):to(wallL):p(371, 376)
end

--加载春联
function M:loadCouplets()
    local points = {   cc.p(257, 219.5), cc.p(752.8, 219.5), cc.p(self:cw() / 2 - 2, 425.5)}
    -- local points = { cc.p(257, 219.5), cc.p(752.8, 219.5)}
    for i, v in ipairs(points) do
        -- 加载春联
        local couplets = import("app.tfdoor.node.Couplets").new({
            layer  = self._layer,
            parent = self._parent,
            type   = i
        }):to(self):p(v):hide()--

        --加载虚线框
        local imgIndex = i ~= 3 and 1 or 2
        local box = D.img("tfdoor/couplets/frame/" .. imgIndex .. ".png"):to(self):p(v):hide():opacity(0)
        box._couplets = couplets
        table.insert(self._coupletsAreaTb, box) 
    end
end

--加载灯笼
function M:loadLantern()
    local points = { cc.p(165.3, 484.1), cc.p(850, 484.1), }
    for i, v in ipairs(points) do
        local lantern = import("app.tfdoor.node.Lantern").new({
            layer  = self._layer,
            parent = self,
            type   = i
        }):to(self):p(v):hide()--

        --加载虚线框
        local box = D.img("tfdoor/lantern/frame.png"):to(self):p(v):anchor(cc.p(0.46, 0.98)):hide():opacity(0)
        box._lantern = lantern
        --是否可以放置
        box._canPut = true
        table.insert(self._lanternAreaTb, box)
    end
end



--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
