--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 手上的灯笼类
----------------------
local M     = class("HandLantern", import("app.common.node.BaseNode"))
M.TAG       = "HandLantern"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("tfdoor/lantern/hand.png"):anchor(cc.p(0.46, 0.98))
end

-- 加载结点
function M:loadPageNode()
    
end

--判断是否贴到正确的位置
function M:judgeRight()
    --停止当前放置位置闪烁
    self._layer:stopPutAreaFlash()
    local putAreaTb = self._layer:getNowPutArea()
    for i, putArea in pairs(putAreaTb) do
        local result = ND.detectCollision({ node1 = putArea, node2 = self })
        if result then
            print("正确区域")
            putArea._canPut = false
            --放置上去
            self:putOn(putArea)
            return
        end
    end
    self._layer._hand:enter()
    -- 回到手上
    self:goBack(self._handPos, function ()
        --手指引导
        self:handGuide()
    end)
end


--放置上去
function M:putOn(putArea)
    if self._layer._propIndex == 1 then
       -- 播放配音[v057012]大红灯笼高高挂！
        soundVoice:playEffectv057012() 
    end
    local pos = putArea:worldpoint()
    local size = 1
    self:line({
        { "union", {
            { "moveTo", 0.2, cc.p(pos.x, pos.y + 30) },
            { "scaleTo", 0.2, size * 1.1 },
        } },
        {"fn", function ()
            -- 播放音效[sfx05703021]放置灯笼
            soundEffect:playEffectsfx05703021()
        end},
        { "union", {
            { "easing", "backin", { "moveTo", 0.1, pos },},
            { "scaleTo", 0.1, size },
        } },
        {"remove"},
        {"fn", function ()
            putArea:hide()
            putArea._lantern:show()
            --灯笼预览动作
            putArea._lantern:previewAct()
        end}
    })
end

--手指引导
function M:handGuide()
    local startPos = self:worldpoint()
    startPos = cc.p(startPos.x, startPos.y - 50)
    local putArea = self._layer:getNowPutArea()
    local endPos = putArea[1]:worldpoint()
    endPos = cc.p(endPos.x, endPos.y - 80)
    local startHandler = function()
        --获取当前放置的位置
        local areaTb = self._layer:getNowPutArea()
        areaTb[1]:line({
            { "show" },
            { "fadeTo", 0.3, 255 }
        })
    end
    local endHandler = function()
        --获取当前放置的位置
        local areaTb = self._layer:getNowPutArea()
        areaTb[1]:line({
            { "fadeTo", 0.3, 0 },
            { "hide" },
        })
    end
    --手指移动引导
    self._layer:handeGuide(startPos, endPos, nil, nil, startHandler, endHandler)
end

--停止手指引导
function M:stopHandGuide()
    -- 移除手指移动引导
    self._layer:removeHandGuide()
    --获取当前放置的位置
    local areaTb = self._layer:getNowPutArea()
    for i, v in ipairs(areaTb) do
        v:stopAllActions():hide():opacity(0)
    end
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if self._layer._canTouch then
        if self._canTouch then
            self._canTouch = false
            --停止手指引导
            self:stopHandGuide()
            --当前位置闪烁
            self._layer:putAreaFlash()
            --停止引导
            self:stopGuide()
            -- 缩放动作
            self:scaleAction()
            self._layer._hand:quit()
            return true
        end
    end
end

function M:onTouchMoved(x, y, touches)
    local offsetX = -50
    local offsetY = 100
    self:p(x + offsetX, y + offsetY)
    bb.si.Tool.limitRectMove({
        node = self,
    -- marginTop = 0,
    -- boundingRect = cc.rect(20, 0, self:size().width - 40, self:size().height)
    })
    bb.si.Tool.limitButtonMove({node = self})
end

function M:onTouchEnded(x, y, touches)
    --判断是否贴到正确的位置
    self:judgeRight()
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
