--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 灯笼类
----------------------
local M     = class("Lantern", import("app.common.node.BaseNode"))
M.TAG       = "Lantern"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    --当前帧动画索引
    self._imgIndex = 1
    --是否可以移动
    self._canMove  = true
    --音效索引
    self._effectIndex = 0
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("tfdoor/lantern/ani/1.png"):anchor(cc.p(0.46, 0.98))
end

--预览动作
function M:previewAct()
    self:line({
        { "easing", "BACKOUT", { "scaleTo", 0.15, 0.9, 1.2 },},
        { "scaleTo", 0.15, 1.05, 0.9 },
        { "scaleTo", 0.1, 0.95, 1.1 },
        { "scaleTo", 0.1, 1.03, 0.95 },
        { "scaleTo", 0.1, 0.98, 1.05 },
        { "easing", "BACKOUT", { "scaleTo", 0.1, 1 } },
        { "fn", function ()
            self._canTouch = true
            --开启引导
            self:openGuide()
        end}
    })
end

-- 加载结点
function M:loadPageNode()

end

--延迟引导
function M:delayGuide()
    if self._delayGuideAct then return end
    self._delayGuideAct = A.line({
        {"Delay", 1},
        {"fn",function ()
            --开启引导
            self:openGuide()
        end}
    }):at(self)
end

--关闭延迟引导
function M:closeDelayGuide()
    if self._delayGuideAct then
        self:stopAction(self._delayGuideAct)
        self._delayGuideAct = nil
    end
end

--开启引导
function M:openGuide()
    if self._handGuideAct then return end
    local pos = self:worldpoint()
    local scaleSize = self:scaleY()
    self._scaleSize = scaleSize
    --手指移动引导
    self._layer:handeGuide(cc.p(pos.x + 5, pos.y - 50), cc.p(pos.x + 5, pos.y - 150), 0, -8)
    self._handGuideAct =A.cycle({
        { "Delay", 0.3 },
        { "scaleTo", 0.5, 1, scaleSize * 1.2 },
        { "fn", function()
            -- 播放音效[sfx05703021]放置灯笼
            -- soundEffect:playEffectsfx05703021()
        end },
        { "scaleTo", 0.1, 1, scaleSize * 0.95 },
        { "scaleTo", 0.1, 1, scaleSize * 1.1 },
        { "scaleTo", 0.1, 1, scaleSize * 0.95 },
        { "scaleTo", 0.1, 1, scaleSize * 1.05 },
        { "scaleTo", 0.1, 1, scaleSize * 1 },
        { "Delay", 1},
        { "fn", function()
        end }
    }):at(self)
end

--关闭引导
function M:closeGuide()
    -- 移除手指移动引导
    self._layer:removeHandGuide()
    if self._handGuideAct then
        self:stopAction(self._handGuideAct)
        self._handGuideAct = nil 
        self:scaleY(self._scaleSize)
    end
end

--移动事件
function M:moveEvent(moveP)
    local dis = moveP.y - self._touch.y
    local newDis = dis * 0.01
    local newY = self:scaleY() + math.abs(newDis)
    self._touch = moveP
    if not self._canMove then return end
    self:scaleY(newY)
    --判断是否切帧
    self:judgeChange(self:scaleY())
end

--判断是否切帧
function M:judgeChange(dis)
    if dis > 1.15 then
        self._imgIndex = self._imgIndex + 1
        self:display("tfdoor/lantern/ani/" .. self._imgIndex .. ".png")
        self:scaleY(1)
        --播放音效
        self:playTouchEffect()
        if self._imgIndex % 2 == 0 then
            self._canMove = false
            self:stopAllActions()
            self:line({
                { "scaleTo", 0.08, 1, 1.1 },
                { "scaleTo", 0.08, 1, 0.95 },
                { "scaleTo", 0.08, 1, 1.05 },
                { "scaleTo", 0.08, 1 },
                { "fn", function()
                    self._canMove = true
                end }
            })
        end
        if self._imgIndex == 8 then
            --结束
            self._isFinish = true
            self:unbindTouch()
            --最终动作
            self:finishAct()
        end
    end
end

--最终动作
function M:finishAct()
    -- 播放音效[sfx05703014]灯笼放置完粒子（复用）
    soundEffect:playEffectsfx05703014()
    -- 环绕粒子动作和显示
    self:loadSurroundPartile()
    self:line({
        { "scaleTo", 0.15, 0.9, 1.2 },
        { "scaleTo", 0.15, 1.1, 0.9 },
        { "scaleTo", 0.1, 0.95, 1.1 },
        { "scaleTo", 0.1, 1.05, 0.95 },
        { "scaleTo", 0.1, 0.98, 1.05 },
        { "easing", "BACKOUT", { "scaleTo", 0.1, 1 } },
        { "fn", function()
            --摇摆动作
            self:swingAction()
            --加载下一道具
            self._layer:loadNextProp()
        end }
    })
end

-- 环绕粒子动作和显示
function M:loadSurroundPartile()
    local iniPos = ccp(50, 0)
    local particle1 = P.newParticle("particle/huanraolizi.plist"):to(self, 999):p(iniPos):scale(1)
    Tools:insertParticleTb(self, particle1)
    -- -- 固定粒子位置
    particle1:setPositionType(kCCPositionTypeRelative)
    local center = ccp(50, 100)								-- 粒子环绕的中心位置
    local rot = 270											-- 初始角度
    local yOff = 0											-- y轴下降像素
    local time = 0.8											-- 环绕时间
    local frame = time * 60									-- 依据时间计算出多少帧
    local fRot = 1080 / frame 								-- 每一帧改变的角度
    local fYOff = 110 / frame 								-- 每一帧下降的高度
    particle1:line({
        A.cycle({
            { "fn", function()
                local a = rot > 180 and particle1:z(1) or particle1:z(-1)
                rot = (rot + fRot) % 360
                yOff = yOff - fYOff
                local xx = center.x + math.cos(math.rad(rot)) * 90
                local yy = center.y + 50 + math.sin(math.rad(rot)) + yOff
                particle1:p(xx, yy)
            end },
            { "delay", 1 / 60 },
        }, frame),
        { "fn", function()
            local pos = ccp(50, 100)   
            local particle = Tools:newParticle("particle/hengpi.plist", pos.x, pos.y):to(self, 999)
            Tools:insertParticleTb(self, particle)
            particle1:stopSystem()
        end },
    })
end

--摇摆动作
function M:swingAction()
    local num = math.random(5, 8)
    self._swingAct = A.line({
        { "rotateby", 0.8, -num },
        { "rotateby", 0.8, num },
        { "rotateby", 0.8, num },
        { "rotateby", 0.8, -num },
        { "fn", function ()
            return self:swingAction()
        end}
    }):at(self)
end

--停止摇摆动作
function M:stopSwingAction()
    if self._swingAct then
        self:stopAction(self._swingAct)
        self._swingAct = nil
        self:rotate(0)
    end
end

--播放音效
function M:playTouchEffect()
    self._effectIndex = self._effectIndex + 1
    if self._effectIndex > 3 then
        self._effectIndex = 1
    end
    local effectNameTb = {"fx05703022", "fx05703023", "fx05703024"}
    print("self._effectIndex", effectNameTb[self._effectIndex])
    soundEffect["playEffects"..effectNameTb[self._effectIndex]](soundEffect)
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if self._isFinish then return end
    if self._layer._canTouch then
        if self._canTouch then
            if self._scaleAct then
                self:stopAction(self._scaleAct)
                self._scaleAct = nil
            end
            --关闭延迟引导
            self:closeDelayGuide()
            --关闭引导
            self:closeGuide()
            --停止摇摆动作
            -- self:stopSwingAction()
            self._touch = cc.p(x, y)
            return true
        end
    end
end

function M:onTouchMoved(x, y, touches)
    if self._isFinish then return end
    --移动事件
    self:moveEvent(cc.p(x, y))
end

function M:onTouchEnded(x, y, touches)
    if self._isFinish then return end
    local size = self:scaleY()
    if self._canMove and not self._scaleAct then
        self._scaleAct = A.line({
            { "scaleTo", 0.08, 1, size * 1.1 },
            { "scaleTo", 0.08, 1, size * 0.95 },
            { "scaleTo", 0.08, 1, size * 1.05 },
            { "scaleTo", 0.08, 1, size },
            { "fn", function()
                self._scaleAct = nil
            end }
        }):at(self)
    end
    --延迟引导
    self:delayGuide()
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
