--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch = true
    -- 上个场景的点击商店
    self._kind = self:getScene()._kind 
    -- 上个场景到清单
    self._listTab = self:getScene()._listTab 
    -- 需要购买到表
    self._buyTab   = {}
    -- 需要购买到表
    self._buyTabGuide  = {}
    -- 摊车表
    self._stallTab = {}
    -- 商品表
    self._goodsTab = {}
    -- 影子表
    self._shadowTab   = {}
    -- 购买次数计数
    self._buyCount = 0
    -- 店铺名
    self._storeName = {"grocery", "lantern", "flower"}
    -- 记录两个以上相同等id
    self._equallyId = 0
    -- 随机数表
    self._numTab   = {} 
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载背景
    self:loadBg()
    -- 列表更新
    self:updateList()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 音效
    local sounds = soundEffect:playEffectsfx05702001()
    sound.setVolume(sounds, 0.5)
    self:goodGuide()
end

-- 商品引导
function M:goodGuide()
    if self._buyCount == 2 then return end
    for i, v in ipairs(self._goodsTab) do
        for j, k in ipairs(self._buyTabGuide) do
            if k == v._index then 
                self._goodsTab[i]:scale(1)
                guideFn:openGuide(self._goodsTab[i], 0.2, 3, 1, 0.15)
                return
            end
        end
    end
end

-- 结束引导
function M:stopGoodGuide()
    for i, v in ipairs(self._goodsTab) do
        -- self._goodsTab[i]:scale(1)
        guideFn:stopGuide(self._goodsTab[i])
    end
end

--加载背景
function M:loadBg()
    -- local test = D.img("222.png"):to(self, 999999):anchor(cc.p(0.5, 0)):p(V.w_2, 0):opacity(250)--:bindTouchLocate()
    -- local bg = U.loadBg("handbook/bg.png"):to(self)
end

-- 列表更新 
function M:updateList()
    local numTb1 = {1, 6, 10}
    local numTb2 = {5, 9, 13}
    local index = 1
    for i, v in ipairs(self._listTab) do
        if v >= numTb1[self._kind] and v <= numTb2[self._kind] then 
            index = i
            break
        end
    end
    local num1, num2 = self._listTab[1], self._listTab[2]
    if KIND_TB[self._kind] then return end
    self._listTab[1] = self._listTab[index]
    self._listTab[2] = self._listTab[index + 1]
    -- 需要购买到清单
    self._buyTab[1] = self._listTab[1]
    self._buyTab[2] = self._listTab[2]
    self._buyTabGuide[1] = self._listTab[1]
    self._buyTabGuide[2] = self._listTab[2]
    if self._kind == 2 and not KIND_TB[1] then 
        self._listTab[3] = num1 
        self._listTab[4] = num2
    elseif self._kind == 3 then
        if KIND_TB[2] and KIND_TB[1] then return end
        local num3, num4 = self._listTab[3], self._listTab[4]
        self._listTab[3] = num1 
        self._listTab[4] = num2
        if KIND_TB[1] or KIND_TB[2] then return end
        self._listTab[5] = num1 
        self._listTab[6] = num2
        if not KIND_TB[3] then 
            self._listTab[5] = num3 
            self._listTab[6] = num4
        end
    end
end

-- 完成时更新清单
function M:updateListFinish()
    BUY_COUNT = BUY_COUNT + 1
    local pos = {5, 3, 1}
    IS_BUYTB[pos[BUY_COUNT]] = true
    IS_BUYTB[pos[BUY_COUNT]+ 1] = true
    if KIND_TB[1] and KIND_TB[2] and KIND_TB[3] then return end
    local num1, num2 = self._listTab[5], self._listTab[6]
    self._listTab[5] = self._listTab[1]
    self._listTab[6] = self._listTab[2]
    self._listTab[1] = self._listTab[3]
    self._listTab[2] = self._listTab[4]
    self._listTab[3] = num1
    self._listTab[4] = num2
    KIND_TB[self._kind] = true
end

-- 加载结点
function M:loadPageNode()
    -- 加载背景
    self:loadBg()
    -- 加载店铺
    self:loadStore()
    -- 加载灯笼
    -- self:loadLantern()
    -- 加载商品
    self:loadGoods()
    -- 加载ui栏
    self:loadUi()
    -- 加载购物袋
    self:loadBag()
    -- 加载小摊老板
    self:loadBoss()
end

-- 加载背景
function M:loadBg()
    local bg = U.loadBg("tfgoodsbuy/bg.png"):to(self)--:bindTouch()
end

-- 切换场景
function M:changeScene(isBuying)
    self:getScene():getButtonLayer().btn_back:unbindTouch()
    isBuying = ifnil(isBuying, false)
    if not self._onceEnter then 
        game:enterScene("tfgoodswalk", {listTab = self._listTab, isFirst = false, shopId = self._kind, isBuying = isBuying}, "fade", 1, COLOR3_WHITE)
        self._onceEnter = true
    end
end

-- 加载店铺
function M:loadStore()
    local pos = {
        {ccp(635.0 + X_OFFSET, 150), ccp(542.7 + X_OFFSET, 630)},
        {ccp(550 + X_OFFSET, 160), ccp(542.7 + X_OFFSET, 695)},
        {ccp(550 + X_OFFSET, 160), ccp(542.7 + X_OFFSET, 620)},
    }
    local Store1 = D.img("tfgoodsbuy/"..self._storeName[self._kind].."/Store1.png"):to(self, 2):p(pos[self._kind][1])--:bindTouchLocate()
    local Store2 = D.img("tfgoodsbuy/"..self._storeName[self._kind].."/Store2.png"):to(self, 35):p(pos[self._kind][2])--:bindTouchLocate()
    table.insert(self._stallTab, Store1)
    table.insert(self._stallTab, Store2)
end

-- 加载灯笼
function M:loadLantern()
    local file = {"bone/dl2", "bone/dl4", "bone/dl2"}
    local armatureName = {"dl_bones1", "dl_bones", "dl_bones1"}
    local pos = {
        {ccp(174 + X_OFFSET, 335), ccp(927.0+ X_OFFSET, 335)}, {ccp(174 + X_OFFSET, 220), ccp(925+ X_OFFSET, 220)}, {ccp(180 + X_OFFSET, 280), ccp(925+ X_OFFSET, 280)},
        }
    for i = 1, 2 do 
        local lantern    = import("app.tfgoodsbuy.node.Lantern").new({
            file         = file[self._kind],
            armatureName = armatureName[self._kind],
            animName     = "dl_pd_1",    
            layer        = self,
        }):to(self, 30):p(pos[self._kind][i]):unbindTouch():scale(1.8)--:bindTouchLocate()
        self._lantern    = lantern  
    end
end

-- 加载商品
function M:loadGoods()
    if self._kind == 1 then 
        -- 加载杂货
        self:loadGrocery()
    elseif self._kind == 2 then 
        -- 加载鞭炮
        self:loadFirecrackers()
    elseif self._kind == 3 then 
        -- 加载花
        self:loadFlower()
    end
end

-- 加载杂货
function M:loadGrocery()
    local tierTab  = {5, 5, 3, 5, 5}
    local pos = {ccp(328.2 + X_OFFSET, 74.4), ccp(450+ X_OFFSET, 69.0), ccp(389.3 + X_OFFSET, 185), ccp(600 + X_OFFSET, 145), ccp(720 + X_OFFSET, 135)}
    local pos1 = {ccp(53, 2), ccp(54, 2), ccp(120, 0), ccp(52, 5), ccp(50, 5)}
    for i = 1, 5 do 
        local goods  = import("app.tfgoodsbuy.node.Goods").new({
            imgName  = "tfgoodsbuy/"..self._storeName[self._kind].."/"..i..".png",
            index    = i,
            layer    = self,
            buyTab   = self._buyTab
        }):to(self, tierTab[i]):p(pos[i]):unbindTouch():scale(1):bindTouch()
        table.insert(self._goodsTab, goods)
        local shadow = D.img("tfgoodsbuy/"..self._storeName[self._kind].."/"..i.."_1.png"):to(goods, -1):p(pos1[i])
        table.insert(self._shadowTab, shadow)
    end
    local box = D.img("tfgoodsbuy/grocery/box.png"):to(self, 4):p(663.6 + X_OFFSET, 115)--:bindTouchLocate()
    table.insert(self._goodsTab, box)
end

-- 加载鞭炮店铺
function M:loadFirecrackers()
    local pos = {ccp(265 + X_OFFSET, 200), ccp(492+ X_OFFSET, 130), ccp(655 + X_OFFSET, 140), 
                ccp(800 + X_OFFSET, 130), ccp(380 + X_OFFSET, 200), ccp(568 + X_OFFSET, 130)}
    local pos3 = {ccp(40, 65), ccp(42, 23), ccp(78, 55), ccp(0, 0), ccp(40, 65)}  
    for i = 6, 11 do 
        local num = i
        if i >= 10 then num = i - 4 end
        local goods  = import("app.tfgoodsbuy.node.Goods").new({
            imgName  = "tfgoodsbuy/"..self._storeName[self._kind].."/"..num..".png",
            index    = num,
            indexEx  = i,
            layer    = self,
            buyTab   = self._buyTab
        }):to(self, 15):p(pos[i - 5]):unbindTouch():scale(1):bindTouch():scale(1)
        table.insert(self._goodsTab, goods)
        if num ~= 6 then 
            local shadow = D.img("tfgoodsbuy/"..self._storeName[self._kind].."/"..num.."_1.png"):to(goods, -1):p(pos3[i - 6])
            table.insert(self._shadowTab, shadow)
        end
    end
    local pos1 = {ccp(262 + X_OFFSET, 173.7), ccp(377.4 + X_OFFSET, 173.7)}
    local pos2 = {ccp(576.1 + X_OFFSET, 123.8), ccp(574.7 + X_OFFSET, 85.5)}
    -- 加载两个架子
    for i = 1, 2 do 
        local shelf = D.img("tfgoodsbuy/lantern/shelf.png"):to(self, 10):p(pos1[i]):scale(1)
        table.insert(self._goodsTab, shelf)
    end
    -- 加载盒子
    for i = 1, 2 do 
        local box = D.img("tfgoodsbuy/lantern/box"..i..".png"):to(self, 10 * i):p(pos2[i]):scale(1.2)
    end
end

-- 加载花
function M:loadFlower()
    local pos = {ccp(328.2 + X_OFFSET, 185), ccp(450+ X_OFFSET, 160), ccp(590 + X_OFFSET, 116.7), ccp(750 + X_OFFSET, 116.7)}
    local pos1 = {ccp(60, 8), ccp(38, 6), ccp(72, 8), ccp(72, 8)}  
    for i = 10, 13 do 
        local index = i - 9
        local goods  = import("app.tfgoodsbuy.node.Goods").new({
            imgName  = "tfgoodsbuy/"..self._storeName[self._kind].."/"..i..".png",
            index    = i,
            layer    = self,
            buyTab   = self._buyTab
        }):to(self, 10):p(pos[i - 9]):unbindTouch():scale(1):bindTouch()
        table.insert(self._goodsTab, goods)
        local shadow = D.img("tfgoodsbuy/"..self._storeName[self._kind].."/shadow.png"):to(goods, -1):p(pos1[index])
        if index == 2 then shadow:scale(0.8) end
        table.insert(self._shadowTab, shadow)
    end
end

-- 加载ui栏
function M:loadUi()
    local ui = import("app.tfgoodsbuy.node.Ui").new({
        canClick   = false,
        layer      = self,
        time       = 0.25,
        isBuy      = true
    }):to(self, 200):p(15 + X_OFFSET, 10 + Y_OFFSET):bindTouch()
    self._ui = ui
    ui:setContentSize(cc.size(1, 1))
end

-- 加载购物袋
function M:loadBag()
    local bag = D.img("tfgoodsbuy/bag/bag.png"):to(self, 250):p(75 + X_OFFSET, 30):scale(1.1)--:bindTouchLocate()
    self._bag = bag
    local bagMask = D.img("tfgoodsbuy/bag/bagmask.png"):to(self, 350):p(75 + X_OFFSET, 30):scale(1.1)--:bindTouchLocate()
    self._bagMask = bagMask
end

-- 加载小摊老板
function M:loadBoss()
    local file = {"bone/gcj_tzx", "bone/gcj_tzf", "bone/gcj_tzm"}
    local armatureName = {"gxn_tzx", "gxn_tzf", "gcj_tzm"}
    local nodeName = {"Bear", "Penguin", "Cat"}
    local pos  = {ccp(576.7 + X_OFFSET, 220), ccp(652.0 + X_OFFSET, 261.7), ccp(654.5 + X_OFFSET, 225)} 
    local boss = import("app.tfgoodsbuy.node."..nodeName[self._kind]).new({
        file         = file[self._kind],
        armatureName = armatureName[self._kind],
        layer        = self,
    }):to(self):scale(0.8):p(pos[self._kind]):scale(0.9)--:bindTouchLocate()
    self._boss = boss
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
