--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("Cat")
M.TAG       = "Cat"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	-- 选对次数
	self._count = 0
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 吆喝1
	self:call1()
	-- 隐藏商品
	-- self:hideGood()
end

-- 隐藏商品
function M:hideGood()
	self:getBone(""):hide()
end

-- 呼吸
function M:breathe()
	self:play("mao_huxi")
end

-- 吆喝1
function M:call1()
	-- 播放配音
	soundVoice:playEffectv057035()
	self:play("mao_zhaohu_ks")
end

-- 吆喝1
function M:call1_1()
	self:play("mao_zhaohu_xh")
end

-- 吆喝1
function M:call1_2()
	self:play("mao_zhaohu_js")
end

-- 激励1 选对
function M:right()
	self._count = self._count + 1
	self:play("mao_jili")
end

-- 激励2 选错
function M:error()
	self:play("mao_jil2")
end

-- 激励3 告别
function M:bye()
	-- 播放配音
	soundVoice:playEffectv057036()
	self:play("mao_jil3")
end


function M:movementHandler(__evtType, __moveId)
	if __evtType == 1 then
		if __moveId == "mao_jili" then
			if self._count == 2 then 
				self:bye()
			else
				self:breathe()
			end
		elseif __moveId == "mao_zhaohu_ks" then 
			self:call1_1()
		elseif __moveId == "mao_zhaohu_ks" or "mao_jil2" then
			self:breathe()
		end
		if __moveId == "mao_jil3" then
			if device.language == "id" then
				A.line({
					{"delay", 2},
					{"fn", function ()
						self._layer:changeScene()
					end}
				}):at(self)
			else
				self._layer:changeScene()
			end
		end
	elseif __evtType == 2 then
		if __moveId == "mao_zhaohu_xh" then
			self:call1_2()
		end
	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    self._armature:getAnimation():setMovementEventCallFunc(function()
    end)
    A.stopTarget(self)
    sound.stopAllSounds()
end

return M
