--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Goods")
M.TAG       = "GoodsNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = true
    -- 点击到到商品种类
    self._index    = params.index
    -- 需要购买到清单
    self._buyTab   = params.buyTab 
    -- 店铺二需要用到
    self._indexEx  = params.indexEx
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    
end


-- 加载结点
function M:loadPageNode()
    
end

-- 拉拉链
function M:playSoundEffect()
    if not self._v057026  then
        -- 播放音效[sfx25601011]拉拉链
        self._v057026     = soundVoice:playEffectv057026()
        sound.setFinishCallback(self._v057026, function()
            self._v057026  = nil
        end)
    end
end

-- 不正确
function M:mistake()
    A.line({
        {"delay", 0.5},
        {"fn", function ()
            -- 播放配音
            self:playSoundEffect()
        end}
    }):at(self)
    -- 音效
    soundEffect:playEffectsfx05702006()
    -- 错误
    self._layer._boss:error()
    local offset = 0
    self:line({
        {"union", {
			{"jumpBy", .2, ccp(0, 50), 50, 1},
			{"scaleTo", .2, 1.1 - offset},
		}},
        {"rotateby" , 0.05  ,18},
        {"rotateby" , 0.05  ,-18},
        {"rotateby" , 0.05  ,-18},
        {"rotateby" , 0.05  ,18},
        {"rotateby" , 0.05  ,18},
        {"rotateby" , 0.05  ,-18},
        {"rotateby" , 0.05  ,-18},
        {"rotateby" , 0.05  ,18},
		{"union", {
			{"jumpBy", .2, ccp(0, -50), 50, 1},
			{"scaleTo", .2, 1 - offset},
        }},
        {"fn", function ()
            self:showShadow()
            -- 震动反馈
            self:shakeAct()
            self._layer:goodGuide()
        end},
		})
end

-- 震动反馈
function M:shakeAct()
    -- 小摊震动
    for i, v in ipairs(self._layer._stallTab) do
        A.line({
            {"scaleTo", .15, 1.003, .997},
            {"scaleTo", .15, .997, 1.003},
            {"scaleTo", .12, 1.002, .998},
            {"scaleTo", .12, .998, 1.002},
            {"scaleTo", .08, 1},
        }):at(v)
    end 
    -- 商品跳动
    for i, v in ipairs(self._layer._goodsTab) do
        local number = RD.number(1, 5)
        local time   = RD.number(5, 10) * 0.01
        A.line({
            {"moveBy", time, ccp(0,  number)},
            {"moveBy", time, ccp(0, -number)},
            {"fn", function ()
                commonAct:nodeScale(v, 0.1, 0.1)
            end}
        }):at(v)
    end 
    self._layer._canTouch = true
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
    T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 正确
function M:correct(index)
    local num = self:createRandom(2, self._layer._numTab)
    self._outTime = soundVoice:soundDuration("v057024", 2)
    A.line({
        {"delay", 0.5},
        {"fn", function ()
            if num == 1 then 
                -- 播放配音
                soundVoice:playEffectv057024()
            else
                self._outTime = soundVoice:soundDuration("v057025", 2)
                -- 播放配音
                soundVoice:playEffectv057025()
            end
        end}
    }):at(self)
    -- 音效
    soundEffect:playEffectsfx05702007()
    -- 正确
    -- self._layer._boss:right()
    local num = 1
    if self._index == 3 or self._index == 9 or self._index == 12 or self._index == 13 then num = 0.6 end
    self:z(300)
    self._layer._bag:display("tfgoodsbuy/bag/baging.png")
    self._layer._bagMask:display("tfgoodsbuy/bag/bagingmask.png")
    local antion = self:insertFlowerAct(num, num)
    --  加载粒子
    local particle = Tools:newParticle("particle/buy_tuowei.plist", 50, 20):to(self, 999)
    Tools:insertParticleTb(self, particle)
    A.line({
        {"union",{
            {"jumpTo", 0.7, ccp(75 + X_OFFSET, 100), 200, 1},
            {"scaleTo", 0.7, num},
        }},
        {"union",{
            {"moveBy", 0.1, ccp(0, -60)},
            antion,
            {"fn", function ()
                -- 结束事件
                self:fishEvent(index)
            end},
        }},
    }):at(self)
end

-- 结束事件
function M:fishEvent(index)
    self._canTouch = false
    T.removeOrder(self._layer._buyTabGuide, self._index)
    self._layer:goodGuide()
    -- ui栏表现
    self:uiShow(index)
    if self._layer._buyCount == 1 then 
        self._layer._canTouch = true
    end
    --  加载粒子
    local particle = P.newParticle("particle/buy_success.plist"):to(self._layer._bag, 999):p(100, 90):scale(1)
    Tools:insertParticleTb(self._layer, particle)
    self:bagAct(self._layer._bag)
    self:bagAct(self._layer._bagMask)
end

-- 袋子动作
function M:bagAct(node)
    -- 音效
    soundEffect:playEffectsfx05702008()
    A.line({
        {"scaleTo", 0.1, 1.15, 1.05},
        {"scaleTo", 0.1, 1.05, 1.15},
        {"scaleTo", 0.1, 1.1}
    }):at(node)
end

-- ui栏表现
function M:uiShow(index)
    self._layer._ui._scrollView:chagneShows(index)
    self._layer._buyCount = self._layer._buyCount + 1
    if self._layer._buyCount == 2 then 

        self:line({
            {"delay", self._outTime - 0.8},
            {"fn", function()
                self._layer._boss:bye()
                -- 完成时更新清单
                self._layer:updateListFinish()
            end}
        })
  
    end
end


-- 插入花的动作
function M:insertFlowerAct(scaleX, scaleY)
    local sizeX, sizeY = scaleX, scaleY 
    local angle = 0 
    local action = A.line({
        {"union", {
            {"jumpBy", 0.2, cc.p(0, 0), 10, 1},
            {"rotateTo", 0.1, angle + 3},
            {"line", {
                {"scaleTo", 0.1, sizeX * 0.95, sizeY * 1.05},
                {"scaleTo", 0.1, sizeX * 1.05, sizeY * 0.95},
            }}
        }},
        {"union", {
            { "jumpBy", 0.1, cc.p(0, 0), 5, 1},
            { "rotateTo", 0.05, angle - 2},
            { "scaleTo", 0.1, sizeX * 1},
        }},
        {"rotateTo", 0.05, angle + 2},
        {"rotateTo", 0.05, angle - 2},
        {"rotateTo", 0.04, angle + 2},
        {"rotateTo", 0.04, angle - 2},
        {"rotateTo", 0.03, angle + 1},
        {"rotateTo", 0.03, angle - 1},
        {"rotateTo", 0.02, angle + 0},
    })
    return action
end

-- 隐藏影子
function M:hideShadow()
    local index = self._index
    if self._layer._kind == 2 then 
        if index == 6 then return end
        index = self._index -  6
        if self._indexEx == 11 then index = 4 end
    elseif self._layer._kind == 3 then 
        index = self._index -  9
    end
    self._layer._shadowTab[index]:hide()
end

-- 显示影子
function M:showShadow()
    local index = self._index
    if self._layer._kind == 2 then 
        if index == 6 then return end
        index = self._index -  6
        if self._indexEx == 11 then index = 4 end
    elseif self._layer._kind == 3 then 
        index = self._index -  9
    end
    self._layer._shadowTab[index]:show()
end

-- 商品语音
function M:goodsSound(index)
    soundVoice:stopNowSound()
    self._v057026 = nil
    local indexTab = {"v057185", "v057184", "v057183", "v057186", "v057187", "v057188", "v057189",
                     "v057190", "v057191", "v057192", "v057193", "v057194", "v057195"}
    -- 播放配音
    soundVoice["playEffect"..indexTab[index]](soundVoice)
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._layer._canTouch then return end
    if not self._canTouch then return end
    -- 商品语音
    self:goodsSound(self._index)
    self._layer:stopGoodGuide()
    self:hideShadow()
    -- 音效[sfx05700004]
    soundEffect:playEffectsfx05700001()
    self._layer._canTouch = false
    if self._buyTab[1] == self._index and self._buyTab[1] ~= self._layer._equallyId then 
        -- 正确
        self:correct(1)
        self._layer._equallyId = self._buyTab[1]
    elseif self._buyTab[2] == self._index and self._buyTab[2] ~= self._layer._equallyId then
        -- 正确
        self:correct(2)
        self._layer._equallyId = self._buyTab[2]
    else 
        -- 不正确
        self:mistake()
    end
    self._layer._ui._scrollView.scrollView:onTouchEndedWithoutTap(x, y, -5)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end
    
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
