--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch = true
    -- 生成的随机数表
    self._listTab   = ifnil(self:getScene()._listTab, {1, 3, 6, 9, 10, 11})
    -- 是否第一次进入
    self._isFirst   = ifnil(self:getScene()._isFirst, true)
    -- 是否还在买年货
    self._isBuying  = ifnil(self:getScene()._isBuying, false)
    -- 商店Id
    self._shopId    = ifnil(self:getScene()._shopId, 4)
    -- 动物表
    self._animalTab = {}
    -- 摊主表
    self._bossTab   = {}
    -- 是否在移动
    self._isMove    = true
    -- 路人表
    self._passerTab = {}
    -- 出来对坐标
    self._outPos    = {
        {ccp(330 + X_OFFSET, 224.2), ccp(1065.7 + X_OFFSET, 224.2), ccp(1602.9 + X_OFFSET, 224.2), ccp(323 + X_OFFSET, 224.2)},
        {ccp(460 + X_OFFSET, 149.8), ccp(1207.4 + X_OFFSET, 149.8), ccp(1741.0 + X_OFFSET, 149.8), ccp(467 + X_OFFSET, 149.8)},
        {ccp(0, 0), ccp(-750 , 0), ccp(-1290, 0), ccp(0, 0)}
    }
    -- 奇奇待机是否打招呼
    self._isHello = false
    -- 随机音效表
    self._numTab = {}
    -- 店铺表格
    self._shopTab = {}
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载空节点 
    self:loadEmptynode()
    -- 加载背景
    self:loadBg()
    -- 加载左场景
    self:loadLeftScence()
    -- 加载右场景
    self:loadRightScence()
    -- 加载三个摊位
    self:loadShop()
    -- 加载场景中的动物
    self:loadAnimal()
    if self._isFirst then 
     
    else
        self._bgMove:beginStandby()
        self:loadUi()
        self._ui._scrollView:bindTouch()
    end

end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    if self._shopId == 4 then 
        -- 播放音效[057BGM04]办年货
        sound:play057BGM04()
    end
    self:gameBegin()
    -- 游戏结束
    -- self:gameOver()
    if KIND_TB[1] and KIND_TB[2] and KIND_TB[3] then
        -- 游戏结束
        self:gameOver()
    end
    if self._isFirst then 
        -- 前情“办年货咯！”
        self._qq:talkEvent()
    else
        -- 年货呼吸
        self._qq:breathAni4()
    end
    -- 买过的商铺不能再点击
    self:boughtShop()
end

-- 买过的商店不能在进入
function M:boughtShop()
    for i, v in ipairs(KIND_TB) do
        if v == true then 
            self._shopTab[i]._canTouch = false
            self._bossTab[i]._canBuy = true
        end
    end
end

-- 随机移动音效
function M:randomMoveSound()
    if not self._moveSound then 
        local num = self:createRandom(3, self._numTab)
        if num == 1 then 
            -- 音效
            self._moveSound = soundEffect:playEffectsfx05702003()
            sound.setFinishCallback(self._moveSound, function()
                self._moveSound = nil
            end)
        elseif num == 2 then
            -- 音效
            self._moveSound = soundEffect:playEffectsfx05702004()
            sound.setFinishCallback(self._moveSound, function()
                self._moveSound = nil
            end)
        elseif num == 3 then
            -- 音效
            self._moveSound = soundEffect:playEffectsfx05702005()
            sound.setFinishCallback(self._moveSound, function()
                self._moveSound = nil
            end)
        end
    end
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
    T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 待机打完一次招呼的间隔
function M:onceHellowLater()
    A.line({
        {"delay", 5},
        {"fn", function ()
            self._isHello = false
        end}
    }):at(self)
end

-- 游戏开始
function M:gameBegin()
    for i, v in ipairs(self._passerTab) do
        if i <= 3 then 
            v:walkRule()
            v._canTouch = true
        end
    end
end

-- 一次性弹动
function M:onceBounce()
    for i, v in ipairs(self._bgMove._btnTab) do
        A.line({
            {"delay", 0.5},
            {"scaleTo", 0.17, 1.1},
            {"scaleTo", 0.17, 0.85},
            {"scaleTo", 0.17, 1.1},
            {"scaleTo", 0.17, 0.85},
        }):at(v)
    end
end

-- 游戏结束
function M:gameOver()
    -- 关闭触控
    for i, v in ipairs(self._bgMove._btnTab) do
        v:unbindTouch()
    end
    self._bgMove:stopBeginStandby()
    self._ui._scrollView:unbindTouch()
    self._bgMove:unbindTouch()
    self._isMove = true
    -- 谢谢宝贝呀，东西都买完了，我们回家吧
    self._qq:flipX(false)
    self._mom:talkEvent1()
    self._canTouch = false
end 

-- 加载空节点
function M:loadEmptynode()
    local pos = ccp(0, 0)
    if not self._isFirst then 
        pos = self._outPos[3][self._shopId]
    end
    -- 加载一个空节点
    local node = U.loadNode({}):to(self):bindTouch():p(pos)--:bindTouchLocate()
    self._node = node
end


--加载背景
function M:loadBg()
    local bgMove = import("app.tfgoodswalk.node.BgMove").new({layer = self}):to(self._node, 200):bindTouch()
    -- 加载一个空节点
    local node1 = U.loadNode({}):to(self._node, 200):p(V.w, 0):unbindTouch()
    local plumTab = {"common/plum/1.png", "common/plum/2.png", "common/plum/3.png", "common/plum/4.png"}
    -- 下梅花
    Tools:loadSnows(bgMove, 999, nil, 8, nil, nil, plumTab)
    Tools:loadSnows(node1, 999, nil, 8, nil, nil, plumTab)
    self._bgMove = bgMove
    local bg1 = D.img("tfgoodswalk/bgleft.png"):to(self._node):anchor(ccp(0, 0)):scale(BG_SCALE):p(-50, 0)
    self._bg1 = bg1
    local bg2 = D.img("tfgoodswalk/bgright.png"):to(self._node):anchor(ccp(0, 0)):scale(BG_SCALE):p(bg1:cw()*BG_SCALE - 50, 0)
    self._bg2 = bg2
    local bg3 = D.img("tfgoodswalk/bgright1.png"):to(self._node):anchor(ccp(0, 0)):scale(BG_SCALE):p(bg1:cw()*BG_SCALE + bg2:cw()*BG_SCALE - 50, 0)
    self._bg3 = bg3
    -- 加载后景
    self:loadBack()
end

-- 加载后景
function M:loadBack()
    -- 加载天空颜色
    U.loadLayer({ color = ccc3(215, 254, 254)}):to(self._node, -1):scale(10)
    -- 加载第一屏
    local back1_1 = D.img("tfgoodswalk/back/1.png"):to(self._bg1, -1):p(-10, 424.3)--:bindTouchLocate()
    local back1_2 = D.img("tfgoodswalk/back/2.png"):to(self._bg1, -1):p(98.5, 340.0)--:bindTouchLocate()
    commonAct:breathing(back1_2)
    local back1_3 = D.img("tfgoodswalk/back/3.png"):to(self._bg1, -1):p(286.5, 422.2)--:bindTouchLocate()
    local back1_4_1 = D.img("tfgoodswalk/back/4_1.png"):to(self._bg1, -1):p(439.9, 322.2)--:bindTouchLocate()
    local back1_4_2 = D.img("tfgoodswalk/back/4_2.png"):to(self._bg1, -1):p(646.6, 322.2)--:bindTouchLocate()
    commonAct:breathing(back1_4_1)
    commonAct:breathing(back1_4_2)
    local back1_5 = D.img("tfgoodswalk/back/5.png"):to(self._bg1, -2):p(783.4, 431.3)--:bindTouchLocate()
    local back1_6 = D.img("tfgoodswalk/back/6.png"):to(self._bg1, -1):p(962.8, 371.5)--:bindTouchLocate()
    commonAct:breathing(back1_6)
    -- 加载第二屏
    local back2_1 = D.img("tfgoodswalk/back/7.png"):to(self._bg2, -1):p(87.4, 426.5)--:bindTouchLocate()
    local back2_2_1 = D.img("tfgoodswalk/back/4_1.png"):to(self._bg2, -1):p(472.1, 425.3)--:bindTouchLocate()
    local back2_2_2 = D.img("tfgoodswalk/back/4_2.png"):to(self._bg2, -1):p(256.0, 467.2)--:bindTouchLocate()
    local back2_3_1 = D.img("tfgoodswalk/back/4.png"):to(self._bg2, -1):p(353.9, 384.0)--:bindTouchLocate()
    local back2_3 = D.img("tfgoodswalk/back/8.png"):to(self._bg2, -1):p(680, 394.0)--:bindTouchLocate()
    commonAct:breathing(back2_2_1)
    commonAct:breathing(back2_2_2)
    commonAct:breathing(back2_3_1)
    local back2_4 = D.img("tfgoodswalk/back/7.png"):to(self._bg2, -1):p(841.5, 435.9)--:bindTouchLocate()
    local back2_4_1 = D.img("tfgoodswalk/back/4_1.png"):to(self._bg2, -1):p(912.9, 339.3)--:bindTouchLocate()
    local back2_4_2 = D.img("tfgoodswalk/back/4_2.png"):to(self._bg2, -1):p(792.4, 356.0):scale(0.7)--:bindTouchLocate()
    commonAct:breathing(back2_4_1)
    commonAct:breathing(back2_4_2)
    local back2_5 = D.img("tfgoodswalk/back/4.png"):to(self._bg2, -1):p(833.2, 350.1):scale(0.7)--:bindTouchLocate()
end

---------- 加载场景 --------------
-- 加载左场景
function M:loadLeftScence()
    -- 加载福栏
    local bar    = D.img("tfgoodswalk/scene/bar.png"):to(self._node, 10):p(120+ X_OFFSET, 323.2)
    -- 加载水果
    local fruits = D.img("tfgoodswalk/scene/fruits.png"):to(self._node, 10):p(345.6+ X_OFFSET, 358.6)--:bindTouchLocate()
    -- 加载石柱子
    local stone  = D.img("tfgoodswalk/scene/stone.png"):to(self._node, 10):p(255+ X_OFFSET, 250)
    -- 加载旗子
    local flag   = D.img("tfgoodswalk/scene/flag.png"):to(self._node, 10):p(393.7+ X_OFFSET, 362.1)--:bindTouchLocate()
    local flag_1   = D.img("tfgoodswalk/scene/flag_1.png"):to(self._node, 10):p(370+ X_OFFSET, 455):anchor(cc.p(0.5, 1))--:bindTouchLocate()
    self:swingAction(flag_1, 2, 3)
    -- 加载屋檐
    local eave   = D.img("tfgoodswalk/scene/eave.png"):to(self._node, 150):p(108.4+ X_OFFSET, 32.6)
    local eave1  = D.img("tfgoodswalk/scene/eave1.png"):to(self._node, 150):p(827.0+ X_OFFSET, -2.9)
end


--摇摆动作
function M:swingAction(node, min, max)
    min = min or 2
    max = max or 4
    local num = math.random(min, max)
    local time = math.random(8, 12)/10
    self._swingAct = A.line({
        {"rotateby", time, -num},
        {"rotateby", time, num},
        {"rotateby", time, num},
        {"rotateby", time, -num},
        {"fn", function ()
            return self:swingAction(node)
        end}
    }):at(node)
end

-- 旗子和春联的晃动
function M:flagAct(node)
    A.cycle({
        {"skewby", 1.0, -5, 5},
        {"skewby", 1.0, 5, -5},
    }):at(node)
end

-- 加载右场景
function M:loadRightScence()
    -- 加载背景的灯笼
    self:loadBackLantern()
    -- 加载旗子
    local flag    = D.img("tfgoodswalk/scene/flag1.png"):to(self._node, 10):p(1454.7 + X_OFFSET, 385.4):scale(1.25)
    local flag1_1   = D.img("tfgoodswalk/scene/flag1_1.png"):to(self._node, 10):p(1460.1 + X_OFFSET, 508.0):anchor(cc.p(0.5, 1))--:bindTouchLocate()
    self:swingAction(flag1_1)
    -- 加载小鞭炮
    local banger  = D.img("tfgoodswalk/scene/banger.png"):to(self._node, 10):p(1495.4 + X_OFFSET, 302.3)--:bindTouchLocate()
    -- 加载屋檐
    local eave2   = D.img("tfgoodswalk/scene/eave2.png"):to(self._node, 150):p(1772.4 + X_OFFSET, 16.6)
    -- 加载花瓶
    local flower  = D.img("tfgoodswalk/scene/flower.png"):to(self._node, 10):p(2012.3 + X_OFFSET, 319.2)--:bindTouchLocate()
    -- -- 加载一半的鞭炮摊
    local banger1 = D.img("tfgoodswalk/scene/banger1.png"):to(self._node, 10):p(2255 + X_OFFSET * 1.7, 220)
    -- 加载灯笼
    local dragon = DragonBone.addFileAndPlay("bone/dl2", "dl_bones1", "dl_pd_1", 0.9):to(self._node, 10):p(2185 + X_OFFSET * 1.7, 255):scale(0.8)
    local banger1_1 = D.img("tfgoodswalk/scene/banger1_1.png"):to(self._node, 10):p(2255 + X_OFFSET * 1.7, 375)
end

-- 加载背景的灯笼
function M:loadBackLantern()
    local pos = {ccp(799.3 + X_OFFSET, 457.6), ccp(1571.0 + X_OFFSET, 488.4), ccp(2053.1+ X_OFFSET, 496.5)}
    local pos1 = {ccp(144.2, 2.4), ccp(212.0, 3.2), ccp(276.7, 15.1), ccp(331.1, 32.4)}
    -- 加载灯笼
    for i = 1, 3 do
        local lantern = D.img("tfgoodswalk/scene/lantern.png"):to(self._node, 5):p(pos[i])--:bindTouchLocate()
        for j = 1, 4 do 
            local lanterns = D.img("tfgoodswalk/scene/lanterns.png"):to(lantern):anchor(cc.p(0.5, 0.8)):p(pos1[j])--:bindTouchLocate()
            self:swingAction(lanterns, 5, 8)
        end
    end
end

-- 加载三个店铺
function M:loadShop()
    local pos = {ccp(618.2+ X_OFFSET, 328.6), ccp(1175.6 + X_OFFSET, 327.1), ccp(1818.7 + X_OFFSET, 314.9)}
    local pos1 = {ccp(84.6, 191.1), ccp(334.2, 191.9), ccp(219.8, 188.6)}
    for i = 1, 3 do 
        local shop  = import("app.tfgoodswalk.node.Shop").new({
            imgName = "tfgoodswalk/scene/shop"..i..".png",
            index   = i,
            layer   = self,
        }):to(self._node, 100):p(pos[i]):bindTouch()
        if i == 1 then
            local pos = {ccp(55, 94), ccp(98, 94)}
            for j = 1, 2 do 
                local index = j + 1
                local snacks = D.img("tfgoodswalk/scene/shop1_"..index..".png"):to(shop):p(pos[j]):scale(0.9)
                local mask   = D.img("tfgoodswalk/scene/shop1_shadow.png"):to(snacks, -1):p(21 + 1.5 * (j - 1), 3 - 2 * (j - 1))
            end 
        end
        table.insert(self._shopTab, shop)
    end
end

---------- 加载场景 --------------

-------- 加载场景中的动物 --------- 
function M:loadAnimal()
    --加载妈妈
    self:loadMom()
    --加载奇奇
    self:loadQq()
    -- 加载摊主
    self:loadBoss()
    -- 加载路人
    self:loadPasser()
end

--加载妈妈
function M:loadMom()
    local enterPos = cc.p(323 + X_OFFSET, 224.2)
    if not self._isFirst then 
        enterPos = self._outPos[1][self._shopId]
    end
    local mom = import("app.tfgoodswalk.node.AniMom").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._node, 119):scale(0.8):p(enterPos.x , enterPos.y):flipX(true):scale(0.9)--:bindTouchLocate()--:unbindTouch()
    table.insert(self._animalTab, mom)
    self._mom = mom
end

--加载奇奇
function M:loadQq()
    local enterPos = cc.p(467 + X_OFFSET, 149.8)
    if not self._isFirst then 
        enterPos = self._outPos[2][self._shopId]
    end
    local qq = import("app.tfgoodswalk.node.AniQq").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._node, 120):scale(0.8):p(enterPos.x, enterPos.y):flipX(true):scale(0.9)--:bindTouchLocate()--:unbindTouch()
    table.insert(self._animalTab, qq)
    self._qq = qq
end

-- 加载摊主
function M:loadBoss()
    local file = {"bone/gcj_tzx", "bone/gcj_tzf", "bone/gcj_tzm"}
    local armatureName = {"gxn_tzx", "gxn_tzf", "gcj_tzm"}
    local nodeName = {"AniBear", "AniPenguin", "AniCat"}
    local pos  = {ccp(779.4 + X_OFFSET, 286.2), ccp(1430.7 + X_OFFSET, 269.7), ccp(1939.8 + X_OFFSET, 282.9)} 
    for i = 1, 3 do 
        local boss = import("app.tfgoodswalk.node."..nodeName[i]).new({
            file         = file[i],
            armatureName = armatureName[i],
            layer        = self,
        }):to(self._node, 110):scale(0.8):p(pos[i]):scale(0.5)--:bindTouchLocate()
        table.insert(self._bossTab, boss)
    end
end

-- 加载路人
function M:loadPasser()
    local file = {"bone/cj_nn", "bone/cj_tyy", "bone/cj_pp", "bone/cj_wc", } 
    local armatureName = {"cj_nn", "cj_tyy", "cj_pp", "cj_wc", "cj_wc"}
    local nodeName = {"AniNaoNao", "AniYiYi", "AniPiPi", "AniDog", }
    local pos = {ccp(1200 + X_OFFSET, 101.5), ccp(-300 + X_OFFSET, 270), ccp(1500 + X_OFFSET, 125), ccp(1200 + X_OFFSET, 70) }
    local indexTb = {135, 112, 130, 136}
    local scaleTb = {1.4, 0.8, 1, 1}
    for i = 1, 4 do
        local passer = import("app.tfgoodswalk.node."..nodeName[i]).new({
            file         = file[i],
            armatureName = armatureName[i],
            layer        = self,
            index        = 1
        }):to(self._node, indexTb[i]):scale(0.8):p(pos[i]):scale(scaleTb[i])--:bindTouchLocate()
        table.insert(self._passerTab, passer)
    end
end

-------- 加载场景中的动物 --------- 

-- 加载ui栏
function M:loadUi()
    if not self._isFirst and not self._isBuying then 
        -- 打开触控
        self._isMove    = false
        -- self._bgMove._canTouch = true 
    end
    local ui = import("app.tfgoodswalk.node.Ui").new({
        isFirst    = self._isFirst,
        layer      = self
    }):to(self, 200):p(15 + X_OFFSET / 3, 0 + Y_OFFSET):bindTouch()
    self._ui = ui
    ui:setContentSize(cc.size(1, 1))
end


-- 加载开场的菜单卷轴
function M:loadList()
    local list = self:createNode("List", {
        layer       = self,
        delayTime   = self._delayTime
    }):to(self, 300):p(0, 0):unbindTouch()--:bindTouchLocate()
    self._list = list
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return SIGN_TOUCH_BEGAN_NO_SWALLOWS
end

function M:onTouchMoved(x, y, touches)
     
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构

----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
