--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("AniBear")
M.TAG       = "AniBear"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer    = params.layer
	-- 是否可以点击
	self._canTouch = true
	-- 选对次数
	self._count    = 0
	self._standbyTab = {}
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:breathe()
	-- 待机动画
	self:standby()
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end

--  待机动画
function M:standby()
	if not self._standbyAct then
		self._standbyAct = A.cycle({
			{"fn", function ()
				-- 随机动作
				self:randomAct()
			end},
			{"delay", 5.5},
		}):at(self)
	end
end

-- 随机动作
function M:randomAct()
	local num = self:createRandom(3, self._standbyTab)
	if num == 1 then 
		self:call1()
	elseif num == 2 then 
		self:call2()
	elseif num == 3 then 
		self:speak1()
	end
end

-- 停止闲置
function M:stopStandby()
	if self._standbyAct then 
		self:stopAction(self._standbyAct)
		self._standbyAct = nil
	end
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
		T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 呼吸
function M:breathe()
	self:play("tzx_hx")
end

-- 说话1
function M:speak1()
	-- 播放配音
	local sounds = soundVoice:playEffectv057028()
	sound.setVolume(sounds, 0.4)
	self:play("tzx_sh1")
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057028", 5)
	A.line({
		{"delay", time},
		{"fn", function ()
			self:breathe()
			-- 待机动画
			self:standby()
			self._canTouch = true
		end}
	}):at(self)
end

-- 说话1
function M:speak2()
	self:play("tzx_sh2")
end

-- 吆喝1
function M:call1()
	self:play("tzx_zh1")
end

-- 吆喝2
function M:call2()
	self:play("tzx_zh2")
end

-- 激励1 选对
function M:right()
	self._count = self._count + 1
	self:play("tzx_dz")
end

-- 激励2 选错
function M:error()
	self:play("tzx_yt")
end

-- 激励3 告别
function M:bye()
	self:play("tzx_gb")
end


function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "tzx_dz"  then
			if self._count == 2 then 
				self:bye()
			else
				self:breathe()
			end
		elseif __moveId == "tzx_zh1" or "tzx_yt" or "tzx_zh2" then
			self:breathe()
			-- 待机动画
			self:standby()
			self._canTouch = true
		end
		if __moveId == "tzx_gb" then
			self._layer:changeScene()
		end
	elseif __evtType == 2 then
		if __moveId ==  "tzx_sh2" then
			self:breathe()
			-- 待机动画
			self:standby()
			self._canTouch = true
		end
	end
end




----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)
	if self._layer._isMove then return end
	if not self._canTouch then return end
	self._canTouch = false
	-- 随机动作
	self:randomAct()
	-- 停止待机动画
	self:stopStandby()
	if self._canBuy then return end
	self._layer._shopTab[1]:scale(1.1)
	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	if self._canBuy then return end
	self._layer._shopTab[1]:scale(1)
	if self._layer._isMove then return end
	self._layer._shopTab[1]:onTouchEnded()
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
