--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("AniMeiMei")
M.TAG       = "AniMeiMei"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer    = params.layer
	-- 选对次数
	self._count    = 0
	-- 人物移动距离
	self._offset   = -800
	--是否可以点击
	self._canTouch = false
	-- 计算打招呼次数
	self._count    = 0 
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:breathe()
	-- 移动定时器
	self:moveTime()
end

-- 移动定时器
function M:moveTime()
	A.cycle({
		{"delay", 1/60},
		{"fn", function ()
			if self:px() >= 2000 and not self._onceEnter then
				self._onceEnter = true 
				self:happyWalkEnd()
				self:stopWalkAct()
			end
		end}
	}):at(self)
end

-- 停止走路
function M:stopWalkAct()
	if self._walkAct then 
		self:stopAction(self._walkAct)
		self._walkAct = nil
	end
end

-- 走路规则
function M:walkRule(offset, time)
	if not self._walkAct then 
		time = time or 7
		offset = offset or -800
			self:happyWalk()
		if offset > 0 then 
			self:flipX(false)
		else
			self:flipX(true)
		end
		self._walkAct = A.line({
			{"moveBy", time, ccp(offset, 0)},
			{"fn", function ()
				self._onceEnter = false
				self:happyWalkEnd()
				self._walkAct = nil
			end}
		}):at(self)
	end
end

--  待机动画
function M:standby()
	A.cycle({
		{"delay", 3.5},
		{"fn", function ()
			local num = self:createRandom(4, self._standbyTab)
			if num == 1 then 
				self:call1()
			elseif num == 2 then 
				self:call2()
			elseif num == 3 then 
				self:speak1()
			elseif num == 4 then 
				self:speak2()
			end
		end}
	}):at(self)
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
		T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 呼吸
function M:breathe()
	self:play("mm_hx")
end

-- 待机东张西望
function M:standby1()
	self:play("mm_dj")
end

-- 开心走路
function M:happyWalk()
	self:play("mm_zl1")
end

-- 开心走路
function M:happyWalk1()
	self:play("mm_zl2")
end

-- 开心走路
function M:happyWalk2()
	self:play("mm_zl3")
end

-- 开心走路
function M:happyWalkEnd()
	self:play("mm_zl4")
end

-- 打招呼(开始)
function M:hello()
	self:play("mm_dzh1")
end

-- 打招呼(循环)
function M:hello1()
	self:play("mm_dzh2")
end

-- 打招呼(结束)
function M:hello2()
	self:play("mm_dzh3")
end

-- 移动限制
function M:moveLimit()
	if self:px() >= 2000 then 
		self._offset = -800
	elseif self:px() <= 400 then 
		self._offset = 800
	end
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "mm_zl1"  then
			local num = N.random(1, 2)
			if num == 1 then
				self:happyWalk1()
			else
				self:happyWalk2()
			end
		elseif __moveId == "mm_zl4" then
			self:standby1()
		elseif __moveId == "mm_dj" then
			-- 移动限制
			self:moveLimit()
			self:walkRule(self._offset)
		elseif __moveId == "mm_dzh1" then
			-- 循环打招呼
			self:hello1()
		elseif __moveId == "mm_dzh3" then
			self._canTouch = true
			self._layer._bgMove._canTouch = true
			-- 恢复奇奇和妈妈的动作
			self._layer._qq:breathAni4()
			self._layer._mom:breathGoodsAni()
			-- 移动限制
			self:moveLimit()
			self:walkRule(self._offset, 7)
		end
	elseif __evtType == 2 then
		if __moveId == "mm_dzh2" then
			-- 打招呼结束
			self:hello2()
			self._count = 0
		end
	end
end

----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)
	if not self._layer._canTouch then return end
	if self._layer._isMove then return end
	if not self._canTouch then return end
	local middlePos = self._layer._qq:px() - 67
	local direction = middlePos - self:px()
	local distance = math.abs(middlePos - self:px())
	if distance <= 400 then 
		if direction > 0 then 
			self:flipX(false)
			self._layer._qq:flipX(false)
			self._layer._mom:flipX(false)
		else
			self:flipX(true)
			self._layer._qq:flipX(true)
			self._layer._mom:flipX(true)
		end
		self._layer._qq:smile()
		self._layer._mom:smile()
		self:hello()
		self._canTouch = false
		self._layer._bgMove._canTouch = false
		if self._walkAct then 
			self:stopAction(self._walkAct)
			self._walkAct = nil
		end
	end
	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end
----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
