--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 基类
----------------------
local M     = class("AniMom", import("app.common.node.BaseMom"))
M.TAG       = "AniMom"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	self:breathGoodsAni()
	--隐藏扫把
	self:hideBroom()
end

--隐藏扫把
function M:hideBroom()
	self._armature:getBone("cqmm_tb"):hide()
end 

-- “奇奇，这是我们要买的东西（展示清单），能帮妈妈找到它们吗”
function M:talkEvent()
	-- 播放配音
	-- soundVoice:playEffectv057023()
	-- -- 获取时长
	local time = soundVoice:getVoiceTime("v057023", 3)
	self._layer._delayTime = time
	-- 对奇奇说话（开始）
	self:goodsTalkAni1_1()
    self:line({
        {"delay", time},
		{"fn", function()
			-- 对奇奇说话（结束）
			self:hearAni()
			-- -- “包在我身上！”
			-- self._layer._qq:talkEvent1()
        end}
    })
end

-- 谢谢宝贝呀，东西都买完了，我们回家吧
function M:talkEvent1()
	-- 播放配音
	soundVoice:playEffectv057027()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057027", 3)
	-- 买完之后说话（开始）
	self:afterBuyTalkAni1_1()
    self:line({
        {"delay", time},
		{"fn", function()
			-- 对奇奇说话（结束）
			self:hearAni()
			-- 嗯！（转场）爸爸和妙妙在忙什么呢？
			self._layer._qq:talkEvent2()
        end}
    })
end

-- 快回去给他们看看我们买的年货吧
function M:talkEvent2()
	-- 播放配音
	soundVoice:playEffectv057086()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057086", 3)
	-- 买完之后说话（开始）
	self:afterBuyTalkAni1_1()
    self:line({
        {"delay", time},
		{"fn", function()
			-- 对奇奇说话（结束）
			self:hearAni()
			
			-- 切换场景
			game:enterScene("tfroom", {}, "fade", 1, COLOR3_WHITE)
        end}
    })
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "qmm_csh4" then
			-- 对奇奇说话（循环）
			self:goodsTalkAni1_2()
		elseif __moveId == "qmm_csh4_2" then
			self:breathGoodsAni()
		elseif __moveId == "qmm_csh5" then
			-- 买完之后说话（循环）
			self:afterBuyTalkAni1_2()
		elseif __moveId == "qmm_csh5_2" then
			-- 呼吸
			self:breathGoodsAni()
		elseif __moveId == "qmm_dj0" then
			-- 呼吸
			self:breathGoodsAni()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
