--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("AniNaoNao")
M.TAG       = "AniNaoNao"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	-- 选对次数
	self._count = 0
	-- 人物移动距离
	self._offset = -1000
	--是否可以点击
	self._canTouch = false
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:breathe()
	-- 移动定时器
	self:moveTime()
end

-- 移动定时器
function M:moveTime()
	A.cycle({
		{"delay", 1/60},
		{"fn", function ()
			local middlePos = self._layer._qq:px() - 67
			local distance = math.abs(middlePos - self:px())
			if distance < 300 and distance > 100 then 
				if self._layer._bgMove._isLeave and not self._layer._isHello then 
					self._layer._isHello = true 
					self:onTouchBegan()
				end
			end 
			if self:px() >= 2000 and not self._onceEnter then
				self._onceEnter = true 
				self:happyWalkEnd()
				self:stopWalkAct()
			elseif self:px() < -100 and not self._onceEnter then
				self._onceEnter = true 
				self:happyWalkEnd()
				self:stopWalkAct()
			end
		end}
	}):at(self)
end



-- 停止走路
function M:stopWalkAct()
	if self._walkAct then 
		self:stopAction(self._walkAct)
		self._walkAct = nil
	end
end

-- 走路规则
function M:walkRule(offset, time)
	if not self._walkAct then 
		offset = offset or self._offset
		time = math.abs(offset) / 180
		self:happyWalk()
		if offset > 0 then 
			-- self:flipX(true)
			self:scaleX(-1.4)
		else
			-- self:flipX(false)
			self:scaleX(1.4)
		end
		self._walkAct = A.line({
			{"union",{
				{"moveBy", time, ccp(offset, 0)},
				{"line", {
					{"delay", 1},
					{"fn", function ()
						self._onceEnter = false
					end}
				}}
			}},
			{"fn", function ()
				self:happyWalkEnd()
				self._walkAct = nil
			end}
		}):at(self)
	end
end




--  待机动画
function M:standby()
	A.cycle({
		{"delay", 3.5},
		{"fn", function ()
			local num = self:createRandom(4, self._standbyTab)
			if num == 1 then 
				self:call1()
			elseif num == 2 then 
				self:call2()
			elseif num == 3 then 
				self:speak1()
			elseif num == 4 then 
				self:speak2()
			end
		end}
	}):at(self)
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
		T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 呼吸
function M:breathe()
	self:play("nn_hx")
end

-- 待机东张西望
function M:standby1()
	self:play("nn_dj")
end

-- 走路
function M:walk()
	self:play("nn_zl1")
end

-- 开心走路
function M:happyWalk()
	self:play("nn_kxzl1")
end

-- 开心走路
function M:happyWalk1()
	self:play("nn_kxzl2")
end

-- 开心走路
function M:happyWalk2()
	self:play("nn_kxzl3")
end

-- 开心走路
function M:happyWalkEnd()
	self:play("nn_kxzl4")
end

-- 打招呼(开始)
function M:hello()
	self:play("nn_dzh1")
end

-- 打招呼(循环)
function M:hello1()
	self:play("nn_dzh2")
end

-- 打招呼(结束)
function M:hello2()
	self:play("nn_dzh3")
end


-- 移动限制
function M:moveLimit()
	if self:px() >= 2000 then 
		self._offset = -1000
	elseif self:px() <= 400 then 
		self._offset = 1000
	end
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "nn_kxzl1"  then
			local num = N.random(1, 2)
			if num == 1 then
				self:happyWalk1()
			else
				self:happyWalk2()
			end
		elseif __moveId == "nn_kxzl4" then
			self:standby1()
		elseif __moveId == "nn_dj" then
			-- 移动限制
			self:moveLimit()
			self:walkRule()
		elseif __moveId == "nn_dzh1" then
			-- 循环打招呼
			self:hello1()
		
		elseif __moveId == "nn_dzh3" then
			self._layer._bgMove:beginStandby()
			-- 恢复是否可以继续打招呼
			self._layer:onceHellowLater()
			self._layer._ui._scrollView:bindTouch()
			self._canTouch = true
			self._layer._bgMove._canTouch = true
			-- 恢复奇奇和妈妈的动作
			self._layer._qq:breathAni4()
			self._layer._mom:breathGoodsAni()
			-- 移动限制
			self:moveLimit()
			self:walkRule()
		end
	elseif __evtType == 2 then
		if __moveId == "tzx_sh1" or "tzx_sh2" then
			if __moveId == "nn_dzh2" then
				-- 打招呼结束
				self:hello2()
			end
		end
	end
end



----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)
	if not self._layer._canTouch then return end
	if self._layer._isMove then return end
	if not self._canTouch then return end
	-- 停止待机
	self._layer._bgMove:stopBeginStandby()
	local middlePos = self._layer._qq:px() - 67
	local direction = middlePos - self:px()
	local distance = math.abs(middlePos - self:px())
	if distance <= 400 and distance >= 200 then 
		-- 音效
		soundEffect:playEffectsfx05702010()
		if direction > 0 then 
			self:scaleX(-1.4)
			self._layer._bgMove:setDirection(false)
		else
			self:scaleX(1.4)
			self._layer._bgMove:setDirection(true)
		end
		self._layer._ui._scrollView:unbindTouch()
		self._layer._qq:helloAni1_1()
		self._layer._mom:smile()
		self:hello()
		self._canTouch = false
		self._layer._bgMove._canTouch = false
		if self._walkAct then 
			self:stopAction(self._walkAct)
			self._walkAct = nil
		end
	end
	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end
----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
