--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("AniPenguin")
M.TAG       = "AniPenguin"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..





----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	-- 选对次数
	self._count = 0
	-- 待机表
	self._standbyTab = {}
	-- 是否可以点击
	self._canTouch   = true
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:breathe()
	-- 待机动画
	self:standby()
end


--  待机动画
function M:standby()
	if not self._standbyAct then
		self._standbyAct = A.cycle({
			{"fn", function ()
				-- 随机动作
				self:randomAct()
			end},
			{"delay", 5.5},
		}):at(self)
	end
end

-- 停止闲置
function M:stopStandby()
	if self._standbyAct then 
		self:stopAction(self._standbyAct)
		self._standbyAct = nil
	end
end

-- 随机动作
function M:randomAct()
	local num = self:createRandom(4, self._standbyTab)
	if num == 1 then 
		self:speak()
	elseif num == 2 then 
		self:call2()
	elseif num == 3 then 
		self:standby1()
	elseif num == 4 then 
		self:standby2()
	end
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
		T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 说话
function M:speak()
	self:play("tzf_sh1")
	-- 播放配音
	local sounds = soundVoice:playEffectv057031()
	sound.setVolume(sounds, 0.4)
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057031", 4)
	A.line({
		{"delay", time},
		{"fn", function ()
			self:play("tzf_sh3")
			-- 待机动画
			self:standby()
			self._canTouch = true
		end}
	}):at(self)

end

-- 待机1
function M:standby1()
	self:play("tzf_dj1")
end

-- 待机2
function M:standby2()
	self:play("tzf_dj2")
end

-- 呼吸
function M:breathe()
	self:play("tzf_hx")
end

-- 吆喝1
function M:call1()
	self:play("tzf_zh1")
end

-- 吆喝2
function M:call2()
	self:play("tzf_zh2")
end

-- 激励1 选对
function M:right()
	self._count = self._count + 1
	self:play("tzf_dz1")
end

-- 激励2 选错
function M:error()
	self:play("tzf_yt")
end

-- 激励3 告别
function M:bye()
	self:play("tzf_gb1")
end


function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "tzf_sh1" then
			self:play("tzf_sh2")
		elseif __moveId == "tzf_zh1" or "tzf_yt" or "tzf_sh3" or "tzf_dj1" or "tzf_dj2" then
			self:breathe()
			self._canTouch = true
			-- 待机
			self:standby()
		end
	elseif __evtType == 2 then
		if __moveId == "tzf_sh2" then
		end
	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)
	if self._layer._isMove then return end
	if not self._canTouch then return end
	self._canTouch = false
	-- 随机动作
	self:randomAct()
	-- 停止待机动画
	self:stopStandby()
	if self._canBuy then return end
	self._layer._shopTab[2]:scale(1.1)
	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	if self._canBuy then return end
	self._layer._shopTab[2]:scale(1)
	if self._layer._isMove then return end
	self._layer._shopTab[2]:onTouchEnded()
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
