--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 基类
----------------------
local M     = class("AniQq", import("app.common.node.BaseQq"))
M.TAG       = "AniDad"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 年货呼吸
	--隐藏桶
	self:hideBucket()
end

--隐藏桶
function M:hideBucket()
	self._armature:getBone("cqq_tong"):hide()
end

--呼吸（年货）
function M:breathAni4()
	self:play("qq_hx4")
end

-- 转身打招呼
function M:turnHello()
	self:play("qq_czb", 1.5)
end

--讲话事件 “办年货咯！”
function M:talkEvent()
	-- 播放配音
	soundVoice:playEffectv057019()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057019", 1.5)
	-- 看妈妈说话（开始）
	self:jumpTalkAni1_1()
	self:line({
		{"delay", time},
		{"fn", function()
			-- 看妈妈说话（结束）
			self:jumpTalkAni1_3()
		end}
	})
end

-- “包在我身上！”
function M:talkEvent1()
	-- 播放配音
	soundVoice:playEffectv057020()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057020", 2)
	-- 拍胸脯说（开始）
	self:clapTalkAni1_1()
	local time = 2
	self:line({
		{"delay", time},
		{"fn", function()
			-- 拍胸脯说（结束）
			self:clapTalkAni1_3()
			-- 呼吸
			self._layer._mom:goodsTalkAni1_3()
		end}
	})
end

-- 加载浮想款
function M:loadThinkBox()
    local thinkbox = D.img("common/thinkbox/4.png"):to(self, 200):p(130, 180):anchor(ccp(0, 0)):scale(0)--:bindTouchLocate()
    A.line({
        {"easing", "backOut", {"scaleTo", 0.5, 1}},
    }):at(thinkbox)
end

-- 嗯！（转场）爸爸和妙妙在忙什么呢？
function M:talkEvent2()
	-- 加载浮想款
	self:loadThinkBox()
	-- 播放配音
	soundVoice:playEffectv057021()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057021", 3)
	-- 问爸爸在干嘛说话（开始）
	self:askTalkAni1_1()
	self:line({
		{"delay", time},
		{"fn", function()
			-- 问爸爸在干嘛说话（结束）
			self:askTalkAni1_3()
			self._layer._mom:talkEvent2()
		end}
	})
end



function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "qq_tys1" then
			-- 跳起来说话（循环）
			self:jumpTalkAni1_2()
		elseif __moveId == "qq_tys1_2" then
			-- 听妈妈说话
			self:hearAni1_1()
			-- “奇奇，这是我们要买的东西（展示清单），能帮妈妈找到它们吗”
			self._layer._mom:talkEvent()
			-- 加载订单
			self._layer:loadList()
		elseif __moveId == "qq_yh1" then
			-- 听妈妈说话
			self:hearAni1_2()
		elseif __moveId == "qq_csh2" then
			-- 拍胸脯说（循环）
			self:clapTalkAni1_2()
		elseif __moveId == "qq_csh2_2" then
			-- 年货呼吸
			self:breathAni4()
		elseif __moveId == "qq_csh3" then
			-- 问爸爸在干嘛说话（循环）
			self:askTalkAni1_2()
		elseif __moveId == "qq_csh3_2" then
			-- 年货呼吸
			self:breathAni4()
			-- 切换场景
			-- game:enterScene("tfroom", {}, "fade", 1, COLOR3_WHITE)
		elseif __moveId == "qq_zs1" then
			self:helloAni1_2()
		elseif __moveId == "qq_czb" then
			self:play("qq_hs1")
		elseif __moveId == "qq_hs1" then
			self:play("qq_hs1_1", 1.5)
		elseif __moveId == "qq_hs1_2" then
			self:play("qq_bzc")
		elseif __moveId == "qq_zs1_3" or "qq_dj0" then
			-- 年货呼吸
			self:breathAni4()
		end
	elseif __evtType == 2 then
		if  __moveId == "qq_zs1_2" then
			self:helloAni1_4()
		elseif __moveId == "qq_hs1_1" then
			self:play("qq_hs1_2")
		end
	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
