--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("AniYiYi")
M.TAG       = "AniYiYi"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	-- 人物移动距离
	self._offset   = 600
	--是否可以点击
	self._canTouch = true
	-- 计算打招呼次数
	self._count    = 0 
	-- 随机数停摊位
	self._num      = N.random(1, 3)
	-- 是否在行走
	self._isWalk   = true
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:breathe()
	-- 移动定时器
	self:moveTime()
end

-- 移动定时器
function M:moveTime()
	A.cycle({
		{"delay", 1/60},
		{"fn", function ()
			if self:px() >= 600 and self:px() <= 605  and self._num == 1 and not self._onceEnter then
				self._onceEnter = true 
				-- 停下转到背面
				self:turnBack()
				self:stopWalkAct()
			elseif self:px() >= 1200 and self:px() <= 1205 and self._num == 2 and not self._onceEnter then
				self._onceEnter = true 
				-- 停下转到背面
				self:turnBack()
				self:stopWalkAct()
			elseif self:px() >= 1800 and self:px() <= 1805 and self._num == 3 and not self._onceEnter then
				self._onceEnter = true 
				-- 停下转到背面
				self:turnBack()
				self:stopWalkAct()
			elseif self:px() >= 2000 and not self._onceEnter then
				self._num = N.random(1, 3)
				self._onceEnter = true 
				self:happyWalkEnd()
				self:stopWalkAct()
			end
		end}
	}):at(self)
end

-- 停止走路
function M:stopWalkAct()
	if self._walkAct then 
		self:stopAction(self._walkAct)
		self._walkAct = nil
	end
end

-- 走路规则
function M:walkRule(offset, time)
	if not self._walkAct then 
		offset = offset or self._offset
		time = math.abs(offset) / 100
		self:happyWalk2()
		if offset > 0 then 
			self:flipX(true)
		else
			self:flipX(false)
		end
		self._walkAct = A.line({
			{"union",{
				{"moveBy", time, ccp(offset, 0)},
				{"line", {
					{"delay", 1},
					{"fn", function ()
						self._onceEnter = false
					end}
				}}
			}},
			{"fn", function ()
				self:happyWalkEnd()
				self._walkAct = nil
			end}
		}):at(self)
	end
end

--  待机动画
function M:standbyTime()
	local num = 0 
	if not self._standbyAct then 
		self._standbyAct = A.cycle({
			{"fn", function ()
				if num == 2 then 
					self:walkRule()
					if self._standbyAct then 
						self:stopAction(self._standbyAct)
						self._standbyAct = nil
					end
				else
					-- 待机（左右看看） 
					self:standby()
				end
				num = num + 1
			end},
			{"delay", 5},
		}):at(self)
	end
end

-- 停止待机动画
function M:stopstandbyAct()
	if not tolua.isnull(self._standbyAct) then
		self:stopAction(self._standbyAct)
		self._standbyAct = nil
	end
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
		T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 呼吸
function M:breathe()
	self:play("ctyy_hx")
end

-- 开心反馈
function M:happy()
	self:play("ctyy_guz")
end

-- 待机（左右看看）
function M:standby()
	self:play("btyy_dj1")
end

-- 开心走路
function M:happyWalk()
	self:play("ctyy_zl1")
end

-- 开心走路
function M:happyWalk1()
	self._isWalk = true
	self:play("ctyy_zl2")
end

-- 开心走路
function M:happyWalk2()
	self._isWalk = true
	self:play("ctyy_zl3")
end

-- 开心走路
function M:happyWalkEnd()
	self:play("ctyy_zl4")
end

-- 停下转到背面
function M:turnBack()
	self._isWalk = false
	self:play("ctyy_zhuan")
end

-- 背面呼吸
function M:breatheBack()
	self:play("btyy_hx")
end

-- 打招呼(开始)
function M:hello()
	self:play("ctyy_dzh1")
end

-- 打招呼(循环)
function M:hello1()
	-- 播放配音
	soundVoice:playEffectv057037()
	self:play("ctyy_dzh2")
end

-- 打招呼(结束)
function M:hello2()
	self:play("ctyy_dzh3")
end

-- 移动限制
function M:moveLimit()
	if self:px() >= 2000 then 
		self._offset = -600
	elseif self:px() <= 400 then 
		self._num = N.random(1, 3)
		self._offset = 600
	end
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "ctyy_zl4"  then
			self:moveLimit()
			self:walkRule()
			-- 停下转到背面
			-- self:turnBack()
		elseif __moveId == "ctyy_zhuan" then
			self._canTouch = true
			-- 背面呼吸
			self:breatheBack()
			-- 待机定时器
			self:standbyTime()
		elseif __moveId == "btyy_dj1" then 
			-- 背面呼吸
			self:breatheBack()
		elseif __moveId == "ctyy_dzh1" then
			-- 循环打招呼
			self:hello1()
		elseif __moveId == "ctyy_dzh3" then
			self._canTouch = true
			self._layer._bgMove._canTouch = true
			-- 恢复奇奇和妈妈的动作
			-- A.line({
			-- 	{"delay", 1.5},
			-- 	{"fn", function ()
			-- 		self._layer._qq:breathAni4()
			-- 	end}
			-- }):at(self)
			self._layer._ui._scrollView:bindTouch()
			self._layer._mom:breathGoodsAni()
			if self._isWalk then 
				self:walkRule()
			else
				-- 停下转到背面
				self:turnBack()
			end
		end
	elseif __evtType == 2 then
		if __moveId == "ctyy_dzh2" then
			self._count = self._count + 1
			if self._count == 3 then 
				-- 打招呼结束
				self:hello2()
				self._count = 0
			end
		end
	end
end




----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)
	if not self._layer._canTouch then return end
	if self._layer._isMove then return end
	if not self._canTouch then return end
	local middlePos = self._layer._qq:px() - 67
	local direction = middlePos - self:px()
	local distance = math.abs(middlePos - self:px())
	-- 停止待机
	self._layer._bgMove:stopBeginStandby()
	if distance <= 400 and distance >= 200 then 
		self:stopstandbyAct()
		if direction > 0 then 
			self:flipX(true)
			self._layer._bgMove:setDirection(false)
		else
			self:flipX(false)
			self._layer._bgMove:setDirection(true)
		end
		-- self._layer._qq:helloAni1_1()
		self._layer._ui._scrollView:unbindTouch()
		self._layer._qq:turnHello()
		self._layer._mom:smile()
		self:hello()
		self._canTouch = false
		self._layer._bgMove._canTouch = false
		if self._walkAct then 
			self:stopAction(self._walkAct)
			self._walkAct = nil
		end
	end
	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end
----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
