--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("BgMove")
M.TAG       = "BgMoveNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer      = params.layer
    --触控
    self._canTouch   = false
    -- 当前处于哪个屏幕
    self._tag        = 1
    -- 按钮表
    self._btnTab     = {}
    -- 按钮遮罩表
    self._btnMaskTab = {}
    -- 是否处于闲置
    self._isLeave    = false
    -- 是否移动过
    self._isMove     = false
    -- 是否碰到边界了
    self._isBoundary = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
    if self._layer._shopId <= 3 then 
        if KIND_TB[1] and KIND_TB[2] and KIND_TB[3] then return end
        -- 边界定时器
        self:borderTime()
    end
    if not self._layer._isFirst then 
        -- 边界定时器
        self:borderTime()
    end
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 边界定时器
function M:borderTime()
    A.cycle({
        {"delay", 1/60},
        {"fn", function ()
            self:btnCount()
            if self._layer._mom:px() <= 400 + X_OFFSET and  self._onceEnter1 then
                self._onceEnter1 = false
                self:btnHide(self._btnTab[1])
            elseif self._layer._mom:px() > 400 + X_OFFSET and not self._onceEnter1 then 
                self._onceEnter1 = true
                self:btnShow(self._btnTab[1])
            end
            if self._layer._mom:px() >= 1500 + X_OFFSET and self._onceEnter2 then
                self._onceEnter2 = false
                self:btnHide(self._btnTab[2])
            elseif self._layer._mom:px() < 1500 + X_OFFSET and not self._onceEnter2 then
                self._onceEnter2 = true
                self:btnShow(self._btnTab[2])
            end
        end}
    }):at(self)
end

-- 开始待机
function M:beginStandby()
    if not self._beginStandbyAct then 
        self._beginStandbyAct = A.line({
            {"delay", 4},
            {"fn", function ()
                self._layer._qq:standbyAni()
                self._layer._mom:standbyAni()
                self._layer:onceBounce()
            end},
            {"delay", 2},
            {"fn", function ()
                self._isLeave  = true
                self._beginStandbyAct = nil
            end}
        }):at(self)
    end
end

-- 停止待机
function M:stopBeginStandby()
    if self._beginStandbyAct then 
        self:stopAction(self._beginStandbyAct)
        self._beginStandbyAct = nil
    end
end


-- 按钮隐藏
function M:btnHide(node)
    A.line({
        {"union",{
            {"fadeout", 0.2},
            {"scaleTo", 0.2, 0}
        }},
        {"hide"}
    }):at(node)
end

-- 按钮显示
function M:btnShow(node)
    A.line({
        {"show"},
        {"union",{
            {"fadeTo", 0.2, 255},
            {"scaleTo", 0.2, 0.8}
        }},
    }):at(node)
end

-- 加载结点
function M:loadPageNode()
    -- 加载移动按钮
    local pos = {ccp(200 + X_OFFSET / 3, 245 + Y_OFFSET), ccp(905 + X_OFFSET * 1.5, 245 + Y_OFFSET)}
    local isFlipX = true
    for i = 1, 2 do 
        if i == 2 then isFlipX = false end
        local btn = D.img("tfgoodswalk/ui/btn.png"):to(self._layer):p(pos[i]):flipX(isFlipX):scale(0):hide()
        local btnMask = D.img("tfgoodswalk/ui/btnmask.png"):to(btn, -1):p(54, 53):scale(0.85)
        table.insert(self._btnTab, btn)
        table.insert(self._btnMaskTab, btnMask)
        self:bindNodeTouch(btn, i)
    end
    self:btnMaskAct()
end

-- 按钮遮罩动作
function M:btnMaskAct()
    for i, v in ipairs(self._btnMaskTab) do
        A.cycle({
            {"union",{
                {"fadeout", 0.8},
                {"scaleTo", 0.8, 1.1},
            }},
            {"scaleTo", 0.1, 0.85},
            {"fadein", 0.1},
        }):at(v)
    end
end


--  人物移动到摊位
function M:animalMove(index)
    -- 层级设置定时器
    local pos = {
        {ccp(480+ X_OFFSET, 280), ccp(1135.7 + X_OFFSET, 280), ccp(1642.9 + X_OFFSET, 280)},
        {ccp(610+ X_OFFSET, 226), ccp(1277.4 + X_OFFSET, 226), ccp(1781.0 + X_OFFSET, 226)}
        }
    local offset = self._layer._mom:px() - pos[1][index].x
    if self._layer._mom:px() >= pos[1][index].x or self._layer._qq:px() >= pos[2][index].x  then 
        self._layer._qq:flipX(false)
        self._layer._mom:flipX(false)
        self._layer._mom:showBowknotL()
    elseif self._layer._mom:px() <= pos[1][index].x or self._layer._qq:px() <= pos[2][index].x  then 
        self._layer._qq:flipX(true)
        self._layer._mom:flipX(true)
        self._layer._mom:showBowknotR()
    end
    -- 走路
    self:walk()
    local time = math.abs(offset) / 400 * 0.8
    if time < 0.8 then time = 0.8 end
    for i, v in ipairs(self._layer._animalTab) do
        A.line({
            {"union",{
                {"moveTo", time, pos[i][index]},
                {"scaleTo", time, 0.75},
            }},
            {"fn", function ()
                self:walkFinish()
                -- 切换场景
                self:changeScene(index)
            end}
        }):at(v)
    end
    -- 背景移动
    self:nodeMove(offset, time)
end

-- -- 层级设置定时器
function M:tierTiem()
    A.cycle({
        {"delay", 1/60},
        {"fn", function ()
            if self._layer._mom:py() >= 265 then 
                self._layer._mom:z(114)
            end
            if self._layer._qq:py() >= 205 then 
                self._layer._qq:z(114)
            end
        end}
    }):at(self)
end

-- 切换场景
function M:changeScene(index)
    game:enterScene("tfgoodsbuy", {kind = index, listTab = self._layer._listTab}, "fade", 1, COLOR3_WHITE)
end

-- 背景移动
function M:nodeMove(offset, time)
    A.line({
        {"union",{
            {"moveBy", time, ccp(offset, 0)},
        }},
    }):at(self._layer._node)
end

-------------------------------------绑定触控-------------------------------------------------

-- 按钮屏幕移动
function M:screenMove(tag)
    local pos = {ccp(0, 0), ccp(-640, 0), ccp(-1280, 0)}
    A.line({
        {"moveTo", 1, pos[tag]},
        {"fn", function ()
            self._layer._moveSound = nil
            self._canTouch = true
            self:beginStandby()
        end}
    }):at(self._layer._node)
end

-- 按钮人物移动
function M:figureMove(tag, node, index)
    self._layer._ui._scrollView:unbindTouch()
    self._layer._isMove = true
    self._canTouch = false
    local pos = {
        {ccp(467 + X_OFFSET, 149.8), ccp(1107 + X_OFFSET, 149.8), ccp(1747 + X_OFFSET, 149.8)},
        {ccp(323 + X_OFFSET, 224.2), ccp(963 + X_OFFSET, 224.2), ccp(1603 + X_OFFSET, 224.2)},
    }
    A.line({
        {"moveTo", 1, pos[index][tag]},
        {"fn", function ()
            self._layer._moveSound = nil
            -- 结束走路
            self:walkFinish()
            self._canEnter = false
            self._canTouch = true
            self._layer._isMove = false
            self._layer._ui._scrollView:bindTouch()
            self._layer._ui._scrollView.canClick = true
            self._layer._ui._scrollView.isClick = true
        end}
    }):at(node)
end

-- 按钮到屏幕计算
function M:btnCount()
    if self._layer._node:px() <= 0 and self._layer._node:px() > -453 then 
        self._tag = 1
    elseif self._layer._node:px() >= -906 and self._layer._node:px() < -453 then 
        self._tag = 2
    elseif self._layer._node:px() >= -1300 and self._layer._node:px() < -906 then 
        self._tag = 3
    end
end

-- 按钮反馈
function M:btnAct(node)
    A.line({
        {"scaleTo", 0.15, 0.9},
        {"scaleTo", 0.15, 0.8}
    }):at(node)
end

function M:touchEffect(node, index)
    local direction = -1
    if index == 2 then
        direction = 1
    end
    node:line({
        A.union({
            { "moveby", 0.1, ccp(-10 * direction, 0) },
            { "scaleTo", 0.1, 0.7, 1.1 },
        }),
        A.union({
            { "moveby", 0.2, ccp(50 * direction, 0) },
            { "fadeTo", 0.2, 50 },
            { "scaleTo", 0.2, 1.2, 0.5},
        }),
        A.union({
            { "easing", "backout", { "moveby", 0.3, ccp(-40 * direction, 0) } },
            { "fadeTo", 0.3, 255 },
            { "scaleTo", 0.3, 0.8},
        }),
    })
end

--按钮触控事件
function M:bindNodeTouch(btn, index)
    --绑定事件(父节点也需要绑定)
    btn:bindTouch()
    --得到self
    local this = self
    function btn:onTouchBegan(x, y, touches)
        if not this._canTouch then return end
        this:touchEffect(btn, index)
        -- 随机音效
        this._layer:randomMoveSound()
        -- 按钮反馈
        this:btnAct(self)
        this._layer._isMove = true
        this._canTouch = false
        if index == 1 then 
            this:setDirection(false)
            this._tag = this._tag - 1
            if this._tag <= 1 then this._tag = 1 end
        else
            this:setDirection(true)
            this._tag = this._tag + 1
            if this._tag >= 3 then this._tag = 3 end
        end
        this:walk()
        this:screenMove(this._tag)
        this:figureMove(this._tag, this._layer._qq, 1)
        this:figureMove(this._tag, this._layer._mom, 2)
        return true
    end
end
-------------------------------------绑定触控-------------------------------------------------

-- 奇奇移动
function M:qiqiMove(offset)
    self._layer._qq:p(self._layer._qq:px() - offset, self._layer._qq:py())
    if self._layer._qq:px() <= 464 + X_OFFSET then 
        self._layer._qq:px(464 + X_OFFSET)
    elseif self._layer._qq:px() >= 1750 + X_OFFSET then 
        self._layer._qq:px(1750 + X_OFFSET)
    end
end

-- 妈妈移动
function M:momMove(offset)
    self._layer._mom:p(self._layer._mom:px() - offset, self._layer._mom:py())
    if self._layer._mom:px() <= 320 + X_OFFSET then 
        self._layer._mom:px(320+ X_OFFSET)
    elseif self._layer._mom:px() >= 1605 + X_OFFSET then 
        self._layer._mom:px(1605 + X_OFFSET)
    end
end

-- 背景移动
function M:bgMove(offset, x, px, posx)
    local dis = 0
    if px >= 0   then
        dis = posx * 0.1
        dis = dis > 50 and 50 or dis
    elseif px <= -1280  then 
        dis = (posx - px) * 0.1
        dis = dis < -50 and -50 or dis
    else
        self._starX = x
    end
    px = px + dis
    self._layer._node:p(px, self._layer._node:py())
end

function M:backAct()
    if self._layer._node:px() >= 0 then
		self._layer._node:line({
			--出场动作
			{"easing","ELASTICOUT", {"moveTo", .8, ccp(0  , 0)}, .8},
		})
	elseif self._layer._node:px() <= -1280 then
		self._layer._node:line({
			--出场动作
			{"easing","ELASTICOUT", {"moveTo", .8, ccp(-1280, 0)}, .8},
		})
	end
end

-- 走路
function M:walk()
    if not self._canEnter then 
        self._canEnter = true
        -- 开始待机
        self:stopBeginStandby()
        self._isLeave  = false
        self._layer._qq:walkSeeAni()
        self._layer._mom:walkGoods()
    end
end

-- 结束走路
function M:walkFinish()
    self._layer._qq:breathAni4()
    self._layer._mom:breathGoodsAni()
end

-- 设置方向
function M:setDirection(type)
    self._layer._qq:flipX(type)
    self._layer._mom:flipX(type)
    if type then
        self._layer._mom:showBowknotL()
    else
        self._layer._mom:showBowknotR()
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    self:stopBeginStandby()
    self._starX = x
    --  触控有效
    return SIGN_TOUCH_BEGAN_NO_SWALLOWS
end

function M:onTouchMoved(x, y, touches)
    if not self._canTouch then return end
    local offset = x - self._starX 
    local posx = self._layer._node:px() + offset
    local px = cc.clampf(posx, -1280, 0)
    local num = math.abs(offset)
    if offset > 0 then 
        self:setDirection(false)
    else 
        self:setDirection(true)
    end
    if num > 3 then 
        -- 随机音效
        self._layer:randomMoveSound()
        self._layer._isMove = true
        self._isMove = true
         -- 走路动作
        self:walk()
        -- 奇奇移动
        self:qiqiMove(offset)
        -- 妈妈移动
        self:momMove(offset)
        -- 背景移动
        self:bgMove(offset, x, px, posx)
    end
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end
    self:beginStandby()
    -- 回弹动作
    self:backAct()
    if self._canEnter then 
        self:walkFinish()
        if not self._isMove then
            self._isMove = false
        else
            A.line({
                {"delay", 0.1},
                {"fn", function ()
                    self._layer._isMove = false
                end}
            }):at(self)
        end
    end
    self._canEnter = false
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
