--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("List")
M.TAG       = "ListNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --等待语音时长
    self._delayTime = ifnil(params.delayTime, 0)
    --触控
    self._canTouch = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end


-- 加载结点
function M:loadPageNode()
    -- 播放配音
	soundVoice:playEffectv057023()
    -- 生成清单
    self:createList()
    -- 加载遮罩
    self:loadMask()
    -- 加载卷轴                 
    self:loadScroll() 
    -- 加载clip              
    self:loadClip()                 
end

-- 生成清单
function M:createList()
    T.clear(self._layer._listTab)
    for i = 1, 6 do 
        local kind1, kind2 = 1, 5
        if i == 3 or i == 4 then 
            kind1 = 6
            kind2 = 9
        elseif i > 4 then 
            kind1 = 10
            kind2 = 13
        end
        local num1 = self:createRandom(kind1, kind2, 6, self._layer._listTab)
    end
end


-- 随机数
function M:createRandom(kind1, kind2, index, randomTab)
    if #randomTab == index then 
    T.clear(randomTab)
    end
    local num = N.randomExcept(kind1, kind2, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 加载物品
function M:loadItem()
    if not self._clip or tolua.isnull(self._clip) then return end
    for i = 1, 6 do
        local index, index1 = i, 1
        if i > 3 then 
            index = i -3
            index1 = 2
        end
        local item = D.img("tfgoodswalk/scroll/item/"..self._layer._listTab[i]..".png"):to(self._clip, 5)
        item:p(-175 + (index - 1) * 170, 75 + (index1 - 1) * -155):scale(1.4)
    end
end

-- 加载遮罩
function M:loadMask()
    local mask = U.loadNodeMask({
		contentSize = cc.size(V.w+40, V.h+40),
		color 		= ccc3(0, 0, 0)
    }):anchor(cc.p(0.5, 0)):p(V.w_2, -10):opacity(180):to(self, 1):bindTouch()
    self._mask = mask
end

-- 加载卷轴  
function M:loadScroll()
    local scroll = D.img("tfgoodswalk/scroll/scroll.png"):scale(0.2):p(420, 300):to(self, 4) --:bindTouchLocate()--:bindTouch()
    self._scroll = scroll

    local left = D.img("tfgoodswalk/scroll/scroll.png"):p(-35, scroll:ch()/2):to(scroll)
    self._left = left
end

-- 加载clip 
function M:loadClip()
    if not self._scroll or tolua.isnull(self._scroll) then return end
    local clipImg = D.img("tfgoodswalk/scroll/box.png"):p(0, 0):scaleX(0.2)
    self._clipImg = clipImg
	local clip                = CCNodeExtend.extend(cc.ClippingNode:create(clipImg)):p(0, self._scroll:ch()/2):bindTouch()
	self._scroll:addChild(clip, -1)
	-- 设置裁剪区域的显示，false为显示裁剪的区域，true为裁剪后的区域(很关键)
	clip:setInverted(false)
	clip:setAlphaThreshold(0)
	self._clip = clip
    local book = D.img("tfgoodswalk/scroll/box.png"):to(self._clip)
    self._book = book
    self:openScroll()               -- 卷轴打开
    self:loadItem()                 -- 加载物品
end

-- 卷轴打开
function M:openScroll()
    -- 音效
    soundEffect:playEffectsfx05700006()
    if not self._scroll or tolua.isnull(self._scroll) then return end
    local size = self._scroll:scale() + 0.2
    self._scroll:line({
        {"union", {
           {"line", {
               {"delay", 0.1},
               {"union", {
                {"scaleTo", 0.1, size * 0.9, size *1.2},
                {"rotateBy", 0.1, -10}
                }}
           }}
        }},
        {"union", {
            {"jumpby", 0.2, cc.p(0, 100), 50, 1},
            {"scaleTo", 0.3, size * 1.1, size *0.6},
            {"rotateBy", 0.2, 5}
        }},
        {"scaleTo", 0.1, size * 1.1, size * 0.8 },
        {"union",{
            {"jumpTo", 0.25, cc.p(V.w_2 + 50, 260 + Y_OFFSET), 50, 1},
            {"rotateBy", 0.25, -355 },
            {"scaleTo", 0.25, 1}
        }},
        {"fn", function()
            self:open()
        end}
    })
end

--打开
function M:open()
    self._layer._bgMove:stopBeginStandby()
    self._scroll:line({
        {"union",{
            {"moveBy", 0.5, cc.p(310, 0)},
            {"line", {
                {"delay", 0.35},
                {"scaleTo", 0.2, 1.1, 0.8},
            }}
        }},
        { "union", {
             {"scaleTo", 0.1, 1},
             {"moveBy", 0.1, cc.p(-20, 0)}
        }},
        {"delay", 2},
        {"fn", function ()
            self:close()
        end}
    })
    self._left:line({
        {"union",{
            {"moveBy", 0.5, cc.p(-595, 0)},
        }}
    })
    self._clip:line({
        {"moveBy", 0.5, cc.p(-290, 0)}
    })
    self._clipImg:line({
        {"scaleTo", 0.5, 1}
    })
end

-- 关闭
function M:close()
    -- 音效
    soundEffect:playEffectsfx05702002()
    self:stopAllActions()
    self._scroll:line({
        {"union",{
            {"moveBy", 0.5, cc.p(-310, 0)},
            {"scaleTo", 0.2, 1.1, 0.8},
        }},
        { "union", {
             {"scaleTo", 0.1, 1},
             {"moveBy", 0.1, cc.p(20, 0)}
        }},
        {"fn", function ()
            -- 到ui栏位置
            self:intoUi()    
        end},
    })
    self._left:line({
        {"union",{
            {"moveBy", 0.5, cc.p(595, 0)},
        }}
    })
    self._clip:line({
        {"moveBy", 0.5, cc.p(290, 0)}
    })
    self._clipImg:line({
        {"scaleTo", 0.5, 0.2, 1}
    }) 
end

-- 到ui栏位置
function M:intoUi()
    -- 移除遮罩
    self._mask:remove()
    local delayTime = self._delayTime - 3
    if delayTime < 0 then
        delayTime = 0
    end
    A.line({
        {"union",{
            {"scaleTo", 0.45, 0.34},
            {"jumpTo", 0.45, ccp(85 + X_OFFSET, 220 + Y_OFFSET), 100, 1},
            {"rotateby", 0.45, -450},
        }},
        {"hide"},
        {"fn", function ()
            self._layer:loadUi()
            self._layer._ui._scrollView:unbindTouch()
        end},
        {"delay", delayTime},
        {"fn", function ()
            -- 场景预览
            self:sceneMove()
        end}
    }):at(self._scroll)
    --修改语音重叠
    self._scroll:plan(function ()
        self._layer._qq:talkEvent1()
    end, delayTime)
end

-- 场景预览
function M:sceneMove()
    A.line({
        {"delay", 2},
        {"moveBy", 2, ccp(-1280, 0)},
        {"moveBy", 2, ccp(1280, 0)},
        {"fn", function ()
            -- 游戏开始
            self:gameBegin()
        end}
    }):at(self._layer._node)
end

-- 游戏开始
function M:gameBegin()
    -- 一次性弹动
    self._layer:onceBounce()
    -- 打开触控
    self._layer._ui._scrollView:bindTouch()
    self._layer._isMove = false
    self._layer._bgMove._canTouch = true
    -- 边界定时器
    self._layer._bgMove:borderTime()
    self._layer._bgMove:beginStandby()  
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
