--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Shop")
M.TAG       = "ShopNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = true
    -- 商店种类
    self._index    = params.index
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
    -- 加载晃动的灯笼 
    self:loadRockLantern()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end


-- 加载结点
function M:loadPageNode()
    self:setTouchCascadeDetected(true)
    local pos = {ccp(140, 290), ccp(310, 290), ccp(155, 290)}
    -- 加载屋檐
    local eave = D.img("tfgoodswalk/scene/shop"..self._index.."_1.png"):to(self, 20):p(pos[self._index])
end


-- 加载晃动的灯笼 
function M:loadRockLantern()
    local file = {"bone/dl2", "bone/dl4", "bone/dl2"}
    local armatureName = {"dl_bones1", "dl_bones", "dl_bones1"}
    local pos = {
        {ccp(10, 190), ccp(270, 190)}, {ccp(190, 125), ccp(440, 125)}, {ccp(25, 170), ccp(295, 165)},
        }
    for i = 1, 2 do 
        local lantern    = import("app.tfgoodswalk.node.Lantern").new({
            file         = file[self._index],
            armatureName = armatureName[self._index],
            -- animName     = "dl_pd_1",    
            layer        = self,
        }):to(self, 15):p(pos[self._index][i]):unbindTouch():scale(0.6)--:bindTouchLocate()
        self._lantern    = lantern  
    end
end


-- 走路
function M:walk()
    self._layer._qq:walkSeeAni()
    self._layer._mom:walkGoods()
end

-- 结束走路
function M:walkFinish()
    self._layer._qq:breathAni4()
    self._layer._mom:breathGoodsAni()
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if self._layer._isMove then return end
    if not self._canTouch then return end
    -- 音效[sfx05700004]
    soundEffect:playEffectsfx05700001()
    self._layer._moveSound = nil
    self._layer:randomMoveSound()
    self:scale(1.1)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    self:scale(1)
    if self._layer._isMove then return end
    if not self._canTouch then return end
    -- 移动到
    self._layer._bgMove:animalMove(self._index)
    self._layer._bgMove._canTouch = false
    self._layer:unbindTouch()
    self._layer._ui._scrollView:unbindTouch()

end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
