--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Ui")
M.TAG       = "UiNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    -- 是否可以点击
    self._canClick = ifnil(params.canClick, true)
    -- 是否第一次
    self._isFirst  = params.isFirst 
    -- 延迟时间
    self._time     = ifnil(params.time, 0.5) 
    -- 是否是二级商店
    self._isBuy    = ifnil(params.isBuy, false) 
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 如果不是第一次进入就置灰购买完的两个
    self:excludeBuyList()
    self:open()
    self._layer._isMove = true
end

-- 游戏开始
function M:gameBegin()
    for i, v in ipairs(self._layer._passerTab) do
        v:walkRule()
    end
end

-- 加载结点
function M:loadPageNode()
    -- 加载卷轴
    self:loadScroll()
    -- 加载裁切
    self:loadClip()
end

-- 加载卷轴  
function M:loadScroll()
    local scroll = D.img("tfgoodswalk/ui/ui/scroll.png"):scale(1):p(70, 225):to(self, 30)--:bindTouchLocate()--:bindTouch()
    self._scroll = scroll

    local left = D.img("tfgoodswalk/ui/ui/scroll.png"):p(scroll:cw()/2, -13):to(scroll)
    self._left = left
end

-- 加载clip 
function M:loadClip()
    if not self._scroll or tolua.isnull(self._scroll) then return end
    local clipImg = D.img("tfgoodswalk/ui/ui/uiBar.png"):p(80, 0):scaleY(0.01)
    self._clipImg = clipImg
	local clip    = CCNodeExtend.extend(cc.ClippingNode:create(clipImg)):p(0, self._scroll:ch()/2):bindTouch()
	self._scroll:addChild(clip, -1)
	-- 设置裁剪区域的显示，false为显示裁剪的区域，true为裁剪后的区域(很关键)
	clip:setInverted(false)
	clip:setAlphaThreshold(0)
    self._clip = clip
    self:loadScrollView()

end

--打开
function M:open()
    -- 音效
    soundEffect:playEffectsfx05702011()
    -- end
    self._scroll:line({
        {"union",{
            {"moveBy", self._time, cc.p(0, 190)},
        }},
        {"scaleTo", 0.1, 1.05},
        {"scaleTo", 0.1, 1},
        {"fn", function ()
            self._scroll:hide()
            Tools:resetParent(self._scrollView, self._layer, 200)
            if self._layer._isFirst then 
                self._scrollView:unbindTouch()
            else
                self._layer._isMove = false
                self._layer._bgMove._canTouch = true 
            end
            -- 如果不是第一次进入就置灰购买完的两个
            self:excludeBuyList()
            if KIND_TB[1] and KIND_TB[2] and KIND_TB[3] then
                -- 游戏结束
                KIND_TB = {} 
                self._scrollView:unbindTouch()
                -- 数据更新
                KIND_TB   = {false, false, false}
                IS_BUYTB  = {false, false, false, false, false, false}
                BUY_COUNT = 0
            end
        end},
    })
    self._left:line({
        {"union",{
            {"moveBy", self._time, cc.p(0, -275)},
        }}
    })
    self._clip:line({
        {"moveBy", self._time, cc.p(0, -155)}
    })
    self._clipImg:line({
        {"scaleTo", self._time, 1}
    })
end

-- 如果不是第一次进入就置灰购买完的两个
function M:excludeBuyList()
    if not self._isFirst then 
        for i, v in ipairs(IS_BUYTB) do
            if v then 
                self._layer._ui._scrollView:chagneShows(i, true)
            end
        end
    end
end

----------  Ui栏  ---------------
-- 添加ScrollView
function M:loadScrollView()
	local ScrollViewEx 	= require("app.common.node.ScrollViewEx")
	self._scrollView 	= ScrollViewEx.new({
        layer           = self,
		dir 		 	= ScrollViewEx.DIRECTION_VERTICAL,
        rect 		 	= CCRect(0, 0, 145, 200),
		firstPoint 	 	= ccp(72.5, 150),
		contentSize  	= CCSize(100, 102.5),
        arrowOffset  	= 47,
        item            = self._layer._listTab,
        canClick        = self._canClick
	}):to(self._clip, 20):p(80, 0)
    self._scrollView:bindTouch()
	-- 添加元素
    self:addItems()
end

-- 添加元素
function M:addItems()
    --创建图标
	for i = 1, 6 do
		-- 子元素
		local node 	= require("app.tfgoodswalk.node.Good").new({
            imgName = "tfgoodswalk/ui/item/"..self._layer._listTab[i]..".png",
            layer   = self,
			id  	= self._layer._listTab[i],
		}):scale(1.07)
        -- ScrollView添加子元素
        if not tolua.isnull(self._scrollView) then 
		    self._scrollView:addItem(node)
        end
	end
end
----------  Ui栏  ---------------

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
