--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")

----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..







----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    -- 进入的次序
    self._enterCount = self:getScene()._enterCount or 1 
    -- 上个场景的装饰
    self._lastTab = self:getScene()._lastTab or {1, 2, 3, 4, 5, 6}
    -- 事件计数
    self._order   = 0
    -- 触控区域
    self._clearPos = {
        cc.p(503.0 + X_OFFSET, 339.9 + Y_OFFSET), cc.p(460.4 + X_OFFSET, 240.0 + Y_OFFSET), cc.p(449.5 + X_OFFSET, 154.8 + Y_OFFSET), cc.p(555.6 + X_OFFSET, 234.2 + Y_OFFSET), cc.p(426.1 + X_OFFSET, 219.6 + Y_OFFSET), 
        cc.p(516.6 + X_OFFSET, 189.9 + Y_OFFSET), cc.p(532.7 + X_OFFSET,  95.7 + Y_OFFSET), cc.p(558.5 + X_OFFSET, 165.8 + Y_OFFSET), cc.p(532.5 + X_OFFSET, 265.9 + Y_OFFSET), cc.p(469.7 + X_OFFSET, 278.2 + Y_OFFSET), 
        cc.p(414.9 + X_OFFSET, 250.2 + Y_OFFSET), cc.p(465.0 + X_OFFSET, 196.8 + Y_OFFSET), cc.p(506.0 + X_OFFSET, 223.0 + Y_OFFSET), cc.p(492.5 + X_OFFSET, 297.4 + Y_OFFSET), cc.p(526.6 + X_OFFSET, 159.9 + Y_OFFSET), 
        cc.p(516.7 + X_OFFSET, 114.9 + Y_OFFSET), cc.p(462.2 + X_OFFSET, 108.8 + Y_OFFSET), cc.p(423.9 + X_OFFSET, 199.7 + Y_OFFSET), cc.p(488.0 + X_OFFSET, 155.6 + Y_OFFSET), cc.p(462.4 + X_OFFSET, 324.9 + Y_OFFSET), 
    }
    self._clearPos1 = {
        cc.p(496.3 + X_OFFSET, 306.0 + Y_OFFSET), cc.p(557.4 + X_OFFSET, 208.7 + Y_OFFSET), cc.p(442.3 + X_OFFSET, 171.8 + Y_OFFSET), cc.p(483.5 + X_OFFSET, 226.7 + Y_OFFSET), cc.p(375.2 + X_OFFSET, 195.4 + Y_OFFSET), 
        cc.p(413.0 + X_OFFSET, 139.2 + Y_OFFSET), cc.p(538.9 + X_OFFSET, 153.8 + Y_OFFSET), cc.p(517.1 + X_OFFSET, 189.6 + Y_OFFSET), cc.p(496.2 + X_OFFSET, 270.4 + Y_OFFSET), cc.p(458.5 + X_OFFSET, 263.4 + Y_OFFSET), 
        cc.p(531.0 + X_OFFSET, 228.1 + Y_OFFSET), cc.p(470.9 + X_OFFSET, 192.8 + Y_OFFSET), cc.p(388.9 + X_OFFSET, 163.3 + Y_OFFSET), cc.p(432.0 + X_OFFSET, 289.1 + Y_OFFSET), cc.p(505.8 + X_OFFSET, 153.9 + Y_OFFSET), 
        cc.p(459.3 + X_OFFSET, 124.2 + Y_OFFSET), cc.p(420.7 + X_OFFSET, 196.2 + Y_OFFSET), cc.p(432.5 + X_OFFSET, 234.1 + Y_OFFSET), cc.p(479.1 + X_OFFSET, 159.7 + Y_OFFSET), cc.p(455.9 + X_OFFSET, 305.8 + Y_OFFSET), 
    }
    -- 是否可以点击
    self._canTouch = true
    -- 右大花表
    self._rightFlowerTab = {}
    -- 左大花表
    self._lightFlowerTab = {}
    -- 中间花表
    self._midFlowerTab   = {}
    -- 计数
    self._count        = 0
    -- 装饰表
    self._lastVaseTab  = {}
    -- 大花瓶表
    self._bigVaseTab   = {}
    -- 小花瓶表
    self._smallVaseTab = {}
    -- 统一弹窗的变量名
    -- 弹窗花的名字表
    self._flowerName      = {"big","small"}
    -- 弹窗大小花的坐标
    self._flowerPos       = {ccp(370, 200), ccp(350, 200)}
    -- 弹窗大小花口的坐标
    self._flowerMouthPos  = {ccp(98, 322), ccp(114, 257)}
    -- 弹窗大小花口的坐标
    self._flowerScale     = {1, 1.1}
    -- 弹窗污渍的坐标
    self._blot            = {ccp(95, 155), ccp(110, 130)}
    -- 装饰表
    self._decorateTab     = {}
end

----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载背景
    self:loadBg()
    -- 加载家具
    self:loadFurniture()
    -- 加载大花瓶
    self:loadBigVase()
    -- 加载小花瓶
    self:loadSmallVase()
    -- 加载窗户
    self:loadDoor()
    -- 加载窗户雪花
    self:loadSnows()
    -- 加载挂饰
    self:loadDecorate()
    if self._enterCount == 1 then 
        -- 加载一家人
        self:loadPerson(ccp(680 + X_OFFSET, 175), ccp(0, 90))
        self._mm:showBowknotR()
        self._mm:hideBowknotL()
    end
    -- self:fishEvent()
    -- self:loadFlowerScrolUi()
    -- Tools:loadTestNode(self, #self._clearPos, self._clearPos)
    -- Tools:loadTestNode(self, #self._clearPos1, self._clearPos1)
end

-- 完全渲染完再播放过场动画
function M:onEnterTransitionFinish()
    if self._enterCount == 1 then 
       -- 播放音效[057BGM05]大扫除
        sound:play057BGM05() 
    end
    if self._enterCount == 1 then 
        -- 开始动作
        self._dad:wipeBroomAni()
        self._mm:walkInto()
    elseif self._enterCount == 2 then
        -- 播放配音
        soundVoice:playEffectv057081()
        A.line({
            {"delay", 0.5},
            {"fn", function ()
                for i, v in ipairs(self._bigVaseTab) do
                    if i == 1 then 
                        -- 加载花瓶闪亮提示
                        v:hintAct()
                    end
                end
            end}
        }):at(self._bg)
    end
end

-- 加载奇奇妙妙一家人
function M:loadPerson(dadPos, mmPos)
    -- 加载爸爸
    self:loadDad(dadPos)
    -- 加载妙妙
    self:loadMm(mmPos)
end

-- 加载浮想款
function M:loadThinkBox()
    -- 音效
    soundEffect:playEffectsfx05700009()
    local thinkbox = D.img("common/thinkbox/3.png"):to(self._mm, 200):p(75, 200):anchor(ccp(0.5, 0)):scale(0)--:bindTouchLocate()
    A.line({
        {"easing", "backOut", {"scaleTo", 0.5, 1}},
    }):at(thinkbox)
end

--加载爸爸
function M:loadDad(dadPos)
    local dad = import("app.tfroom.node.AniDad").new({
        layer    = self,
    }):to(self._bg, 200):scale(0.8):p(dadPos.x, dadPos.y - 20):flipX(true)--:bindTouchLocate()
    self._dad = dad
end

--加载妙妙
function M:loadMm(mmPos)
    local mm  = import("app.tfroom.node.AniMm").new({
        layer    = self,
    }):to(self._bg, 200):scale(0.8):p(mmPos.x, mmPos.y):flipX(true)--:bindTouchLocate()
    self._mm = mm
end

--加载递出的手
function M:loadHand()
    local hand = import("app.common.node.BaseHand").new({
        layer = self,
    }):to(self, 999)
    self._hand = hand
    -- 加载手上的毛巾
    self:loadTowel()
end

-- 加载手上的毛巾
function M:loadTowel()
    local towel = import("app.tfroom.node.Towel").new({
        imgName = "tfcleanwindow/towel/1.png",
        layer   = self,
    }):to(self._hand, 999):scale(0.8)
    local handPos = self._hand:getCenterPos()
    local offsetX = 0
    local offsetY = 10
    towel:p(handPos.x + offsetX, handPos.y + offsetY)
    self._hand._handThing = towel
    self._towel = towel
end

----------  加载花瓶弹窗擦除  --------------
-- 加载弹窗
function M:loadBox(pos, offsetPos)
    local box    = import("app.common.node.BaseBox").new({
        layer    = self,
        movePos  = offsetPos,
        enterPos = pos
    }):to(self, 998)
    self._box = box
end

-- 加载box事件
function M:loadThing(node)
    self._order = self._order + 1
    self:loadBigFlower(node, self._order)
end

-- 加载大花瓶
function M:loadBigFlower(node, index)
    -- 加载裁切
    local mask = D.img("common/box.png"):to(node):p(360, -173):opacity(0)
    local clippingNode = CCNodeExtend.extend(cc.ClippingNode:create(mask)):bindTouch()
    clippingNode:to(node):setInverted(true):setContentSize(CCSize(100, 100)):setAlphaThreshold(1)
    local bigFlower = D.img("tfroom/clean/flower/"..self._flowerName[index].."/vase.png")
    :to(clippingNode):p(self._flowerPos[index]):scale(self._flowerScale[index])
    self._bigFlower = bigFlower
    local vase1 = D.img("tfroom/clean/flower/"..self._flowerName[index].."/vase1.png"):to(bigFlower, -2):p(self._flowerMouthPos[index])
    -- 加载大花瓶污渍擦除
    self:loadBigTexture(bigFlower, index)
    -- 加载传递的手
    self:loadHand()
    -- 熊猫手进入
    self:handEnter()
end


-- 熊猫手进入
function M:handEnter()
    A.line({
        {"delay", 0.5},
        {"fn", function ()
            self._hand:enter()
        end},
        {"delay", 1},
        {"fn", function ()
            self._towel._canTouch = true
        end},
    }):at(self)
end


-- 加载大花瓶污渍擦除
function M:loadBigTexture(node, index)
    if self._texture then return end
    local bigTexture = import("app.common.Texture").new({
        size         = cc.size(V.w, V.h),
        paint        = "common/point.png",
    }):to(node, 90):p(self._blot[index]):scale(1)
    local size = index == 1 and 1 or 0.94
    bigTexture:addImg("tfroom/clean/flower/"..self._flowerName[index].."/blot.png", cc.p(bigTexture:cw()/2, bigTexture:ch()/2), size)
    bigTexture:opacity(0)
    self._bigTexture = bigTexture
end
---------- 加载花瓶弹窗擦除 --------------

---------- 加载花瓶ui栏 --------------
-- 加载插花ui栏 
function M:loadFlowerScrolUi()
    self._canTouch = true
    -- 加载通用ui栏
    self:loadScrolUi(4, false)
    -- 加载ui栏内滚动的格子
    self:loadItem()
    -- 加载虚线
    -- self:loadDotted()
    -- 加载ok按钮
    -- self:loadOkBtn()
end

-- 加载滚动Ui栏
function M:loadScrolUi(index, isScrol)
    local sprite = require("app.common.node.ScrollUi")
    local ui = sprite.new({
        picPath   	= "common/ui/uiBar.png",
        layer       = self,
        pos         = cc.p(1160 + 1.5 * X_OFFSET, 250 + Y_OFFSET),
        zOrder      = 100,
        showNumber  = 4,
        arrowScroll = isScrol
    }):to(self, 9999):scale(1)--:bindTouchLocate()
    self._ui = ui
end

-- 加载窗花格子
function M:loadItem()
    self._itemTab = {}
    for i = 1, 4 do
        local sprite = require("app.tfroom.node.Flower")
        local item   = sprite.new({
            imgName      = "common/ui/item.png",
            index        = i,
            layer        = self,
        })
        item._itemSize   = 0
        table.insert(self._itemTab, item)
    end
    -- 在滚动栏中添加初始项
    self._ui._scrollView:addItemToScrollView(self._itemTab)
end

-- 加载ok按钮
function M:loadOkBtn(pos)
    local okBtn = import("app.common.node.BaseOkBtn").new({
        imgName = "common/okbtn/line.png",
        pos     = pos,
    }):to(self, 9999)
    self._okBtn = okBtn
end
---------- 加载花瓶ui栏 --------------

-- 加载3秒无炒作自动打勾
function M:laterTime()
    if tolua.isnull(self._laterTimeAct) then 
        self._laterTimeAct = A.line({
            {"delay", 3},
            {"fn", function ()
                if not tolua.isnull(self._okBtn._btn) then 
                    self._okBtn._btn:onTouchBegan()
                end
            end}
        }):at(self)
    end
end

-- 停止3秒计算重新计时
function M:stopLaterTime()
    for i, v in ipairs(self._itemTab) do
        v:stopAllActions()
    end
    if not tolua.isnull(self._laterTimeAct) then 
        self:stopAction(self._laterTimeAct)
        self._laterTimeAct = nil
    end
end

-- ok键下一个事件
function M:okNextStep()
    self._ui:unbindTouch()
    self._canTouch = false
    -- 清空数据
    self:stopLaterTime()
    self._count          = 0
    self._rightFlowerTab = {}
    self._lightFlowerTab = {}
    self._midFlowerTab = {}
    -- ui栏退出
    self._ui:quit()
    -- 弹框消失
    A.line({
        {"delay", 2},
        {"fn", function ()
            self._box:quit()
            self._onceEnter = false
            if self._order == 1 then 
                -- 大花瓶结束
                self:finishBigVase(self._order, 2)
            elseif self._order == 2 then
                self:finishBigVase(self._order, 1)
            end
        end}
    }):at(self)
end

-- -- 全局负值
-- function M:overall()
--     for i, v in ipairs(self._lastVaseTab) do
--         table.insert(G_FLOWER_TB, v)
--     end 
-- end

-- 大花瓶结束
function M:finishBigVase(order, index)
    -- 全局负值
    -- self:overall()
    local tabName = {self._bigVaseTab, self._smallVaseTab}
    local vaseNameTb = {"bigFlowerTb", "smallFlowerTb"}
    print("是不是走这里修改了呀！！！！")
    --装饰存入本地表中
    T.copyTable(G_ROOM_DECORATE_CONFIG[vaseNameTb[order]], self._lastVaseTab)
    ST.setTable("ROOM_DECORATE_CONFIG", G_ROOM_DECORATE_CONFIG)
    for i, v in ipairs(tabName[order]) do
        for j = 1, 3 do 
            --获取花的坐标
            -- id：花的坐标  index:从左到右第几朵  vaseType:1:大花瓶 2:小花盆
            local flipX, angle, pos, tier = Tools:getFlowerConfig(self._lastVaseTab[j], j, order)
            local flower = D.img("tfroom/flower/"..self._flowerName[order].."/"..self._lastVaseTab[j]..".png")
            flower:anchor(ccp(0.5, 0)):to(tabName[order][i], tier):p(pos):flipX(flipX):rotate(angle):hide()
            -- 花动作
            self:flowerAct(i, flower)
            -- table.insert(G_FLOWER_ISFLIPX, flipX)
        end
        A.line({
            {"fadeout", 0.5},
        }):at(v._blot)
    end
    -- 加载花瓶闪亮提示
    self._box:unbindTouch()
    -- 事件结束
    self:eventEnd(order)
end

-- 花动作
function M:flowerAct(index, flower)
    A.line({
        {"delay", 1},
        {"fn", function ()
            if not self._onceEnter then
                self._onceEnter = true
               -- 音效
     	        soundEffect:playEffectsfx05703028() 
            end
            flower:show()
            commonAct:nodeScale(flower, 0.5, 1)
        end}
    }):at(self)
end

-- 事件结束
function M:eventEnd(order)
    if order == 1 then 
        A.line({
            {"delay", 0.5},
            {"fn", function ()
                self._smallVase:hintAct()
            end}
        }):at(self)
    else
        -- 最后的结束
        self:fishEvent()
    end
end

-- 最后的结束
function M:fishEvent()
    -- 加广告
    Tools:openAd()
    -- 音效
    soundEffect:playEffectsfx05703025()
    --  加载粒子
    A.line({
        {"delay", 0.7},
        {"fn", function ()
            soundEffect:playEffectsfx05703029()
            local particle = Tools:newParticle("particle/all_clean.plist", V.w_2, V.h_2):to(self, 10)
            Tools:insertParticleTb(self, particle)
        end}
    }):at(self)
    -- 加载奇奇妙妙一家人
    self:loadPerson(ccp(1200 + X_OFFSET, 175), ccp(1000 + X_OFFSET, 90))
    self._mm:showBowknotL()
    self._mm:hideBowknotR()
    self._dad:walkIntoScreen()
    self._mm:walkIntoScreen()
    self._mm:flipX(false)
end

-- 游戏开始
function M:gameBegin()
    A.line({
        {"union",{
            {"scaleTo", 1.5, 2.2},
            {"moveBy", 1.5, ccp(0, -650 + Y_OFFSET)}
        }},
        {"fn", function ()
            game:enterScene("tfcleanwindow", {}, "fade", 1, COLOR3_WHITE)
        end}
    }):at(self._bg)
    A.line({
        {"delay", 1.5},
        {"fadeTo", 1.5, 255}
    }):at(self._blot)
end

-- 加载背景
function M:loadBg()
    local bg = U.loadBg("tfroom/bg.png"):to(self)--:scale(1.25 + X_OFFSET / 1000 + Y_OFFSET / 4000)--:bindTouchLocate()
    self._bg = bg
end

-- 加载家具
function M:loadFurniture()
    -- 加载沙发
    local pos = {ccp(512.3, 202.6), ccp(754.7, 121.7), ccp(261.9, 120.8)}
    for i = 1, 3 do 
        local sofa = D.img("tfroom/furniture/sofa"..i..".png"):to(self._bg, 100):p(pos[i]):scale(0.86)
    end
    -- 加载桌子
    local desk    = D.img("tfroom/furniture/desk.png"):to(self._bg, 100):p(515.6, 95.4):scale(0.86)
    -- 加载抱枕
    -- local cushion = D.img("tfroom/furniture/cushion.png"):to(self._bg, 100):p(426.8, 222.9):scale(0.86)
end

-- 加载大花瓶
function M:loadBigVase()
    local pos = {ccp(140, 238.1), ccp(885, 238.1)}
    for i = 1, 2 do 
        -- 加载瓶身
        local vase    = import("app.tfroom.node.BigVase").new({
            imgName   = "tfroom/flower/big/vase.png",
            layer     = self,
            index     = i
        }):to(self._bg, 100):p(pos[i]):scale(0.86)
        table.insert(self._bigVaseTab, vase)
        local vase1   = D.img("tfroom/flower/big/vase1.png"):to(vase, -2):p(41.8, 144):scale(1)
        -- 加载污渍
        local blot    = D.img("tfroom/flower/big/blot.png"):to(vase):p(40.9, 71.3):scale(1)
        vase._blot    = blot
    end
end

-- 加载小花瓶
function M:loadSmallVase()
    -- 加载瓶身
    local smallVase = import("app.tfroom.node.SmallVase").new({
        imgName   = "tfroom/flower/small/vase.png",
        layer     = self,
    }):to(self._bg, 100):p(578.6, 149.4):scale(0.86):bindTouch()--:bindTouchLocate()
    local vase1     = D.img("tfroom/flower/small/vase1.png"):to(smallVase, -2):p(29.6, 64):scale(1)--:bindTouchLocate()
    -- 加载污渍
    local blot      = D.img("tfroom/flower/small/blot.png"):to(smallVase):p(29.8, 32.4):scale(1)
    table.insert(self._smallVaseTab, smallVase)
    self._smallVase = smallVase
    smallVase._blot = blot
end

-- 加载窗户
function M:loadDoor()
    local frame  = D.img("tfroom/door/frame.png"):to(self._bg, 90):p(512.5, 414.6):scale(0.86)--:bindTouchLocate()
    self._frame  = frame
    local doorbg = D.img("tfroom/door/doorbg.png"):to(frame, -5):p(152.0, 150.9):scale(1)
    if self._enterCount == 2 then 
        local pos = {ccp(205, 155), ccp(100, 155)}
        -- 加载窗花
        for i = 1, 2 do
            local doorFlower = D.img("tfroom/doorflower/"..self._lastTab[i]..".png"):to(frame):p(pos[i]):scale(1.25)--:bindTouchLocate()
        end
        return 
    end
    -- 加载雾气
    local blot = D.img("tfroom/door/fog.png"):to(frame):p(152.0, 150.9):opacity(200)
    -- 加载污渍
    local blot = D.img("tfroom/door/blot.png"):to(frame):p(152.0, 150.9):scale(1):opacity(77)
    self._blot = blot
end

-- 加载窗户雪花
function M:loadSnows()
    -- 加载裁切
    local mask = D.img("tfroom/door/doorbg.png"):to(self._frame, -10):p(152.0, 150.9)--:opacity(0)
    local clippingNode = CCNodeExtend.extend(cc.ClippingNode:create(mask)):bindTouch()
    clippingNode:to(self._frame, -1):setInverted(false):setContentSize(CCSize(100, 100)):setAlphaThreshold(0)
    local snow = D.img("tfroom/door/doorbg.png"):to(clippingNode):p(152.0, 150.9):scale(1):opacity(0)
    --雪花
    Tools:loadSnows(snow, 999, nil, 5, true, nil, nil, true)
end

-- 加载装饰
function M:loadDecorate()
    local lastTab = self._lastTab or {1, 2, 3, 4, 5, 6}
    if self._enterCount == 1 then return end
    local pos = {ccp(322.1, 390.2), ccp(241.1, 397.6), ccp(779.0, 397.6), ccp(696.9, 397.6)}
    for i = 1, 4 do 
        local decorate = D.img("tfroom/decorate/"..self._lastTab[i + 2]..".png"):to(self._bg):p(pos[i]):scale(0.86)--:bindTouchLocate()
    end

end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
