--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = class("AniDad", import("app.common.node.BaseDad"))
M.TAG       = "AniDad"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(820 + X_OFFSET, 150))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸（循环）
	self:breathBroomAni()
end

--走入屏幕
function M:walkIntoScreen()
	--隐藏扫把
	self:hideBroom()
	--走路
	self:walkBroomAni()
	self:line({
		{"moveto", 2.5, self._enterPos},
		{"fn", function ()
			-- 呼吸
			self:breathBroomAni()
		end}
	})
end

-- 走出屏幕
function M:walkOutScreen(pos)
	--走路
	self:walkAni()
	self:line({
		{"moveto", 2.5, pos},
	})
end

-- “我在做新年的大扫除呀，扫去旧的东西，才能迎来新的一年嘛”
function M:talkEvent()
	-- 播放配音
	soundVoice:playEffectv057008()
	-- 说话2（开始）
	self:talkAni1_1()
	local time1 = soundVoice:getVoiceTime("v057008", 6)
	self:line({
		{"delay", time1},
		{"fn", function()
			-- 说话2（结束）
			self:talkAni1_3()
		end},
		{"fn", function()
			-- 说话2（结束）
			self:talkAni1_5()
			-- 妙妙说话 “我也要来帮忙”
			self._layer._mm:talkEvent2()
		end},
	})
end

-- “嗯，变得干干净净，而且有了年味儿，宝贝真棒！”
function M:talkEvent1()
	-- 播放配音
	soundVoice:playEffectv057010()
	-- 说话2（开始）
	self:talkAni2_1()
	local time1 = soundVoice:getVoiceTime("v057010", 4)
	self:line({
		{"delay", time1},
		{"fn", function()
			-- 说话2（结束）
			self:talkAni2_3()
		end},
		{"fn", function()
			-- 说话2（结束）
			self:talkAni2_5()
		end},
	})
end

-- “我们去看看还缺点什么吧”
function M:talkEvent2()
	-- 播放配音
	soundVoice:playEffectv057085()
	-- 说话2（开始）
	self:talkAni2_1()
	local time1 = soundVoice:getVoiceTime("v057085", 2)
	self:line({
		{"delay", time1},
		{"fn", function()
			-- 说话2（结束）
			self:talkAni2_3()
		end},
		{"delay", 1},
		{"fn", function()
			self:breathAni()
			self._layer._mm:talkEvent3()
		end},
	})
end

--隐藏扫把
function M:hideBroom()
	self._armature:getBone("cqmb_sb"):hide()
end

--摸妙妙的头
function M:touchMmHead()
	-- 播放配音
	soundVoice:playEffectv057009()
	-- 谢谢宝贝呀
	-- 音效[sfx05703002]妙爸摸头
	soundEffect:playEffectsfx05703002()
	-- 摸头说话（开始）
	self:touchedTalkAni1()
	self._layer._mm:z(self._layer._mm:z()-1)
	-- 被摸（开始）
	A.line({
		{"delay", 0.2},
		{"fn", function ()
			self._layer._mm:beTouched1_1()
		end}
	}):at(self)
	local time = 2
	self:line({
		{"Delay", time},
		{"fn", function ()
			-- 摸头说话（结束）
			self:touchedTalkAni3()
			-- 被摸（结束）
			self._layer._mm:beTouched1_3()
		end}
	})
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "qmb_ch" then
			-- 呼吸（循环）
			self:lookBroomAni()
		elseif __moveId == "qmb_csh1" then
			-- 说话1（循环）
			self:talkAni1_2()
		elseif __moveId == "qmb_csh1_2" then
			-- 说话1（循环）
			self:talkAni1_4()
		elseif __moveId == "qmb_csh1_4" then
			-- 呼吸（循环）
			self:lookBroomAni()
		elseif __moveId == "qmb_csh3" then
   			-- 摸头说话（循环）
			self:touchedTalkAni2()
		elseif __moveId == "qmb_csh3_2" then
			self:play("qmb_chx2")
		elseif __moveId == "qmb_jl" then
			-- 呼吸
			self:breathAni()
		elseif __moveId == "qmb_csh2" then
			-- 说话2（循环）
			self:talkAni2_2()
		elseif __moveId == "qmb_csh2_2" then
			-- 说话2（循环）
			self:talkAni2_4()
		elseif __moveId == "qmb_csh2_4" then
			-- 呼吸
			self:breathAni()
			-- 开心笑
			self._layer._mm:smileAni()
			-- 音效
			soundEffect:playEffectsfx05703027()
			--  加载粒子
			self._particle = P.newParticle("particle/mm_bighappy.plist"):to(self._layer, 999):p(V.w_2, V.h_2 + 200):scale(1)
			Tools:insertParticleTb(self._layer, self._particle)
			-- 播放音效[sfx05700013]全屏星星粒子
			soundEffect:playEffectsfx05700013()
		end
	elseif __evtType == 2 then
		if __moveId == "qmb_csh1_1" then 
			self:talkAni1_3()
		end
	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end
return M
