--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = class("AniMm", import("app.common.node.BaseMm"))
M.TAG       = "AniMm"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer    = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(680 + X_OFFSET, 90))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	--换装
	self:changeClose()
	-- 呼吸
	self:breathAni()
end

--换装
function M:changeClose()
	self._armature:getBone("cmm_wq"):hide()
end

--走入屏幕
function M:walkIntoScreen()
	--走路
	self:walkAni()
	self:line({
		{"moveto", 2.5, self._enterPos},
		{"fn", function ()
			-- “爸爸你看你看！客厅是不是变得很漂亮！”
			self:talkEvent1()
		end}
	})
end

--走向爸爸
function M:walkInto()
	local offset = PT.distance(self:point(), ccp(509.5 + X_OFFSET, 100))
	local time = offset / 230 
	-- 音效[sfx05703001]妙妙入场
	soundEffect:playEffectsfx05703001()
	-- 走路
	self:walkLookAni()
	self:line({
		{"moveTo", time, ccp(509.5 + X_OFFSET, 100)},
		{"fn", function()
			-- 呼吸
			self:breathAni()
			-- “爸爸，你在做什么呀！”
			self:talkEvent()
		end}
	})
end

-- 走出屏幕
function M:walkOutScreen(pos)
	--走路
	self:walkAni()
	self:line({
		{"moveto", 2.5, pos},
	})
end

-- “爸爸，你在做什么呀！”
function M:talkEvent()
	-- 播放配音
	soundVoice:playEffectv057001()
	-- 问爸爸说话（开始）
	self:talkAni1_1()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057001", 2)
	self:line({
		{"delay", time},
		{"fn", function ()
			-- 开心说话（结束）
			self:talkAni1_3()
		end}
	})
end

-- “爸爸你看你看！客厅是不是变得很漂亮！”
function M:talkEvent1()
	-- 播放配音
	soundVoice:playEffectv057006()
	-- 开心说话（开始）
	self:talkAni3_1()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057006", 3)
	self:line({
		{"delay", time},
		{"fn", function ()
			-- 帮忙说话（结束）
			self:talkAni3_3()
		end}
	})
end

-- “我也要来帮忙“
function M:talkEvent2()
	-- 播放配音
	soundVoice:playEffectv057002()
	-- 帮忙说话（开始）
	self:talkAni2_1()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057002", 2)
	self:line({
		{"delay", time},
		{"fn", function ()
			-- 帮忙说话（结束）
			self:talkAni2_3()
		end}
	})
end

-- “咦？总觉得还缺了点什么？”
function M:talkEvent3()
	self._layer:loadThinkBox()
	-- 疑问说话（开始）
	self:talkAni4_3()
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057007", 2)
	self:line({
		{"delay", time},
		{"fn", function ()
			game:enterScene("tfdoor", {}, "fade", 1, COLOR3_WHITE)
		end}
	})
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "mm_csh1" then
			-- 开心说话（循环）
			self:talkAni1_2()
		elseif  __moveId == "mm_csh1_2" then
			-- 看着爸爸
			self:lookAni()
			-- “我在做新年的大扫除呀，扫去旧的东西，才能迎来新的一年嘛”
			self._layer._dad:talkEvent()
		elseif __moveId == "mm_csh2" then
			-- 帮忙说话（循环）
			self:talkAni2_2()
		elseif __moveId == "mm_csh2_2" then
			-- 呼吸
			self:breathAni()
			-- 爸爸摸妙妙的头
			self._layer._dad:touchMmHead()
		elseif __moveId == "mm_bm1" then
			--  加载粒子
			local particle = Tools:newParticle("particle/mm_happy.plist", 40, 205):to(self, 999)
			Tools:insertParticleTb(self, particle)
			-- 被摸头
			self:beTouched1_2()
		elseif __moveId == "mm_bm1_2" then
			-- 呼吸
			self:breathAni()
			-- 游戏开始()
			self._layer:gameBegin()
		elseif __moveId == "mm_csh3" then
			-- 帮忙说话（循环）
			self:talkAni3_2()
		elseif __moveId == "mm_csh3_2" then
			-- 呼吸
			self:breathAni()
			-- “嗯，变得干干净净，而且有了年味儿，宝贝真棒！”
			self._layer._dad:talkEvent1()
		elseif __moveId == "mm_xiao" then
			self._layer._dad._particle:stopSystem() 
			-- “咦？总觉得还缺了点什么？”
			-- self:talkEvent3()
			self:breathAni()
			self._layer._dad:talkEvent2()
		elseif __moveId == "mm_csh4" then
			-- 疑惑说话（循环）
			self:talkAni4_2()
		end
	elseif __evtType == 2 then
		
	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end
return M
