--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Flower")
M.TAG       = "FlowerNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    self._layer = params.layer
    -- 花的种类
    self._index = params.index
    -- 是否可以点击
    self._canTouch = true
    -- 是否拖动出去
    self._isMove   = false
    -- 是否可以创建
    self._canCreat = true
    -- 是否可以结束
    self._isEnd    = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载花
    self:loadFlower()
   
end


-- 加载花
function M:loadFlower()
    local flower = D.img("tfroom/clean/flower/big/put/ui/"..self._index..".png"):scale(1):to(self, 300):p(50, 50)
    self._flower = flower
end

-- 加载新的拖动
function M:loadNew(pos)
    if self._canCreat then 
        self._canCreat = false
        local doorNewflower = import("app.tfroom.node.NewFlower").new({
            layer     = self,
            index     = self._index,
        }):scale(0.8):to(self._layer, 9999):p(pos):anchor(ccp(0.5, 0))
        self._doorNewflower = doorNewflower
    end
end

-- 插花
function M:putflower(type)
    local tabName = {self._layer._rightFlowerTab, self._layer._lightFlowerTab, self._layer._midFlowerTab}
    for i, v in ipairs(tabName[type]) do
        if v then 
            T.removeOrder(tabName[type], v)
            v:remove()
        end
    end
    -- 新东西的动作
    self:newflower(type)
    table.insert(tabName[type], self._doorNewflower)
    self._layer._lastVaseTab[type] = self._index
end

-- 新东西的动作
function M:newflower(type)
    local offset = -10
    local tier   = -1
    if self._index >= 3 then 
        offset = 30
    end
    if type == 3 and self._index >= 3 then 
        offset = 70
    elseif type == 3 and self._index <= 2 then 
        offset = -20
        tier = -2
    end
    -- 右 左
    local pos  = {ccp(465 + X_OFFSET, 300 + Y_OFFSET), ccp(400 + X_OFFSET, 300 + Y_OFFSET), ccp(432.5 + X_OFFSET, 300 + Y_OFFSET)}
    local pos1 = {ccp(120, 370 - offset), ccp(53, 370 - offset), ccp(85, 370 - offset)}
    if self._layer._order == 2 then
        pos1[type].x = pos1[type].x + 11 
        pos1[type].y = pos1[type].y - 70
        if self._index == 3 or self._index == 4 then 
            pos1[2].x = 80
        end
    elseif type == 3 and self._index == 2 then 
        pos1[3].x = 75
    elseif type == 2 and self._index == 2 then 
        pos1[2].x = 35
    end
    -- 花动作
    self:newflowerAct(pos, pos1, type, tier)
end

-- 花动作
function M:newflowerAct(pos, pos1, type, tier)
    A.line({
        {"moveTo", 0.2, pos[type]},
        {"fn", function ()
            Tools:resetParent(self._doorNewflower, self._layer._bigFlower, tier)
            -- 方向设置
            self:setDirection(type)
            A.line({
                {"moveTo", 0.15, pos1[type]},
                {"fn", function ()
                    -- 窗花结束
                    self:doorNewflowerFinish(type)
                end}
            }):at(self._doorNewflower)
        end},
    }):at(self._doorNewflower)
end

-- 窗花结束
function M:doorNewflowerFinish(type)
    -- 花的粒子
    self:flowerParticle()
    -- 花的震动
    self:shakeAct()
    local tabName = {self._layer._lightFlowerTab, self._layer._rightFlowerTab, self._layer._midFlowerTab}
    for i, v in ipairs(tabName[type]) do
        commonAct:nodeScale(v, 0.25, 0.5)
    end
    -- 判断是否完成
    self:isFinish()
    self._layer._lastTab[type] = self._index
end

-- 花的粒子
function M:flowerParticle()
    --音效
    soundEffect:playEffectsfx05703013()
    local nameTab = {"flower_redred", "flower_green", "flower_red", "flower_yellow"}
    local posTab  = {ccp(90, 400), ccp(130, 330)}
    --  加载粒子
    local particle = Tools:newParticle("particle/"..nameTab[self._index]..".plist", 0, 85):to(self._doorNewflower, 999):scale(1.2)
    Tools:insertParticleTb(self, particle)
    if self._layer._rightFlowerTab[1] and self._layer._lightFlowerTab[1] and self._layer._midFlowerTab[1] and not self._onceEnter then 
        self._onceEnter = true
        -- 音效
     	soundEffect:playEffectsfx05703014()
        --  加载粒子
        self._particle = P.newParticle("particle/vase_light.plist"):to(self._layer._bigFlower, 10):p(posTab[self._layer._order]):scale(1)
        Tools:insertParticleTb(self, self._particle)
    end
end

-- 花的震动
function M:shakeAct()
    for i, v in ipairs(self._doorNewflower._otherFlowerTb) do
        self:insertFlowerAct(v)
    end
end

-- 插入花的动作
function M:insertFlowerAct(node)
    commonAct:nodeScale(node, 0.5, 1)
end

-- 方向设置
function M:setDirection(type)
    if self._index == 3 or self._index == 1 then 
        if type == 2 then 
            self._doorNewflower:rotate(-23)
            if self._index == 1 then 
                local index = #self._doorNewflower._otherFlowerTb
                local node  = self._doorNewflower._otherFlowerTb[index]
                local node1 = self._doorNewflower._otherFlowerTb[index - 1]
                node:rotate(23):p(node:px() - 20, node:py() + 5)
                node1:rotate(23):p(node1:px() - 11, node1:py() + 5)
            end
        end
    else
        if type == 1 then 
            self._doorNewflower:rotate(23)
            if self._index == 2 then 
                local index = #self._doorNewflower._otherFlowerTb
                local node  = self._doorNewflower._otherFlowerTb[index]
                local node1 = self._doorNewflower._otherFlowerTb[index - 1]
                node:rotate(-23):p(node:px()+ 15, node:py())
                node1:rotate(-23):p(node1:px() + 10, node1:py())
            end
        end
    end
    if type == 3 then 
        if self._index == 1 or self._index == 3 then 
            self._doorNewflower:rotate(-10)
        else
            self._doorNewflower:rotate(10)
        end
        
    end
end

-- 判断是否完成
function M:isFinish()
    if #self._layer._rightFlowerTab == 1 and #self._layer._lightFlowerTab == 1 and #self._layer._midFlowerTab == 1 then 
        self._layer:okNextStep()
        -- 计数
        self._layer._count = self._layer._count + 1
    elseif self._layer._order == 1 and #self._layer._lightFlowerTab == 0 then
        -- 播放配音
        soundVoice:playEffectv057005()
        -- 获取时长
        local time = soundVoice:getVoiceTime("v057005", 2)
        A.line({
            {"delay", time},
            {"fn", function ()
                soundVoice:playEffectv057084()
            end}
        }):at(self)
    end
end

-- 隐藏
function M:moveHide()
    if not self._moveHideAct then 
        self._moveHideAct = A.line({
            {"union",{
                {"scaleTo", 0.1, 0},
                {"fadeout", 0.1},
            }},
            {"hide"}
        }):at(self._flower)
    end
end

-- 显示
function M:moveShow()
    self._canCreat = true
    A.line({
        {"delay", 0.1},
        {"union",{
            {"fadein", 0.5},
            {"scaleTo", 0.5, 1},
            {"fn", function ()
                 self._flower:show()
            end}
        }},
        {"fn", function ()
            self._layer._canTouch = true
            if self._moveHideAct then 
                self._moveHideAct = nil
            end
        end}
    }):at(self._flower)
end

-- 返回
function M:back()
    local worldPos = self:getParent():convertToWorldSpace(self:point())
    A.line({
        {"union",{
            {"scaleTo", 0.25, 0.25},
            {"jumpTo", 0.25, ccp(worldPos.x - 3, worldPos.y + 2), 50, 1},
            {"fn", function()
                -- 音效[sfx05700008]
                soundEffect:playEffectsfx05700008()
            end},
        }},
        {"fn", function ()
            -- 花动作
            self:flowerAct()
            self._canCreat = true
        end},
        {"delay", 0.12},
        {"remove"}
    }):at(self._doorNewflower)
end

-- 花动作
function M:flowerAct()
    A.line({
        {"union",{
            {"fadein", 0.1},
            {"scaleTo", 0.1, 1}
        }},
        {"show"},
        {"fn", function ()
            commonAct:nodeScale(self._flower, 1, 0.5)
        end},
        {"delay", 0.05},
        {"fn", function ()
            self._layer._canTouch = true
            if self._moveHideAct then 
                self._moveHideAct = nil
            end
        end},
    }):at(self._flower)
end

-- 放置(副本)
function M:put1()
    if self._doorNewflower:py() < 350 + Y_OFFSET and self._doorNewflower:py() > 50 + Y_OFFSET then 
        if self._doorNewflower:px() < 690 + X_OFFSET and self._doorNewflower:px() > 437 + X_OFFSET then 
            -- 显示
            self:moveShow()
            if self._layer._rightFlowerTab[1] and not self._onceEnter then 
                self._onceEnter = true
                self:putflower(2)
            else
                -- 插花
                self:putflower(1)
            end
        elseif self._doorNewflower:px() <= 437 + X_OFFSET and self._doorNewflower:px() > 190 + X_OFFSET then 
            self:moveShow()
            if self._layer._lightFlowerTab[1] and not self._onceEnter1 then 
                self._onceEnter1 = true
                self:putflower(1)
            else
                -- 插花
                self:putflower(2)
            end
        else
            self:back()
        end
    else
        self:back()
    end
end

-- 放置
function M:put()
    if self._doorNewflower:py() < 350 + Y_OFFSET and self._doorNewflower:py() > 50 + Y_OFFSET then 
        if self._doorNewflower:px() < 690 + X_OFFSET and self._doorNewflower:px() > 190 + X_OFFSET then 
            -- 显示
            self:moveShow()
            if not self._layer._rightFlowerTab[1] then 
                self:putflower(1)
            elseif not self._layer._lightFlowerTab[1] then 
                -- 插花
                self:putflower(2)
            else
                -- 插花
                self:putflower(3)
            end
        else
            self:back()
        end
    else
        self:back()
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._layer._canTouch then return end
    -- 音效[sfx05700001]
    soundEffect:playEffectsfx05700001()
    -- self._layer:stopLaterTime()
    self._layer._canTouch = false
    self._isEnd = false
    self._flower:scale(1.2)
    self._startPos = ccp(x, y)
    -- 可穿透
	return SIGN_TOUCH_BEGAN_NO_SWALLOWS	
end

function M:onTouchMoved(x, y, touches)
    local offset = ccpSub(self._startPos , ccp(x, y))
    if math.abs(offset.x) >= 40 or math.abs(offset.y) >= 40 then
        self._isMove = true
        self._isEnd  = true
        self._layer._ui._scrollView._canTouch = false
        self:loadNew(ccp(x, y))
        -- -- 隐藏
        self:moveHide()
        self._doorNewflower:p(x, y)
    else
        if self._doorNewflower and self._isMove then
            self._doorNewflower:p(x, y)
        end
    end
    local marginTop = 230
    if  NV.isMembers() then
        marginTop = marginTop - 80
    end
    bb.si.Tool.limitRectMove({
        node      = self._doorNewflower,
        marginTop = marginTop,
    })
    bb.si.Tool.limitButtonMove({node = self._doorNewflower})
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return  end
    self._flower:scale(1)
    -- -- 停止虚线 
    self._isMove = false
    if not self._isEnd then 
        self._layer._canTouch = true
        return  
    end
    -- 放置装饰
    self:put()
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    if not tolua.isnull(self._particle) then 
        self._particle:remove()
        self._particle = nil
    end
    Tools:removeParticleTb(self)
end





--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]

----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
