--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("NewFlower")
M.TAG       = "NewFlower"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer          = params.layer
    --触控
    self._canTouch       = false
    -- 花的种类
    self._index          = params.index
    -- 花表
    self._otherFlowerTb  = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    
    -- 加载其他的小花
    self:loadOtherFlower()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end


-- 加载其他的小花
function M:loadOtherFlower()
    T.clear(self._otherFlowerTb)
    if self._index == 1 then 
        local angle = {0, 0, 5, 5, 10, 0, -10} 
        local index = {2, 5, 3, 5, 1, 6, 7}
        local pos = {ccp(-4.3, -4.6), ccp(7.6, 17.5), ccp(17.7, 39.7), ccp(32.0, 15.8), ccp(43.4, 26.6), ccp(4.6, 85.8), ccp(49.8, 101.4)}
        for i = 1, 5 do 
            local flower = D.img("tfroom/clean/flower/big/put/"..self._index.."_"..i..".png"):to(self, index[i]):p(pos[i]):rotate(angle[i])--:bindTouchLocate()--:scale()
            table.insert(self._otherFlowerTb, flower)
        end
        -- 加载两个灯笼
        for i = 1, 2 do 
            local lantern = D.img("tfroom/clean/flower/big/put/lantern.png"):to(self, index[i + 5]):p(pos[i + 5]):rotate(angle[i + 5])--:bindTouchLocate()
            table.insert(self._otherFlowerTb, lantern)
        end
    elseif self._index == 2 then
        local angle = {-10, -5, -5, 0, 0} 
        local index = {2, 1, 3, 5, 5}
        local pos = {ccp(0, 0), ccp(14.5, 52.4), ccp(56.1, 27.0), ccp(-30, 65), ccp(40, 108.2)}
        for i = 1, 3 do 
            local flower = D.img("tfroom/clean/flower/big/put/"..self._index.."_"..i..".png"):to(self, index[i]):p(pos[i]):rotate(angle[i])--:bindTouchLocate()--:scale()
            table.insert(self._otherFlowerTb, flower)
        end
        -- 加载两个灯笼
        for i = 1, 2 do 
            local lantern = D.img("tfroom/clean/flower/big/put/lantern.png"):to(self, index[i + 3]):p(pos[i + 3])--:bindTouchLocate()
            table.insert(self._otherFlowerTb, lantern)
        end
    elseif self._index == 3 then 
        local angle = {0, 10, 25}
        local index = {2, 1, 3}
        local pos = {ccp(0, 0), ccp(14.5, 52.4), ccp(28.6, -6.6), ccp(-15.6, 68.6), ccp(52.0, 108.2)}
        for i = 1, 3 do 
            local flower = D.img("tfroom/clean/flower/big/put/"..self._index.."_"..i..".png"):to(self, index[i]):p(pos[i]):rotate(angle[i])--:bindTouchLocate()--:scale()
            table.insert(self._otherFlowerTb, flower)
        end
    elseif self._index == 4 then 
        local angle = {-15, -22, -5 ,1}
        local index = {3, 2, 2, 1}
        local pos = {ccp(0, 0), ccp(-32.4, 43.9), ccp(21.1, 50.4), ccp(-2.2, 97.7)}
        for i = 1, 4 do 
            local flower = D.img("tfroom/clean/flower/big/put/"..self._index.."_"..i..".png"):to(self, index[i]):p(pos[i]):rotate(angle[i])--:bindTouchLocate()--:scale()
            table.insert(self._otherFlowerTb, flower)
        end
    end
    -- local 
end


--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
