--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Towel")
M.TAG       = "TowelNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    self._layer = params.layer
    -- 计数
    self._clearCount = 0
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
end

-- 打开引导
function M:openGuide()
    -- 开启引导
    guideFn:openGuide(self, 0.1, 3)
end

-- 抹布动作
function M:towelAction()
    if self._towelAct then return end
    local index1, index2 = 1, 5
    if self._clearCount > 0 then 
        index1 = 6
        index2 = 4
    end
    self._towelAct = A.cycle({
        {"imagerange", "tfcleanwindow/towel/", index1, index2, 0.1},
    }):at(self)
end


-- 停止抹布动作
function M:stopTowelAction()
    if not self._towelAct then return end
    self:stopAction(self._towelAct)
    self._towelAct = nil
end

-- 抹布离场
function M:towelOut()
    self:stopTowelAction()
    self:display("tfcleanwindow/towel/7.png")
    self._canTouch = false
    self._layer._bigTexture:fadeOutEvent()
    -- 结束动作
    self:finishAct()
    -- 声音渐弱或渐强
    sound.voiceFadeTo(self._sfx05703011, 0.01, 1)
end

-- 结束动作
function M:finishAct()
    -- 播放配音
    soundVoice:playEffectv057174()
    -- 音效
    soundEffect:playEffectsfx05703017()
    if self._layer._order == 1 then 
        --  加载粒子
        local particle = Tools:newParticle("particle/vase_clean.plist", 480 + X_OFFSET, 215 + Y_OFFSET):to(self._layer, 999)
        Tools:insertParticleTb(self._layer, particle)
    else
        --  加载粒子
        local particle = Tools:newParticle("particle/vase_clean2.plist", 480 + X_OFFSET, 215 + Y_OFFSET):to(self._layer, 999)
        Tools:insertParticleTb(self._layer, particle)
    end
    A.line({
        {"delay", 0.3},
        {"fn", function ()
            self._layer._hand:enter() 
        end}
    }):at(self)
    -- 返回动作
    self:back()
end

-- 返回动作
function M:back()
    A.line({
        {"jumpTo", 0.5, ccp(830 + X_OFFSET, 70), 50, 1},
        {"fn", function ()
            Tools:resetParent(self, self._layer._hand, 93)
            commonAct:nodeScale(self, 1, 0.5)
            A.line({
                {"delay", 0.3},
                {"fn", function ()
                    -- 去广告
                    Tools:closeAd()
                    -- 手手消失
                    self._layer._hand:quit() 
                    -- 瓶子移动
                    self:itemMove()
                    -- 加载ui栏
                    self._layer:loadFlowerScrolUi()
                end}
            }):at(self)
        end}
    }):at(self)
end

-- 瓶子移动
function M:itemMove()
    local pos = {ccp(0, -220), ccp(0, -190)}
    A.line({
        {"delay", 0.5},
        {"union",{
            {"moveBy", 0.6, pos[self._layer._order]},
            {"fn", function()
                --音效
                soundEffect:playEffectsfx05703012()
            end},
        }},
    }):at(self._layer._bigFlower)
    A.line({
        {"delay", 0.5},
        {"easing", "BACKOUT", {"moveBy", 0.3, ccp(-50, 0)}},
    }):at(self._layer._box)
end

-- 计算函数
function M:count()
    local posName = {self._layer._clearPos, self._layer._clearPos1}
    for i, v in ipairs(posName[self._layer._order]) do
        if PT.distance(v, self._startPos) < 25 then
            if self._layer._testNodeTable then
                self._layer._testNodeTable[i]:hide()
                table.remove(self._layer._testNodeTable, i)
            end
            table.remove(posName[self._layer._order], i)
            self._clearCount = self._clearCount + 1
            break
        end
    end
end

-- 擦拭花瓶
function M:playSoundEffect()
    if not self._sfx05703011 then
        -- 播放音效[sfx05703011]擦拭花瓶
        self._sfx05703011     = soundEffect:playEffectsfx05703011()
        sound.setFinishCallback(self._sfx05703011, function()
            self._sfx05703011 = nil
        end)
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    print(self._canTouch)
    if not self._canTouch then return end
    -- 音效[sfx05700001]
    soundEffect:playEffectsfx05700001()
    -- 关闭引导
    guideFn:stopGuide(self)
    -- 手手消失
    if not self._once then 
        self._once = true
        self._layer._hand:quit() 
    end
    self:towelAction()
    self._startPos = ccp(x, y)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._canTouch then return end
    self._layer._bigTexture:erasure(self._startPos, ccp(x, y + 50), nil, 255, 0.65)
    self:p(x, y)
    bb.si.Tool.limitRectMove({
        node      = self,
        -- marginTop = 80,
    })
    bb.si.Tool.limitButtonMove({node = self})
    -- 计算函数
    self:count()
    if self._clearCount >= 20 then 
        self:towelOut()
    end
    if x < 600 + X_OFFSET and x > 360 + X_OFFSET and y > 105 + Y_OFFSET and y < 425 then 
        self:playSoundEffect()
    end
    if self._clearCount >= 10 and not self._onceEnter then 
        self._onceEnter = true
        -- 停止动作
        self:stopTowelAction()
        -- 开始擦除改变
        self:towelAction()
    end
    self._startPos = ccp(x, y)
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end
    if self._clearCount >= 15 then 
        self:towelOut()
    end
    -- 声音渐弱或渐强
    sound.voiceFadeTo(self._sfx05703011, 0.01, 1)
    -- 开启引导
    guideFn:openGuide(self, 0.1, 3)
    -- 开启引导
    guideFn:openGuide(self, 0.1, 3)
    self:stopTowelAction()
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end






--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]

----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
