local M = {}

--------------------------
-- 公共方法
--------------------------
-- 播放音效
function M:playSound(fileName, isCycle)
    local isCycle = ifnil(isCycle, false)
    local nowSound = sound.playSound("effect/".. fileName ..".mp3", isCycle)
    self._nowSound = nowSound
    return nowSound
end

-- 停止当前音效
function M:stopNowSound()
    if self._nowSound then 
        sound.stopSound(self._nowSound)
        self._nowSound = nil 
    end 
end

-- 获取时长
function M:getVoiceTime(fileName, t)
    local t = t or 2
    local path = sound.getFullPath("effect/" .. fileName .. ".mp3")
    local time = NV.soundDuration(path, t)
    return time
end

-- 获取音频长度
function M:soundDuration(fileName, default)
    if (fileName == "") then
        return 3
    end
    local path = sound.getFullPath("effect/" .. fileName .. ".mp3")
    local time = NV.soundDuration(path, default)
    return time
end

--------------------------
-- 语音
--------------------------
-- 播放配音[v057177]宝宝过春节
function M:playEffectv057177()
    return self:playSound("v057177")
end
-- 播放配音[v057001]爸爸，你在扫地吗？
function M:playEffectv057001()
    return self:playSound("v057001")
end
-- 播放配音[v057002]哇~妙妙也想帮忙
function M:playEffectv057002()
    return self:playSound("v057002")
end
-- 播放配音[v057080]窗户太脏啦！要先擦一擦哦！
function M:playEffectv057080()
    return self:playSound("v057080")
end
-- 播放配音[v057003]快贴上奇奇买回来的窗花~
function M:playEffectv057003()
    return self:playSound("v057003")
end
-- 播放配音[v057004]挂上好看的东西，大家一定会更喜欢~
function M:playEffectv057004()
    return self:playSound("v057004")
end
-- 播放配音[v057081]花瓶也好脏呀，擦一擦吧
function M:playEffectv057081()
    return self:playSound("v057081")
end
-- 播放配音[v057005]耶！花开富贵！
function M:playEffectv057005()
    return self:playSound("v057005")
end
-- 播放配音[v057006]爸爸你看！客厅是不是变漂亮啦！
function M:playEffectv057006()
    return self:playSound("v057006")
end
-- 播放配音[v057007]咦？总觉得还缺了点什么？
function M:playEffectv057007()
    return self:playSound("v057007")
end
-- 播放配音[v057008]是呀，新年快到了，要做个大扫除，扫去旧的东西，才能迎来新的一年哦~
function M:playEffectv057008()
    return self:playSound("v057008")
end
-- 播放配音[v057009]宝贝真棒！谢谢你~
function M:playEffectv057009()
    return self:playSound("v057009")
end
-- 播放配音[v057174]擦得真干净呀宝贝！
function M:playEffectv057174()
    return self:playSound("v057174")
end
-- 播放配音[v057082]真好看！
function M:playEffectv057082()
    return self:playSound("v057082")
end
-- 播放配音[v057083]哈哈哈，真喜庆
function M:playEffectv057083()
    return self:playSound("v057083")
end
-- 播放配音[v057084]说的真好！妙妙！
function M:playEffectv057084()
    return self:playSound("v057084")
end
-- 播放配音[v057010]太棒了！还好有宝贝的帮助，我们可以开心地迎新年啦~
function M:playEffectv057010()
    return self:playSound("v057010")
end
-- 播放配音[v057085]我们去看看还缺点什么吧
function M:playEffectv057085()
    return self:playSound("v057085")
end
-- 播放配音[v057011]爸爸快看！我们的大门还是空着的！
function M:playEffectv057011()
    return self:playSound("v057011")
end
-- 播放配音[v057012]挂灯笼咯！
function M:playEffectv057012()
    return self:playSound("v057012")
end
-- 播放配音[v057013]（笑）对了，我们还要贴对联、挂灯笼呢
function M:playEffectv057013()
    return self:playSound("v057013")
end
-- 播放配音[v057014]这叫上联
function M:playEffectv057014()
    return self:playSound("v057014")
end
-- 播放配音[v057015]这叫下联
function M:playEffectv057015()
    return self:playSound("v057015")
end
-- 播放配音[v057016]最后是横批哟
function M:playEffectv057016()
    return self:playSound("v057016")
end
-- 播放配音[v057017]哇！大红灯笼高高挂！要过年咯！
function M:playEffectv057017()
    return self:playSound("v057017")
end
-- 播放配音[v057018]今天两个宝贝都辛苦啦！
function M:playEffectv057018()
    return self:playSound("v057018")
end
-- 播放配音[v057019]新年快到了，要办年货咯！
function M:playEffectv057019()
    return self:playSound("v057019")
end
-- 播放配音[v057020]包在我身上！
function M:playEffectv057020()
    return self:playSound("v057020")
end
-- 播放配音[v057021]爸爸和妙妙在忙什么呢？
function M:playEffectv057021()
    return self:playSound("v057021")
end
-- 播放配音[v057022]奇奇可以一起帮忙嘛？
function M:playEffectv057022()
    return self:playSound("v057022")
end
-- 播放配音[v057023]奇奇，可以帮妈妈找到这些年货吗？
function M:playEffectv057023()
    return self:playSound("v057023")
end
-- 播放配音[v057024]嗯！宝贝真棒
function M:playEffectv057024()
    return self:playSound("v057024")
end
-- 播放配音[v057025]对，就是这个~
function M:playEffectv057025()
    return self:playSound("v057025")
end
-- 播放配音[v057026]咦…我们不需要买它哟
function M:playEffectv057026()
    return self:playSound("v057026")
end
-- 播放配音[v057027]谢谢宝贝呀，年货全都买到啦
function M:playEffectv057027()
    return self:playSound("v057027")
end
-- 播放配音[v057086]快回去给他们看看我们买的年货吧
function M:playEffectv057086()
    return self:playSound("v057086")
end
-- 播放配音[v057028]新年到，新年到，零食瓜子少不了
function M:playEffectv057028()
    return self:playSound("v057028")
end
-- 播放配音[v057029]选一选，看一看嘞~
function M:playEffectv057029()
    return self:playSound("v057029")
end
-- 播放配音[v057030]走好嘞您嘞~
function M:playEffectv057030()
    return self:playSound("v057030")
end
-- 播放配音[v057031]挂灯笼，贴春联，红红火火过大年~
function M:playEffectv057031()
    return self:playSound("v057031")
end
-- 播放配音[v057032]想买些什么呢！
function M:playEffectv057032()
    return self:playSound("v057032")
end
-- 播放配音[v057033]拜拜~
function M:playEffectv057033()
    return self:playSound("v057033")
end
-- 播放配音[v057034]卖花咯~看一看，舒心，买一束，开心~
function M:playEffectv057034()
    return self:playSound("v057034")
end
-- 播放配音[v057035]呵呵~欢迎光临
function M:playEffectv057035()
    return self:playSound("v057035")
end
-- 播放配音[v057036]谢谢惠顾~
function M:playEffectv057036()
    return self:playSound("v057036")
end
-- 播放配音[v057037]早上好~
function M:playEffectv057037()
    return self:playSound("v057037")
end
-- 播放配音[v057038]妈妈，为什么除夕要吃年夜饭呀
function M:playEffectv057038()
    return self:playSound("v057038")
end
-- 播放配音[v057039]好耶！妙妙想要做饭给大家吃！
function M:playEffectv057039()
    return self:playSound("v057039")
end
-- 播放配音[v057040]饺子
function M:playEffectv057040()
    return self:playSound("v057040")
end
-- 播放配音[v057041]年年有鱼
function M:playEffectv057041()
    return self:playSound("v057041")
end
-- 播放配音[v057042]包饺子啦！
function M:playEffectv057042()
    return self:playSound("v057042")
end
-- 播放配音[v057043]咕噜咕噜，烧一锅开水
function M:playEffectv057043()
    return self:playSound("v057043")
end
-- 播放配音[v057087]再把饺子放到锅里
function M:playEffectv057087()
    return self:playSound("v057087")
end
-- 播放配音[v057088]有调料，饺子会更好吃
function M:playEffectv057088()
    return self:playSound("v057088")
end
-- 播放配音[v057044]陈醋
function M:playEffectv057044()
    return self:playSound("v057044")
end
-- 播放配音[v057045]番茄酱
function M:playEffectv057045()
    return self:playSound("v057045")
end
-- 播放配音[v057046]辣椒粉
function M:playEffectv057046()
    return self:playSound("v057046")
end
-- 播放配音[v057047]完成啦！
function M:playEffectv057047()
    return self:playSound("v057047")
end
-- 播放配音[v057048]鱼蒸好啦！
function M:playEffectv057048()
    return self:playSound("v057048")
end
-- 播放配音[v057049]蒸鱼豉油
function M:playEffectv057049()
    -- return self:playSound("v057049")
end
-- 播放配音[v057050]年夜饭呀，又叫团圆饭，是为了让一家人坐在一起吃饭，团团圆圆。
function M:playEffectv057050()
    return self:playSound("v057050")
end
-- 播放配音[v057173]妙妙，你想跟妈妈一起学做年夜饭吗？
function M:playEffectv057173()
    return self:playSound("v057173")
end
-- 播放配音[v057051]妙妙想做什么菜呢
function M:playEffectv057051()
    return self:playSound("v057051")
end
-- 播放配音[v057052]妙妙，要搅拌锅里的饺子，才不会粘住哦
function M:playEffectv057052()
    return self:playSound("v057052")
end
-- 播放配音[v057053]把葱和姜塞到鱼肚子下，蒸出来的鱼会香喷喷哒
function M:playEffectv057053()
    return self:playSound("v057053")
end
-- 播放配音[v057089]淋上蒸鱼豉油，鱼会更香哦~
function M:playEffectv057089()
    return self:playSound("v057089")
end
-- 播放配音[v057054]最后淋上滚烫的油，香味全出来啦
function M:playEffectv057054()
    return self:playSound("v057054")
end
-- 播放配音[v057055]宝贝太能干啦，我们继续下一道菜吧！
function M:playEffectv057055()
    return self:playSound("v057055")
end
-- 播放配音[v057056]上菜咯，把美味的饭菜摆上桌吧~
function M:playEffectv057056()
    return self:playSound("v057056")
end
-- 播放配音[v057057]哈哈哈，真是一桌好菜，去喊大家吃饭咯~
function M:playEffectv057057()
    return self:playSound("v057057")
end
-- 播放配音[v057073]白玉饺子，吉祥如意
function M:playEffectv057073()
    return self:playSound("v057073")
end
-- 播放配音[v057074]年年有鱼，富贵连年
function M:playEffectv057074()
    return self:playSound("v057074")
end
-- 播放配音[v057075]什锦火锅，红红火火
function M:playEffectv057075()
    return self:playSound("v057075")
end
-- 播放配音[v057059]好香呀~
function M:playEffectv057059()
    return self:playSound("v057059")
end
-- 播放配音[v057076]水煮青菜，平平安安
function M:playEffectv057076()
    return self:playSound("v057076")
end
-- 播放配音[v057060]哇—要流口水了~
function M:playEffectv057060()
    return self:playSound("v057060")
end
-- 播放配音[v057077]蜜汁烧鸡，大吉大利
function M:playEffectv057077()
    return self:playSound("v057077")
end
-- 播放配音[v057078]四喜丸子，福禄寿喜
function M:playEffectv057078()
    return self:playSound("v057078")
end
-- 播放配音[v057079]红烧大虾，和和美美
function M:playEffectv057079()
    return self:playSound("v057079")
end
-- 播放配音[v057061]宝贝们，来拿新年红包啦
function M:playEffectv057061()
    return self:playSound("v057061")
end
-- 播放配音[v057062]接下来是奇奇的红包哦~
function M:playEffectv057062()
    return self:playSound("v057062")
end
-- 播放配音[v057063]恭喜宝贝们又长大一岁！
function M:playEffectv057063()
    return self:playSound("v057063")
end
-- 播放配音[v057064]耶！红包！红包！
function M:playEffectv057064()
    return self:playSound("v057064")
end
-- 播放配音[v057065]谢谢爸爸妈妈，祝你们财源滚滚来
function M:playEffectv057065()
    return self:playSound("v057065")
end
-- 播放配音[v057066]耶！奇奇有大~红包啦！
function M:playEffectv057066()
    return self:playSound("v057066")
end
-- 播放配音[v057067]谢谢爸爸妈妈，祝你们新年快乐
function M:playEffectv057067()
    return self:playSound("v057067")
end
-- 播放配音[v057068]奇奇喜欢哪个礼物呢？
function M:playEffectv057068()
    return self:playSound("v057068")
end
-- 播放配音[v057069]妙妙喜欢哪个礼物呢？
function M:playEffectv057069()
    return self:playSound("v057069")
end
-- 播放配音[v057070]当当当——礼物在哪里呢~
function M:playEffectv057070()
    return self:playSound("v057070")
end
-- 播放配音[v057071]诶呀没关系~新年红包少不了
function M:playEffectv057071()
    return self:playSound("v057071")
end
-- 播放配音[v057072]恭喜宝贝们又长大一岁！
function M:playEffectv057072()
    return self:playSound("v057072")
end
-- 播放配音[v057090]放烟花咯
function M:playEffectv057090()
    return self:playSound("v057090")
end
-- 播放配音[v057091]哇！好漂亮啊
function M:playEffectv057091()
    return self:playSound("v057091")
end
-- 播放配音[v057092]好耶好耶！
function M:playEffectv057092()
    return self:playSound("v057092")
end
-- 播放配音[v057093]放烟花咯
function M:playEffectv057093()
    return self:playSound("v057093")
end
-- 播放配音[v057094]好耶！
function M:playEffectv057094()
    return self:playSound("v057094")
end
-- 播放配音[v057095]呵呵，放烟花真开心
function M:playEffectv057095()
    return self:playSound("v057095")
end
-- 播放配音[v057096]宝贝们，烟花是很危险的，要站远一点看哟
function M:playEffectv057096()
    return self:playSound("v057096")
end
-- 播放配音[v057097]除夕就要结束，新的一年要到啦，咱们一家人来倒计时吧~
function M:playEffectv057097()
    return self:playSound("v057097")
end
-- 播放配音[v057098]孩子们！快抬头看~
function M:playEffectv057098()
    return self:playSound("v057098")
end
-- 播放配音[v057099]5——
function M:playEffectv057099()
    return self:playSound("v057099")
end
-- 播放配音[v057100]4——
function M:playEffectv057100()
    return self:playSound("v057100")
end
-- 播放配音[v057101]3——
function M:playEffectv057101()
    return self:playSound("v057101")
end
-- 播放配音[v057102]2——
function M:playEffectv057102()
    return self:playSound("v057102")
end
-- 播放配音[v057103]1——
function M:playEffectv057103()
    return self:playSound("v057103")
end
-- 播放配音[v057104]新年快乐！
function M:playEffectv057104()
    return self:playSound("v057104")
end
-- 播放配音[v057105]看到亲人朋友们，可以向他们拜年哦~
function M:playEffectv057105()
    return self:playSound("v057105")
end
-- 播放配音[v057106]美美老师~
function M:playEffectv057106()
    return self:playSound("v057106")
end
-- 播放配音[v057107]兔一一~
function M:playEffectv057107()
    return self:playSound("v057107")
end
-- 播放配音[v057108]闹闹~
function M:playEffectv057108()
    return self:playSound("v057108")
end
-- 播放配音[v057109]皮皮~
function M:playEffectv057109()
    return self:playSound("v057109")
end
-- 播放配音[v057110]壮壮~
function M:playEffectv057110()
    return self:playSound("v057110")
end
-- 播放配音[v057111]新年快乐！
function M:playEffectv057111()
    return self:playSound("v057111")
end
-- 播放配音[v057112]新年好呀！
function M:playEffectv057112()
    return self:playSound("v057112")
end
-- 播放配音[v057113]谢谢哟
function M:playEffectv057113()
    return self:playSound("v057113")
end
-- 播放配音[v057114]再见~
function M:playEffectv057114()
    return self:playSound("v057114")
end
-- 播放配音[v057115]我们也来帮忙贴福字吧！
function M:playEffectv057115()
    return self:playSound("v057115")
end
-- 播放配音[v057116]福字贴好啦！
function M:playEffectv057116()
    return self:playSound("v057116")
end
-- 播放配音[v057117]谢谢狗狗们！
function M:playEffectv057117()
    return self:playSound("v057117")
end
-- 播放配音[v057118]天快黑了，舞龙庙会就要开始啦！
function M:playEffectv057118()
    return self:playSound("v057118")
end
-- 播放配音[v057119]记得要有礼貌哦~
function M:playEffectv057119()
    return self:playSound("v057119")
end
-- 播放配音[v057120]敲敲门，拜年咯！
function M:playEffectv057120()
    return self:playSound("v057120")
end
-- 播放配音[v057121]美美老师~
function M:playEffectv057121()
    return self:playSound("v057121")
end
-- 播放配音[v057122]兔一一~
function M:playEffectv057122()
    return self:playSound("v057122")
end
-- 播放配音[v057123]闹闹~
function M:playEffectv057123()
    return self:playSound("v057123")
end
-- 播放配音[v057124]皮皮~
function M:playEffectv057124()
    return self:playSound("v057124")
end
-- 播放配音[v057125]壮壮~
function M:playEffectv057125()
    return self:playSound("v057125")
end
-- 播放配音[v057126]新年快乐！
function M:playEffectv057126()
    return self:playSound("v057126")
end
-- 播放配音[v057127]新年好呀！
function M:playEffectv057127()
    return self:playSound("v057127")
end
-- 播放配音[v057128]选个年货送给他吧~
function M:playEffectv057128()
    return self:playSound("v057128")
end
-- 播放配音[v057129]谢谢你`
function M:playEffectv057129()
    return self:playSound("v057129")
end
-- 播放配音[v057130]再见哟~
function M:playEffectv057130()
    return self:playSound("v057130")
end
-- 播放配音[v057131]我们也来帮忙切年糕吧！
function M:playEffectv057131()
    return self:playSound("v057131")
end
-- 播放配音[v057132]太可爱啦~~
function M:playEffectv057132()
    return self:playSound("v057132")
end
-- 播放配音[v057133]拜年可真开心呀~
function M:playEffectv057133()
    return self:playSound("v057133")
end
-- 播放配音[v057134]奇奇妙妙，新年快乐呀~
function M:playEffectv057134()
    return self:playSound("v057134")
end
-- 播放配音[v057135]谢谢孩子们，这是我的回礼哟~
function M:playEffectv057135()
    return self:playSound("v057135")
end
-- 播放配音[v057136]对啦，我正打算贴福字哟
function M:playEffectv057136()
    return self:playSound("v057136")
end
-- 播放配音[v057137]这就是福字，不过呀得把它倒过来贴，意思是福气到了~
function M:playEffectv057137()
    return self:playSound("v057137")
end
-- 播放配音[v057138]谢谢孩子们，再见~
function M:playEffectv057138()
    return self:playSound("v057138")
end
-- 播放配音[v057139]奇奇妙妙，新年好呀~
function M:playEffectv057139()
    return self:playSound("v057139")
end
-- 播放配音[v057140]谢谢你们~这是我的回礼
function M:playEffectv057140()
    return self:playSound("v057140")
end
-- 播放配音[v057141]拜拜~
function M:playEffectv057141()
    return self:playSound("v057141")
end
-- 播放配音[v057142]奇奇妙妙，新年快乐~
function M:playEffectv057142()
    return self:playSound("v057142")
end
-- 播放配音[v057143]好酷的礼物！我正准备分年糕，也想送一些给你们！
function M:playEffectv057143()
    return self:playSound("v057143")
end
-- 播放配音[v057144]用这根线把年糕分成片吧！你们知道吗，年糕不但好吃，还有年年高升的意思呢！
function M:playEffectv057144()
    return self:playSound("v057144")
end
-- 播放配音[v057145]带回家和爸爸妈妈一起吃噢！
function M:playEffectv057145()
    return self:playSound("v057145")
end
-- 播放配音[v057146]再见再见~
function M:playEffectv057146()
    return self:playSound("v057146")
end
-- 播放配音[v057147]奇奇妙妙，新年好唷
function M:playEffectv057147()
    return self:playSound("v057147")
end
-- 播放配音[v057148]谢谢~我也有准备小礼物唷
function M:playEffectv057148()
    return self:playSound("v057148")
end
-- 播放配音[v057149]再见唷
function M:playEffectv057149()
    return self:playSound("v057149")
end
-- 播放配音[v057150]新年快乐，万事如意噢！
function M:playEffectv057150()
    return self:playSound("v057150")
end
-- 播放配音[v057151]谢谢你们，我有回礼噢！
function M:playEffectv057151()
    return self:playSound("v057151")
end
-- 播放配音[v057152]看呐！狗狗们也想拜年呢~
function M:playEffectv057152()
    return self:playSound("v057152")
end
-- 播放配音[v057153]哇塞！咱们三人一起去舞龙吧！
function M:playEffectv057153()
    return self:playSound("v057153")
end
-- 播放配音[v057154]舞龙庙会开始啦！
function M:playEffectv057154()
    return self:playSound("v057154")
end
-- 播放配音[v057155]挪一挪手指，让龙灯动起来吧
function M:playEffectv057155()
    return self:playSound("v057155")
end
-- 播放配音[v057156]看，有人想看咱们的龙灯表演，快到他身边去
function M:playEffectv057156()
    return self:playSound("v057156")
end
-- 播放配音[v057157]爱心是人们产生的快乐，继续收集爱心，带来更多的快乐吧
function M:playEffectv057157()
    return self:playSound("v057157")
end
-- 播放配音[v057158]小朋友们！祝你们新的一年健康快乐，每天都能笑嘻嘻
function M:playEffectv057158()
    return self:playSound("v057158")
end
-- 播放配音[v057175]春节歌谣
function M:playEffectv057175()
    return self:playSound("v057175")
end
-- 播放配音[v057176]春节小知识
function M:playEffectv057176()
    return self:playSound("v057176")
end
-- 播放配音[v057159]春节
function M:playEffectv057159()
    return self:playSound("v057159")
end
-- 播放配音[v057160]春节又叫新年，是中国最重要的传统节日之一。过了春节，我们就又长大了一岁！
function M:playEffectv057160()

    return nil--self:playSound("v057160")
end
-- 播放配音[v057161]大扫除
function M:playEffectv057161()
    return self:playSound("v057161")
end
-- 播放配音[v057162]大扫除，是春节前很重要的一件事。人们会打扫干净屋子，来迎接新的一年。
function M:playEffectv057162()
    return self:playSound("v057162")
end
-- 播放配音[v057163]春联
function M:playEffectv057163()
    return self:playSound("v057163")
end
-- 播放配音[v057164]春节时，人们会写春联贴春联，为了新的一年，可以红红火火。
function M:playEffectv057164()
    return self:playSound("v057164")
end
-- 播放配音[v057165]年夜饭
function M:playEffectv057165()
    return self:playSound("v057165")
end
-- 播放配音[v057166]年夜饭，又叫团圆饭。在除夕夜，一家人会坐在一起吃饭，团团圆圆。
function M:playEffectv057166()
    return self:playSound("v057166")
end
-- 播放配音[v057167]拜年
function M:playEffectv057167()
    return self:playSound("v057167")
end
-- 播放配音[v057168]在热闹的正月里，人们会到亲人和朋友家做客，送去新年祝福。
function M:playEffectv057168()
    return self:playSound("v057168")
end
-- 播放配音[v057169]烟花爆竹
function M:playEffectv057169()
    return self:playSound("v057169")
end
-- 播放配音[v057170]在很久以前，人们会在过年时燃放爆竹，来吓走可怕的年兽。小朋友要记住，烟花爆竹很危险，要离的远远的。
function M:playEffectv057170()
    return self:playSound("v057170")
end
-- 播放配音[v057171]舞龙舞狮
function M:playEffectv057171()
    return self:playSound("v057171")
end
-- 播放配音[v057172]龙和狮子是中国的吉祥物，过年的时候，人们喜欢舞龙舞狮来庆祝节日
function M:playEffectv057172()
    return self:playSound("v057172")
end
-- 播放配音[v057178]廿四
function M:playEffectv057178()
    return self:playSound("v057178")
end
-- 播放配音[v057179]除夕
function M:playEffectv057179()
    return self:playSound("v057179")
end
-- 播放配音[v057180]正月初一
function M:playEffectv057180()
    return self:playSound("v057180")
end
-- 播放配音[v057181]妙妙，什么时候过年呐~
function M:playEffectv057181()
    return self:playSound("v057181")
end
-- 播放配音[v057182]料酒
function M:playEffectv057182()
    return self:playSound("v057182")
end
-- 播放配音[v057183]糖果
function M:playEffectv057183()
    return self:playSound("v057183")
end
-- 播放配音[v057184]瓜子
function M:playEffectv057184()
    return self:playSound("v057184")
end
-- 播放配音[v057185]花生
function M:playEffectv057185()
    return self:playSound("v057185")
end
-- 播放配音[v057186]橘子
function M:playEffectv057186()
    return self:playSound("v057186")
end
-- 播放配音[v057187]苹果
function M:playEffectv057187()
    return self:playSound("v057187")
end
-- 播放配音[v057188]灯笼
function M:playEffectv057188()
    return self:playSound("v057188")
end
-- 播放配音[v057189]中国结
function M:playEffectv057189()
    return self:playSound("v057189")
end
-- 播放配音[v057190]春联
function M:playEffectv057190()
    return self:playSound("v057190")
end
-- 播放配音[v057191]福字
function M:playEffectv057191()
    return self:playSound("v057191")
end
-- 播放配音[v057192]富贵竹
function M:playEffectv057192()
    return self:playSound("v057192")
end
-- 播放配音[v057193]银柳
function M:playEffectv057193()
    return self:playSound("v057193")
end
-- 播放配音[v057194]洋牡丹
function M:playEffectv057194()
    return self:playSound("v057194")
end
-- 播放配音[v057195]金百合
function M:playEffectv057195()
    return self:playSound("v057195")
end
-- 播放配音[v057196]压岁钱~
function M:playEffectv057196()
    return self:playSound("v057196")
end
-- 播放配音[v057197]在年夜饭后，长辈会给小朋友压岁钱，祝福小朋友能够平平安安地长
function M:playEffectv057197()
    return self:playSound("v057197")
end
-- 播放配音[v273388]年兽
function M:playEffectv273388()
    return self:playSound("v273388")
end
-- 播放配音[v273389]传说古时候每到除夕“年兽”就出来捣乱，所以这天人们都会燃放爆竹来驱赶“年兽”
function M:playEffectv273389()
    return self:playSound("v273389")
end

return M
