--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏声音管理类，定义声音管理相关操作方法及逻辑实现。

-   实现声音管理常用操作。

]]

----------------------
-- 类
----------------------
local M = {}
M.TAG   = "sound"

-- 指定继承关系
setmetatable(M, { __index = function(table, key)
    return bb.SoundBase[key]
end})


----------------------
-- 公共参数
----------------------
-- [公共参数]
-- 常量
-- ..
local bgmusic = nil
-- [操作变量]
-- ..
--场景中需要暂停的声音
local scenesounds     = {}
--拍照场景音频集合
local takephotosounds = {}
--背景音乐集合
local backgroundmusics= {}


M._nowMusic = nil

M._nowMusicName = ""


-- 获取音频长度
function M:soundDuration(fileName, default)
    if (fileName == "") then
        return 3
    end
    local path = sound.getFullPath("effect/" .. fileName .. ".mp3")
    local time = NV.soundDuration(path, default, true)
    return time
end



----------------------
-- 预加载方法
----------------------
-- [工具方法][预加载]
local function preloadMusicBackground(fileName)
    M.preloadMusic("music/" .. fileName)
end
-- 预加载背景音乐[001]
function M:preloadMusicBackground001() 
    preloadMusicBackground("bg001.mp3")
end

-- 预加载背景音乐[002]
function M:preloadMusicBackground002() 
    preloadMusicBackground("bg002.mp3")
end


---------


-- [工具方法][背景音乐]
local function playMusicBackground(fileName)
    -- if G_NO_PLAY_BG_MUSIC then return end
    -- if M._nowMusicName == fileName then return end

    -- if M._nowMusic then
    --     sound.voiceFadeTo(M._nowMusic, 0, 0.5)
    -- end
    -- M._nowMusicName = fileName

    -- local scene = D.getRunningScene()
    -- if M._nowMusic and scene then
    --     M._nowMusic = nil
    --     M._nowMusicName = ""
    --     scene:performWithDelay(function()
    --         M._nowMusic = sound.playMusic("music/" .. fileName, true)
    --         M._nowMusicName = fileName
    --         sound.setVolume(M._nowMusic, 0)
    --         sound.voiceFadeTo(M._nowMusic, 1, 0.5)
    --     end, 0.5)
    -- else
    --     M._nowMusic = sound.playMusic("music/" .. fileName, true)
    --     sound.setVolume(M._nowMusic, 0)
    --     sound.voiceFadeTo(M._nowMusic, 1, 0.5)
    -- end
    sound.playMusic("music/" .. fileName,true)
end
-- 播放背景音乐[001]
function M:playMusicBackground001()
    playMusicBackground("bg001.mp3")
end
-- 播放背景音乐[002]
function M:playMusicBackground002()
    playMusicBackground("bg002.mp3")
end

-- 播放音效[057BGM01]欢迎界面
function M:play057BGM01()
    local handle = playMusicBackground("057BGM01.mp3")
end
-- 播放音效[057BGM02]开场动画、图鉴-春节歌谣
function M:play057BGM02()
    local handle = playMusicBackground("057BGM02.mp3")
end
-- 播放音效[057BGM03]选择界面
function M:play057BGM03()
    local handle = playMusicBackground("057BGM03.mp3")
end
-- 播放音效[057BGM04]办年货
function M:play057BGM04()
    local handle = playMusicBackground("057BGM04.mp3")
end
-- 播放音效[057BGM05]大扫除
function M:play057BGM05()
    local handle = playMusicBackground("057BGM05.mp3")
end
-- 播放音效[057BGM06]厨房做菜
function M:play057BGM06()
    local handle = playMusicBackground("057BGM06.mp3")
end
-- 播放音效[057BGM07]上菜、吃年夜饭
function M:play057BGM07()
    local handle = playMusicBackground("057BGM07.mp3")
end
-- 播放音效[057BGM08]压岁钱
function M:play057BGM08()
    local handle = playMusicBackground("057BGM08.mp3")
end
-- 播放音效[057BGM09]拜年
function M:play057BGM09()
    local handle = playMusicBackground("057BGM09.mp3")
end
-- 播放音效[057BGM10]舞龙
function M:play057BGM10()
    local handle = playMusicBackground("057BGM10.mp3")
end

-- [工具方法][音效]
local function playEffectButton(fileName)
    M.playEffect("effect/button/" .. fileName)
end
-- 播放按钮音效[001]
function M:playEffectButton001()
    playEffectButton("btn001.mp3")
end

-- 播放按钮音效[001]
function M:playEffectButton001()
    playEffectButton("btn001.mp3")
end
---------


-- [工具方法][音效]
function M:playEffectWelcome()
    M.playEffect("effect/" .. "welcome.mp3")
end
function M:playEffectWelcome1()
    M.playEffect("effect/" .. "welcome1.mp3")
end
function M:playEffectWelcome2()
    M.playEffect("effect/" .. "welcome2.mp3")
end
function M:playEffectWelcome3()
    M.playEffect("effect/" .. "welcome3.mp3")
end






-------------------------------------
-- 盒子音效
-------------------------------------
-- 播放背景音乐[盒子001]
function M:playMusicBoxBackground001()
   playMusicBackground("box/box_bg.mp3") 
end

-- [工具方法][音效]
local function playEffect(fileName)
    M.playEffect("effect/" .. fileName)
end

-- 播放音效[宝宝巴士]跳1
function M:playEffectBox_Jump1()
    playEffect("box/box_jump1.mp3")
end

-- 播放音效[宝宝巴士]跳2
function M:playEffectBox_Jump2()
    playEffect("box/box_jump2.mp3")
end

-- 播放音效[宝宝巴士]跳3
function M:playEffectBox_Babybus()
    playEffect("box/box_babybus.mp3")
end

-- 播放音效[宝宝巴士]小鸟
function M:playEffectBox_Bird()
    playEffect("box/box_bird.mp3")
end

-- 播放音效[宝宝巴士]点击
function M:playEffectBox_Click()
    playEffect("box/box_click.wav")
end

-- 播放音效[宝宝巴士]奇奇
function M:playEffectBox_Kiki()
    playEffect("box/box_kiki.mp3")
end

-- 播放音效[宝宝巴士]奇奇
function M:playEffectBox_Rest()
    playEffect("box/box_rest.mp3")
end

-- 播放音效[宝宝巴士]奇奇
function M:playEffectBox_Rest_Short()
    playEffect("box/box_rest_short.mp3")
end

-- 播放音效[宝宝巴士]解锁时音效
function M:playEffectBox_Rest_Shake()
    playEffect("box/box_rest_shake.mp3")
end

-- 播放音效[宝宝巴士]解锁时音效
function M:playEffectBox_Rest_Unlock()
    playEffect("box/box_rest_unlock.mp3")
end

--卸载背景音
function M:unloadMusics()
  self.stopMusic(true)
end
------------------------------------------------------
return M