# 组件开发规范说明

## 目录结构
每个组件应该包含以下文件：
```
componentName/
  ├── componentName.js    // 组件逻辑
  ├── componentName.html  // 组件模板
  └── componentName.scss  // 组件样式
```
举例
```
lbLineSwitch/
  ├── lbLineSwitch.js    // 组件逻辑
  ├── lbLineSwitch.html  // 组件模板
  └── lbLineSwitch.scss  // 组件样式, 需在directives.scss中引入才会生效
```
## 命名规范
1. 组件目录名：使用小驼峰命名，与组件名保持一致
2. 组件文件名：与目录名保持一致(如`lbLineSwitch.html`、`lbLineSwitch.js`、`lbLineSwitch.scss`)
3. 组件指令名：建议使用 `lb` 前缀，采用驼峰命名法（如：`lbLineSwitch`）

## 文件规范

### JavaScript 文件
1. 使用 ES6 模块导出方式
2. 必须包含组件说明注释，包括：
   - 组件功能描述
   - 使用示例

### HTML 文件
1. 使用语义化标签
2. 保持结构清晰，适当添加注释
3. 使用 Angular 指令时注意命名规范

### SCSS 文件
1. 使用 BEM 命名规范
2. 样式作用域限定在组件内
3. 避免使用全局样式污染

## 组件开发流程
1. 创建组件目录及必要文件
2. 实现组件基础功能
3. 编写组件文档
4. 进行测试
5. 提交代码审查

