  /*
   * 经营概况时间筛选元素
   * 使用方法 <filter-time-component dateControl="dateControl" search = "fn"></filter-time-component>
   * prop: dateControl（双向绑定的数据源），search（单向绑定时间改变时查询函数），changeTabCallBack
   * dateControl格式 {
   *   type: String // 筛选日期类型 'day' 'week' 'month' 'year' 'range'
   *   modelValue: Array // [起始时间, 结束时间]
   *   minYear: String/Number // 初始年份
   *   changeTab: 加载完成后，父组件可使用changeTab手动触发tab切换事件
   * }
   */
  export default function registerFilterTimeComponent(module) {
    module.directive("filterTimeComponent", [
      "$cordovaDatePicker",
      "Tools",
      "$ionicModal",
      "$ionicScrollDelegate",
      "lbScrollDelegate",
      "$rootScope",
      "$ionicPopover",
      "$timeout",
      filterTimeComponent,
    ]);
    function filterTimeComponent(
      $cordovaDatePicker,
      Tools,
      $ionicModal,
      $ionicScrollDelegate,
      lbScrollDelegate,
      $rootScope,
      $ionicPopover,
      $timeout,
    ) {
      return {
        restrict: "E",
        replace: true,
        scope: {
          dateControl: "=",
          search: "&",
          changeTabCallBack: "&",
          intervalDays:"=",
        },
        templateUrl: "directives/filterTimeComponent/index.html",
        link: function (scope) {
          //  自定义时间段间隔
          scope.intervalDays = scope.intervalDays || 2;
          scope.nowDate = new Date();
          scope.platformIsIOS = $rootScope.platformIsIOS;
          scope.formatNowDate = Tools.dateFormat(scope.nowDate, "yyyy-MM-dd");
          scope.yearData = {
            years: [],
            yearDataList: [],
          };
          scope.tabOptions = [
            {
              label: "按天",
              val: "day",
            },
            {
              label: "按周",
              val: "week",
            },
            {
              label: "按月",
              val: "month",
            },
            // {
            //   label: "按季",
            //   val: "quarter",
            // },
            {
              label: "按年",
              val: "year",
            },
            {
              label: "按时间段",
              val: "range",
            },
          ];
          scope.prevBtnName = {
            day: "前一天",
            week: "前一周",
            month: "前一月",
            quarter: "前一季",
            year: "前一年",
          };
          scope.nextBtnName = {
            day: "后一天",
            week: "后一周",
            month: "后一月",
            quarter: "后一季",
            year: "后一年",
          };
          //经营明细时间周期需要展示的options个数
          scope.showOptionsNum = 2;
          //handleTabOptionsOfOperateDetail用于经营概况时间组件展示改造
          //经营概况时间周期需要记忆用户最后一次选择的时间周期类型，并于固定于时间周期最左侧，其他时间周期向右排列
          function handleTabOptionsOfOperateDetail() {  
            if (
              scope.dateControl.type != "day" &&
              scope.dateControl.fromOperateDetail
            ) {
              let index = scope.tabOptions.findIndex(
                (item) => item.val == scope.dateControl.type
              );
              let [deleteOptions] = scope.tabOptions.splice(index, 1);
              scope.tabOptions.unshift(deleteOptions);
            }
            if(scope.tabOptions.findIndex((item)=>item.val==scope.dateControl.type)<=1) {
              scope.currentOption = scope.tabOptions[scope.showOptionsNum]
            } else {
              scope.currentOption = scope.tabOptions.find((item) => item.val == scope.dateControl.type)
            }
          }

          // 日期第一项
          scope.earliestDate = null;
          scope.defaultType = "day";
          // 滚动到指定年份的函数
          scope.scrollToYear = function (year) {
            scope.currentYear = year;
            let currentYearObj = scope.yearData.yearDataList.find(
              (item) => item.year == scope.currentYear
            );
            if (currentYearObj) {
              var element = document.getElementById(
                "year" + currentYearObj.year
              ); // 假设每个年份对应的元素有一个特定的ID
              if (element) {
                var scrollDom =
                  $ionicScrollDelegate.$getByHandle("datePickerScroll");
                scrollDom.scrollTo(0, element.offsetTop);
              }
            }
          };
          scope.scrollHandler = function () {
            const content = document.querySelector(".year-content");
            const titles = content.querySelectorAll(".title");
            const scrollPosition = $ionicScrollDelegate
              .$getByHandle("datePickerScroll")
              .getScrollPosition().top;
            for (let i = 0; i < titles.length; i++) {
              const title = titles[i];
              const attrDate = title.getAttribute("data-year"); // 通过自定义属性获取日期信息
              const titlePosition = title.offsetTop;
              if (
                titlePosition <= scrollPosition &&
                titlePosition + title.clientHeight > scrollPosition
              ) {
                scope.currentYear = parseInt(attrDate);
                scope.$apply(); // 手动触发AngularJS脏检查
                break;
              }
            }
          };
          scope.setTime = function (type, isRange) {
            let startTime = scope.dateControl.modelValue[0];
            let endTime = scope.dateControl.modelValue[1];
            let selectedTime = type == "start" ? startTime : endTime;
            $cordovaDatePicker
              .show({
                date: selectedTime ? new Date(selectedTime) : new Date(),
                mode: "date",
                doneButtonLabel: "确定",
                cancelButtonLabel: "取消",
              })
              .then(function (d) {
                if (!isNaN(d.getTime())) {
                  if (!isRange) {
                    startTime = new Date(d.getTime());
                    endTime = new Date(d.getTime());
                    startTime.setHours(0, 0, 0, 0);
                    endTime.setHours(23, 59, 59, 999);
                    scope.dateControl.modelValue[0] = startTime;
                    scope.dateControl.modelValue[1] = endTime;
                    scope.search && scope.search();
                  } else {
                    selectedTime = new Date(d.getTime());
                    if (type == "start") {
                      if (endTime && selectedTime > endTime) {
                        Tools.toastShow("开始时间需小于结束时间");
                      } else {
                        scope.dateControl.modelValue[0] = selectedTime;
                        scope.search && scope.search();
                      }
                    } else {
                      if (startTime && selectedTime < startTime) {
                        Tools.toastShow("结束时间需大于起始时间");
                      } else {
                        scope.dateControl.modelValue[1] = selectedTime;
                        scope.search && scope.search();
                      }
                    }
                  }
                }
              });
          };
          // 获取日期处于当年的第几天
          function getDayOfYear(date) {
            const start = new Date(date.getFullYear(), 0, 0);
            const diff = date - start;
            const oneDay = 1000 * 60 * 60 * 24;
            const dayOfYear = Math.floor(diff / oneDay);
            return dayOfYear;
          }
          // 获取周/月/年
          scope.getWeekDates = function (year) {
            var dates = [];
            var currentDate = new Date(year, 0, 1); // 将日期设置为给定年份的第一天
            var weekNum = 1; // 初始化周数
            while (currentDate.getFullYear() === year) {
              // 只处理给定年份的日期且不超过今周
              if (currentDate.getDay() === 1 && currentDate <= scope.nowDate) {
                // 当日期对应的星期为周一时
                var weekRange = {};
                var startOfWeek = new Date(currentDate); // 记录本周开始日期
                var endOfWeek = new Date(currentDate); // 记录本周结束日期
                endOfWeek.setDate(endOfWeek.getDate() + 6);
                weekRange.weekNum = weekNum;
                weekRange.startOfWeek = startOfWeek;
                weekRange.endOfWeek = endOfWeek;
                weekRange.text =
                  "第" +
                  weekNum +
                  "周（" +
                  (startOfWeek.getMonth() + 1) +
                  "月" +
                  startOfWeek.getDate() +
                  "-" +
                  (endOfWeek.getMonth() + 1) +
                  "月" +
                  endOfWeek.getDate() +
                  "）";
                dates.push(weekRange);
                weekNum++; // 周数加一
              }
              currentDate.setDate(currentDate.getDate() + 1); // 日期加一天
            }
            return dates;
          };

          // 选择周期选择框
          scope.openSelectOptionPopover = function ($event) {
            $event && $event.stopPropagation() && $event.preventDefault();
            if (scope.selectOptionPopover) {
              scope.selectOptionPopover.show($event);
            } else {
              $ionicPopover
                .fromTemplateUrl("selectOptionPopover.html", {
                  scope: scope,
                })
                .then(function (popover) {
                  scope.selectOptionPopover = popover;
                  scope.selectOptionPopover.show($event);
                });
            }
          };

          // 关闭周期选择框
          scope.hideSelecOptionPopover = function (item) {
            var isSame = scope.dateControl.type === item.val;
            if (isSame) {
              scope.selectOptionPopover.hide();
              return;
            }
            scope.currentOption = item;
            scope.changeTab(item.val)
            scope.selectOptionPopover.hide();
          };


          scope.showDatePicker = function () {
            if (scope.datePickModal) {
              scope.datePickModal.show();
            } else {
              $ionicModal.fromTemplateUrl(
                "directives/filterTimeComponent/datePicker.html",
                function (modal) {
                  scope.datePickModal = modal;
                  scope.datePickModal.show();
                },
                {
                  scope: scope,
                  animation: "slide-in-perspective",
                }
              );
            }
            // 重置已选年份
            scope.currentYear =
              scope.dateControl.modelValue[0].getFullYear() ||
              scope.nowDate.getFullYear();
            scope.scrollToYear(scope.currentYear);
          };
          scope.onHideDateModal = function () {
            lbScrollDelegate.resize("datePickerScroll");
            scope.datePickModal && scope.datePickModal.hide();
          };
          // 获取日期所处的周(该方法一月一号为第一周)
          // scope.getWeekNumber = function (date) {
          //   const targetDate = new Date(date);
          //   targetDate.setHours(0, 0, 0, 0); // Set time to the beginning of the day
          //   targetDate.setDate(targetDate.getDate() + 4 - (targetDate.getDay() || 7));
          //   // 获取年份的第一天
          //   const firstDayOfYear = new Date(targetDate.getFullYear(), 0, 1);
          //   const weekNumber = Math.ceil(((targetDate - firstDayOfYear) / 86400000 + 1) / 7);
          //   return weekNumber;
          // };
          // 获取日期所处的周（每年第一个周一为第一周，如一月一号不是周一则为去年的周期）
          // sundayFirst 是否以周日为周第一天
          scope.getWeekNumber = function (date, sundayFirst) {
            const dayOffset = sundayFirst ? 0 : 1;
            date = new Date(date);
            // 获取年份的第一天
            var yearStart = new Date(date.getFullYear(), 0, 1);
            var firstMonday = new Date(yearStart.getTime());
            // 获取年份的第一周第一天
            // yearStart.getDate()：获取当前年份的第一天是几号，即获取一月一号的日期。
            // yearStart.getDay()：获取当前年份的第一天是星期几，返回值为 0（星期日）到 6（星期六）。
            // (1 - yearStart.getDay() + 7) % 7：这部分计算的目的是找到当前年份的第一个周一。假设一月一号是星期三（返回值为 2），那么 (1 - 2 + 7) % 7 的结果为 6，表示距离一月一号最近的周一是一月的第六天。
            // yearStart.getDate() + (1 - yearStart.getDay() + 7) % 7：将一月一号的日期加上距离最近的周一的天数，得到当前年份的第一个周一的日期。
            firstMonday.setDate(
              yearStart.getDate() + ((dayOffset - yearStart.getDay() + 7) % 7)
            );
            // 计算日期所在周数
            var diff = date - firstMonday;
            var weekNumber = Math.ceil((diff / (24 * 60 * 60 * 1000) + 1) / 7);
            // 如果计算出的周数为0，说明日期在去年最后一周
            if (weekNumber === 0) {
              var lastYear = date.getFullYear() - 1;
              var lastYearStart = new Date(lastYear, 0, 1);
              var lastYearEnd = new Date(lastYear, 11, 31);
              // 获取处于去年第几周
              var lastYearWeeks = Math.ceil(
                (lastYearEnd -
                  new Date(
                    lastYearStart.getTime() +
                      ((1 - lastYearStart.getDay() + 7) % 7)
                  )) /
                  (24 * 60 * 60 * 1000) /
                  7
              );
              weekNumber = lastYearWeeks;
            }
            return weekNumber;
          };
          function updateDateRange(type, currentDate, offset) {
            let startTime = "";
            let endTime = "";
            const currentYear = currentDate.getFullYear();
            const currentMonth = currentDate.getMonth();
            const targetMonth = currentMonth + offset;
            const targetQuarter = Math.ceil((currentMonth + 1) / 3) + offset;
            // 修改月份时可能会跨年 targetMonth为-1时说明去年，targetMonth为12为下一年
            const targetYear = currentYear + Math.floor(targetMonth / 12);
            const targetMonthNormalized = (targetMonth + 12) % 12;
            const targetYearOfQuarter = currentYear + Math.floor(targetQuarter / 4);
            const targetQuarterNormalized = (targetQuarter + 4) % 4;
            
            switch (type) {
              case "year":
                startTime = new Date(currentYear + offset, 0, 1);
                endTime = new Date(currentYear + offset, 11, 31, 23, 59, 59);
                break;
              case "quarter":
                startTime = new Date(targetYearOfQuarter, (targetQuarterNormalized-1) * 3, 1);
                endTime = new Date(targetYearOfQuarter, targetQuarterNormalized * 3, 0, 23, 59, 59);    
                break;
              case "month":
                // 获取月份第一个和最后一天
                startTime = new Date(targetYear, targetMonthNormalized, 1);
                endTime = new Date(
                  targetYear,
                  targetMonthNormalized + 1,
                  0,
                  23,
                  59,
                  59
                );
                break;
              case "week":
                startTime = new Date(currentDate);
                endTime = new Date(currentDate);
                startTime.setDate(startTime.getDate() + offset * 7);
                endTime.setDate(endTime.getDate() + offset * 7 + 6);
                endTime.setHours(23, 59, 59); // 设置时间为 23:59:59
                break;
              case "day":
                startTime = Tools.getDayBegin(
                  new Date(currentDate).setDate(currentDate.getDate() + offset)
                );
                endTime = Tools.getDayEnd(
                  new Date(currentDate).setDate(currentDate.getDate() + offset)
                );
                break;
              default:
                break;
            }
            return { startTime, endTime };
          }
          // 点击上一个/下一个获取时间
          function updateDate(type, offset) {
            const currentDate = scope.dateControl.modelValue[0];
            const { startTime, endTime } = updateDateRange(
              type,
              currentDate,
              offset
            );
            scope.dateControl.modelValue[0] = startTime;
            scope.dateControl.modelValue[1] = endTime;
            scope.search && scope.search();
          }
          scope.onSelectTime = function (type, year, month, week, quarter) {
            let startTime = "";
            let endTime = "";
            switch (type) {
              // 获取年份第一天
              case "year":
                startTime = new Date(year, 0, 1);
                endTime = new Date(year, 11, 31, 23, 59, 59);
                break;
              // 获取月份第一天和最后一天
              case "month":
                startTime = new Date(year, month, 1);
                endTime = new Date(year, month + 1, 0, 23, 59, 59);
                break;
              case "week":
                startTime = week.startOfWeek;
                endTime = new Date(week.endOfWeek);
                endTime.setHours(23, 59, 59, 999);
                break;
              case "quarter":
                // 季度第一天和最后一天
                startTime = new Date(year, (quarter - 1) * 3, 1,0,0,0);
                endTime = new Date(year, quarter * 3, 0,23,59,59);
                break;
              default:
                break;
            }
            scope.dateControl.modelValue[0] = startTime;
            scope.dateControl.modelValue[1] = endTime;
            scope.search && scope.search();
            scope.onHideDateModal();
          };
          scope.onClickPrev = function (type, isDisabled) {
            if (isDisabled) return;
            updateDate(type, -1);
          };
          scope.onClickNext = function (type, isDisabled) {
            if (isDisabled) return;
            updateDate(type, 1);
          };
          scope.showCheckBtnOfQuarter =function(quarter,year){     
            return quarter == Math.ceil((scope.dateControl.modelValue[0].getMonth()+1)/3) 
            && year == scope.dateControl.modelValue[0].getFullYear()
          }
          scope.showCheckBtnOfYear =function(year){     
            return year == scope.dateControl.modelValue[0].getFullYear()
          }
          scope.formatQuarterType =function (date){
            const month=date.getMonth()+1;
            const year=date.getFullYear();
            return `${year}年第${Math.ceil(month/3)}季度`;
          }
          // 切换tab需要重置获取到当前tab项的起始和结束日期
          scope.changeTab = function (type, intervalDays) {
            scope.dateControl.type = type;
            let startDate = "";
            let endDate = "";
            const currentYear = scope.nowDate.getFullYear();
            const currentMonth = scope.nowDate.getMonth();
            if (type == "day") {
              startDate = new Date(scope.nowDate);
              endDate = new Date(scope.nowDate);
            } else if (type == "week") {
              // 获取本周数据的起始是结束日期
              const yearDataObj = scope.yearData.yearDataList.find(
                (item) => item.year == currentYear
              );
              if (yearDataObj && yearDataObj.weekList) {
                const weekDateObj = yearDataObj.weekList.find(
                  (item) => item.weekNum == scope.getWeekNumber(scope.nowDate)
                );
                startDate =
                  (weekDateObj && weekDateObj.startOfWeek) || scope.nowDate;
                endDate =
                  (weekDateObj && weekDateObj.endOfWeek) || scope.nowDate;
              }
            } else if (type == "month") {
              startDate = new Date(currentYear, currentMonth, 1);
              endDate = new Date(currentYear, currentMonth + 1, 0);
            } else if (type == "quarter") {
              const quarterNumber = Math.ceil((currentMonth + 1) / 3);
              startDate = new Date(currentYear, (quarterNumber - 1) * 3, 1);
              endDate = new Date(currentYear, quarterNumber * 3 , 0);
            } else if (type == "year") {
              startDate = new Date(currentYear, 0, 1);
              endDate = new Date(currentYear, 11, 31);
            } else if (type == "range") {
              endDate = new Date(scope.nowDate);
              startDate = new Date(new Date().setDate(endDate.getDate() - (intervalDays || 2)));
            }
            scope.dateControl.modelValue[0] = startDate;
            scope.dateControl.modelValue[1] = endDate;
            scope.dateControl.modelValue[0].setHours(0, 0, 0, 0);
            scope.dateControl.modelValue[1].setHours(23, 59, 59, 999);
            scope.changeTabCallBack && scope.changeTabCallBack();
            scope.search && scope.search();
          };
          // 将重置方法绑定到父组件元素
          scope.dateControl.changeTab = scope.changeTab;
          // 将经营明细处理记忆时间周期的方法交由外面调用，防止出现不能成功记忆的问题
          scope.dateControl.handleTabOptionsOfOperateDetail = handleTabOptionsOfOperateDetail;
          scope.init = function () {
            if (
              !$rootScope.globalTimeDate ||
              !Array.isArray($rootScope.globalTimeDate) ||
              !$rootScope.globalTimeDate.length
            ) {
              $rootScope.globalTimeDate = Tools.getGlobalTimeData();
            }
            // 当天日期已超过了全局数据里最后一天，需要获取最新数据
            if (
              $rootScope.globalTimeDate &&
              $rootScope.globalTimeDate[0] &&
              $rootScope.globalTimeDate[0].weekList &&
              $rootScope.globalTimeDate[0].weekList[0] &&
              new Date() > $rootScope.globalTimeDate[0].weekList[0].endOfWeek
            ) {
              $rootScope.globalTimeDate = Tools.getGlobalTimeData();
            }
            let minYear = 2014;
            minYear = Number(scope.dateControl.minYear || minYear);
            const currentYear = scope.nowDate.getFullYear();
            let yearRange = currentYear - minYear;
            yearRange = yearRange <= 0 ? 0 : yearRange;
            scope.yearData.years = [];
            scope.yearData.yearDataList = [];
            scope.yearData.yearDataList = $rootScope.globalTimeDate.slice(
              0,
              yearRange + 1
            );
            scope.yearData.years = scope.yearData.yearDataList.map(
              (item) => item.year
            );
            // 获取数组的最后一项，判断最早的日期，用于日期选择限制
            scope.earliestDate =
              scope.yearData.yearDataList[
                scope.yearData.yearDataList.length - 1
              ];
            scope.firstWeek =
              scope.earliestDate.weekList[
                scope.earliestDate.weekList.length - 1
              ];
          };
          scope.init();
          // 判断是否为今天
          scope.isToday = function (date) {
            const inputDate = new Date(date); // 将输入的日期转换为 Date 对象
            // 比较年、月、日是否相同
            return (
              inputDate.getDate() === scope.nowDate.getDate() &&
              inputDate.getMonth() === scope.nowDate.getMonth() &&
              inputDate.getFullYear() === scope.nowDate.getFullYear()
            );
          };
          scope.isCurrentMonth = function (date) {
            const inputDate = new Date(date);
            return (
              inputDate.getMonth() === scope.nowDate.getMonth() &&
              inputDate.getFullYear() === scope.nowDate.getFullYear()
            );
          };
          scope.isCurrentQuarter = function (date) {
            const inputDate = new Date(date);
            let quarterNumber= Math.ceil((scope.nowDate.getMonth()+1 )/ 3);
            let startMonOfQuarter= (quarterNumber-1)*3;
            let endMonOfQuarter= quarterNumber*3-1;
            return (
              inputDate.getMonth()>=startMonOfQuarter&&inputDate.getMonth()<=endMonOfQuarter  &&
              inputDate.getFullYear() === scope.nowDate.getFullYear()
            );
          };
          // 判断是否为今年
          scope.isCurrentYear = function (date) {
            const inputDate = new Date(date);
            return inputDate.getFullYear() === scope.nowDate.getFullYear();
          };
          scope.isCurrentWeek = function (date) {
            const inputDate = new Date(date);
            return (
              scope.getWeekNumber(inputDate) ===
              scope.getWeekNumber(scope.nowDate)
            );
          };
          scope.isDisabledNext = function (type, date) {
            if (type == "day") return false;
            if (type === "week") {
              return scope.isCurrentWeek(date);
            } else if (type === "month") {
              return scope.isCurrentMonth(date);
            } else if (type === "year") {
              return scope.isCurrentYear(date);
            } else if (type === "quarter") {
              return scope.isCurrentQuarter(date);
            } else return false;
          };
          scope.isDisabledPrev = function (type, date) {
            if (type == "day") return false;
            const tempDate = new Date(date);
            if (type === "week") {
              return (
                tempDate <= (scope.firstWeek && scope.firstWeek.startOfWeek)
              );
            } else if (type === "month") {
              return (
                tempDate.getFullYear() == scope.earliestDate.year &&
                tempDate.getMonth() == 0
              );
            } else if (type === "year") {
              return tempDate.getFullYear() == scope.earliestDate.year;
            } else return false;
          };
          //销毁
          scope.$on("$destroy", function () {
            scope.selectOptionPopover && scope.selectOptionPopover.remove();
            scope.datePickModal && scope.datePickModal.remove();
          });
        },
      };
    }
  }