/**
 * Echart生成中国地图
 * @usage
 * <lb-china-map element-id="main"></lb-china-map>
 */
export default function registerLbChinaMap(module) {
  module.directive("lbChinaMap", ["$timeout", lbChinaMap]);

  function lbChinaMap($timeout) {
    var timer = null;
    const defalutData = [
      { name: "北京", id: 110000 },
      { name: "天津", id: 120000 },
      { name: "河北", id: 130000 },
      { name: "山西", id: 140000 },
      { name: "内蒙古", id: 150000 },
      { name: "辽宁", id: 210000 },
      { name: "吉林", id: 220000 },
      { name: "黑龙江", id: 230000 },
      { name: "上海", id: 310000 },
      { name: "江苏", id: 320000 },
      { name: "浙江", id: 330000 },
      { name: "安徽", id: 340000 },
      { name: "福建", id: 350000 },
      { name: "江西", id: 360000 },
      { name: "山东", id: 370000 },
      { name: "河南", id: 410000 },
      { name: "湖北", id: 420000 },
      { name: "湖南", id: 430000 },
      { name: "广东", id: 440000 },
      { name: "广西", id: 450000 },
      { name: "海南", id: 460000 },
      { name: "重庆", id: 500000 },
      { name: "四川", id: 510000 },
      { name: "贵州", id: 520000 },
      { name: "云南", id: 530000 },
      { name: "西藏", id: 540000 },
      { name: "陕西", id: 610000 },
      { name: "甘肃", id: 620000 },
      { name: "青海", id: 630000 },
      { name: "宁夏", id: 640000 },
      { name: "新疆", id: 650000 },
      { name: "台湾", id: 710000 },
      { name: "香港", id: 810000 },
      { name: "澳门", id: 820000 },
    ];
    return {
      restrict: "AE",
      replace: true,
      template:
        "<div ng-style='styles' class='chinaMpaContainer' id='{{elementId}}'></div>",
      scope: {
        elementId: "@elementId", // 容器id 必传
        provinceData: "@provinceData",
        styles: "=styles",
        options: "=options", // echart配置项 不传取默认数据
        afterRender: "&afterRender", // 获取echart实例，进行数据操作
        provinceHandler: "&provinceHandler", // 省份点击事件
      },
      link: link,
    };
    function link(scope, element, attrs) {
      scope.styles = scope.styles || {
        height: "300px",
        width: "100vw",
      };
      $timeout.cancel(timer);
      timer = $timeout(function () {
        const options = scope.options || getDefaultOpts(scope.provinceData);
        const elementId = scope.elementId;
        const chart = initChartMap(elementId, options, scope);
  
        scope.afterRender && scope.afterRender({ $chart: chart });
      });
    }
    function initChartMap(elementId, options, scope) {
      if (!elementId) {
        console.error("elementId is required");
        return;
      }
      const chart = window.echarts.init(document.getElementById(elementId));
      const DEFAULT_HIGHLIGHT_DURATION = 1000;
      chart.setOption(options);
      let selectedRegion = null;
      // 默认点击事件处理
      chart.on("click", function (params) {
        let isCancel = selectedRegion === params.name;
        selectedRegion = isCancel ? null : params.name;
        chart.dispatchAction({
          type: "highlight",
          name: params.name,
        });
        if(isCancel) {
          chart.dispatchAction({
            type: 'hideTip'
          })
        } else {
          chart.dispatchAction({
            type: "showTip",
            seriesIndex: 0,
            name: params.name,
          });
        }
  
  
        // 1秒后取消高亮
        setTimeout(() => {
          chart.dispatchAction({
            type: "downplay",
            name: params.name,
          });
        }, DEFAULT_HIGHLIGHT_DURATION);
  
        if (typeof scope.provinceHandler === "function") {
          var $params = {
            isCancel,
            defalutData,
            ...params
          }
          scope.provinceHandler({ $params });
        }
      });
      return chart;
    }
    function getDefaultOpts(data) {
      // data = [
      //   { name: "北京", value: 2154 },
      //   { name: "天津", value: 1560 },
      //   { name: "河北", value: 7461 },
      //   { name: "山西", value: 3718 },
      //   { name: "内蒙古", value: 2534 },
      //   { name: "辽宁", value: 4359 },
      //   { name: "吉林", value: 2704 },
      //   { name: "黑龙江", value: 3773 },
      //   { name: "上海", value: 2424 },
      //   { name: "江苏", value: 8051 },
      //   { name: "浙江", value: 5737 },
      //   { name: "安徽", value: 6324 },
      //   { name: "福建", value: 3941 },
      //   { name: "江西", value: 4648 },
      //   { name: "山东", value: 10047 },
      //   { name: "河南", value: 9605 },
      //   { name: "湖北", value: 5917 },
      //   { name: "湖南", value: 6899 },
      //   { name: "广东", value: 11346 },
      //   { name: "广西", value: 4926 },
      //   { name: "海南", value: 934 },
      //   { name: "重庆", value: 3102 },
      //   { name: "四川", value: 8341 },
      //   { name: "贵州", value: 3623 },
      //   { name: "云南", value: 4830 },
      //   { name: "西藏", value: 364 },
      //   { name: "陕西", value: 3864 },
      //   { name: "甘肃", value: 2637 },
      //   { name: "青海", value: 603 },
      //   { name: "宁夏", value: 688 },
      //   { name: "新疆", value: 2487 },
      //   { name: "台湾", value: 2357 },
      //   { name: "香港", value: 745 },
      //   { name: "澳门", value: 66 },
      // ];
  
      const option = {
        // title: {
        //   text: "省份销量分布",
        //   left: "center",
        // },
        tooltip: {
          trigger: "item",
        },
        visualMap: {
          min: 0,
          max: 12000,
          left: "left",
          top: "bottom",
          // text: ["高", "低"],
          itemHeight: 50, // 设置高度
          itemWidth: 10, // 设置宽度
          calculable: true,
          inRange: {
            color: ["#e0ffff", "#006edd"],
          },
        },
        series: [
          {
            name: "销量",
            type: "map",
            map: "china",
            roam: false,
            scaleLimit: {
              min: 1,
              max: 5
            },          
            label: {
              show: false,
            },
            data: data,
            emphasis: {
              label: {
                show: true,
              },
              itemStyle: {
                areaColor: "#ff7f50",
              },
            },
            selectedMode: "single",
            select: {
              label: {
                show: true,
                fontSize: 14,
              },
              itemStyle: {
                areaColor: "#ff7f50",
                shadowBlur: 10,
                shadowOffsetX: 0,
                shadowOffsetY: 0,
                shadowColor: "rgba(0, 0, 0, 0.5)",
              },
            },
          },
        ],
      };
      return option;
    }
  }

}
