/**
 * 自定义lb-city-picker
 * 后面省市区的新样式统一用这个
 */
export default function registerLbCityPicker(module) {
  module.directive("lbCityPicker", [
    "$ionicPopup",
    "$timeout",
    "$ionicScrollDelegate",
    "$ionicModal",
    "Tools",
    "$ionicPopover",
    function (
      $ionicPopup,
      $timeout,
      $ionicScrollDelegate,
      $ionicModal,
      Tools,
      $ionicPopover
    ) {
      function isBoolean(value) {
        return typeof value === "boolean";
      }
      return {
        restrict: "AE",
        replace: true,
        template:
          '<div class="flex"><div class={{vm.cssClass}}><i class={{vm.iconClass}}></i>{{vm.title}}<span class="f16" ng-class="{\'colorbf\': isInitAddress}">{{vm.areaData || vm.initAddress}}</span></div><i class="icon iconfont icon-arrow-right color8c ml5 mr-5"></i></div>',
        scope: {
          options: "=options",
          areaData: "=areaData",
        },
        link: function (scope, element, attrs) {
          var vm = (scope.vm = {}),
            so = scope.options,
            citypickerModel = null;
          vm.initAddress = "省-市-区"; // 初始化展示地址
          vm.initAddressId = [110000, 110100, 110101]; // 默认展示地址信息
          vm.uuid = Math.random().toString(36).substring(3, 8);
          vm.provinceHandle = "province-" + vm.uuid;
          vm.cityHandle = "city-" + vm.uuid;
          vm.countryHandle = "country-" + vm.uuid;
          vm.title = so.title || "";
          vm.buttonText = so.buttonText || "完成";
          vm.cssClass =
            "lb-word-break flex1" +
            (angular.isDefined(so.iconClass) ? " lb-item-icon-left " : " ") +
            (angular.isDefined(so.cssClass) ? so.cssClass : "");
          vm.iconClass =
            "icon " + (angular.isDefined(so.iconClass) ? so.iconClass : "");
          vm.barCssClass = angular.isDefined(so.barCssClass)
            ? so.barCssClass
            : "bar-stable";
          vm.backdrop = isBoolean(so.backdrop) ? so.backdrop : true; // 遮罩层
          vm.backdropClickToClose = isBoolean(so.backdropClickToClose)
            ? so.backdropClickToClose
            : false; // 点击空白出关闭窗口
          vm.hardwareBackButtonClose = isBoolean(so.hardwareBackButtonClose)
            ? so.hardwareBackButtonClose
            : true; // 安卓硬件返回
          vm.tag = so.tag || "-"; // 城市分隔符
          vm.step = so.step || 36; // 滚动步长 （li的高度）
          vm.areaData = scope.areaData || vm.initAddress;
  
          vm.returnOk = function () {
            scope.isInitAddress = false;
            vm.areaDataId = [];
            vm.areaChildren = [];
            if (vm.province) {
              vm.areaDataId.push(vm.province.id);
              vm.areaData = vm.province.areaName;
              vm.areaChildren.push(vm.province.children);
              if (vm.city && vm.city.children) {
                vm.areaDataId.push(vm.city.id);
                vm.areaData += vm.tag + vm.city.areaName;
                vm.areaChildren.push(vm.city.children);
                if (vm.country) {
                  vm.areaDataId.push(vm.country.id);
                  vm.areaData += vm.tag + vm.country.areaName;
                }
              }
            }
            so.areaDataId = vm.areaDataId;
            so.areaData = vm.areaData.split(vm.tag);
            so.areaChildren = vm.areaChildren;
            $timeout(function () {
              citypickerModel && citypickerModel.hide();
              so.buttonClicked && so.buttonClicked(); // 执行回调
            }, 50);
          };
          vm.returnCancel = function () {
            citypickerModel && citypickerModel.hide();
            $timeout(function () {
              vm.initAreaData(vm.areaData && vm.areaData.split(vm.tag));
            }, 150);
          };
          vm.clickToClose = function () {
            vm.backdropClickToClose && vm.returnCancel();
          };
  
          vm.getValue = function (name) {
            $timeout.cancel(vm.runing);
            $timeout.cancel(vm.touch_complete);
            switch (name) {
              case "province":
                var province = true,
                  Handle = vm.provinceHandle,
                  HandleChild = vm.cityHandle;
                break;
              case "city":
                var city = true,
                  Handle = vm.cityHandle,
                  HandleChild = vm.countryHandle;
                break;
              case "country":
                var country = true,
                  Handle = vm.countryHandle,
                  HandleChild = null;
                break;
            }
            var top = $ionicScrollDelegate
              .$getByHandle(Handle)
              .getScrollPosition().top; // 当前滚动位置
            var step = Math.round(top / vm.step);
            if (step < 0) {
              step = 0;
            } else if (step > vm.AreaService.length - 1) {
              step = vm.AreaService.length - 1;
            }
  
            vm.runing = $timeout(function () {
              province &&
                ((vm.province = vm.AreaService[step]),
                (vm.city = vm.province.children[0]),
                (vm.country = {}),
                vm.city &&
                  vm.city.children &&
                  (vm.country = vm.city.children[0])); //处理省市乡联动数据
              city &&
                ((vm.city = vm.province.children[step]),
                (vm.country = {}),
                vm.city &&
                  vm.city.children &&
                  (vm.country = vm.city.children[0])); // 处理市乡联动数据
              country && (vm.country = vm.city.children[step]); // 处理乡数据
              HandleChild &&
                $ionicScrollDelegate.$getByHandle(HandleChild).scrollTop(); // 初始化子scroll top位
            }, 50);
            vm.touch_complete = $timeout(function () {
              // 停止滑动时触发
              top = $ionicScrollDelegate
                .$getByHandle(Handle)
                .getScrollPosition().top; // 当前滚动位置
              step = Math.round(top / vm.step);
              if (top % vm.step !== 0) {
                // 列表子项滚动到高亮中间区域
                $ionicScrollDelegate
                  .$getByHandle(Handle)
                  .scrollTo(0, step * vm.step, true);
              }
            }, 300);
          };
  
          scope.$on("areaService", function (event, data) {
            // 获取父控制器传递的参数
            vm.AreaService = data.areaService; // average：40ms
            scope.$emit("provinceService", { areaService: vm.AreaService });
          });
  
          vm.initAreaData = function (AreaData) {
            if (!vm.AreaService) {
              return false;
            }
            if (
              !AreaData ||
              (Tools.isArray(AreaData) &&
                AreaData.join(vm.tag) === vm.initAddress) ||
              AreaData === vm.initAddress
            ) {
              AreaData = vm.initAddressId;
            }
            if (!Tools.isArray(AreaData) && typeof AreaData === "string") {
              AreaData = vm.areaDataId;
            }
            //初始化地址时有可能只有省、省市（此时需要补全地址选中框）
            // 获取地址信息（默认选中省市区县的第一个）
            AreaData = getAreaFirstAddress(AreaData).areaDataId;
            if (AreaData[0]) {
              // 初始化省
              for (var i = 0; i < vm.AreaService.length; i++) {
                if (
                  AreaData[0] === vm.AreaService[i].id ||
                  AreaData[0] === vm.AreaService[i].areaName
                ) {
                  $ionicScrollDelegate
                    .$getByHandle(vm.provinceHandle)
                    .scrollTo(0, i * vm.step);
                  vm.province = vm.AreaService[i];
                  break;
                }
              }
            } else {
              //清除原有数据（插件第一次初始化遗留）
              vm.province = null;
            }
            if (AreaData[1] && vm.province && vm.province.children) {
              // 初始化市
              for (var i = 0; i < vm.province.children.length; i++) {
                if (
                  AreaData[1] === vm.province.children[i].id ||
                  AreaData[1] === vm.province.children[i].areaName
                ) {
                  $ionicScrollDelegate
                    .$getByHandle(vm.cityHandle)
                    .scrollTo(0, i * vm.step);
                  vm.city = vm.province.children[i];
                  break;
                }
              }
            } else {
              //清除原有数据（插件第一次初始化遗留）
              vm.city = null;
            }
            if (AreaData[2] && vm.city && vm.city.children) {
              // 初始化区
              for (var i = 0; i < vm.city.children.length; i++) {
                if (
                  AreaData[2] === vm.city.children[i].id ||
                  AreaData[2] === vm.city.children[i].areaName
                ) {
                  $ionicScrollDelegate
                    .$getByHandle(vm.countryHandle)
                    .scrollTo(0, i * vm.step);
                  vm.country = vm.city.children[i];
                  break;
                }
              }
            } else {
              //清除原有数据（插件第一次初始化遗留）
              vm.country = null;
            }
          };
  
          scope.$watch(
            "areaData",
            function (newVal) {
              if (!newVal || (Tools.isArray(newVal) && !newVal.length)) {
                // 清空地址信息
                scope.isInitAddress = true;
                vm.areaData = vm.initAddress;
                $timeout(function () {
                  vm.initAreaData(vm.areaData);
                }); // 初始化地址
                return false;
              }
              scope.isInitAddress = false;
              if (
                newVal !== vm.areaData &&
                Tools.isArray(newVal) &&
                newVal.length > 1 &&
                newVal.join(vm.tag) !== vm.areaData
              ) {
                if (vm.isCreated) {
                  vm.AreaService && vm.initAreaData(newVal);
                } else {
                  vm.defaultAreaData = newVal;
                  initAreaAddress(newVal);
                }
              }
            },
            true
          );
  
          // 初始化以及变更地址信息
          function initAreaAddress(data) {
            vm.areaDataId = [];
            if (data[0]) {
              var province = Tools.getObject(vm.AreaService, "id", data[0]);
              vm.areaData = province && province.areaName;
              vm.areaDataId.push(data[0]);
              if (data[1] && province && province.children) {
                var city = Tools.getObject(province.children, "id", data[1]);
                if (city && city.children) {
                  vm.areaData += vm.tag + city.areaName;
                  vm.areaDataId.push(data[1]);
                  if (data[2]) {
                    var country = Tools.getObject(city.children, "id", data[2]);
                    country && (vm.areaData += vm.tag + country.areaName);
                    vm.areaDataId.push(data[2]);
                  }
                }
              }
              scope.isInitAddress = false;
              so.areaDataId = vm.areaDataId;
              vm.areaData && (so.areaData = vm.areaData.split(vm.tag));
            } else {
              vm.areaData = vm.initAddress;
              scope.isInitAddress = true;
            }
            $timeout(function () {
              vm.AreaService && vm.initAreaData(vm.areaData);
            }, 50);
          }
  
          // 获取地址信息（默认选中省市区县的第一个）
          function getAreaFirstAddress(data) {
            var areaDataId = [];
            var areaData = [];
            if (data[0] || vm.AreaService.length > 0) {
              var province = Tools.getObject(
                vm.AreaService,
                "id",
                data[0] || vm.AreaService.children[0].id
              );
              var areaDataId = [];
              var areaData = [];
              province && areaDataId.push(province.id);
              areaData = province && province.areaName;
              if (
                (data[1] && province && province.children.length > 0) ||
                (province && province.children.length > 0)
              ) {
                var city = Tools.getObject(
                  province.children,
                  "id",
                  data[1] || province.children[0].id
                );
                if (city) {
                  areaDataId.push(city.id);
                  areaData += vm.tag + city.areaName;
                  if (
                    (data[2] && city.children.length > 0) ||
                    city.children.length > 0
                  ) {
                    var country =
                      Tools.getObject(
                        city.children,
                        "id",
                        data[2] || city.children[0].id
                      ) || {};
                    areaDataId.push(country.id || "");
                    country && (areaData += vm.tag + country.areaName);
                  }
                }
              }
            }
            return {
              areaDataId: areaDataId,
              areaData: areaData,
            };
          }
  
          scope.$on("changeAddress", function (event, data) {
            initAreaAddress(data);
          });
  
          element.on("click", function () {
            if (citypickerModel) {
              initAreaAddress(vm.areaDataId || []);
              citypickerModel.show();
              return false;
            }
            vm.isCreated = true;
  
            citypickerModel = $ionicPopover.fromTemplate(
              "<div  ng-class=\"{'lb-city-picker-backdrop' : vm.backdrop }\">" +
                '<ion-modal-view  class="lb-city-picker-bg f16">' +
                '<div class="lb-city-bgclose" ng-click="vm.clickToClose()" ></div>' +
                '<div class="lb-city-picker ">' +
                '  <header class=" bar lb-city-picker-header" ng-class="vm.barCssClass">\n' +
                '      <div class="buttons">\n' +
                '        <button class="button button-clear button-positive" ng-click="vm.returnCancel()">取消</button>\n' +
                "      </div>\n" +
                '      <h1 class="title"></h1>\n' +
                '      <div class="buttons">\n' +
                '        <button class="button button-clear button-positive" ng-click="vm.returnOk()">{{vm.buttonText}}</button>\n' +
                "      </div>\n" +
                "  </header>\n" +
                '  <div class="lb-city-picker-inner has-header">\n' +
                '    <div class="row ">\n' +
                '      <div class="col col-33">\n' +
                "        <ion-scroll-minh delegate-handle={{vm.provinceHandle}}  overflow-scroll=false on-release=\"vm.getValue('province')\" on-scroll-complete=\"vm.getValue('province')\" scrollbar-y=false >\n" +
                "          <ul >\n" +
                '            <li ng-repeat="province in vm.AreaService" >{{province.areaName}}</li>\n' +
                "          </ul>\n" +
                "        </ion-scroll-minh>\n" +
                "      </div>\n" +
                '      <div class="col col-33">\n' +
                "        <ion-scroll-minh delegate-handle={{vm.cityHandle}} on-release=\"vm.getValue('city')\"  overflow-scroll=false on-scroll-complete=\"vm.getValue('city')\" scrollbar-y=false>\n" +
                "          <ul >\n" +
                '            <li  ng-repeat="city in vm.province.children">{{city.areaName}}</li>\n' +
                "          </ul>\n" +
                "        </ion-scroll-minh>\n" +
                "      </div>\n" +
                '      <div class="col col-33">\n' +
                "        <ion-scroll-minh delegate-handle={{vm.countryHandle}} overflow-scroll=false on-release=\"vm.getValue('country')\" on-scroll-complete=\"vm.getValue('country')\" scrollbar-y=false>\n" +
                "          <ul >\n" +
                '            <li  ng-repeat="country in vm.city.children" >{{country.areaName}}</li>\n' +
                "          </ul>\n" +
                "        </ion-scroll-minh>\n" +
                "      </div>\n" +
                "  </div>\n" +
                '  <div class="lb-picker-center-highlight"></div>\n' +
                "  </div>\n" +
                "</div>\n" +
                "</ion-modal-view>\n" +
                "</div>",
              {
                scope: scope,
                animation: "slide-in-up",
                backdropClickToClose: vm.backdropClickToClose,
                hardwareBackButtonClose: vm.hardwareBackButtonClose,
              }
            );
  
            $timeout(function () {
              initAreaAddress(vm.areaDataId || []);
              citypickerModel.show();
              vm.AreaService && vm.initAreaData(vm.areaData);
            }, 50);
          });
          scope.$on("$destroy", function () {
            citypickerModel && citypickerModel.remove();
          });
        },
      };
    },
  ]);
}
