/**
 * 自定义lb-input
 * 通过拦截点击事件，实现点击输入框后光标自动聚焦到文字尾部
 */
export default function registerLbInput(module) {
  module.directive("lbInput", ["$timeout", lbInput]);

  function lbInput($timeout) {
    return {
      restrict: "E",
      replace: true,
      template: "<input />",
      scope: {
        type: "@",
        className: "@",
        model: "=",
        placeholder: "@",
        events: "=",
        onNgClick: "&ngClick",
      },
      link: function (scope, element, attrs) {
        // 设置input元素的属性
        element.attr("type", scope.type);
        element.attr("class", scope.className);
        element.attr("ng-model", "model");
        element.attr("placeholder", scope.placeholder);
  
        element.on("click", handleClick);
  
        function handleClick(event) {
          // 可以在这里添加自定义逻辑
          // 调用传递给指令的onCustomClick函数
          clickInterceptor(event, function () {
            scope.onNgClick && scope.onNgClick({ $event: event });
          });
        }
        // 通过拦截点击事件，实现点击输入框后光标自动聚焦到文字尾部
        function clickInterceptor(event, cb) {
          if (!event) return;
          var el = event && event.target;
          // 聚焦状态下不执行
          if (document.activeElement == el) {
            return;
          }
          // 备份原数据
          var value = el.value;
          var placeholder = el.placeholder;
          // 清空原数据
          el.value = "";
          el.placeholder = "";
          // 清除定时器
          el.timmer && clearTimeout(el.timmer);
          el.timmer = setTimeout(function () {
            // 重新赋值
            el.value = value;
            el.placeholder = placeholder;
            // 触发聚焦，光标自动移动到尾部
            el.focus();
            cb && cb(event);
          }, 100);
        }
        scope.$on("$destroy", function () {
          if (element && handleClick) {
            element.off("click", handleClick);
          }
        });
      },
    };
  }
}
