/**
 * 网络专线切换
 * @usage
 * <lb-line-switch element-id="main"></lb-line-switch>
 */
export default function registerLbLineSwitch(module) {
  module.directive('lbLineSwitch', ["$ionicPopover", "$window", "ServerConfig", "Tools", lbLineSwitch]);
  
  function lbLineSwitch($ionicPopover, $window, ServerConfig, Tools) {
    return {
      restrict: "E",
      replace: true,
      scope: {
        prodDomainList: "=",
        userSelectDomain: "=",
      },
      templateUrl: "directives/lbLineSwitch/lbLineSwitch.html",
      link: function (scope) {
        console.log("lbLineSwitch render")
        scope.prodDomainList = scope.prodDomainList || [];
        const userLineEnName = $window.localStorage.getItem('userLineEnName');
        let domainObj = Tools.getObject(scope.prodDomainList, 'lineEnName', userLineEnName);
        if(!domainObj) {
          domainObj = scope.prodDomainList[0];
        }
        scope.userSelectDomain = domainObj || {};
  
        scope.openSelectDomainPopover = function ($event) {
          $event && $event.stopPropagation() && $event.preventDefault();
          if (scope.selectDomainPopover) {
            scope.selectDomainPopover.show($event);
          } else {
            $ionicPopover
              .fromTemplateUrl("selectDomainPopover.html", {
                scope: scope,
              })
              .then(function (popover) {
                scope.selectDomainPopover = popover;
                scope.selectDomainPopover.show($event);
              });
          }
        };
        // 选择对应域名
        scope.selectProdDomainItem = function ($event, item) {
          $event && $event.stopPropagation() && $event.preventDefault();
          scope.userSelectDomain = item;
          const domainConfigList = item.configList || [];
          for (let index = 0; index < domainConfigList.length; index++) {
            const item = domainConfigList[index];
            const configKey = item.configKey;
            const configValue = item.configValue;
            ServerConfig[configKey] = configValue;
          }
          $window.localStorage.setItem("userLineEnName", item.lineEnName);
          scope.selectDomainPopover && scope.selectDomainPopover.hide();
        };
      },
    };
  
  }
}


