  /*
   * 创建时间筛选元素
   * 使用方法 <lb-quick-time obj="filterQuickTimeObj"></lb-quick-time>
   * obj格式 {
   *   startKey: String(option)  // 开始时间对应的key 默认'startTime'
   *   endKey: String(option) // 结束时间对应的key 默认'endTime'
   *   startTime: timeStamp // 开始时间对应的value，保持与startKey的value一致
   *   endTime: timeStamp // 结束时间对应的value，保持与endKey的value一致
   * }
   */
export default function registerLbQuickTime(module) {
	module.directive("lbQuickTime", [
	"$cordovaDatePicker",
	"Tools",
	"$ionicModal",
	"qsModal",
	lbQuickTime,
]);
function lbQuickTime($cordovaDatePicker, Tools, $ionicModal, qsModal) {
	return {
		restrict: "E",
		replace: true,
		scope: {
			quickTimeOption: "=", // 
			oneYear: "=",
			crossYear: "=", // 是否跨年
			obj: "=",
			customText: "=", // 自定义时间文本，默认显示“自定义”
			formatDateType: "=", // 格式化自定义时间的展示 默认取“dateType”，如25.6.14-25.7.14
			quickTimeCb: "&", // 选择时间后的回调函数
		},
		templateUrl: "directives/lbQuickTime/lbQuickTime.html",
		link: function (scope) {
			scope.defaultQuickTimeOption = [
				{ text: "今天", value: "today" },
				{ text: "7天", value: "sevenDays" },
				{ text: "30天", value: "thirtyDays" },
			];
			scope.quickTimeOption = scope.quickTimeOption || scope.defaultQuickTimeOption;

			scope.currentSelectQuickTime = "thirtyDays";
			scope.customText = scope.customText || "自定义";
			scope.formatDateType = scope.formatDateType || "dateType"
			scope.startKey = (scope.obj && scope.obj.startKey) || "startTime";
			scope.endKey = (scope.obj && scope.obj.endKey) || "endTime";

			scope.selectDateQuery = {
				createTimeBegin: "",
				createTimeEnd: "",
			};

			scope.setCreateTimeBegin = function () {
				$cordovaDatePicker
				.show({
					date: scope.selectDateQuery.createTimeBegin
					? new Date(scope.selectDateQuery.createTimeBegin)
					: new Date(),
					mode: "date",
					minDate: "",
					maxDate: "",
					doneButtonLabel: "确定",
					cancelButtonLabel: "取消",
				})
				.then(function (d) {
					if (!isNaN(d.getTime())) {
					  scope.selectDateQuery.createTimeBegin = Tools.getDayBegin(d.getTime()).getTime();
					}
				});
			};
			scope.setCreateTimeEnd = function () {
				$cordovaDatePicker
				.show({
					date: scope.selectDateQuery.createTimeEnd
					? new Date(scope.selectDateQuery.createTimeEnd)
					: new Date(),
					mode: "date",
					minDate: "",
					maxDate: "",
					doneButtonLabel: "确定",
					cancelButtonLabel: "取消",
				})
				.then(function (d) {
					if (!isNaN(d.getTime())) {
					  scope.selectDateQuery.createTimeEnd = Tools.getDayEnd(d.getTime()).getTime();
					}
				});
			};

			scope.handlerQuickTimeText = function (item) {
				if (item === "custom") {
						if (scope.selectDateQuery.createTimeBegin && scope.selectDateQuery.createTimeEnd) {
							return formattedDateShow(scope.selectDateQuery.createTimeBegin, scope.selectDateQuery.createTimeEnd)
						}
						return scope.customText;
					}
				return item.text;
			}

			function formattedDateShow(createTimeBegin, createTimeEnd) {
				var begin = new Date(createTimeBegin);
				var end = new Date(createTimeEnd);
				switch(scope.formatDateType) {
					case "dateType":
						var beginYear = begin.getFullYear() % 100;
						var beginMonth = begin.getMonth() + 1;
						var beginDay = begin.getDate();
						var endYear = end.getFullYear() % 100;
						var endMonth = end.getMonth() + 1;
						var endDay = end.getDate();
						return `${beginYear}.${beginMonth}.${beginDay}-${endYear}.${endMonth}.${endDay}`

					default:
						return "";
				}
			}

			scope.modalId = `dateModal_${Math.random().toString(36).substr(2, 8)}`;

			//打开自定义选择日期的modal
			scope.openSelectDateModal = function () {
				var begin = scope.obj[scope.startKey] || Tools.dateFormat(
					Tools.getDayBegin(
						new Date().setDate(new Date().getDate() - 29)
					),
					"yyyy-MM-dd"
				)
				var end = scope.obj[scope.endKey] || new Date();
				scope.selectDateQuery.createTimeBegin = Tools.dateFormat(
					new Date(begin),
					"yyyy-MM-dd"
				)
				scope.selectDateQuery.createTimeEnd = Tools.dateFormat(new Date(end), "yyyy-MM-dd");
				qsModal.formModal(
					"customSelectDateModal.html",
					function (customSelectDateModal) {
						customSelectDateModal.show();
					},
					{
						id: scope.modalId,
						scope: scope,
						animation: "slide-in-up",
					}
				);
			};

			scope.hideSelectDateModal = function () {
				qsModal.hide(scope.modalId);
			}

			scope.searchBySelectDate = function () {
				if (
					!scope.selectDateQuery.createTimeBegin ||
					!scope.selectDateQuery.createTimeEnd
				) {
					Tools.toastShow("请选择日期！");
					return;
				}
				const beginTime = new Date(scope.selectDateQuery.createTimeBegin).getTime();
				const endTime = new Date(scope.selectDateQuery.createTimeEnd).getTime();
				// 限制范围为一年
				if (scope.oneYear && !Tools.ltOneYear(beginTime, endTime)) {
					Tools.toastShow("时间跨度不能超过一年");
					return;
				}
				if (scope.crossYear === false && Tools.isCrossYear(beginTime, endTime)) {
					Tools.toastShow("时间跨度不能跨年");
					return;
				}
				if (beginTime > endTime) {
					Tools.toastShow("结束日期应大于开始日期！");
					return;
				}
				scope.obj[scope.startKey] = new Date(Tools.getDayBegin(beginTime)).getTime();
				scope.obj[scope.endKey] = new Date(Tools.getDayEnd(endTime)).getTime();
				if (typeof scope.quickTimeCb == "function") {
					const data = {
						...scope.obj,
						type: scope.currentSelectQuickTime,
					}          
					scope.quickTimeCb({data});
				}
				scope.hideSelectDateModal();
			}

      scope.quickTimeClick = function (item) {
				if (item === "custom") {
					scope.currentSelectQuickTime = "custom";
					// 打开自定义选择日期的modal
          			scope.openSelectDateModal();
				} else {
					var value = item.value;
					scope.currentSelectQuickTime = value;
					switch (value) {
						case "today":
							scope.obj[scope.startKey] = Tools.getDayBegin(
								new Date().setDate(new Date().getDate())
							).getTime();
							break;
						case "sevenDays":
							scope.obj[scope.startKey] = Tools.getDayBegin(
								new Date().setDate(new Date().getDate() - 6)
							).getTime();
							break;
						case "thirtyDays":
							scope.obj[scope.startKey] = Tools.getDayBegin(
								new Date().setDate(new Date().getDate() - 29)
							).getTime();
							break;
					}
					scope.obj[scope.endKey] = Tools.getDayEnd(new Date().getTime()).getTime();
					if (typeof scope.quickTimeCb == "function") {
						const data = {
							...scope.obj,
							type: scope.currentSelectQuickTime,
						}
						scope.quickTimeCb({data});
					}
				}
      }

			scope.clearSelectDate = function () {
				scope.selectDateQuery.createTimeBegin = Tools.dateFormat(
					Tools.getDayBegin(
						new Date().setDate(new Date().getDate() - 29)
					),
					"yyyy-MM-dd"
				)
				scope.selectDateQuery.createTimeEnd = Tools.dateFormat(new Date(), "yyyy-MM-dd");
			}
		},
	};
	}
}