/*!
 * workweixin-inject-cordova.js v1.0
 * 如果是打包上架到企业微信或再浏览器中使用，引用该js，将覆盖原cordova插件暴露的js全局变量，如果没有覆盖到的则通过捕获全局异常提示不支持插件
 */
;(function (pluginList, window) {
    'use strict';

    var CUR_ENVIROMENT = "GENERAL_BROWSER";

    if(window.WwxPlugin){
        CUR_ENVIROMENT = "WORK_WEIXIN";
    }

    var browserTipTime = null;

    // 浏览器环境下调用了原生插件时，给出对应的提示
    function noSupportBrowserTips() {
        window.browserEnvCordovaPlugins.toast('此功能需要下载秦丝进销存App才能使用');
    }

    // 是否存在该对象
    function isObjectExists(str){
        var arr = str ? str.split('.') : [];
        var obj = null;
        if (Array.isArray(arr) && arr.length > 0) {
            for (var i = 0; i < arr.length; i++) {
                if(i === 0 ){
                    obj = window;
                }
                
                if(typeof obj[arr[i]] == "undefined" ){
                    return false;
                }

                obj = obj[arr[i]];
                
            }
            return true;
        }else{
            return false;
        }
    }

    // 初始化对象
    function initObject(str){
        var arr = str ? str.split('.') : [];
        var result = null;
        if (Array.isArray(arr) && arr.length > 0) {
            for (var i = 0; i < arr.length; i++) {
                if(i === 0 ){
                    result = window;
                }
                
                if(typeof result[arr[i]] == "undefined" ){
                    result[arr[i]] = {};
                }

                result = result[arr[i]];
                
            }
            return result;
        }
    }

    function injectPlugin(index){
        var item = pluginList[index];
        var plugin = null;
        if(!isObjectExists(item.cordovaPluginName)){
            var plugin = initObject(item.cordovaPluginName);

            //优先挂载当前环境的方法
            var currentEnvMethods = item.methods[CUR_ENVIROMENT];
            for(var method in currentEnvMethods){
                plugin[method] = currentEnvMethods[method];
            }

            //如果当前不是通用浏览器环境，再挂载通用浏览器环境的方法
            if(currentEnvMethods !== "GENERAL_BROWSER"){
                var generalEnvMethods = item.methods["GENERAL_BROWSER"];
                for(var method in generalEnvMethods){
                    if(typeof plugin[method] == "undefined"){
                        plugin[method] = generalEnvMethods[method];
                    }                    
                }
            }

        }
    }

    // 循环将所有传进来的插件进行注入
    for (var i = 0, len = pluginList.length; i < len; i++) {
        injectPlugin(i);
    }

    // 声明当前是注入cordova变量的浏览器环境，避免lib\ionic\js\ionic.bundle.js中根据存在window.cordova变量判断是app内嵌webview而一直等待deviceready事件（第2464行）
    window.BROWSER_INJECT_CORDOVA = true;    

})(
    //注意cordovaPluginName不包括window变量
    [
        {
        cordovaPluginName: 'plugins.toast',
        methods:{
            "GENERAL_BROWSER": {
                show: function(args){
                    window.browserEnvCordovaPlugins.toast(args);
                },
                hide: function(args){
                    
                }
            },
            "WORK_WEIXIN": {

            }
        }
    },
    {
        cordovaPluginName: 'datePicker',
        methods:{
            "GENERAL_BROWSER": {
                show: function(options,callBack){
                    window.browserEnvCordovaPlugins.datePicker(options,callBack);
                }
            }
        }
    },
    {
        cordovaPluginName: 'cordova.plugins.Keyboard',
        methods:{
            "GENERAL_BROWSER": {
                close: function(){
                    
                },
                show: function(){

                },
                hideKeyboardAccessoryBar: function(){

                },
                disableScroll: function(){

                }
            }
        }
    },
    {
        cordovaPluginName: 'navigator.notification',
        methods:{
            "GENERAL_BROWSER": {
                alert: function (message, callback) {
                    setTimeout(function () {
                        window.alert(message);
                        if (callback) {
                            callback();
                        }
                    }, 0);
                },
                confirm: function (message, callback) {
                    setTimeout(function () {
                        var result = window.confirm(message);
                        if (callback) {
                            if (result) {
                                callback(1);
                            } else {
                                callback(2);
                            }
                        }
                    }, 0);
                },
                prompt: function (message, callback, title, buttonLabels, defaultText) {
                    // `notification.prompt` executes asynchronously
                    setTimeout(function () {
                        var result = window.prompt(message, defaultText || '');
                        if (callback) {
                            if (result === null) {
                                callback({ buttonIndex: 2, input1: '' }); // Cancel
                            } else {
                                callback({ buttonIndex: 1, input1: result }); // OK
                            }
                        }
                    }, 0);
                },
                beep: function (times) {
                    var audioContext = (function () {
                        // Determine if the Audio API is supported by this browser
                        var AudioApi = window.AudioContext;
                        if (!AudioApi) {
                            AudioApi = window.webkitAudioContext;
                        }
                    
                        if (AudioApi) {
                            // The Audio API is supported, so create a singleton instance of the AudioContext
                            return new AudioApi();
                        }
                    
                        return undefined;
                    }());

                    if (times > 0) {
                        var BEEP_DURATION = 700;
                        var BEEP_INTERVAL = 300;
                
                        if (audioContext) {
                            // Start a beep, using the Audio API
                            var osc = audioContext.createOscillator();
                            osc.type = 0; // sounds like a "beep"
                            osc.connect(audioContext.destination);
                            osc.start(0);
                
                            setTimeout(function () {
                                // Stop the beep after the BEEP_DURATION
                                osc.stop(0);
                
                                if (--times > 0) {
                                    // Beep again, after a pause
                                    setTimeout(function () {
                                        navigator.notification.beep(times);
                                    }, BEEP_INTERVAL);
                                }
                
                            }, BEEP_DURATION);
                        } else if (typeof (console) !== 'undefined' && typeof (console.log) === 'function') {
                            // Audio API isn't supported, so just write `beep` to the console
                            for (var i = 0; i < times; i++) {
                                console.log('Beep!');
                            }
                        }
                    }
                }

                
            }
        }
    },
    {
        // https://github.com/wildabeast/BarcodeScanner/#using-the-plugin
        cordovaPluginName: 'cordova.plugins.barcodeScanner',
        methods:{
            "WORK_WEIXIN": {
                scan: function(success,fail){
                    wx.scanQRCode({
                        desc: 'scanQRCode desc',
                        needResult: 1, // 默认为0，扫描结果由企业微信处理，1则直接返回扫描结果，
                        scanType: ["qrCode", "barCode"], // 可以指定扫二维码还是条形码（一维码），默认二者都有
                        success: function(res) {
                            success({
                                text: res.resultStr
                            });
                        },
                        error: function(res) {
                            if (res.errMsg.indexOf('function_not_exist') > 0) {
                                alert('企业微信版本过低请升级')
                            }else{
                                fail(res.errMsg);
                            }
                        }
                    });
                },
                encode: function(type, data, success, fail){
                    fail("暂不支持encode!");
                }

            }
        }
    },    
    {
        cordovaPluginName: 'plugins.updateApp',
        methods:{
            "GENERAL_BROWSER": {
                getAppVersion: function(callBack){
                    
                    callBack("1.0.0");
                }
            }
        }
    },
    {
        cordovaPluginName: 'device',
        methods:{
            "GENERAL_BROWSER": {
                model: "browserInjectCordova",
                platform: "browser",
                version: "1.0.0",
            }
        }
    },
    {
        cordovaPluginName: 'navigator.splashscreen',
        methods:{
            "GENERAL_BROWSER": {
                hide: function(){
                    //do nothing
                },
                show: function(){
                    //do nothing
                },
                isVisible: true
            }
        }
    },{
        cordovaPluginName: 'cordova.plugins.barcodeScanner',
        methods: {
            "WORK_WEIXIN":{
                "scan": function(callback, errorCallback){
                    wx.scanQRCode({
                        desc: 'scanQRCode desc',
                        needResult: 0, // 默认为0，扫描结果由企业微信处理，1则直接返回扫描结果，
                        scanType: ["qrCode", "barCode"], // 可以指定扫二维码还是条形码（一维码），默认二者都有
                        success: function(res) {
                            // 回调
                            callback(res)
                        },
                        error: function(res) {
                            if (res.errMsg.indexOf('function_not_exist') > 0) {
                                alert('版本过低请升级')
                            }else{
                                errorCallback(res)
                            }
                        }
                    });
                }
            }
        }
    },{
        cordovaPluginName: 'cordova.plugins.work',
        methods: {
            "WORK_WEIXIN":{
                "openUserProfile": function(type, userid, callback, errorCallback){
                    wx.invoke('openUserProfile', {
                        "type": type, //1表示该userid是企业成员，2表示该userid是外部联系人
                        "userid": userid //可以是企业成员，也可以是外部联系人
                    }, function(res) {
                        if(res.err_msg != "openUserProfile:ok") {
                            errorCallback(res)
                        }else{
                            callback(res)
                        }
                    });
                }
            }
        }
        
    }
    // {
    //     cordovaPluginName: 'imagePicker',
    //     methods:{}
    // },
    // {
    //     cordovaPluginName: 'navigator.camera',
    //     methods:{}
    // },
    // {
    //     cordovaPluginName: 'cordova.plugins.clipboard',
    //     methods:{}
    // },
    // {
    //     cordovaPluginName: 'navigator.contacts',
    //     methods:{}
    // },
    // {
    //     cordovaPluginName: 'plugins.socialsharing',
    //     methods:{}
    // },
    // {
    //     cordovaPluginName: 'Wechat',
    //     methods:{}
    // },
    // {
    //     cordovaPluginName: 'YCQQ',
    //     methods:{}
    // }
], window);

