
/**
 * OCR图片识别
 */
window.OCR = (function($){
  var APPID = {
    TABLE: "e9155e0dd168497489d6550a7e720125", // 智能表格识别
    LABEL: "e56a80277e9847ac8d8371b4e126e1e0" // 吊牌识别
  }


  // 定义OCR类
  function OCR(host) {
    console.log("host", host)
    this.taskList = []
    this.servicePrefix = host
  }

  OCR.prototype.createTask = createTask;
  OCR.prototype.getTaskInfoById = getTaskInfoById;
  OCR.prototype.getTaskInfoList = getTaskInfoList;
  OCR.prototype.addTask = addTask;
  OCR.prototype.popTask = popTask;
  OCR.prototype.taskLoop = taskLoop;
  OCR.prototype.updateTask = updateTask;
  OCR.APPID = APPID;
  OCR.extractAndParseJSON = extractAndParseJSON;

  function addTask(task) {
    this.taskList.push(task)
  }
  function popTask() {
    return this.taskList.pop()
  }
  function updateTask(taskId, obj) {
    this.taskList.forEach(task => {
      if(task.id === taskId) {
        Object.assign(task, obj)
      }
    });
  }

  function getEarlyTask() {
    // 过滤出处理中的任务
    var taskListInProgress = this.taskList.filter(task => task.finised);
    // 取出最后一项
    return taskListInProgress.pop();
  }

  /**
   * 循环处理任务列表
   */
  function taskLoop() {
    if(this.taskList.lenght === 0) { return };
    var earlyTask = getEarlyTask();
    var queryParams = {
      taskId: earlyTask.taskId
    }
    var that = this;
    this.getTaskInfoById(queryParams).then(res => {
      if(res.statusCode === 1 && res.object) {
        that.updateTask(earlyTask.taskId, res.object)
        this.taskLoop()
      }
    })
  }

  /**
   * 创建解析任务
   * @param {Object} data
   * @param {string} data.appId - 智能表格识别(APPID.TABLE)  服装吊牌(APPID.LABEL) 默认为-智能表格识别
   * @param {string} data.query - 图片链接.
   * @param {string} data.async - 是否异步 1-是，0-否 默认为1
   * @required data.query
   * @returns {promise}
   */
  function createTask (data) {
    var url = this.servicePrefix + '/ths/is/ai/call.ac';
    var methods = 'post';
    return service(url, methods, data)
  }

  /**
   * 查询任务信息
   * @param {queryParams} queryParams.taskId
   * @required queryParams.taskId
   * @returns {promise}
   */
  function getTaskInfoById (queryParams) {
    var queryStr = new URLSearchParams(queryParams)

    var url = this.servicePrefix + '/ths/is/ai/getCall.ac?' + queryStr
    return service(url, "POST")
  }
  /**
   * 查询任务列表
   * @param {queryParams} queryParams.page
   * @required queryParams.page
   * @returns {promise}
   */
  function getTaskInfoList (queryParams, data) {
    queryParams = queryParams || { page: 1 };
    var queryStr = new URLSearchParams(queryParams);
    var url = this.servicePrefix + '/ths/is/ai/getCallList.ac?' + queryStr;
    return service(url, "POST", data)
  }

  function service(url, method = 'GET', data) {
    return new Promise((resolve, reject) => {
      const xhr = new XMLHttpRequest();
      xhr.open(method, url, true);
      xhr.withCredentials = true; // 跨域请求时携带凭证
      xhr.setRequestHeader('Content-Type', 'application/json');
  
      xhr.onload = () => {
        if (xhr.status >= 200 && xhr.status < 300) {
          resolve(JSON.parse(xhr.responseText));
        } else {
          reject(new Error(`Request failed with status ${xhr.status}`));
        }
      };
  
      xhr.onerror = () => reject(new Error('Network error'));
  
      xhr.send(method === 'GET' ? null : JSON.stringify(data));
    });
  }
  function extractAndParseJSON(text) {
    // 使用正则表达式匹配JSON对象
    try {
      const jsonObject = JSON.parse(text);
      return jsonObject;
    } catch (error) {
      try {
        let regex =  /\{(.*?)\}/s;
        const match = text.match(regex);
        if (match) {
          const jsonObject = JSON.parse(match[0]);
          return jsonObject; // 返回解析后的JSON对象
        } else {
          throw new Error('No JSON string found in the text.'); // 没有找到JSON字符串
        }
      } catch (error) {
        // 捕获并处理错误
        console.error('Error parsing JSON:', error.message);
        return null; // 返回null或相应的错误信息
      }
    }
    
  }
  return OCR;
}
)($)