angular.module('exceptionOverride', []).config(function ($provide) {
    $provide.decorator("$exceptionHandler", ['$delegate', '$injector',function ($delegate, $injector) {
        return function (exception, cause) {
            var $http = $injector.get("$http");
            var ServerConfig = $injector.get("ServerConfig");
            var $rootScope = $injector.get("$rootScope");
            var logMsg = function (error) {
                var msg = null;
                var stack = null;
                if (error && error.stack) stack = error.stack;
                if (error && error.message) msg = error.message;
                var json = { onerror: 'is-onerror-event', msg: msg, error: stack }
                var userAgent = navigator.userAgent;
                var errorInfo = "&data=" + JSON.stringify(json) + "&device=" + encodeURIComponent(userAgent)
                if ($rootScope.platformIsAndroid) {
                    errorInfo += "&androidChannel=" + ServerConfig.androidChannel;
                }
                errorInfo += "&cid=" + ServerConfig.cid;
                errorInfo += "&version=" + ServerConfig.innerAppVersion;
                errorInfo += "&app=appRun";
                $http.get("https://qinsilk-log.cn-hangzhou.log.aliyuncs.com/logstores/error_report_log/track?APIVersion=0.6.0" + errorInfo);
            }
            exception.message += ' (caused by "' + cause + '")';
            logMsg(exception)
        }
    }]);
})
