cordova.define("com.qinsilk.bluetoothprinter.bluetoothPrinter", function(require, exports, module) {
var exec = require('cordova/exec');

var printer = {
    list: function (fnSuccess, fnError) {
        exec(fnSuccess, fnError, "BluetoothPrinter", "list", []);
    },
    open: function (fnSuccess, fnError, name, bleType,model) {
        exec(fnSuccess, fnError, "BluetoothPrinter", "open", [name, bleType,model]);
    },
    close: function (fnSuccess, fnError) {
        exec(fnSuccess, fnError, "BluetoothPrinter", "close", []);
    },
    print: function (fnSuccess, fnError, str, times) {
        exec(fnSuccess, fnError, "BluetoothPrinter", "print", [str, times]);
    },
    innerPrint: function (fnSuccess, fnError, str, times) {
        exec(fnSuccess, fnError, "BluetoothPrinter", "innerPrint", [str, times]);
    },
    printExpressArray: function (fnSuccess, fnError, expressArray, times,isPrintSentCallBack, bleType) {
        exec(fnSuccess, fnError, "BluetoothPrinter", "printExpressArray", [expressArray, times,isPrintSentCallBack, bleType]);
    },
    printLabelArray: function (fnSuccess, fnError, labelSetting, labelArray, times, bleType) {
        exec(fnSuccess, fnError, "BluetoothPrinter", "printLabelArray", [labelSetting, labelArray, times, bleType]);
    },
    printTMSQRcodeArray: function (fnSuccess, fnError, qrCodeSetting, qrCodeArry, times, bleType){
        exec(fnSuccess, fnError, "BluetoothPrinter", "printTMSQRcodeArray", [qrCodeSetting, qrCodeArry, times, bleType]);
    },
    connect: function (success, failure, name) {
        exec(success, failure, "BluetoothPrinter", "connect", [name]);
    },
    //新方法 直接打印指令
    printInstructions: function (fnSuccess, fnError, printData, times, bleType) {
        exec(fnSuccess, fnError, "BluetoothPrinter", "printInstructions", [printData, times, bleType]);
    },
    // 读取序列号
    readDeviceSn: function (fnSuccess, fnError) {
        exec(fnSuccess, fnError, "BluetoothPrinter", "readDeviceSn", []);
    },
    // 读取Mac
    readDeviceMac: function (fnSuccess, fnError) {
        exec(fnSuccess, fnError, "BluetoothPrinter", "readDeviceMac", []);
    },
    //发送cmd命令
    sendCmd: function (success, failure, cmd) {
        exec(success, failure, "BluetoothPrinter", "sendCmd", [cmd]);
    }
};

module.exports = printer;

});
