cordova.define("cordova-plugin-image-picker.ImagePicker", function(require, exports, module) {
/*global cordova,window,console*/
/**
 * An Image Picker plugin for Cordova
 *
 * Developed by Wymsee for Sync OnSet
 */

var ImagePicker = function () {

};

/*
*	success - success callback
*	fail - error callback
*	options
*/
ImagePicker.prototype.getPictures = function (success, fail, options) {
    if (!options) {
        options = {};
    }
    if (success == null) {
        success = function () { };
    }
    if (fail == null) {
        fail = function () { };
    }

    var params = {
        maximumImagesCount: options.maximumImagesCount ? options.maximumImagesCount : 9, // 最大图片数量
        cropW: options.width ? options.width : 0,
        cropH: options.height ? options.height : 0,
        isCrop: options.allowEdit, // 安卓可支持多图裁剪 ios只支持单图裁剪
        allowPickingOriginalPhoto: options.allowPickingOriginalPhoto, //是否显示原图按钮 默认不显示
        quality: options.quality ? options.quality : 100,
        hightCrop: options.hightCrop ? options.hightCrop : true, //默认高级裁剪 false为普通裁剪  ios使用
        showCropCircle: options.showCropCircle,// 显示圆形裁剪 默认矩形裁剪
        isCamera: options.isCamera ? options.isCamera : true,//默认显示拍照按钮
        sortAscendingByModificationDate: options.sortAscendingByModificationDate == false ? false : true, // ios 按照修改日期排序 默认true
        isGif: options.isGif,//是否显示gif 默认不显示
        returnType: options.returnType,// 1为返回数组对象 （包含文件详情） 0位返回数组文件路径（只包含文件路径） 默认为0
        circleCropRadius: options.circleCropRadius,// 普通裁剪时 圆形裁剪半径
        compress: options.compress, //是否压缩 默认不压缩
        correctOrientation: options.correctOrientation, //自动调整拍照 压缩方向
        isWeChatStyle: options.isWeChatStyle==false ? false : true, //是否为微信风格 android
        minimumCompressSize: options.minimumCompressSize, // 默认为100 小于100kb不压缩 android
        enableBase64: options.enableBase64, // 是否包含base64字符串 默认为false  returnType为1时有效,因为base64字符串比较大，所以默认为false

    };

    return cordova.exec(success, fail, "ImagePicker", "getPictures", [params]);
};

/*
*	success - success callback
*	fail - error callback
*	options
*/
ImagePicker.prototype.openCamera = function (success, fail, options) {
    if (!options) {
        options = {};
    }
    if (success == null) {
        success = function () { };
    }
    if (fail == null) {
        fail = function () { };
    }

    var params = {
        cropW: options.width ? options.width : 0,
        cropH: options.height ? options.height : 0,
        isCrop: options.allowEdit, // 安卓可支持多图裁剪 ios只支持单图裁剪
        quality: options.quality ? options.quality : 100,
        hightCrop: options.hightCrop ? options.hightCrop : true, //默认高级裁剪 false为普通裁剪  ios使用
        showCropCircle: options.showCropCircle,// 显示圆形裁剪 默认矩形裁剪
        returnType: options.returnType,// 1为返回数组对象 （包含文件详情） 0位返回数组文件路径（只包含文件路径） 默认为0
        circleCropRadius: options.circleCropRadius,// 普通裁剪时 圆形裁剪半径
        compress: options.compress, //是否压缩 默认不压缩
        correctOrientation: options.correctOrientation, //自动调整拍照 压缩方向
        isWeChatStyle: options.isWeChatStyle==false ? false : true, //是否为微信风格 android
        enableBase64: options.enableBase64, // 是否包含base64字符串 默认为false  returnType为1时有效,因为base64字符串比较大，所以默认为false
		saveToPhotoAlbum: options.saveToPhotoAlbum, // 是否保存在图库 ios
	};

    return cordova.exec(success, fail, "ImagePicker", "openCamera", [params]);
};

/*
*	success - success callback
*	fail - error callback
*	options
*/
ImagePicker.prototype.openVideo = function (success, fail, options) {
    if (!options) {
        options = {};
    }
    if (success == null) {
        success = function () { };
    }
    if (fail == null) {
        fail = function () { };
    }
    var params = {
        MaxSecond: options.maxSecond, //显示多少秒以内的视频or音频也可适用 android
        MinSecond: options.minSecond, //显示多少秒以内的视频or音频也可适用  android
        quality: options.quality ? options.quality : 100,
        recordVideoSecond: options.recordVideoSecond,// 视频秒数录制 默认60s int android
        videoMaximumDuration: options.videoMaximumDuration,//显示多少秒以内的视频or音频 ios
        returnType: options.returnType,// 1为返回数组对象 （包含文件详情） 0位返回数组文件路径（只包含文件路径） 默认为0
    };

    return cordova.exec(success, fail, "ImagePicker", "openVideo", [params]);
};

/**
 * 删除缓存
 */
ImagePicker.prototype.deleteCache = function () {
    var params = {};
    return cordova.exec(null, null, "ImagePicker", "deleteCache", [params]);
}

window.imagePicker = new ImagePicker();
});
