cordova.define("cordova-plugin-qinsilk-qrcodescan.QinsilkQrcodeScan", function(require, exports, module) {
var exec = require("cordova/exec");


  var scanInProgress = false;

  var QinsilkQrcodeScan = function () { };

  // 单个扫码 （华为）
  // 可选参数： {"scan_desc":'支持扫码'} 自定义文字显示
  QinsilkQrcodeScan.prototype.scan = function (successCallback, errorCallback, options) {
    if (errorCallback == null) {
      errorCallback = function () { };
    }

    if (typeof errorCallback != "function") {
      console.log(
        "QinsilkQrcodeScan.scan failure: failure parameter not a function"
      );
      return;
    }

    if (typeof successCallback != "function") {
      console.log(
        "QinsilkQrcodeScan.scan failure: success callback parameter must be a function"
      );
      return;
    }

    if (scanInProgress) {
      errorCallback('Scan is already in progress');
      return;
    }

    scanInProgress = true;


    var params = {
      ...options,
      show_scan_title: options.show_scan_title,
      scan_desc: options.scan_desc,//显示文字描述
      disableBeepEnabled: options.disableBeepEnabled,//是否禁用声音
      isDialog: options.isDialog,// 是否显示modal
    };

    exec(
      function (result) {
        scanInProgress = false;
        successCallback(result);
      },
      function (error) {
        scanInProgress = false;
        errorCallback(error);
      },
      "QinsilkQrcodeScan",
      "scan",
      [params]
    );
  };


  QinsilkQrcodeScan.prototype.multiFunScan = function (successCallback, errorCallback, options) {
    if (errorCallback == null) {
      errorCallback = function () { };
    }

    if (typeof errorCallback != "function") {
      console.log(
        "QinsilkQrcodeScan.scan failure: failure parameter not a function"
      );
      return;
    }

    if (typeof successCallback != "function") {
      console.log(
        "QinsilkQrcodeScan.scan failure: success callback parameter must be a function"
      );
      return;
    }

    if (scanInProgress) {
      errorCallback('Scan is already in progress');
      return;
    }

    scanInProgress = true;

    var params = {
      disableBeepEnabled: options.disableBeepEnabled,//是否禁用声音
      isDialog: options.isDialog,// 是否显示modal
      ...options
    };

    exec(
      function (result) {
        scanInProgress = false;
        if (result.format === 'UPC_A' && result.text.length === 13) {
            result.text = result.text.substring(1);
        }
        successCallback(result);
      },
      function (error) {
        scanInProgress = false;
        errorCallback(error);
      },
      "QinsilkQrcodeScan",
      "multiFunScan",
      [params]
    );
  };


  // modal扫码 （华为）
  /*
  */
  QinsilkQrcodeScan.prototype.dialogScan = function (successCallback, errorCallback, config) {
    if (errorCallback == null) {
      errorCallback = function () { };
    }

    if (typeof errorCallback != "function") {
      console.log(
        "QinsilkQrcodeScan.dialogScan failure: failure parameter not a function"
      );
      return;
    }

    if (typeof successCallback != "function") {
      console.log(
        "QinsilkQrcodeScan.dialogScan failure: success callback parameter must be a function"
      );
      return;
    }

    exec(
      function (result) {
        successCallback(result);
      },
      function (error) {
        errorCallback(error);
      },
      "QinsilkQrcodeScan",
      "dialogScan",
      [config]
    );
  };



  // 内嵌扫码 （华为）（可连续扫码）
  /*
  * config 参数： {"width":100,"height":100,"left":10,"top":10}
  */
  QinsilkQrcodeScan.prototype.innerScan = function (successCallback, errorCallback, options) {
    if (errorCallback == null) {
      errorCallback = function () { };
    }

    if (typeof errorCallback != "function") {
      console.log(
        "QinsilkQrcodeScan.scan failure: failure parameter not a function"
      );
      return;
    }

    if (typeof successCallback != "function") {
      console.log(
        "QinsilkQrcodeScan.scan failure: success callback parameter must be a function"
      );
      return;
    }
    if (scanInProgress) {
      errorCallback('Scan is already in progress');
      return;
    }

    scanInProgress = true;

    var params = {
      disableBeep: options.disableBeepEnabled == false ? false : true,//是否禁用声音
      vibrate: options.vibrate == false ? false : true,//是否为震动
      continue: options.continue == false ? false : true,//是否为连续扫码
      ...options,
    };

    exec(
      function (result) {
        scanInProgress = false;
        successCallback(result);
      },
      function (error) {
        scanInProgress = false;
        errorCallback(error);
      },
      "QinsilkQrcodeScan",
      "innerScan",
      [params]
    );
  };

  //隐藏自定义扫码
  QinsilkQrcodeScan.prototype.hideScan = function () {
    exec(
      null,
      null,
      "QinsilkQrcodeScan",
      "hideScan",
      []
    );
  }


  //图片扫码
  QinsilkQrcodeScan.prototype.imageScan = function (successCallback, errorCallback,filePath) {
    if (errorCallback == null) {
      errorCallback = function () { };
    }
  
    if (typeof errorCallback != "function") {
      console.log(
        "QinsilkQrcodeScan.imageScan failure: failure parameter not a function"
      );
      return;
    }
  
    if (typeof successCallback != "function") {
      console.log(
        "QinsilkQrcodeScan.imageScan failure: success callback parameter must be a function"
      );
      return;
    }
    exec(
       function (result) {
            successCallback(result);
          },
          function (error) {
            errorCallback(error);
          },
      "QinsilkQrcodeScan",
      "imageScan",
      [filePath]
    );
  }

  var qinsilkQrcodeScanner = new QinsilkQrcodeScan();
  module.exports = qinsilkQrcodeScanner;


});
