/**
 * 公共函数
 */

//全局的配置文件 
var config = {
	fileTypes : "txt|epub|pdf|umd", //允许上传的文件格式 "txt|epub"
	url : "http://"+location.host+"?action=addBook",//"http://localhost/t/post.php",//
	fileLimitSize : 500 * 1024 *1024

}

var file = {
	"inQueue" : [], //已经在队列里面的文件，包括 HTML5上传和 Flash上传的
	"clientHaveFiles" : [] // 客户端已经存在的文件列表
}

/**
 * HTML5 和 flash 公用，所有文件对象集合
 * @var array 
 */
var filesUpload	= []; //

$.ajax({
	url : "http://"+location.host+'?action=getBooksList&t='+(+new Date()),//"http://localhost/t/t.php",//
	async:false,//同步获取数据
	dataType : "json",
	success:function(data){
     /*   data = '[{"id":28,"size":1050127,"name":"333.pdf"}]';
        data = JSON.parse(data);*/
		try{
			var dataLen = data.length;
            var li = "";
			if(dataLen > 0 ){
				for(var i=0; i < dataLen;  i++){
					 filesUpload.push(data[i]);
                     var size = countFileSize(data[i].size);
                     var li_id ="tr_" + data[i].id;
                    var name = substr_string(data[i].name);
                     li = li+ '<li id='+li_id+'><dl class="grybg"><dt>'+name+'</dt><dd>'+size+'</dd><dd>完成<span class="delete" onclick="confirmDel(\''+data[i].id+'\',\''+data[i].name+'\')">&nbsp;&nbsp;删除</span></dd></dl><div class="jdt"><p id="progress_bar_p_'+data[i].id+'" class="orange" style="width: 100%;"></p></div></li>';
				}
                /*$("#tableStyle").html(li);*/
			}
		}catch(e){}
		
	}
})

//统计文件大小
function countFileSize(fileSize)
{
	var KB  = 1024;
	var MB = 1024 * 1024;
	if(KB >= fileSize){
	   return fileSize+"B";
	}else if(MB >= fileSize){
		return (fileSize/KB).toFixed(2)+"KB";
	}else{
		return (fileSize/MB).toFixed(2)+"MB";
	}
}

//如果文件太长进行截取
function substr_string(name)
{
	var maxLen = 15;
	var len = name.length;
	if(len < 17 )return name;
	
	var lastIndex = name.lastIndexOf(".");
	var suffix    = name.substr(lastIndex);
	var pre       = name.substr(0,lastIndex);
	var preLen    = pre.length;
	var preStart  = preLen - 10;
	//前面10个 + 后面5个
	var fileName  =  pre.substr(0,10) + "...." + pre.substr( preStart > 4 ? -4 : -preStart , 4)+suffix;
	return fileName
}


function checkFile(file) {
	
	if(file.size > config.fileLimitSize){
		return "文件太大，不能超过500MB";
	}
	
	if (!file.name || !file.name.toLowerCase().match('('+config.fileTypes+')$')) {
		return "无法上传此格式的文件，请选择EPUB,TXT,PDF或UMD格式的图书文件";
	}
	
	var len = filesUpload.length;
	for(var i=0; i< len; i++){
		if(filesUpload[i].name == file.name)	{
			return "文件已经存在，请先删除再重新上传";
		}
	}
	return null;
}






/**
 * 添加文件时，回调的函数
 * @param object file 文件对象
 * @param int type 0 是swf 上传的，1 是html5上传的
 */
function fileQueued(file, type)
{
	var size=0 ,fid=file.id, name="";
	type = type || 0;
	
	if(file != undefined )
	{
		//计算文件大小 单位MB
		size = countFileSize(file.size);
		name = substr_string(file.name)
		//创建要插入的元素
//		"<tr id='tr_'"+fid+"><td><div class='bh-poStion'><h1>"+name+"</h1>"+
//						"<div class='bh-tip bh-tip3' id='progress_bar_"+fid+"'>"+
//						"<span id='progress_bar_span_"+fid+"'></span></div>"+
//						"</div></td><td><span class='bh-M'>"+size+"</span></td><td><div class='bh-link' id='handle_button_"+fid+"'>"+
//						"<a href='javascript:void(0)' onclick=userCancelUpload('"+fid+"',"+type+")>取消</a></div></td></tr>";
					
          var HTML = '<li  id=tr_'+fid+'>'+
					'<dl class="grybg">'+
						'<dt>'+name+'</dt>'+
						'<dd>'+size+'</dd>'+
						'<dd id="handle_button_'+fid+'"  onclick=userCancelUpload("'+fid+'",'+type+') class="orange">'+
							'<span id="progress_bar_span_'+fid+'">0%</span> 取消</dd>'+
					'</dl>'+
					'<div class="jdt"><p  id="progress_bar_p_'+fid+'" ></p></div>'+
			'</li>';
						
						
		jQuery("#tableStyle").append(HTML);
		//保存falsh_id，为上传做准备
		//global_flash_id.push(file.id);
		//更改背景颜色
		changeTrBackGroundColor()
	}
}

function changeTrBackGroundColor()
{
	var getTr=document.getElementById("tableStyle").getElementsByTagName("dl");
	trNum=getTr.length;
	for(var i=0;i<trNum;i++){
		if(i%2==0){
			getTr[i].style.backgroundColor="#f3f3f3";
		}
	}
}	



//上传时返回的状态
function uploadProgress(file, bytesLoaded, bytesTotal) 
{
	if(!$("#progress_bar_p_"+file.id).hasClass("orange")){
		$("#progress_bar_p_"+file.id).addClass("orange");
	}
	$("#progress_bar_p_"+file.id).css("width",(bytesLoaded/bytesTotal)*100+"%");
	$("#progress_bar_span_"+file.id).html(parseInt((bytesLoaded/bytesTotal)*100)+"%");
	
}


//上传成功
function uploadSuccess(file, serverData, res)
{
	var id = "handle_button_"+file.id;
    var trid =  "tr_"+file.id;
	$("#"+id).replaceWith("<dd>完成<span class='delete' onclick='confirmDel(\""+file.id+"\",\""+file.name+"\")'>&nbsp;&nbsp;删除</span></dd>")
}
function confirmDel(id,name){
   if(confirm("确定删除这本书吗？")){
       deleteBook(id,name);
   }
}

function deleteBook(id,name){
    name = base64.encode(base64.utf16to8(name));
    var trid =  "tr_"+id;

    $.ajax({
        url : "http://"+location.host+'?action=delBook&name='+name+'&t='+(+new Date()),//"http://localhost/t/t.php",//
        async:false,//同步获取数据
        dataType : "json",
        success:function(data){
            if(data.flag == 1)
            {
                $("#"+trid).remove();
                removeFileFromFilesUpload(filesUpload, id)
            }
        },
        error:function(){
            alert("wifi服务器连接失败");
        }
    })
}


//取消上传
function userCancelUpload(file_id, type)
{
	
	if(type==0){
		SWFFuns.cancelUpload(file_id);
	}else{
		HTML5Funs.cancelUpload(file_id);
	}
	
	$("#handle_button_"+file_id).html("已取消").removeClass("orange").addClass("gray");
	//如果已经上传一部分了
	if($("#progress_bar_p_"+file_id).hasClass("orange")){
			$("#progress_bar_p_"+file_id).removeClass("orange");
			$("#progress_bar_p_"+file_id).addClass("gray");
	}	
}


/**
 * 通过文件名称 从全局的文件列表中获取文件对象
 *
 */
function getFileFomeFilesUpload(filename){
	var len = filesUpload.length;
	for(var i=0; i < len; i++){
		if(filesUpload[i].name == filename){
			return filesUpload[i];
		}
	}
	
	return null;
}


/**
 * 往全局的 上传列表添加一个数据
 */
function addFileToFilesUpload(file){
	
	if(typeof file == "string"){
		filesUpload.push({"name":file})
		return true;
	}else if(typeof file == "object"){
		filesUpload.push(file);
		return true;
	}
	
	return false;
}

/**
 * 往全局的 上传列表添加一个数据
 */
function updateFileToFilesUpload(file){
	
	var len = filesUpload.length;
	for(var i=0; i < len; i++){
		if(filesUpload[i].name == file.name){
			filesUpload[i] = file;
			return true;
		}
	}
	
	return false;
}

/**
 * 查找在数组中的位置
 */
function findObjectKey (object, fid){
	var len = object.length; 
	for(var i=0; i<len; i++){
		if(object[i].id == fid){
			return i;
		}
	}
	return -1;
}

/**
 * 从全局的文件集合中移除文件，一般上传失败时使用
 * @param array files   文件对象集合  [{},{},{}]
 * @param int fid  要删除的文件id
 * @return 删除后的数组，  其实数组是引用类型可以不返回
 */
function removeFileFromFilesUpload(files, fid){
	
	var filesUploadKey = -1;
	
	filesUploadKey = findObjectKey(files, fid);
	//从全局文件中移除
	if(filesUploadKey > -1)
		 files.splice(filesUploadKey, 1);
		 
	return files;
}
var base64 = {
    base64encodechars: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",
        base64decodechars: new Array(-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63,
        52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
        15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
        41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1),
        encode: function (str) {
        var out, i, len;
        var c1, c2, c3;
        len = str.length;
        i = 0;
        out = "";
        while (i < len) {
            c1 = str.charCodeAt(i++) & 0xff;
            if (i == len) {
                out += this.base64encodechars.charAt(c1 >> 2);
                out += this.base64encodechars.charAt((c1 & 0x3) << 4);
                out += "==";
                break;
            }
            c2 = str.charCodeAt(i++);
            if (i == len) {
                out += this.base64encodechars.charAt(c1 >> 2);
                out += this.base64encodechars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xf0) >> 4));
                out += this.base64encodechars.charAt((c2 & 0xf) << 2);
                out += "=";
                break;
            }
            c3 = str.charCodeAt(i++);
            out += this.base64encodechars.charAt(c1 >> 2);
            out += this.base64encodechars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xf0) >> 4));
            out += this.base64encodechars.charAt(((c2 & 0xf) << 2) | ((c3 & 0xc0) >> 6));
            out += this.base64encodechars.charAt(c3 & 0x3f);
        }
        console.log(out);
        return out;
    },

    decode: function (str) {
        var c1, c2, c3, c4;
        var i, len, out;
        len = str.length;
        i = 0;
        out = "";
        while (i < len) {

            do {
                c1 = this.base64decodechars[str.charCodeAt(i++) & 0xff];
            } while (i < len && c1 == -1);
            if (c1 == -1) break;

            do {
                c2 = this.base64decodechars[str.charCodeAt(i++) & 0xff];
            } while (i < len && c2 == -1);
            if (c2 == -1) break;
            out += String.fromCharCode((c1 << 2) | ((c2 & 0x30) >> 4));

            do {
                c3 = str.charCodeAt(i++) & 0xff;
                if (c3 == 61) return out;
                c3 = this.base64decodechars[c3];
            } while (i < len && c3 == -1);
            if (c3 == -1) break;
            out += String.fromCharCode(((c2 & 0xf) << 4) | ((c3 & 0x3c) >> 2));

            do {
                c4 = str.charCodeAt(i++) & 0xff;
                if (c4 == 61) return out;
                c4 = this.base64decodechars[c4];
            } while (i < len && c4 == -1);
            if (c4 == -1) break;
            out += String.fromCharCode(((c3 & 0x03) << 6) | c4);
        }
        console.log(out);
        return out;
    },

    utf16to8: function (str) {
        var out, i, len, c;
        out = "";
        len = str.length;
        for (i = 0; i < len; i++) {
            c = str.charCodeAt(i);
            if ((c >= 0x0001) && (c <= 0x007f)) {
                out += str.charAt(i);
            } else if (c > 0x07ff) {
                out += String.fromCharCode(0xe0 | ((c >> 12) & 0x0f));
                out += String.fromCharCode(0x80 | ((c >> 6) & 0x3f));
                out += String.fromCharCode(0x80 | ((c >> 0) & 0x3f));
            } else {
                out += String.fromCharCode(0xc0 | ((c >> 6) & 0x1f));
                out += String.fromCharCode(0x80 | ((c >> 0) & 0x3f));
            }
        }
        return out;
    },

    utf8to16: function (str) {
        var out, i, len, c;
        var char2, char3;
        out = "";
        len = str.length;
        i = 0;
        while (i < len) {
            c = str.charCodeAt(i++);
            switch (c >> 4) {
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                    // 0xxxxxxx
                    out += str.charAt(i - 1);
                    break;
                case 12:
                case 13:
                    // 110x xxxx   10xx xxxx
                    char2 = str.charCodeAt(i++);
                    out += String.fromCharCode(((c & 0x1f) << 6) | (char2 & 0x3f));
                    break;
                case 14:
                    // 1110 xxxx  10xx xxxx  10xx xxxx
                    char2 = str.charCodeAt(i++);
                    char3 = str.charCodeAt(i++);
                    out += String.fromCharCode(((c & 0x0f) << 12) | ((char2 & 0x3f) << 6) | ((char3 & 0x3f) << 0));
                    break;
            }
        }
        return out;
    }

};
