"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function () { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var falcon;
(function (falcon) {
    var EventManager = (function () {
        function EventManager() {
        }
        Object.defineProperty(EventManager, "net2Cs", {
            get: function () {
                return this._net2Cs;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(EventManager, "events", {
            get: function () {
                return this._events;
            },
            enumerable: true,
            configurable: true
        });
        EventManager.registerEvent = function (eventVo, receivedEventsHanlder) {
            if (receivedEventsHanlder === void 0) { receivedEventsHanlder = null; }
            if (eventVo === null)
                return;
            this._receivedEventsHanlder = receivedEventsHanlder;
            var eventClass = eventVo.eventClass;
            if (eventClass) {
                if (this._events.get(eventClass) === undefined)
                    this._events.set(eventClass, []);
                var key = eventVo.eventClass;
                var events = this._events.get(eventVo.eventClass);
                var find = void 0;
                for (var i = 0, l = events.length; i < l; i++) {
                    if (events[i].proxy === eventVo.proxy) {
                        find = true;
                        break;
                    }
                }
                if (!find)
                    events.push(eventVo);
                if (eventClass.prototype instanceof falcon.Net2C) {
                    var code = eventClass.prototype.code;
                    this._net2Cs.set(code, eventVo);
                }
            }
        };
        EventManager.traceNetLog = function (event, isServer) {
            if (event instanceof falcon.Net2C) {
                var date = new Date();
                var code = event.code;
                var msg = this.msgs[code];
                if (code !== 16) {
                    var comments = window["comments"];
                    var comment = comments ? comments["cm" + code] : "";
                    if (window['env'] && window['env']['isNativeIOS']) {
                        console.warn((isServer ? "-----------[SERVER]-----------" : "") + " S->C\u3010" + code + "\u3011\u3010" + comment + "\u3011=>", msg);
                    }
                    else {
                        console.log((isServer ? "-----------[SERVER]-----------" : "") + date.toLocaleTimeString() + " " + date.getMilliseconds() + " %cS->C【" + code + "】【" + comment + "】=> ", "color:#0021e9;background:#dddddd;", msg);
                    }
                }
            }
        };
        EventManager.dispatchModuleEvent = function (event) {
            if (!event)
                return;
            if (event instanceof falcon['Net2S']) {
                var msgBody = event['encode']();
                if (falcon['currentSocket']) {
                    var code = event.constructor.prototype.code;
                    falcon['currentSocket'].send(code, msgBody);
                }
            }
            else {
                this.traceNetLog(event, true);
                var events = this._events.get(event.getClass());
                if (events) {
                    for (var i = 0, l = events.length; i < l; i++) {
                        var eventVo = events[i];
                        var raceVo = this.getRaceVo(event);
                        if (raceVo) {
                            this._races.push({ raceVo: raceVo, eventVo: eventVo, event: event });
                        }
                        else {
                            this.traceNetLog(event);
                            eventVo.proxy.receivedEvents(event);
                            if (this._receivedEventsHanlder) {
                                this._receivedEventsHanlder(eventVo, event);
                            }
                        }
                    }
                }
            }
        };
        EventManager.getRaceVo = function (event) {
            if (event instanceof falcon.Net2C) {
                var curCode = event.code;
                return this.NetRaces[curCode];
            }
            return undefined;
        };
        EventManager.delay = function (time) {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    if (time <= 0)
                        return [2, undefined];
                    return [2, new Promise(function (c, e) {
                        setTimeout(c, time);
                    })];
                });
            });
        };
        EventManager.triggerUpdate = function () {
            if (this._canRace) {
                this._canRace = false;
                this.raceNext();
            }
        };
        EventManager.raceNext = function () {
            return __awaiter(this, void 0, void 0, function () {
                var nextVo, raceVo, eventVo, event_1, _a, type, time, _nextDelay, _delay, _b, err_1;
                return __generator(this, function (_c) {
                    switch (_c.label) {
                        case 0:
                            if (!this._races.length) return [3, 15];
                            nextVo = this._races[0];
                            raceVo = nextVo.raceVo, eventVo = nextVo.eventVo, event_1 = nextVo.event;
                            _a = raceVo.races, type = _a.type, time = _a.time;
                            _nextDelay = raceVo.nextDelay || 0;
                            _delay = raceVo.delay || 0;
                            this.traceNetLog(event_1);
                            return [4, this.delay(_delay)];
                        case 1:
                            _c.sent();
                            _c.label = 2;
                        case 2:
                            _c.trys.push([2, 12, , 13]);
                            _b = type;
                            switch (_b) {
                                case "all": return [3, 3];
                                case "complete": return [3, 5];
                                case "race": return [3, 7];
                                case "time": return [3, 9];
                            }
                            return [3, 11];
                        case 3: return [4, Promise.all([this.delay(time), eventVo.proxy.receivedEvents(event_1)])];
                        case 4:
                            _c.sent();
                            return [3, 11];
                        case 5: return [4, eventVo.proxy.receivedEvents(event_1)];
                        case 6:
                            _c.sent();
                            return [3, 11];
                        case 7: return [4, Promise.race([this.delay(time), eventVo.proxy.receivedEvents(event_1)])];
                        case 8:
                            _c.sent();
                            return [3, 11];
                        case 9:
                            eventVo.proxy.receivedEvents(event_1);
                            return [4, this.delay(time)];
                        case 10:
                            _c.sent();
                            return [3, 11];
                        case 11: return [3, 13];
                        case 12:
                            err_1 = _c.sent();
                            console.error("执行当前队列消息发生错误：", err_1);
                            return [3, 13];
                        case 13: return [4, this.delay(_nextDelay)];
                        case 14:
                            _c.sent();
                            this._races.shift();
                            this.raceNext();
                            return [3, 16];
                        case 15:
                            this._canRace = true;
                            _c.label = 16;
                        case 16: return [2];
                    }
                });
            });
        };
        EventManager._events = new Map();
        EventManager._net2Cs = new Map();
        EventManager._codeReg = /^.*Net2[S|C]_(\d+)$/;
        EventManager.NetRaces = {};
        EventManager._races = [];
        EventManager._canRace = true;
        EventManager.msgs = {};
        return EventManager;
    }());
    falcon.EventManager = EventManager;
})(falcon || (falcon = {}));
setInterval(function () {
    falcon.EventManager.triggerUpdate();
});
var falcon;
(function (falcon) {
    var EventVo = (function () {
        function EventVo() {
            this._id = 0;
            EventVo._uniqueID += 1;
            this._id = EventVo._uniqueID;
        }
        Object.defineProperty(EventVo.prototype, "id", {
            get: function () {
                return this._id;
            },
            enumerable: true,
            configurable: true
        });
        EventVo._uniqueID = 0;
        return EventVo;
    }());
    falcon.EventVo = EventVo;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var Module = (function () {
        function Module() {
            this._proxyClassMap = new Map();
        }
        Object.defineProperty(Module.prototype, "proxyClassMap", {
            get: function () {
                return this._proxyClassMap;
            },
            enumerable: true,
            configurable: true
        });
        Module.prototype.registerProxys = function () {
            return [];
        };
        Module.prototype.getProxy = function ($proxyClass) {
            return this._proxyClassMap.get($proxyClass);
        };
        Module.prototype.startProxy = function () {
            this._resigerProxys = this.registerProxys();
            for (var i = 0, l = this._resigerProxys.length; i < l; i++) {
                var proxyClass = this._resigerProxys[i];
                var _proxyInstance = new proxyClass(this);
                this._proxyClassMap.set(proxyClass, _proxyInstance);
                _proxyInstance.startEvents();
            }
        };
        return Module;
    }());
    falcon.Module = Module;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var ModuleEvent = (function () {
        function ModuleEvent() {
        }
        ModuleEvent.prototype.getClass = function () {
            return this['constructor'];
        };
        return ModuleEvent;
    }());
    falcon.ModuleEvent = ModuleEvent;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var NetBase = (function (_super) {
        __extends(NetBase, _super);
        function NetBase() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._codeReg = /^.*Net2[S|C]_(\d+)$/;
            return _this;
        }
        Object.defineProperty(NetBase.prototype, "code", {
            get: function () {
                var eventClassName = this['constructor'].name;
                return +eventClassName.replace(this._codeReg, '$1');
            },
            enumerable: true,
            configurable: true
        });
        return NetBase;
    }(falcon.ModuleEvent));
    falcon.NetBase = NetBase;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var Net2C = (function (_super) {
        __extends(Net2C, _super);
        function Net2C() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(Net2C.prototype, "data", {
            get: function () {
                return this._data;
            },
            enumerable: true,
            configurable: true
        });
        Net2C.prototype.decode = function (data) {
        };
        return Net2C;
    }(falcon.NetBase));
    falcon.Net2C = Net2C;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var Net2S = (function (_super) {
        __extends(Net2S, _super);
        function Net2S() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Net2S.prototype.encode = function () {
            return undefined;
        };
        return Net2S;
    }(falcon.NetBase));
    falcon.Net2S = Net2S;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var ModuleManager = (function () {
        function ModuleManager() {
        }
        Object.defineProperty(ModuleManager, "moduleList", {
            get: function () {
                return this._moduleList;
            },
            enumerable: true,
            configurable: true
        });
        ModuleManager.resigerModule = function ($modules) {
            this._modules = $modules;
        };
        ModuleManager.startModule = function () {
            for (var i = 0, l = this._modules.length; i < l; i++) {
                var $moduleClass = this._modules[i];
                var _instance = new $moduleClass();
                this._moduleList[i] = _instance;
                _instance.startProxy();
            }
        };
        ModuleManager._moduleList = [];
        return ModuleManager;
    }());
    falcon.ModuleManager = ModuleManager;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var Proxy = (function () {
        function Proxy($module) {
            this._module = $module;
        }
        Proxy.prototype.registerEvents = function () {
            return null;
        };
        Proxy.prototype.getClass = function () {
            return this['constructor'];
        };
        Proxy.prototype.getModule = function () {
            return this._module;
        };
        Proxy.prototype.receivedEvents = function ($event) { };
        Proxy.prototype.startEvents = function () {
            var _events = this.registerEvents();
            if (_events != null) {
                for (var i = 0, l = _events.length; i < l; i++) {
                    var _eventVo = new falcon.EventVo();
                    _eventVo.proxy = this;
                    _eventVo.eventClass = _events[i];
                    falcon.EventManager.registerEvent(_eventVo);
                }
            }
        };
        Proxy.prototype.dispatchModuleEvent = function ($event) {
            falcon.EventManager.dispatchModuleEvent($event);
        };
        return Proxy;
    }());
    falcon.Proxy = Proxy;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    function SD(instanceClass) {
        var modules = falcon.ModuleManager.moduleList;
        for (var i = 0; i < modules.length; i++) {
            var module = modules[i];
            var proxys = module.proxyClassMap;
            var instance = proxys.get(instanceClass);
            if (instance)
                return instance;
        }
        console.error("\u6CA1\u6709\u627E\u5230" + instanceClass.toString() + "\u4EE3\u7406");
        return undefined;
    }
    falcon.SD = SD;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var _FalconConfigMgr = (function () {
        function _FalconConfigMgr() {
            this._config = {};
            if (_FalconConfigMgr._instance) {
                throw new Error("Error: Instantiation failed: Use SingletonDemo.getInstance() instead of new.");
            }
            _FalconConfigMgr._instance = this;
        }
        _FalconConfigMgr.getInstance = function () {
            return _FalconConfigMgr._instance;
        };
        _FalconConfigMgr.prototype.loadConfig = function (config) {
            this._config.appid = config.appid;
            this._config.severid = config.severid;
            this._config.deviceid = config.deviceid;
            this._config.devicetype = config.devicetype;
            this._config.isdebug = config.isdebug || false;
            this._config.bundleId = config.bundleId;
            this._config.idfa = config.idfa;
            this._config.chId = config.chId;
            this._config.subChId = config.subChId;
            this._config.baseUrl = config.baseUrl;
            this._config.version = config.version;
            this._config.system = config.system;
            this._config.android = config.android;
            if (!this._config.android) {
                this._config.android = { imei: "", androidId: "", mac: "", oaid: "" };
            }
            if (window['env'].isNativeAndroid) {
                this._config.devicetype = 0;
                this._config.clientType = 2;
                if (!this._config.chId && !this._config.subChId) {
                    console.error("android\u5E73\u53F0\u4E00\u7EA7\u6E20\u9053\u4E0E\u4E8C\u7EA7\u6E20\u9053\u4E0D\u5B58\u5728\uFF01", this._config.chId, this._config.subChId);
                }
                if (this._config.idfa) {
                    console.warn("android\u5E73\u53F0\u4E0D\u5E94\u8BE5\u4F20idfa,\u8FD9\u91CC\u76F4\u63A5\u5FFD\u7565\u4E86\uFF01");
                    this._config.idfa = "";
                }
                if (config.android) {
                    this._config.uuid = config.android.androidId;
                    if (!config.android.imei && !config.android.imei2) {
                        console.error("android\u5E73\u53F0\u4F20\u9012\u7684imei\u4E0Eimei2\u4E0D\u5B58\u5728\uFF01", config.android.imei, config.android.imei2);
                    }
                    if (config.android.imei) {
                        this._config.android.imei = config.android.imei;
                    }
                    else {
                        this._config.android.imei = config.android.imei2;
                    }
                }
                else {
                    console.error("android\u5E73\u53F0\u914D\u7F6E\u7684android\u4FE1\u606F\u4E0D\u5B58\u5728\uFF01");
                }
            }
            else if (window['env'].isNativeIOS) {
                this._config.devicetype = 1;
                this._config.clientType = 1;
                if (config.idfa) {
                    this._config.uuid = config.idfa;
                }
                else {
                    console.error("ios\u5E73\u53F0\u914D\u7F6E\u7684idfa\u4E0D\u5B58\u5728\uFF01");
                }
            }
            else {
                this._config.devicetype = 1;
                this._config.clientType = 1;
                this._config.uuid = "";
            }
            window['appid'] = config.appid;
        };
        _FalconConfigMgr.prototype.getConfig = function () {
            return this._config;
        };
        _FalconConfigMgr._instance = new _FalconConfigMgr();
        return _FalconConfigMgr;
    }());
    falcon._FalconConfigMgr = _FalconConfigMgr;
})(falcon || (falcon = {}));
String.prototype.format = function () {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    if (args.length == 0) {
        return this;
    }
    var self = this;
    for (var i = 0; i < args.length; i++) {
        var sval = args[i];
        while (true) {
            var result = null;
            if (typeof sval === "number") {
                result = self.match(/(%d)|(%s)/);
                if (result) {
                    self = self.replace(/(%d)|(%s)/, sval.toString());
                    break;
                }
            }
            result = self.match(/%s/);
            if (result) {
                self = self.replace(/%s/, sval);
            }
            else {
                self += "    " + sval;
            }
            break;
        }
    }
    return self;
};
var falcon;
(function (falcon) {
    var Base64Util = (function () {
        function Base64Util() {
        }
        Base64Util.encode = function (arraybuffer) {
            var bytes = new Uint8Array(arraybuffer);
            var len = bytes.length;
            var base64 = '';
            for (var i = 0; i < len; i += 3) {
                base64 += chars[bytes[i] >> 2];
                base64 += chars[((bytes[i] & 3) << 4) | (bytes[i + 1] >> 4)];
                base64 += chars[((bytes[i + 1] & 15) << 2) | (bytes[i + 2] >> 6)];
                base64 += chars[bytes[i + 2] & 63];
            }
            if ((len % 3) === 2) {
                base64 = base64.substring(0, base64.length - 1) + '=';
            }
            else if (len % 3 === 1) {
                base64 = base64.substring(0, base64.length - 2) + '==';
            }
            return base64;
        };
        Base64Util.decode = function (base64) {
            var bufferLength = base64.length * 0.75;
            var len = base64.length;
            var p = 0;
            var encoded1 = 0;
            var encoded2 = 0;
            var encoded3 = 0;
            var encoded4 = 0;
            if (base64[base64.length - 1] === '=') {
                bufferLength--;
                if (base64[base64.length - 2] === '=') {
                    bufferLength--;
                }
            }
            var arraybuffer = new ArrayBuffer(bufferLength), bytes = new Uint8Array(arraybuffer);
            for (var i = 0; i < len; i += 4) {
                encoded1 = lookup[base64.charCodeAt(i)];
                encoded2 = lookup[base64.charCodeAt(i + 1)];
                encoded3 = lookup[base64.charCodeAt(i + 2)];
                encoded4 = lookup[base64.charCodeAt(i + 3)];
                bytes[p++] = (encoded1 << 2) | (encoded2 >> 4);
                bytes[p++] = ((encoded2 & 15) << 4) | (encoded3 >> 2);
                bytes[p++] = ((encoded3 & 3) << 6) | (encoded4 & 63);
            }
            return arraybuffer;
        };
        return Base64Util;
    }());
    falcon.Base64Util = Base64Util;
})(falcon || (falcon = {}));
var chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
var lookup = new Uint8Array(256);
for (var i = 0; i < chars.length; i++) {
    lookup[chars.charCodeAt(i)] = i;
}
var falcon;
(function (falcon) {
    var Endian = (function () {
        function Endian() {
        }
        Endian.LITTLE_ENDIAN = "littleEndian";
        Endian.BIG_ENDIAN = "bigEndian";
        return Endian;
    }());
    falcon.Endian = Endian;
    var ByteArray = (function () {
        function ByteArray(buffer, bufferExtSize) {
            if (bufferExtSize === void 0) { bufferExtSize = 0; }
            this.bufferExtSize = 0;
            this.EOF_byte = -1;
            this.EOF_code_point = -1;
            if (bufferExtSize < 0) {
                bufferExtSize = 0;
            }
            this.bufferExtSize = bufferExtSize;
            var bytes, wpos = 0;
            if (buffer) {
                var uint8 = void 0;
                if (buffer instanceof Uint8Array) {
                    uint8 = buffer;
                    wpos = buffer.length;
                }
                else {
                    wpos = buffer.byteLength;
                    uint8 = new Uint8Array(buffer);
                }
                if (bufferExtSize == 0) {
                    bytes = new Uint8Array(wpos);
                }
                else {
                    var multi = (wpos / bufferExtSize | 0) + 1;
                    bytes = new Uint8Array(multi * bufferExtSize);
                }
                bytes.set(uint8);
            }
            else {
                bytes = new Uint8Array(bufferExtSize);
            }
            this.write_position = wpos;
            this._position = 0;
            this._bytes = bytes;
            this.data = new DataView(bytes.buffer);
            this.endian = Endian.BIG_ENDIAN;
        }
        Object.defineProperty(ByteArray.prototype, "endian", {
            get: function () {
                return this.$endian == 0 ? Endian.LITTLE_ENDIAN : Endian.BIG_ENDIAN;
            },
            set: function (value) {
                this.$endian = value == Endian.LITTLE_ENDIAN ? 0 : 1;
            },
            enumerable: true,
            configurable: true
        });
        ByteArray.prototype.setArrayBuffer = function (buffer) {
        };
        Object.defineProperty(ByteArray.prototype, "readAvailable", {
            get: function () {
                return this.write_position - this._position;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ByteArray.prototype, "buffer", {
            get: function () {
                return this.data.buffer.slice(0, this.write_position);
            },
            set: function (value) {
                var wpos = value.byteLength;
                var uint8 = new Uint8Array(value);
                var bufferExtSize = this.bufferExtSize;
                var bytes;
                if (bufferExtSize == 0) {
                    bytes = new Uint8Array(wpos);
                }
                else {
                    var multi = (wpos / bufferExtSize | 0) + 1;
                    bytes = new Uint8Array(multi * bufferExtSize);
                }
                bytes.set(uint8);
                this.write_position = wpos;
                this._bytes = bytes;
                this.data = new DataView(bytes.buffer);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ByteArray.prototype, "rawBuffer", {
            get: function () {
                return this.data.buffer;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ByteArray.prototype, "bytes", {
            get: function () {
                return this._bytes;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ByteArray.prototype, "dataView", {
            get: function () {
                return this.data;
            },
            set: function (value) {
                this.buffer = value.buffer;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ByteArray.prototype, "bufferOffset", {
            get: function () {
                return this.data.byteOffset;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ByteArray.prototype, "position", {
            get: function () {
                return this._position;
            },
            set: function (value) {
                this._position = value;
                if (value > this.write_position) {
                    this.write_position = value;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(ByteArray.prototype, "length", {
            get: function () {
                return this.write_position;
            },
            set: function (value) {
                this.write_position = value;
                if (this.data.byteLength > value) {
                    this._position = value;
                }
                this._validateBuffer(value);
            },
            enumerable: true,
            configurable: true
        });
        ByteArray.prototype._validateBuffer = function (value) {
            if (this.data.byteLength < value) {
                var be = this.bufferExtSize;
                var tmp = void 0;
                if (be == 0) {
                    tmp = new Uint8Array(value);
                }
                else {
                    var nLen = ((value / be >> 0) + 1) * be;
                    tmp = new Uint8Array(nLen);
                }
                tmp.set(this._bytes);
                this._bytes = tmp;
                this.data = new DataView(tmp.buffer);
            }
        };
        Object.defineProperty(ByteArray.prototype, "bytesAvailable", {
            get: function () {
                return this.data.byteLength - this._position;
            },
            enumerable: true,
            configurable: true
        });
        ByteArray.prototype.clear = function () {
            var buffer = new ArrayBuffer(this.bufferExtSize);
            this.data = new DataView(buffer);
            this._bytes = new Uint8Array(buffer);
            this._position = 0;
            this.write_position = 0;
        };
        ByteArray.prototype.readBoolean = function () {
            if (this.validate(1))
                return !!this._bytes[this.position++];
        };
        ByteArray.prototype.readByte = function () {
            if (this.validate(1))
                return this.data.getInt8(this.position++);
        };
        ByteArray.prototype.readBytes = function (bytes, offset, length) {
            if (offset === void 0) { offset = 0; }
            if (length === void 0) { length = 0; }
            if (!bytes) {
                return;
            }
            var pos = this._position;
            var available = this.write_position - pos;
            if (available < 0) {
                return;
            }
            if (length == 0) {
                length = available;
            }
            else if (length > available) {
                return;
            }
            var position = bytes._position;
            bytes._position = 0;
            bytes.validateBuffer(offset + length);
            bytes._position = position;
            bytes._bytes.set(this._bytes.subarray(pos, pos + length), offset);
            this.position += length;
        };
        ByteArray.prototype.readDouble = function () {
            if (this.validate(8)) {
                var value = this.data.getFloat64(this._position, this.$endian == 0);
                this.position += 8;
                return value;
            }
        };
        ByteArray.prototype.readFloat = function () {
            if (this.validate(4)) {
                var value = this.data.getFloat32(this._position, this.$endian == 0);
                this.position += 4;
                return value;
            }
        };
        ByteArray.prototype.readInt = function () {
            if (this.validate(4)) {
                var value = this.data.getInt32(this._position, this.$endian == 0);
                this.position += 4;
                return value;
            }
        };
        ByteArray.prototype.readShort = function () {
            if (this.validate(2)) {
                var value = this.data.getInt16(this._position, this.$endian == 0);
                this.position += 2;
                return value;
            }
        };
        ByteArray.prototype.readUnsignedByte = function () {
            if (this.validate(1))
                return this._bytes[this.position++];
        };
        ByteArray.prototype.readUnsignedInt = function () {
            if (this.validate(4)) {
                var value = this.data.getUint32(this._position, this.$endian == 0);
                this.position += 4;
                return value;
            }
        };
        ByteArray.prototype.readUnsignedShort = function () {
            if (this.validate(2)) {
                var value = this.data.getUint16(this._position, this.$endian == 0);
                this.position += 2;
                return value;
            }
        };
        ByteArray.prototype.readUTF = function () {
            var length = this.readUnsignedShort();
            if (length > 0) {
                return this.readUTFBytes(length);
            }
            else {
                return "";
            }
        };
        ByteArray.prototype.readUTFBytes = function (length) {
            if (!this.validate(length)) {
                return;
            }
            var data = this.data;
            var bytes = new Uint8Array(data.buffer, data.byteOffset + this._position, length);
            this.position += length;
            return this.decodeUTF8(bytes);
        };
        ByteArray.prototype.writeBoolean = function (value) {
            this.validateBuffer(1);
            this._bytes[this.position++] = +value;
        };
        ByteArray.prototype.writeByte = function (value) {
            this.validateBuffer(1);
            this._bytes[this.position++] = value & 0xff;
        };
        ByteArray.prototype.writeBytes = function (bytes, offset, length) {
            if (offset === void 0) { offset = 0; }
            if (length === void 0) { length = 0; }
            var writeLength;
            if (offset < 0) {
                return;
            }
            if (length < 0) {
                return;
            }
            else if (length == 0) {
                writeLength = bytes.length - offset;
            }
            else {
                writeLength = Math.min(bytes.length - offset, length);
            }
            if (writeLength > 0) {
                this.validateBuffer(writeLength);
                this._bytes.set(bytes._bytes.subarray(offset, offset + writeLength), this._position);
                this.position = this._position + writeLength;
            }
        };
        ByteArray.prototype.writeDouble = function (value) {
            this.validateBuffer(8);
            this.data.setFloat64(this._position, value, this.$endian == 0);
            this.position += 8;
        };
        ByteArray.prototype.writeFloat = function (value) {
            this.validateBuffer(4);
            this.data.setFloat32(this._position, value, this.$endian == 0);
            this.position += 4;
        };
        ByteArray.prototype.writeInt = function (value) {
            this.validateBuffer(4);
            this.data.setInt32(this._position, value, this.$endian == 0);
            this.position += 4;
        };
        ByteArray.prototype.writeShort = function (value) {
            this.validateBuffer(2);
            this.data.setInt16(this._position, value, this.$endian == 0);
            this.position += 2;
        };
        ByteArray.prototype.writeUnsignedInt = function (value) {
            this.validateBuffer(4);
            this.data.setUint32(this._position, value, this.$endian == 0);
            this.position += 4;
        };
        ByteArray.prototype.writeUnsignedShort = function (value) {
            this.validateBuffer(2);
            this.data.setUint16(this._position, value, this.$endian == 0);
            this.position += 2;
        };
        ByteArray.prototype.writeUTF = function (value) {
            var utf8bytes = this.encodeUTF8(value);
            var length = utf8bytes.length;
            this.validateBuffer(2 + length);
            this.data.setUint16(this._position, length, this.$endian == 0);
            this.position += 2;
            this._writeUint8Array(utf8bytes, false);
        };
        ByteArray.prototype.writeUTFBytes = function (value) {
            this._writeUint8Array(this.encodeUTF8(value));
        };
        ByteArray.prototype.toString = function () {
            return "[ByteArray] length:" + this.length + ", bytesAvailable:" + this.bytesAvailable;
        };
        ByteArray.prototype._writeUint8Array = function (bytes, validateBuffer) {
            if (validateBuffer === void 0) { validateBuffer = true; }
            var pos = this._position;
            var npos = pos + bytes.length;
            if (validateBuffer) {
                this.validateBuffer(npos);
            }
            this.bytes.set(bytes, pos);
            this.position = npos;
        };
        ByteArray.prototype.validate = function (len) {
            var bl = this._bytes.length;
            if (bl > 0 && this._position + len <= bl) {
                return true;
            }
            else {
            }
        };
        ByteArray.prototype.validateBuffer = function (len) {
            this.write_position = len > this.write_position ? len : this.write_position;
            len += this._position;
            this._validateBuffer(len);
        };
        ByteArray.prototype.encodeUTF8 = function (str) {
            var pos = 0;
            var codePoints = this.stringToCodePoints(str);
            var outputBytes = [];
            while (codePoints.length > pos) {
                var code_point = codePoints[pos++];
                if (this.inRange(code_point, 0xD800, 0xDFFF)) {
                    this.encoderError(code_point);
                }
                else if (this.inRange(code_point, 0x0000, 0x007f)) {
                    outputBytes.push(code_point);
                }
                else {
                    var count = void 0, offset = void 0;
                    if (this.inRange(code_point, 0x0080, 0x07FF)) {
                        count = 1;
                        offset = 0xC0;
                    }
                    else if (this.inRange(code_point, 0x0800, 0xFFFF)) {
                        count = 2;
                        offset = 0xE0;
                    }
                    else if (this.inRange(code_point, 0x10000, 0x10FFFF)) {
                        count = 3;
                        offset = 0xF0;
                    }
                    outputBytes.push(this.div(code_point, Math.pow(64, count)) + offset);
                    while (count > 0) {
                        var temp = this.div(code_point, Math.pow(64, count - 1));
                        outputBytes.push(0x80 + (temp % 64));
                        count -= 1;
                    }
                }
            }
            return new Uint8Array(outputBytes);
        };
        ByteArray.prototype.decodeUTF8 = function (data) {
            var fatal = false;
            var pos = 0;
            var result = "";
            var code_point;
            var utf8_code_point = 0;
            var utf8_bytes_needed = 0;
            var utf8_bytes_seen = 0;
            var utf8_lower_boundary = 0;
            while (data.length > pos) {
                var _byte = data[pos++];
                if (_byte == this.EOF_byte) {
                    if (utf8_bytes_needed != 0) {
                        code_point = this.decoderError(fatal);
                    }
                    else {
                        code_point = this.EOF_code_point;
                    }
                }
                else {
                    if (utf8_bytes_needed == 0) {
                        if (this.inRange(_byte, 0x00, 0x7F)) {
                            code_point = _byte;
                        }
                        else {
                            if (this.inRange(_byte, 0xC2, 0xDF)) {
                                utf8_bytes_needed = 1;
                                utf8_lower_boundary = 0x80;
                                utf8_code_point = _byte - 0xC0;
                            }
                            else if (this.inRange(_byte, 0xE0, 0xEF)) {
                                utf8_bytes_needed = 2;
                                utf8_lower_boundary = 0x800;
                                utf8_code_point = _byte - 0xE0;
                            }
                            else if (this.inRange(_byte, 0xF0, 0xF4)) {
                                utf8_bytes_needed = 3;
                                utf8_lower_boundary = 0x10000;
                                utf8_code_point = _byte - 0xF0;
                            }
                            else {
                                this.decoderError(fatal);
                            }
                            utf8_code_point = utf8_code_point * Math.pow(64, utf8_bytes_needed);
                            code_point = null;
                        }
                    }
                    else if (!this.inRange(_byte, 0x80, 0xBF)) {
                        utf8_code_point = 0;
                        utf8_bytes_needed = 0;
                        utf8_bytes_seen = 0;
                        utf8_lower_boundary = 0;
                        pos--;
                        code_point = this.decoderError(fatal, _byte);
                    }
                    else {
                        utf8_bytes_seen += 1;
                        utf8_code_point = utf8_code_point + (_byte - 0x80) * Math.pow(64, utf8_bytes_needed - utf8_bytes_seen);
                        if (utf8_bytes_seen !== utf8_bytes_needed) {
                            code_point = null;
                        }
                        else {
                            var cp = utf8_code_point;
                            var lower_boundary = utf8_lower_boundary;
                            utf8_code_point = 0;
                            utf8_bytes_needed = 0;
                            utf8_bytes_seen = 0;
                            utf8_lower_boundary = 0;
                            if (this.inRange(cp, lower_boundary, 0x10FFFF) && !this.inRange(cp, 0xD800, 0xDFFF)) {
                                code_point = cp;
                            }
                            else {
                                code_point = this.decoderError(fatal, _byte);
                            }
                        }
                    }
                }
                if (code_point !== null && code_point !== this.EOF_code_point) {
                    if (code_point <= 0xFFFF) {
                        if (code_point > 0)
                            result += String.fromCharCode(code_point);
                    }
                    else {
                        code_point -= 0x10000;
                        result += String.fromCharCode(0xD800 + ((code_point >> 10) & 0x3ff));
                        result += String.fromCharCode(0xDC00 + (code_point & 0x3ff));
                    }
                }
            }
            return result;
        };
        ByteArray.prototype.encoderError = function (code_point) {
        };
        ByteArray.prototype.decoderError = function (fatal, opt_code_point) {
            if (fatal) {
            }
            return opt_code_point || 0xFFFD;
        };
        ByteArray.prototype.inRange = function (a, min, max) {
            return min <= a && a <= max;
        };
        ByteArray.prototype.div = function (n, d) {
            return Math.floor(n / d);
        };
        ByteArray.prototype.stringToCodePoints = function (string) {
            var cps = [];
            var i = 0, n = string.length;
            while (i < string.length) {
                var c = string.charCodeAt(i);
                if (!this.inRange(c, 0xD800, 0xDFFF)) {
                    cps.push(c);
                }
                else if (this.inRange(c, 0xDC00, 0xDFFF)) {
                    cps.push(0xFFFD);
                }
                else {
                    if (i == n - 1) {
                        cps.push(0xFFFD);
                    }
                    else {
                        var d = string.charCodeAt(i + 1);
                        if (this.inRange(d, 0xDC00, 0xDFFF)) {
                            var a = c & 0x3FF;
                            var b = d & 0x3FF;
                            i += 1;
                            cps.push(0x10000 + (a << 10) + b);
                        }
                        else {
                            cps.push(0xFFFD);
                        }
                    }
                }
                i += 1;
            }
            return cps;
        };
        return ByteArray;
    }());
    falcon.ByteArray = ByteArray;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    falcon.$hashCount = 1;
    var HashObject = (function () {
        function HashObject() {
            this.$hashCode = falcon.$hashCount++;
        }
        Object.defineProperty(HashObject.prototype, "hashCode", {
            get: function () {
                return this.$hashCode;
            },
            enumerable: true,
            configurable: true
        });
        return HashObject;
    }());
    falcon.HashObject = HashObject;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var StringUtil = (function () {
        function StringUtil() {
        }
        StringUtil.format = function (sfmt) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            if (args.length == 0) {
                return sfmt;
            }
            for (var i = 0; i < args.length; i++) {
                var sval = args[i];
                while (true) {
                    var result = null;
                    if (typeof (sval) === "number") {
                        result = sfmt.match(/(%d)|(%s)/);
                        if (result) {
                            sfmt = sfmt.replace(/(%d)|(%s)/, sval.toString());
                            break;
                        }
                    }
                    result = sfmt.match(/%s/);
                    if (result) {
                        sfmt = sfmt.replace(/%s/, sval);
                    }
                    else {
                        sfmt += "    " + sval;
                    }
                    break;
                }
            }
            ;
            return sfmt;
        };
        return StringUtil;
    }());
    falcon.StringUtil = StringUtil;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var Utils = (function () {
        function Utils() {
        }
        Utils.decodeURIComponent = function (str) {
            try {
                var decodeStr = decodeURIComponent(str ? str : "");
                return decodeStr;
            }
            catch (err) {
                return str;
            }
        };
        return Utils;
    }());
    falcon.Utils = Utils;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var ELOGLEVEL;
    (function (ELOGLEVEL) {
        ELOGLEVEL[ELOGLEVEL["CRITICAL"] = 50] = "CRITICAL";
        ELOGLEVEL[ELOGLEVEL["ERROR"] = 40] = "ERROR";
        ELOGLEVEL[ELOGLEVEL["WARNING"] = 30] = "WARNING";
        ELOGLEVEL[ELOGLEVEL["INFO"] = 20] = "INFO";
        ELOGLEVEL[ELOGLEVEL["DEBUG"] = 10] = "DEBUG";
        ELOGLEVEL[ELOGLEVEL["NOTSET"] = 0] = "NOTSET";
    })(ELOGLEVEL = falcon.ELOGLEVEL || (falcon.ELOGLEVEL = {}));
    var _Logger = (function () {
        function _Logger(stag) {
            this._tag = stag;
            this._handlers = [];
            this._loglevel = ELOGLEVEL.DEBUG;
        }
        _Logger.prototype.addHandler = function (objhandler) {
            this._handlers.push(objhandler);
        };
        _Logger.prototype.setLogLevel = function (nlv) {
            this._loglevel = nlv;
        };
        _Logger.prototype.notset = function (sfmt) {
            var sout = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                sout[_i - 1] = arguments[_i];
            }
            this.log.apply(this, [ELOGLEVEL.NOTSET, sfmt].concat(sout));
        };
        _Logger.prototype.info = function (sfmt) {
            var sout = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                sout[_i - 1] = arguments[_i];
            }
            this.log.apply(this, [ELOGLEVEL.INFO, sfmt].concat(sout));
        };
        _Logger.prototype.debug = function (sfmt) {
            var sout = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                sout[_i - 1] = arguments[_i];
            }
            this.log.apply(this, [ELOGLEVEL.DEBUG, sfmt].concat(sout));
        };
        _Logger.prototype.critical = function (sfmt) {
            var sout = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                sout[_i - 1] = arguments[_i];
            }
            this.log.apply(this, [ELOGLEVEL.CRITICAL, sfmt].concat(sout));
        };
        _Logger.prototype.error = function (sfmt) {
            var sout = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                sout[_i - 1] = arguments[_i];
            }
            this.log.apply(this, [ELOGLEVEL.ERROR, sfmt].concat(sout));
        };
        _Logger.prototype.warning = function (sfmt) {
            var sout = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                sout[_i - 1] = arguments[_i];
            }
            this.log.apply(this, [ELOGLEVEL.WARNING, sfmt].concat(sout));
        };
        _Logger.prototype.log = function (nlv, sfmt) {
            var sout = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                sout[_i - 2] = arguments[_i];
            }
            var self = this;
            this._handlers.forEach(function (objandler) {
                if (self._loglevel <= nlv) {
                    objandler.emit.apply(objandler, [nlv, sfmt].concat(sout));
                }
            });
        };
        return _Logger;
    }());
    falcon._Logger = _Logger;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var BaseHandler = (function () {
        function BaseHandler(startime, gettime) {
            this._fmtstr = "";
            this._startime = startime;
            if (startime) {
                this._gettime = typeof gettime == "function" ? gettime : Date.now;
                this._startime = this._gettime() ? 0 : startime;
            }
        }
        BaseHandler.prototype.setFmter = function (fmtstr) {
            this._fmtstr = fmtstr;
        };
        BaseHandler.prototype.emit = function (nlv, sfmt) {
            var sout = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                sout[_i - 2] = arguments[_i];
            }
        };
        BaseHandler.prototype.flush = function () { };
        BaseHandler.prototype.getString = function (nlv, sfmt) {
            if (this._startime) {
                sfmt =
                    falcon.StringUtil.format("[%d]", this._gettime() - this._startime) + sfmt;
            }
            sfmt = "%s[%s]%s".format(this._fmtstr, falcon.ELOGLEVEL[nlv], sfmt);
            return sfmt;
        };
        return BaseHandler;
    }());
    falcon.BaseHandler = BaseHandler;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var CONSOLE_KEY = {
        50: "error",
        40: "error",
        30: "warn",
        20: "info",
        10: "debug",
        0: "log"
    };
    var SysoutHandler = (function (_super) {
        __extends(SysoutHandler, _super);
        function SysoutHandler(startime, gettime) {
            var _this = _super.call(this, startime, gettime) || this;
            if (true) {
                _this._ofunc = _this.web_out;
            }
            return _this;
        }
        SysoutHandler.prototype.web_out = function (nlv, sfmt) {
            var sout = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                sout[_i - 2] = arguments[_i];
            }
            console[CONSOLE_KEY[nlv]].apply(console, [sfmt].concat(sout[0].slice(0)));
        };
        SysoutHandler.prototype.native_out = function (nlv) { };
        SysoutHandler.prototype.emit = function (nlv, sfmt) {
            var sout = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                sout[_i - 2] = arguments[_i];
            }
            var sffmt = this.getString(nlv, sfmt);
            this._ofunc(nlv, sffmt, sout);
        };
        return SysoutHandler;
    }(falcon.BaseHandler));
    falcon.SysoutHandler = SysoutHandler;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var Event_ = (function () {
        function Event_(name, listener, target, once) {
            this.name = name;
            this.listener = listener;
            this.target = target;
            this.once = once ? once : false;
        }
        return Event_;
    }());
    var EventDispatcher = (function () {
        function EventDispatcher() {
            this._flag = 0;
            this._eventMap = new Map();
        }
        EventDispatcher.prototype.on = function (eventname, listencb, target, once) {
            var eventMap = this._eventMap;
            if (typeof eventname == "number") {
                eventname = "MSG_" + eventname;
            }
            var name = eventname;
            var list = eventMap[name];
            if (!list) {
                list = eventMap[name] = [];
            }
            else if (this._flag !== 0) {
                eventMap[name] = list = list.concat();
            }
            this.insertEvent(list, name, listencb, target, once);
        };
        EventDispatcher.prototype.insertEvent = function (list, name, listener, target, once) {
            var length = list.length;
            for (var i = 0; i < length; i++) {
                var event_2 = list[i];
                if (event_2.listener == listener && event_2.target == target) {
                    return false;
                }
            }
            var event = new Event_(name, listener, target, once);
            list.push(event);
        };
        EventDispatcher.prototype.emit = function (eventname) {
            var _a;
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            if (typeof eventname == "number") {
                eventname = "MSG_" + eventname;
            }
            var eventMap = this._eventMap;
            var name = eventname;
            var list = eventMap[name];
            if (!list) {
                return true;
            }
            var length = list.length;
            if (length == 0) {
                return true;
            }
            var onceList = [];
            this._flag++;
            for (var i = 0; i < length; i++) {
                var event_3 = list[i];
                (_a = event_3.listener).call.apply(_a, [event_3.target].concat(args));
                if (event_3.once) {
                    onceList.push(event_3);
                }
            }
            this._flag--;
            while (onceList.length) {
                var event_4 = onceList.pop();
                this.removeEventListener(event_4.name, event_4.listener, event_4.target);
            }
        };
        EventDispatcher.prototype.removeEventListener = function (name, listener, target) {
            if (typeof name == "number") {
                name = "MSG_" + name;
            }
            var eventMap = this._eventMap;
            var list = eventMap[name];
            if (!list) {
                return;
            }
            if (this._flag !== 0) {
                eventMap[name] = list = list.concat();
            }
            this.removeEvent(list, listener, target);
            if (list.length == 0) {
                eventMap[name] = null;
            }
        };
        EventDispatcher.prototype.removeEventListeners = function (name) {
            if (typeof name == "number") {
                name = "MSG_" + name;
            }
            var eventMap = this._eventMap;
            var list = eventMap[name];
            if (!list) {
                return;
            }
            list.length = 0;
            eventMap.delete(name);
        };
        EventDispatcher.prototype.removeEvent = function (list, listener, target) {
            var length = list.length;
            for (var i = 0; i < length; i++) {
                var event_5 = list[i];
                if (event_5.listener == listener && event_5.target == target) {
                    list.splice(i, 1);
                    return true;
                }
            }
            return false;
        };
        EventDispatcher.prototype.once = function (eventname, listencb, target) {
            this.on(eventname, listencb, target, true);
        };
        EventDispatcher.prototype.dump = function () {
            var eventMap = this._eventMap;
            for (var name_1 in eventMap) {
                console.log(eventMap[name_1]);
            }
        };
        return EventDispatcher;
    }());
    falcon.EventDispatcher = EventDispatcher;
})(falcon || (falcon = {}));
var MD5 = (function () {
    function MD5() {
        this.hexcase = 0;
        this.b64pad = "";
    }
    MD5.prototype.hex_md5 = function (s) {
        return this.rstr2hex(this.rstr_md5(this.str2rstr_utf8(s)));
    };
    MD5.prototype.b64_md5 = function (s) {
        return this.rstr2b64(this.rstr_md5(this.str2rstr_utf8(s)));
    };
    MD5.prototype.any_md5 = function (s, e) {
        return this.rstr2any(this.rstr_md5(this.str2rstr_utf8(s)), e);
    };
    MD5.prototype.hex_hmac_md5 = function (k, d) {
        return this.rstr2hex(this.rstr_hmac_md5(this.str2rstr_utf8(k), this.str2rstr_utf8(d)));
    };
    MD5.prototype.b64_hmac_md5 = function (k, d) {
        return this.rstr2b64(this.rstr_hmac_md5(this.str2rstr_utf8(k), this.str2rstr_utf8(d)));
    };
    MD5.prototype.any_hmac_md5 = function (k, d, e) {
        return this.rstr2any(this.rstr_hmac_md5(this.str2rstr_utf8(k), this.str2rstr_utf8(d)), e);
    };
    MD5.prototype.md5_vm_test = function () {
        return (this.hex_md5("abc").toLowerCase() == "900150983cd24fb0d6963f7d28e17f72");
    };
    MD5.prototype.rstr_md5 = function (s) {
        return this.binl2rstr(this.binl_md5(this.rstr2binl(s), s.length * 8));
    };
    MD5.prototype.rstr_hmac_md5 = function (key, data) {
        var bkey = this.rstr2binl(key);
        if (bkey.length > 16)
            bkey = this.binl_md5(bkey, key.length * 8);
        var ipad = Array(16), opad = Array(16);
        for (var i = 0; i < 16; i++) {
            ipad[i] = bkey[i] ^ 0x36363636;
            opad[i] = bkey[i] ^ 0x5c5c5c5c;
        }
        var hash = this.binl_md5(ipad.concat(this.rstr2binl(data)), 512 + data.length * 8);
        return this.binl2rstr(this.binl_md5(opad.concat(hash), 512 + 128));
    };
    MD5.prototype.rstr2hex = function (input) {
        try {
            this.hexcase;
        }
        catch (e) {
            this.hexcase = 0;
        }
        var hex_tab = this.hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
        var output = "";
        var x;
        for (var i = 0; i < input.length; i++) {
            x = input.charCodeAt(i);
            output += hex_tab.charAt((x >>> 4) & 0x0f) + hex_tab.charAt(x & 0x0f);
        }
        return output;
    };
    MD5.prototype.rstr2b64 = function (input) {
        try {
            this.b64pad;
        }
        catch (e) {
            this.b64pad = "";
        }
        var tab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        var output = "";
        var len = input.length;
        for (var i = 0; i < len; i += 3) {
            var triplet = (input.charCodeAt(i) << 16) |
                (i + 1 < len ? input.charCodeAt(i + 1) << 8 : 0) |
                (i + 2 < len ? input.charCodeAt(i + 2) : 0);
            for (var j = 0; j < 4; j++) {
                if (i * 8 + j * 6 > input.length * 8)
                    output += this.b64pad;
                else
                    output += tab.charAt((triplet >>> (6 * (3 - j))) & 0x3f);
            }
        }
        return output;
    };
    MD5.prototype.rstr2any = function (input, encoding) {
        var divisor = encoding.length;
        var i, j, q, x, quotient;
        var dividend = Array(Math.ceil(input.length / 2));
        for (i = 0; i < dividend.length; i++) {
            dividend[i] =
                (input.charCodeAt(i * 2) << 8) | input.charCodeAt(i * 2 + 1);
        }
        var full_length = Math.ceil((input.length * 8) / (Math.log(encoding.length) / Math.log(2)));
        var remainders = Array(full_length);
        for (j = 0; j < full_length; j++) {
            quotient = Array();
            x = 0;
            for (i = 0; i < dividend.length; i++) {
                x = (x << 16) + dividend[i];
                q = Math.floor(x / divisor);
                x -= q * divisor;
                if (quotient.length > 0 || q > 0)
                    quotient[quotient.length] = q;
            }
            remainders[j] = x;
            dividend = quotient;
        }
        var output = "";
        for (i = remainders.length - 1; i >= 0; i--)
            output += encoding.charAt(remainders[i]);
        return output;
    };
    MD5.prototype.str2rstr_utf8 = function (input) {
        var output = "";
        var i = -1;
        var x, y;
        while (++i < input.length) {
            x = input.charCodeAt(i);
            y = i + 1 < input.length ? input.charCodeAt(i + 1) : 0;
            if (0xd800 <= x && x <= 0xdbff && 0xdc00 <= y && y <= 0xdfff) {
                x = 0x10000 + ((x & 0x03ff) << 10) + (y & 0x03ff);
                i++;
            }
            if (x <= 0x7f)
                output += String.fromCharCode(x);
            else if (x <= 0x7ff)
                output += String.fromCharCode(0xc0 | ((x >>> 6) & 0x1f), 0x80 | (x & 0x3f));
            else if (x <= 0xffff)
                output += String.fromCharCode(0xe0 | ((x >>> 12) & 0x0f), 0x80 | ((x >>> 6) & 0x3f), 0x80 | (x & 0x3f));
            else if (x <= 0x1fffff)
                output += String.fromCharCode(0xf0 | ((x >>> 18) & 0x07), 0x80 | ((x >>> 12) & 0x3f), 0x80 | ((x >>> 6) & 0x3f), 0x80 | (x & 0x3f));
        }
        return output;
    };
    MD5.prototype.str2rstr_utf16le = function (input) {
        var output = "";
        for (var i = 0; i < input.length; i++)
            output += String.fromCharCode(input.charCodeAt(i) & 0xff, (input.charCodeAt(i) >>> 8) & 0xff);
        return output;
    };
    MD5.prototype.str2rstr_utf16be = function (input) {
        var output = "";
        for (var i = 0; i < input.length; i++)
            output += String.fromCharCode((input.charCodeAt(i) >>> 8) & 0xff, input.charCodeAt(i) & 0xff);
        return output;
    };
    MD5.prototype.rstr2binl = function (input) {
        var output = Array(input.length >> 2);
        for (var i = 0; i < output.length; i++)
            output[i] = 0;
        for (var i = 0; i < input.length * 8; i += 8)
            output[i >> 5] |= (input.charCodeAt(i / 8) & 0xff) << i % 32;
        return output;
    };
    MD5.prototype.binl2rstr = function (input) {
        var output = "";
        for (var i = 0; i < input.length * 32; i += 8)
            output += String.fromCharCode((input[i >> 5] >>> i % 32) & 0xff);
        return output;
    };
    MD5.prototype.binl_md5 = function (x, len) {
        x[len >> 5] |= 0x80 << len % 32;
        x[(((len + 64) >>> 9) << 4) + 14] = len;
        var a = 1732584193;
        var b = -271733879;
        var c = -1732584194;
        var d = 271733878;
        for (var i = 0; i < x.length; i += 16) {
            var olda = a;
            var oldb = b;
            var oldc = c;
            var oldd = d;
            a = this.md5_ff(a, b, c, d, x[i + 0], 7, -680876936);
            d = this.md5_ff(d, a, b, c, x[i + 1], 12, -389564586);
            c = this.md5_ff(c, d, a, b, x[i + 2], 17, 606105819);
            b = this.md5_ff(b, c, d, a, x[i + 3], 22, -1044525330);
            a = this.md5_ff(a, b, c, d, x[i + 4], 7, -176418897);
            d = this.md5_ff(d, a, b, c, x[i + 5], 12, 1200080426);
            c = this.md5_ff(c, d, a, b, x[i + 6], 17, -1473231341);
            b = this.md5_ff(b, c, d, a, x[i + 7], 22, -45705983);
            a = this.md5_ff(a, b, c, d, x[i + 8], 7, 1770035416);
            d = this.md5_ff(d, a, b, c, x[i + 9], 12, -1958414417);
            c = this.md5_ff(c, d, a, b, x[i + 10], 17, -42063);
            b = this.md5_ff(b, c, d, a, x[i + 11], 22, -1990404162);
            a = this.md5_ff(a, b, c, d, x[i + 12], 7, 1804603682);
            d = this.md5_ff(d, a, b, c, x[i + 13], 12, -40341101);
            c = this.md5_ff(c, d, a, b, x[i + 14], 17, -1502002290);
            b = this.md5_ff(b, c, d, a, x[i + 15], 22, 1236535329);
            a = this.md5_gg(a, b, c, d, x[i + 1], 5, -165796510);
            d = this.md5_gg(d, a, b, c, x[i + 6], 9, -1069501632);
            c = this.md5_gg(c, d, a, b, x[i + 11], 14, 643717713);
            b = this.md5_gg(b, c, d, a, x[i + 0], 20, -373897302);
            a = this.md5_gg(a, b, c, d, x[i + 5], 5, -701558691);
            d = this.md5_gg(d, a, b, c, x[i + 10], 9, 38016083);
            c = this.md5_gg(c, d, a, b, x[i + 15], 14, -660478335);
            b = this.md5_gg(b, c, d, a, x[i + 4], 20, -405537848);
            a = this.md5_gg(a, b, c, d, x[i + 9], 5, 568446438);
            d = this.md5_gg(d, a, b, c, x[i + 14], 9, -1019803690);
            c = this.md5_gg(c, d, a, b, x[i + 3], 14, -187363961);
            b = this.md5_gg(b, c, d, a, x[i + 8], 20, 1163531501);
            a = this.md5_gg(a, b, c, d, x[i + 13], 5, -1444681467);
            d = this.md5_gg(d, a, b, c, x[i + 2], 9, -51403784);
            c = this.md5_gg(c, d, a, b, x[i + 7], 14, 1735328473);
            b = this.md5_gg(b, c, d, a, x[i + 12], 20, -1926607734);
            a = this.md5_hh(a, b, c, d, x[i + 5], 4, -378558);
            d = this.md5_hh(d, a, b, c, x[i + 8], 11, -2022574463);
            c = this.md5_hh(c, d, a, b, x[i + 11], 16, 1839030562);
            b = this.md5_hh(b, c, d, a, x[i + 14], 23, -35309556);
            a = this.md5_hh(a, b, c, d, x[i + 1], 4, -1530992060);
            d = this.md5_hh(d, a, b, c, x[i + 4], 11, 1272893353);
            c = this.md5_hh(c, d, a, b, x[i + 7], 16, -155497632);
            b = this.md5_hh(b, c, d, a, x[i + 10], 23, -1094730640);
            a = this.md5_hh(a, b, c, d, x[i + 13], 4, 681279174);
            d = this.md5_hh(d, a, b, c, x[i + 0], 11, -358537222);
            c = this.md5_hh(c, d, a, b, x[i + 3], 16, -722521979);
            b = this.md5_hh(b, c, d, a, x[i + 6], 23, 76029189);
            a = this.md5_hh(a, b, c, d, x[i + 9], 4, -640364487);
            d = this.md5_hh(d, a, b, c, x[i + 12], 11, -421815835);
            c = this.md5_hh(c, d, a, b, x[i + 15], 16, 530742520);
            b = this.md5_hh(b, c, d, a, x[i + 2], 23, -995338651);
            a = this.md5_ii(a, b, c, d, x[i + 0], 6, -198630844);
            d = this.md5_ii(d, a, b, c, x[i + 7], 10, 1126891415);
            c = this.md5_ii(c, d, a, b, x[i + 14], 15, -1416354905);
            b = this.md5_ii(b, c, d, a, x[i + 5], 21, -57434055);
            a = this.md5_ii(a, b, c, d, x[i + 12], 6, 1700485571);
            d = this.md5_ii(d, a, b, c, x[i + 3], 10, -1894986606);
            c = this.md5_ii(c, d, a, b, x[i + 10], 15, -1051523);
            b = this.md5_ii(b, c, d, a, x[i + 1], 21, -2054922799);
            a = this.md5_ii(a, b, c, d, x[i + 8], 6, 1873313359);
            d = this.md5_ii(d, a, b, c, x[i + 15], 10, -30611744);
            c = this.md5_ii(c, d, a, b, x[i + 6], 15, -1560198380);
            b = this.md5_ii(b, c, d, a, x[i + 13], 21, 1309151649);
            a = this.md5_ii(a, b, c, d, x[i + 4], 6, -145523070);
            d = this.md5_ii(d, a, b, c, x[i + 11], 10, -1120210379);
            c = this.md5_ii(c, d, a, b, x[i + 2], 15, 718787259);
            b = this.md5_ii(b, c, d, a, x[i + 9], 21, -343485551);
            a = this.safe_add(a, olda);
            b = this.safe_add(b, oldb);
            c = this.safe_add(c, oldc);
            d = this.safe_add(d, oldd);
        }
        return [a, b, c, d];
    };
    MD5.prototype.md5_cmn = function (q, a, b, x, s, t) {
        return this.safe_add(this.bit_rol(this.safe_add(this.safe_add(a, q), this.safe_add(x, t)), s), b);
    };
    MD5.prototype.md5_ff = function (a, b, c, d, x, s, t) {
        return this.md5_cmn((b & c) | (~b & d), a, b, x, s, t);
    };
    MD5.prototype.md5_gg = function (a, b, c, d, x, s, t) {
        return this.md5_cmn((b & d) | (c & ~d), a, b, x, s, t);
    };
    MD5.prototype.md5_hh = function (a, b, c, d, x, s, t) {
        return this.md5_cmn(b ^ c ^ d, a, b, x, s, t);
    };
    MD5.prototype.md5_ii = function (a, b, c, d, x, s, t) {
        return this.md5_cmn(c ^ (b | ~d), a, b, x, s, t);
    };
    MD5.prototype.safe_add = function (x, y) {
        var lsw = (x & 0xffff) + (y & 0xffff);
        var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
        return (msw << 16) | (lsw & 0xffff);
    };
    MD5.prototype.bit_rol = function (num, cnt) {
        return (num << cnt) | (num >>> (32 - cnt));
    };
    return MD5;
}());
var massagepack;
(function (massagepack) {
    var Extended = (function () {
        function Extended(type, data) {
            if (type < -256 || type > 255) {
                throw RangeError("mpack: invalid extended type [" + type + "]");
            }
            this.type = type;
            this.data = data;
        }
        return Extended;
    }());
    massagepack.Extended = Extended;
    var Decoder = (function () {
        function Decoder(buffer) {
            this.NIL = 0xc0;
            this.FALSE = 0xc2;
            this.TRUE = 0xc3;
            this.BIN8 = 0xc4;
            this.BIN16 = 0xc5;
            this.BIN32 = 0xc6;
            this.EXT8 = 0xc7;
            this.EXT16 = 0xc8;
            this.EXT32 = 0xc9;
            this.FLOAT32 = 0xca;
            this.FLOAT64 = 0xcb;
            this.UINT8 = 0xcc;
            this.UINT16 = 0xcd;
            this.UINT32 = 0xce;
            this.UINT64 = 0xcf;
            this.INT8 = 0xd0;
            this.INT16 = 0xd1;
            this.INT32 = 0xd2;
            this.INT64 = 0xd3;
            this.FIXEXT1 = 0xd4;
            this.FIXEXT2 = 0xd5;
            this.FIXEXT4 = 0xd6;
            this.FIXEXT8 = 0xd7;
            this.FIXEXT16 = 0xd8;
            this.STR8 = 0xd9;
            this.STR16 = 0xda;
            this.STR32 = 0xdb;
            this.ARRAY16 = 0xdc;
            this.ARRAY32 = 0xdd;
            this.MAP16 = 0xde;
            this.MAP32 = 0xdf;
            this.FIXARRAY = 0x90;
            this.FIXSTR = 0xa0;
            this.FIXMAP = 0x80;
            this.POSITIVE_FIXNUM = 0x00;
            this.NEGATIVE_FIXNUM = 0xe0;
            if (buffer instanceof ArrayBuffer) {
                this.buffer = buffer;
                this.offset = 0;
                this.view = new DataView(this.buffer);
            }
            else {
                this.buffer = buffer.buffer;
                this.offset = 0;
                this.view = new DataView(buffer.buffer, buffer.byteOffset, buffer.byteLength);
            }
        }
        Decoder.toArrayBuffer = function (buf) {
            var ab = new ArrayBuffer(buf.length);
            var view = new Uint8Array(ab);
            for (var i = 0; i < buf.length; ++i) {
                view[i] = buf[i];
            }
            return ab;
        };
        Decoder.prototype.decode = function () {
            var offset = this.offset;
            try {
                return this.decodeObject(this);
            }
            catch (e) {
                this.offset = offset;
                if (!(e instanceof RangeError)) {
                    throw e;
                }
            }
        };
        Decoder.prototype.decodeUTF8 = function (s) {
            return massagepack.utf8.decode(s);
        };
        Decoder.prototype.decodeStringOfLength = function (self, length) {
            var off = self.offset;
            var buf = undefined;
            var str = undefined;
            var i = undefined;
            var n = undefined;
            self.offset += length;
            buf = new Uint8Array(self.view.buffer, self.view.byteOffset + off, length);
            str = "";
            for (i = 0, n = buf.byteLength; i !== n; ++i) {
                str += String.fromCharCode(buf[i]);
            }
            return this.decodeUTF8(str);
        };
        Decoder.prototype.decodeFixstr = function (self, tag) {
            return this.decodeStringOfLength(self, tag & ~this.FIXSTR);
        };
        Decoder.prototype.decodeStr8 = function (self) {
            return this.decodeStringOfLength(self, this.decodeUint8(self));
        };
        Decoder.prototype.decodeStr16 = function (self) {
            return this.decodeStringOfLength(self, this.decodeUint16(self));
        };
        Decoder.prototype.decodeStr32 = function (self) {
            return this.decodeStringOfLength(self, this.decodeUint32(self));
        };
        Decoder.prototype.decodeBin8 = function (self) {
            var length = this.decodeUint8(self);
            var offset = self.offset;
            self.offset += length;
            return new Uint8Array(self.view.buffer, self.view.byteOffset + offset, length);
        };
        Decoder.prototype.decodeBin16 = function (self) {
            var length = this.decodeUint16(self);
            var offset = self.offset;
            self.offset += length;
            return new Uint8Array(self.view.buffer, self.view.byteOffset + offset, length);
        };
        Decoder.prototype.decodeBin32 = function (self) {
            var length = this.decodeUint32(self);
            var offset = self.offset;
            self.offset += length;
            return new Uint8Array(self.view.buffer, self.view.byteOffset + offset, length);
        };
        Decoder.prototype.decodePositiveFixnum = function (self, tag) {
            return tag;
        };
        Decoder.prototype.decodeNegativeFixnum = function (self, tag) {
            return self.view.getInt8(self.offset - 1);
        };
        Decoder.prototype.decodeUint8 = function (self) {
            var value = self.view.getUint8(self.offset);
            self.offset += 1;
            return value;
        };
        Decoder.prototype.decodeUint16 = function (self) {
            var value = self.view.getUint16(self.offset);
            self.offset += 2;
            return value;
        };
        Decoder.prototype.decodeUint32 = function (self) {
            var value = self.view.getUint32(self.offset);
            self.offset += 4;
            return value;
        };
        Decoder.prototype.decodeUint64 = function (self) {
            throw new TypeError("mpack: javascript doesn't support 64 bits integer");
        };
        Decoder.prototype.decodeInt8 = function (self) {
            var value = self.view.getInt8(self.offset);
            self.offset += 1;
            return value;
        };
        Decoder.prototype.decodeInt16 = function (self) {
            var value = self.view.getInt16(self.offset);
            self.offset += 2;
            return value;
        };
        Decoder.prototype.decodeInt32 = function (self) {
            var value = self.view.getInt32(self.offset);
            self.offset += 4;
            return value;
        };
        Decoder.prototype.decodeInt64 = function (self) {
            throw new TypeError("mpack: javascript doesn't support 64 bits integer");
        };
        Decoder.prototype.decodeFloat32 = function (self) {
            var value = self.view.getFloat32(self.offset);
            self.offset += 4;
            return value;
        };
        Decoder.prototype.decodeFloat64 = function (self) {
            var value = self.view.getFloat64(self.offset);
            self.offset += 8;
            return value;
        };
        Decoder.prototype.decodeArrayOfLength = function (self, length) {
            var array = new Array(length);
            var index = undefined;
            for (index = 0; index !== length; ++index) {
                array[index] = this.decodeObject(self);
            }
            return array;
        };
        Decoder.prototype.decodeFixarray = function (self, tag) {
            return this.decodeArrayOfLength(self, tag & ~this.FIXARRAY);
        };
        Decoder.prototype.decodeArray16 = function (self) {
            return this.decodeArrayOfLength(self, this.decodeUint16(self));
        };
        Decoder.prototype.decodeArray32 = function (self) {
            return this.decodeArrayOfLength(self, this.decodeUint32(self));
        };
        Decoder.prototype.decodeMapOfLength = function (self, length) {
            var map = {};
            var key = undefined;
            var val = undefined;
            var index = undefined;
            for (index = 0; index !== length; ++index) {
                key = this.decodeObject(self);
                val = this.decodeObject(self);
                map[key] = val;
            }
            return map;
        };
        Decoder.prototype.decodeFixmap = function (self, tag) {
            return this.decodeMapOfLength(self, tag & ~this.FIXMAP);
        };
        Decoder.prototype.decodeMap16 = function (self) {
            return this.decodeMapOfLength(self, this.decodeUint16(self));
        };
        Decoder.prototype.decodeMap32 = function (self) {
            return this.decodeMapOfLength(self, this.decodeUint32(self));
        };
        Decoder.prototype.decodeExtendedOfLength = function (self, length) {
            var type = this.decodeUint8(self);
            var offset = self.offset;
            self.offset += length;
            return new Extended(type, new Uint8Array(self.view.buffer, self.view.byteOffset + offset, length));
        };
        Decoder.prototype.decodeFixext1 = function (self) {
            return this.decodeExtendedOfLength(self, 1);
        };
        Decoder.prototype.decodeFixext2 = function (self) {
            return this.decodeExtendedOfLength(self, 2);
        };
        Decoder.prototype.decodeFixext4 = function (self) {
            return this.decodeExtendedOfLength(self, 4);
        };
        Decoder.prototype.decodeFixext8 = function (self) {
            return this.decodeExtendedOfLength(self, 8);
        };
        Decoder.prototype.decodeFixext16 = function (self) {
            return this.decodeExtendedOfLength(self, 16);
        };
        Decoder.prototype.decodeExt8 = function (self) {
            return this.decodeExtendedOfLength(self, this.decodeUint8(self));
        };
        Decoder.prototype.decodeExt16 = function (self) {
            return this.decodeExtendedOfLength(self, this.decodeUint16(self));
        };
        Decoder.prototype.decodeExt32 = function (self) {
            return this.decodeExtendedOfLength(self, this.decodeUint32(self));
        };
        Decoder.prototype.decodeObject = function (self) {
            var tag = this.decodeUint8(self);
            if ((tag & 0x80) === this.POSITIVE_FIXNUM) {
                return this.decodePositiveFixnum(self, tag);
            }
            if ((tag & 0xe0) === this.NEGATIVE_FIXNUM) {
                return this.decodeNegativeFixnum(self, tag);
            }
            if ((tag & 0xe0) === this.FIXSTR) {
                return this.decodeFixstr(self, tag);
            }
            if ((tag & 0xf0) === this.FIXARRAY) {
                return this.decodeFixarray(self, tag);
            }
            if ((tag & 0xf0) === this.FIXMAP) {
                return this.decodeFixmap(self, tag);
            }
            switch (tag) {
                case this.NIL:
                    return null;
                case this.FALSE:
                    return false;
                case this.TRUE:
                    return true;
                case this.STR8:
                    return this.decodeStr8(self);
                case this.STR16:
                    return this.decodeStr16(self);
                case this.STR32:
                    return this.decodeStr32(self);
                case this.BIN8:
                    return this.decodeBin8(self);
                case this.BIN16:
                    return this.decodeBin16(self);
                case this.BIN32:
                    return this.decodeBin32(self);
                case this.INT8:
                    return this.decodeInt8(self);
                case this.INT16:
                    return this.decodeInt16(self);
                case this.INT32:
                    return this.decodeInt32(self);
                case this.INT64:
                    return this.decodeInt64(self);
                case this.UINT8:
                    return this.decodeUint8(self);
                case this.UINT16:
                    return this.decodeUint16(self);
                case this.UINT32:
                    return this.decodeUint32(self);
                case this.UINT64:
                    return this.decodeUint64(self);
                case this.FLOAT32:
                    return this.decodeFloat32(self);
                case this.FLOAT64:
                    return this.decodeFloat64(self);
                case this.ARRAY16:
                    return this.decodeArray16(self);
                case this.ARRAY32:
                    return this.decodeArray32(self);
                case this.MAP16:
                    return this.decodeMap16(self);
                case this.MAP32:
                    return this.decodeMap32(self);
                case this.FIXEXT1:
                    return this.decodeFixext1(self);
                case this.FIXEXT2:
                    return this.decodeFixext2(self);
                case this.FIXEXT4:
                    return this.decodeFixext4(self);
                case this.FIXEXT8:
                    return this.decodeFixext8(self);
                case this.FIXEXT16:
                    return this.decodeFixext16(self);
                case this.EXT8:
                    return this.decodeExt8(self);
                case this.EXT16:
                    return this.decodeExt16(self);
                case this.EXT32:
                    return this.decodeExt32(self);
                default:
                    throw new TypeError("mpack: decoder found an unknown tag: " + tag);
            }
        };
        return Decoder;
    }());
    massagepack.Decoder = Decoder;
})(massagepack || (massagepack = {}));
var massagepack;
(function (massagepack) {
    var utf8 = (function () {
        function utf8() {
        }
        utf8.encode = function (string) {
            return this.utf8encode(string);
        };
        utf8.decode = function (string) {
            return this.utf8decode(string);
        };
        utf8.ucs2decode = function (string) {
            var output = [];
            var counter = 0;
            var length = string.length;
            var value;
            var extra;
            while (counter < length) {
                value = string.charCodeAt(counter++);
                if (value >= 0xd800 && value <= 0xdbff && counter < length) {
                    extra = string.charCodeAt(counter++);
                    if ((extra & 0xfc00) == 0xdc00) {
                        output.push(((value & 0x3ff) << 10) + (extra & 0x3ff) + 0x10000);
                    }
                    else {
                        output.push(value);
                        counter--;
                    }
                }
                else {
                    output.push(value);
                }
            }
            return output;
        };
        utf8.ucs2encode = function (array) {
            var length = array.length;
            var index = -1;
            var value;
            var output = "";
            while (++index < length) {
                value = array[index];
                if (value > 0xffff) {
                    value -= 0x10000;
                    output += this.stringFromCharCode(((value >>> 10) & 0x3ff) | 0xd800);
                    value = 0xdc00 | (value & 0x3ff);
                }
                output += this.stringFromCharCode(value);
            }
            return output;
        };
        utf8.checkScalarValue = function (codePoint) {
            if (codePoint >= 0xd800 && codePoint <= 0xdfff) {
            }
        };
        utf8.createByte = function (codePoint, shift) {
            return this.stringFromCharCode(((codePoint >> shift) & 0x3f) | 0x80);
        };
        utf8.encodeCodePoint = function (codePoint) {
            if ((codePoint & 0xffffff80) == 0) {
                return this.stringFromCharCode(codePoint);
            }
            var symbol = "";
            if ((codePoint & 0xfffff800) == 0) {
                symbol = this.stringFromCharCode(((codePoint >> 6) & 0x1f) | 0xc0);
            }
            else if ((codePoint & 0xffff0000) == 0) {
                this.checkScalarValue(codePoint);
                symbol = this.stringFromCharCode(((codePoint >> 12) & 0x0f) | 0xe0);
                symbol += this.createByte(codePoint, 6);
            }
            else if ((codePoint & 0xffe00000) == 0) {
                symbol = this.stringFromCharCode(((codePoint >> 18) & 0x07) | 0xf0);
                symbol += this.createByte(codePoint, 12);
                symbol += this.createByte(codePoint, 6);
            }
            symbol += this.stringFromCharCode((codePoint & 0x3f) | 0x80);
            return symbol;
        };
        utf8.utf8encode = function (string) {
            var codePoints = this.ucs2decode(string);
            var length = codePoints.length;
            var index = -1;
            var codePoint;
            var byteString = "";
            while (++index < length) {
                codePoint = codePoints[index];
                byteString += this.encodeCodePoint(codePoint);
            }
            return byteString;
        };
        utf8.readContinuationByte = function () {
            if (this.byteIndex >= this.byteCount) {
            }
            var continuationByte = this.byteArray[this.byteIndex] & 0xff;
            this.byteIndex++;
            if ((continuationByte & 0xc0) == 0x80) {
                return continuationByte & 0x3f;
            }
            return continuationByte;
        };
        utf8.decodeSymbol = function () {
            var byte1;
            var byte2;
            var byte3;
            var byte4;
            var codePoint;
            if (this.byteIndex > this.byteCount) {
                return "";
            }
            if (this.byteIndex == this.byteCount) {
                return false;
            }
            byte1 = this.byteArray[this.byteIndex] & 0xff;
            this.byteIndex++;
            if ((byte1 & 0x80) == 0) {
                return byte1;
            }
            if ((byte1 & 0xe0) == 0xc0) {
                byte2 = this.readContinuationByte();
                codePoint = ((byte1 & 0x1f) << 6) | byte2;
                if (codePoint >= 0x80) {
                    return codePoint;
                }
                else {
                    return codePoint;
                }
            }
            if ((byte1 & 0xf0) == 0xe0) {
                byte2 = this.readContinuationByte();
                byte3 = this.readContinuationByte();
                codePoint = ((byte1 & 0x0f) << 12) | (byte2 << 6) | byte3;
                if (codePoint >= 0x0800) {
                    this.checkScalarValue(codePoint);
                    return codePoint;
                }
                else {
                    return codePoint;
                }
            }
            if ((byte1 & 0xf8) == 0xf0) {
                byte2 = this.readContinuationByte();
                byte3 = this.readContinuationByte();
                byte4 = this.readContinuationByte();
                codePoint =
                    ((byte1 & 0x07) << 0x12) | (byte2 << 0x0c) | (byte3 << 0x06) | byte4;
                if (codePoint >= 0x010000 && codePoint <= 0x10ffff) {
                    return codePoint;
                }
            }
            return "";
        };
        utf8.utf8decode = function (byteString) {
            this.byteArray = this.ucs2decode(byteString);
            this.byteCount = this.byteArray.length;
            this.byteIndex = 0;
            var codePoints = [];
            var tmp;
            while ((tmp = this.decodeSymbol()) !== false) {
                codePoints.push(tmp);
            }
            return this.ucs2encode(codePoints);
        };
        utf8.stringFromCharCode = String.fromCharCode;
        return utf8;
    }());
    massagepack.utf8 = utf8;
})(massagepack || (massagepack = {}));
var falcon;
(function (falcon) {
    var HttpMethod;
    (function (HttpMethod) {
        HttpMethod["GET"] = "GET";
        HttpMethod["POST"] = "POST";
    })(HttpMethod = falcon.HttpMethod || (falcon.HttpMethod = {}));
    var HttpResponseType;
    (function (HttpResponseType) {
        HttpResponseType["TEXT"] = "text";
        HttpResponseType["ARRAY_BUFFER"] = "arraybuffer";
        HttpResponseType["DOCUMENT"] = "document";
        HttpResponseType["JSON"] = "json";
    })(HttpResponseType = falcon.HttpResponseType || (falcon.HttpResponseType = {}));
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var H5HttpReq = (function () {
        function H5HttpReq() {
            this._url = "";
            this._xhr = this.getXHR();
        }
        H5HttpReq.prototype.open = function (url, listener, method) {
            var _this = this;
            if (method === void 0) { method = falcon.HttpMethod.GET; }
            this._url = url;
            this._method = method;
            this._listener = listener || function () { };
            this._xhr.onreadystatechange = function () {
                _this._listener(_this.response, _this._xhr);
            };
            this._xhr.open(this._method, this._url, true);
        };
        H5HttpReq.prototype.send = function (data) {
            if (this._responseType != null) {
                this._xhr.responseType = this._responseType;
            }
            if (this._withCredentials != null) {
                this._xhr.withCredentials = this._withCredentials;
            }
            if (this.headerObj) {
                for (var key in this.headerObj) {
                    this._xhr.setRequestHeader(key, this.headerObj[key]);
                }
            }
            this._xhr.send(data);
        };
        H5HttpReq.prototype.abort = function () {
            if (this._xhr) {
                this._xhr.abort();
            }
        };
        H5HttpReq.prototype.getRefreshTokenHeader = function (accessToken, url) {
            var headObject = JSON.parse(JSON.stringify(this.headerObj));
            var timestamp = Math.floor(Date.now() / 1000);
            headObject["X-QP-Token"] = accessToken;
            headObject["X-QP-Nonce"] = timestamp.toString();
            headObject["X-QP-Timestamp"] = timestamp;
            var headcont = {
                "X-QP-AppId": falcon.configMgr.getConfig().appid,
                "X-QP-Nonce": timestamp.toString(),
                "X-QP-Timestamp": timestamp
            };
            var sign = falcon.XhrHttp.getUcHash(headcont, this._method, this._url);
            headObject["X-QP-Signature"] = sign;
            return headObject;
        };
        H5HttpReq.prototype.resend = function (accessToken, url, listener) {
            var _this = this;
            this._listener = listener || function () { };
            if (this._xhr) {
                this._xhr.abort();
                this._xhr = null;
            }
            this._xhr = this.getXHR();
            this._xhr.onreadystatechange = function () {
                _this._listener(_this.response, _this._xhr);
            };
            if (accessToken) {
                var timestamp = Math.floor(Date.now() / 1000);
                this.headerObj["X-QP-Token"] = accessToken;
                this.headerObj["X-QP-Nonce"] = timestamp.toString();
                this.headerObj["X-QP-Timestamp"] = timestamp;
                var headcont = {
                    "X-QP-AppId": falcon.configMgr.getConfig().appid,
                    "X-QP-Nonce": timestamp.toString(),
                    "X-QP-Timestamp": timestamp
                };
                var sign = falcon.XhrHttp.getUcHash(headcont, this._method, url);
                this.headerObj["X-QP-Signature"] = sign;
            }
            if (this.headerObj) {
                for (var key in this.headerObj) {
                    this._xhr.setRequestHeader(key, this.headerObj[key]);
                }
            }
            this._xhr.send();
        };
        H5HttpReq.prototype.getAllResponseHeaders = function () {
            if (!this._xhr) {
                return null;
            }
            var result = this._xhr.getAllResponseHeaders();
            return result ? result : "";
        };
        H5HttpReq.prototype.setRequestHeader = function (header, value) {
            if (!this.headerObj) {
                this.headerObj = {};
            }
            this.headerObj[header] = value;
        };
        H5HttpReq.prototype.getResponseHeader = function (header) {
            if (!this._xhr) {
                return null;
            }
            var result = this._xhr.getResponseHeader(header);
            return result ? result : "";
        };
        H5HttpReq.prototype.getXHR = function () {
            var cc = cc || {};
            if (window) {
                if (window["XMLHttpRequest"]) {
                    return new window["XMLHttpRequest"]();
                }
            }
            else if (cc) {
                cc.log("use cc.load");
                return cc.loader.getXMLHttpRequest();
            }
        };
        Object.defineProperty(H5HttpReq.prototype, "withCredentials", {
            get: function () {
                return this._withCredentials;
            },
            set: function (value) {
                this._withCredentials = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(H5HttpReq.prototype, "response", {
            get: function () {
                if (!this._xhr) {
                    return null;
                }
                if (this._xhr.response != undefined) {
                    return this._xhr.response;
                }
                if (this._responseType == "text") {
                    return this._xhr.responseText;
                }
                else if (this._responseType == falcon.HttpResponseType.ARRAY_BUFFER &&
                    /msie 9.0/i.test(navigator.userAgent)) {
                    var w = window;
                    return w.convertResponseBodyToText(this._xhr["responseBody"]);
                }
                else if (this._responseType == falcon.HttpResponseType.DOCUMENT) {
                    return this._xhr.responseXML;
                }
                return null;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(H5HttpReq.prototype, "responseType", {
            get: function () {
                return this._responseType;
            },
            set: function (reptype) {
                this._responseType = reptype;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(H5HttpReq.prototype, "timeout", {
            set: function (num) {
                if (this._xhr) {
                    this._xhr.timeout = num;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(H5HttpReq.prototype, "status", {
            get: function () {
                if (!this._xhr) {
                    return null;
                }
                return this._xhr.status;
            },
            enumerable: true,
            configurable: true
        });
        return H5HttpReq;
    }());
    falcon.H5HttpReq = H5HttpReq;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var AppSecret = "3c6e0b8a9c15224a8228b9a98ca1531d";
    var XhrHttp = (function () {
        function XhrHttp() {
        }
        XhrHttp.get = function (url, exparm, cb, httpOptions) {
            if (exparm === void 0) { exparm = {}; }
            if (!exparm["callbackId"])
                this.callbackId++;
            var xhrhttp = XhrHttp.crtHttpReq();
            var header = exparm["header"] || {};
            if (!httpOptions) {
                httpOptions = { timeout: 10000, tryTimes: 3 };
            }
            else {
                httpOptions.timeout = httpOptions.timeout || 10000;
                httpOptions.tryTimes = httpOptions.tryTimes || 3;
            }
            console.info("[GET]->S\u3010" + this.callbackId + "\u3011", url);
            for (var key in header) {
                if (header.hasOwnProperty(key)) {
                    var element = header[key];
                    xhrhttp.setRequestHeader(key, element);
                }
            }
            var fail_idx = exparm["initRetry"] ? +exparm["initRetry"] : 0;
            var listen_cb = function (resp, xhr_) {
                return __awaiter(this, void 0, void 0, function () {
                    var respData, consoleKey, err_2, err_3;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                if (!(xhr_.readyState == 4)) return [3, 11];
                                if (!(xhr_.status >= 200 && xhr_.status < 207)) return [3, 10];
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 8, , 9]);
                                respData = JSON.parse(resp);
                                consoleKey = "warn";
                                if (respData.hasOwnProperty("errCode") && respData.errCode !== 0) {
                                    consoleKey = "error";
                                }
                                console["" + consoleKey]("S->[GET]\u3010" + this.cid + "\u3011" + (Date.now() - this.time) + "ms", respData);
                                if (!(respData.errCode === 80003)) return [3, 6];
                                _a.label = 2;
                            case 2:
                                _a.trys.push([2, 4, , 5]);
                                return [4, falcon.ucMgr.refreshToken(falcon.configMgr.getConfig().baseUrl)];
                            case 3:
                                _a.sent();
                                return [3, 5];
                            case 4:
                                err_2 = _a.sent();
                                console.error(err_2);
                                return [3, 5];
                            case 5:
                                fail_cb(this);
                                return [3, 7];
                            case 6:
                                if (url.indexOf("/uc/v1/token") !== -1 && respData.errCode === 1004) {
                                    if (XhrHttp.onRefreshTokenExpire) {
                                        XhrHttp.onRefreshTokenExpire();
                                    }
                                }
                                else {
                                    cb(true, resp);
                                }
                                _a.label = 7;
                            case 7: return [3, 9];
                            case 8:
                                err_3 = _a.sent();
                                console.error("\u8FD4\u56DE\u7684GET\u8BF7\u6C42\uFF1A" + url + "\u4E0D\u662FJSON\u683C\u5F0F\uFF1A", err_3);
                                cb(true, resp);
                                return [3, 9];
                            case 9: return [3, 11];
                            case 10:
                                fail_cb(this);
                                _a.label = 11;
                            case 11: return [2];
                        }
                    });
                });
            };
            var fail_cb = function (thisObj) {
                var httpOptions = thisObj.httpOptions;
                fail_idx += 1;
                if (fail_idx > httpOptions.tryTimes) {
                    console.error("\u8BF7\u6C42\u8D85\u65F6\uFF1AS->[GET]\u3010" + thisObj.cid + "\u3011" + (Date.now() - thisObj.time) + "ms", url);
                    cb(false, "fail");
                }
                else {
                    console.error("\u8BF7\u6C42\u5931\u8D25\uFF1AS->[GET]\u3010\u91CD\u8BD5\u6B21\u6570\uFF1A" + fail_idx + "\u3011\u3010" + thisObj.cid + "\u3011" + (Date.now() - thisObj.time) + "ms", url);
                    thisObj.exparm["header"] = xhrhttp['getRefreshTokenHeader'](falcon.userMgr.getAccessToken());
                    thisObj.exparm['initRetry'] = fail_idx;
                    thisObj.exparm['callbackId'] = thisObj.cb;
                    XhrHttp.get(thisObj.url, thisObj.exparm, thisObj.cb, httpOptions);
                }
            };
            xhrhttp.timeout = httpOptions.timeout;
            xhrhttp.open(url, listen_cb.bind({ cid: this.callbackId, time: Date.now(), url: url, exparm: exparm, cb: cb, httpOptions: httpOptions }), falcon.HttpMethod.GET);
            xhrhttp.send(null);
        };
        XhrHttp.post = function (url, senddata, exparm, cb, httpOptions) {
            if (exparm === void 0) { exparm = {}; }
            var xhrhttp = XhrHttp.crtHttpReq();
            var header = exparm["header"] || {};
            if (!httpOptions) {
                httpOptions = { timeout: 10000, tryTimes: 3 };
            }
            else {
                httpOptions.timeout = httpOptions.timeout || 10000;
                httpOptions.tryTimes = httpOptions.tryTimes || 3;
            }
            if (!exparm["callbackId"])
                this.callbackId++;
            console.info("[POST]->S\u3010" + this.callbackId + "\u3011", url);
            for (var key in header) {
                if (header.hasOwnProperty(key)) {
                    var element = header[key];
                    xhrhttp.setRequestHeader(key, element);
                }
            }
            var fail_idx = exparm["initRetry"] ? +exparm["initRetry"] : 0;
            var listen_cb = function (resp, xhr_) {
                return __awaiter(this, void 0, void 0, function () {
                    var respData, consoleKey, err_4, err_5;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                if (!(xhr_.readyState == 4)) return [3, 11];
                                if (!(xhr_.status >= 200 && xhr_.status < 207)) return [3, 10];
                                _a.label = 1;
                            case 1:
                                _a.trys.push([1, 8, , 9]);
                                respData = JSON.parse(resp);
                                consoleKey = "warn";
                                if (respData.hasOwnProperty("errCode") && respData.errCode !== 0) {
                                    consoleKey = "error";
                                }
                                console["" + consoleKey]("S->[POST]\u3010" + this.cid + "\u3011" + (Date.now() - this.time) + "ms", respData);
                                if (!(respData.errCode === 80003)) return [3, 6];
                                _a.label = 2;
                            case 2:
                                _a.trys.push([2, 4, , 5]);
                                return [4, falcon.ucMgr.refreshToken(falcon.configMgr.getConfig().baseUrl)];
                            case 3:
                                _a.sent();
                                return [3, 5];
                            case 4:
                                err_4 = _a.sent();
                                console.error(err_4);
                                return [3, 5];
                            case 5:
                                fail_cb(this);
                                return [3, 7];
                            case 6:
                                cb(true, resp);
                                _a.label = 7;
                            case 7: return [3, 9];
                            case 8:
                                err_5 = _a.sent();
                                console.error("\u8FD4\u56DE\u7684POST\u8BF7\u6C42\uFF1A" + url + "\u4E0D\u662FJSON\u683C\u5F0F\uFF1A", err_5);
                                cb(true, resp);
                                return [3, 9];
                            case 9: return [3, 11];
                            case 10:
                                fail_cb(this);
                                _a.label = 11;
                            case 11: return [2];
                        }
                    });
                });
            };
            var fail_cb = function (thisObj) {
                var httpOptions = thisObj.httpOptions;
                fail_idx += 1;
                if (fail_idx > httpOptions.tryTimes) {
                    console.error("\u8BF7\u6C42\u8D85\u65F6\uFF1AS->[POST]\u3010" + thisObj.cid + "\u3011" + (Date.now() - thisObj.time) + "ms", url);
                    cb(false, "fail");
                }
                else {
                    console.error("\u8BF7\u6C42\u5931\u8D25\uFF1AS->[POST]\u3010\u91CD\u8BD5\u6B21\u6570\uFF1A" + fail_idx + "\u3011\u3010" + thisObj.cid + "\u3011" + (Date.now() - thisObj.time) + "ms", url);
                    thisObj.exparm["header"] = xhrhttp['getRefreshTokenHeader'](falcon.userMgr.getAccessToken());
                    thisObj.exparm['initRetry'] = fail_idx;
                    thisObj.exparm['callbackId'] = thisObj.cb;
                    XhrHttp.post(thisObj.url, thisObj.senddata, thisObj.exparm, thisObj.cb, httpOptions);
                }
            };
            xhrhttp.timeout = httpOptions.timeout;
            xhrhttp.open(url, listen_cb.bind({ cid: this.callbackId, time: Date.now(), url: url, senddata: senddata, exparm: exparm, cb: cb, httpOptions: httpOptions }), falcon.HttpMethod.POST);
            xhrhttp.send(JSON.stringify(senddata));
        };
        XhrHttp.crtUrlWithParms = function (baseurl, actname, parmdic) {
            if (typeof parmdic != "object") {
                return baseurl + actname;
            }
            var keys = Object.keys(parmdic).sort();
            var ret = "";
            keys.forEach(function (key_) {
                ret = ret + key_ + "=" + parmdic[key_] + "&";
            });
            ret = baseurl + actname + "?" + ret.substring(0, ret.length - 1);
            return ret;
        };
        XhrHttp.crtHttpReq = function () {
            return new falcon.H5HttpReq();
        };
        XhrHttp.getUcHash = function (headcont, methodname, url) {
            var keys = Object.keys(headcont).sort();
            var outarr = [];
            keys.forEach(function (k_) {
                outarr.push("%s:%s".format(k_, headcont[k_]));
            });
            var hash_str = methodname + outarr.join("") + url + AppSecret;
            var mdc = new MD5();
            var sign = mdc.hex_md5(hash_str).toUpperCase();
            return sign;
        };
        XhrHttp.getInterfHeader = function (appid, methodname, url, gid, acctoken, sysDot) {
            var config = falcon.configMgr.getConfig();
            var timestamp = Math.floor(Date.now() / 1000);
            var headcont = {
                "X-QP-AppId": appid,
                "X-QP-Nonce": timestamp.toString(),
                "X-QP-Timestamp": timestamp
            };
            var sign = XhrHttp.getUcHash(headcont, methodname, url);
            headcont["Content-Type"] = "application/json";
            headcont["X-QP-Signature"] = sign;
            if (gid) {
                headcont["X-QP-Gid"] = gid;
            }
            if (acctoken) {
                headcont["X-QP-Token"] = acctoken;
            }
            if (sysDot)
                headcont["Cotent-Encoding"] = "gzip";
            var bundleId = config.bundleId;
            if (bundleId)
                headcont["X-QP-BundleId"] = bundleId;
            var qpos = "ios";
            var clientType = 1;
            if (window['env']) {
                if (window['env']['isNativeAndroid']) {
                    qpos = "android";
                    clientType = 2;
                }
                else if (window['env']['isNativeIOS']) {
                    qpos = "ios";
                    clientType = 1;
                }
            }
            headcont["X-QP-AppVersion"] = config.version;
            headcont["X-QP-ResVersion"] = "0.0.1";
            headcont["X-QP-OS"] = qpos;
            headcont["X-QP-OSVersion"] = config.system;
            headcont["X-QP-ClientType"] = clientType;
            headcont["X-QP-UserId"] = falcon.userMgr.getUserId();
            headcont["X-QP-ChannelId"] = config.chId + "_" + config.subChId;
            return headcont;
        };
        XhrHttp.callbackId = 0;
        return XhrHttp;
    }());
    falcon.XhrHttp = XhrHttp;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var H5Socket = (function () {
        function H5Socket() {
            this.host = "";
            this.port = 0;
        }
        H5Socket.prototype.addCallBacks = function (onConnect, onClose, onSocketData, onError, thisObject) {
            this.onConnect = onConnect;
            this.onClose = onClose;
            this.onSocketData = onSocketData;
            this.onError = onError;
            this.thisObject = thisObject;
        };
        H5Socket.prototype.connect = function (host, port) {
            this.host = host;
            this.port = port;
            var socketServerUrl = (/\d+\.\d+\.\d+\.\d+/.test(host) ? "ws://" : "wss://") +
                this.host +
                ":" +
                this.port;
            var _cert = falcon.cert();
            if (_cert) {
                this.socket = new WebSocket(socketServerUrl, [], _cert);
            }
            else {
                this.socket = new WebSocket(socketServerUrl);
            }
            this.socket.binaryType = "arraybuffer";
            this._bindEvent();
        };
        H5Socket.prototype.connectByUrl = function (url) {
            var _cert = falcon.cert();
            if (_cert) {
                this.socket = new WebSocket(url, [], _cert);
            }
            else {
                this.socket = new WebSocket(url);
            }
            this.socket.binaryType = "arraybuffer";
            this._bindEvent();
        };
        H5Socket.prototype._bindEvent = function () {
            var _this = this;
            this.socket.onopen = function () {
                if (_this.onConnect) {
                    _this.onConnect.call(_this.thisObject);
                }
            };
            this.socket.onclose = function (e) {
                if (_this.onClose) {
                    console.log("h5socket onClose————————————————————————", e);
                    _this.onClose.call(_this.thisObject);
                }
            };
            this.socket.onerror = function (e) {
                if (_this.onError) {
                    console.log("h5socket onerror————————————————————————", e);
                    _this.onError.call(_this.thisObject);
                }
            };
            this.socket.onmessage = function (e) {
                _this.onSocketData && _this.onSocketData.call(_this.thisObject, e.data);
            };
        };
        H5Socket.prototype.send = function (message) {
            this.socket.send(message);
        };
        H5Socket.prototype.close = function () {
            this.socket.close();
        };
        H5Socket.prototype.disconnect = function () {
            this.socket.disconnect && this.socket.disconnect();
        };
        return H5Socket;
    }());
    falcon.H5Socket = H5Socket;
    falcon.ISocket = H5Socket;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var TSocket = (function () {
        function TSocket() {
            this.host = "";
            this.port = 0;
        }
        TSocket.prototype.addCallBacks = function (onConnect, onClose, onSocketData, onError, thisObject) {
            this.onConnect = onConnect;
            this.onClose = onClose;
            this.onSocketData = onSocketData;
            this.onError = onError;
            this.thisObject = thisObject;
        };
        TSocket.prototype.connect = function (host, port) {
            this.host = host;
            this.port = port;
            var socketServerUrl = (/\d+\.\d+\.\d+\.\d+/.test(host) ? "ws://" : "wss://") +
                this.host +
                ":" +
                this.port;
            var _cert = falcon.cert();
            if (_cert) {
                this.socket = new WebSocket(socketServerUrl, [], _cert);
            }
            else {
                this.socket = new WebSocket(socketServerUrl);
            }
            this.socket.binaryType = "arraybuffer";
            this._bindEvent();
        };
        TSocket.prototype.connectByUrl = function (url) {
            var _cert = falcon.cert();
            if (_cert) {
                this.socket = new WebSocket(url, [], _cert);
            }
            else {
                this.socket = new WebSocket(url);
            }
            this.socket.binaryType = "arraybuffer";
            this._bindEvent();
        };
        TSocket.prototype._bindEvent = function () {
            var _this = this;
            var socket = this.socket;
            this.socket.onopen = function (e) {
                if (_this.onConnect) {
                    _this.onConnect.call(_this.thisObject);
                }
            };
            this.socket.onclose = function (e) {
                if (_this.onClose) {
                    console.log("tsocket onClose————————————————————————", e);
                    _this.onClose.call(_this.thisObject);
                }
            };
            this.socket.onerror = function (e) {
                if (_this.onError) {
                    console.log("tsocket onerror————————————————————————", e);
                    _this.onError.call(_this.thisObject);
                }
            };
            this.socket.onmessage = function (e) {
                if (_this.onSocketData) {
                    _this.onSocketData.call(_this.thisObject, e.data);
                }
            };
        };
        TSocket.prototype.send = function (message) {
            this.socket.send(message);
        };
        TSocket.prototype.close = function () {
            this.socket.close();
        };
        TSocket.prototype.disconnect = function () {
            this.socket.disconnect && this.socket.disconnect();
        };
        return TSocket;
    }());
    falcon.TSocket = TSocket;
    falcon.ISocket = TSocket;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var SocketType;
    (function (SocketType) {
        SocketType["COIN"] = "COIN";
        SocketType["MATCH"] = "MATCH";
    })(SocketType = falcon.SocketType || (falcon.SocketType = {}));
    function cert() {
        if (!window['cc'])
            return undefined;
        if (!window['env'].isNativeAndroid)
            return undefined;
        var pemUrl = window['cc'].url.raw('resources/cert.pem');
        return pemUrl;
    }
    falcon.cert = cert;
    var Net = (function () {
        function Net(host, port) {
            if (host === void 0) { host = ""; }
            if (port === void 0) { port = 0; }
            this._writeMessage = "";
            this._readMessage = "";
            this._type = Net.TYPE_STRING;
            this._bytesWrite = false;
            this._isReadySend = false;
            this._connected = false;
            this._connecting = false;
            this._online = false;
            this.noReconnect = false;
            this._connected = false;
            this._writeMessage = "";
            this._readMessage = "";
            if (window["WebSocket"]) {
                this.socket = new falcon.H5Socket();
                console.log("H5Socket__________________start");
            }
            else {
                this.socket = new falcon.TSocket();
                console.log("TSocket__________________start");
            }
            this.socket.addCallBacks(this.onConnect, this.onClose, this.onSocketData, this.onError, this);
            this._msg_dispatcher = new falcon.EventDispatcher();
        }
        Net.prototype.onConnect = function () {
            this._connected = true;
            this._connecting = false;
            this._online = true;
            this.noReconnect = false;
            this.stop_tick_reconnect();
            this.tick_heart_beat();
            this.dispatchEvent(Net.CONNECT_SUCCESS);
        };
        Net.prototype.onClose = function () {
            console.log("net onClose_____________________", this._online, this.noReconnect);
            this._connected = false;
            if (this._online) {
                this.stop_tick_heart_beat();
                if (!this.noReconnect)
                    this.tick_reconnect();
                this.dispatchEvent(Net.CONNECT_CLOSE);
                this._online = false;
            }
        };
        Net.prototype.onSocketData = function (message) {
            if (typeof message == "string") {
                this._readMessage += message;
            }
            else {
                this._readByte._writeUint8Array(new Uint8Array(message));
            }
        };
        Net.prototype.onError = function () {
            if (this._connecting) {
                this._connecting = false;
            }
            this.stop_tick_heart_beat();
            this.tick_reconnect();
            this.dispatchEvent(Net.CONNECT_FAILURE);
        };
        Net.prototype.flush = function () {
            if (!this._connected) {
                return;
            }
            if (this._writeMessage) {
                console.log(this._writeMessage);
                console.log(this._writeMessage.length);
                this.socket.send(this._writeMessage);
                this._writeMessage = "";
            }
            if (this._bytesWrite) {
                this.socket.send(this._writeByte.buffer);
                this._bytesWrite = false;
                this._writeByte.clear();
            }
            this._isReadySend = false;
        };
        Net.prototype.connect = function (host, port) {
            if (!this._connecting && !this._connected) {
                this._connecting = true;
                this.socket.connect(host, port);
                this.ip = host;
                this.port = port;
            }
        };
        Net.prototype.connectByUrl = function (url) {
            if (!this._connecting && !this._connected) {
                this._connecting = true;
                this.socket.connectByUrl(url);
            }
        };
        Net.prototype.close = function (noReconnect) {
            if (noReconnect === void 0) { noReconnect = false; }
            console.log("net close-------------", this._connected, noReconnect);
            if (this._connected) {
                this.socket.close();
                this._connected = false;
            }
            this.noReconnect = noReconnect;
            if (noReconnect) {
                this.stop_tick_reconnect();
                this.stop_tick_heart_beat();
            }
        };
        Net.prototype.writeBytes = function (bytes, offset, length) {
            if (offset === void 0) { offset = 0; }
            if (length === void 0) { length = 0; }
            if (!this._connected) {
                return;
            }
            if (!this._writeByte) {
                return;
            }
            this._bytesWrite = true;
            this._writeByte.writeBytes(bytes, offset, length);
            this.flush();
        };
        Net.prototype.readUTF = function () {
            var message;
            if (this._type == Net.TYPE_BINARY) {
                this._readByte.position = 0;
                message = this._readByte.readUTF();
                this._readByte.clear();
            }
            else {
                message = this._readMessage;
                this._readMessage = "";
            }
            return message;
        };
        Net.prototype.tick_heart_beat = function () {
            var _this = this;
            this.stop_tick_heart_beat();
            this.timer_heart_beat = setInterval(function () {
                if (!_this._online) {
                    return;
                }
                _this.send_heart_beat_pack();
            }, Net.HB_TIME_CD * 1000);
        };
        Net.prototype.stop_tick_heart_beat = function () {
            if (this.timer_heart_beat) {
                clearInterval(this.timer_heart_beat);
            }
        };
        Net.prototype.send_heart_beat_pack = function () { };
        Object.defineProperty(Net.prototype, "online", {
            get: function () {
                return this._online;
            },
            enumerable: true,
            configurable: true
        });
        Net.prototype.reconnect = function () {
            this.connect(this.ip, this.port);
        };
        Net.prototype.tick_reconnect = function () {
            var _this = this;
            this.stop_tick_reconnect();
            this.timer_reconnect = setInterval(function () {
                _this.reconnect();
            }, Net.RE_CONNECT_TIME_INTERVAL * 1000);
        };
        Net.prototype.stop_tick_reconnect = function () {
            if (this.timer_reconnect) {
                clearInterval(this.timer_reconnect);
            }
        };
        Net.prototype.registerMsgListener = function (msgId, handler, target) {
            this._msg_dispatcher.on(msgId, handler, target);
        };
        Net.prototype.unregisterMsgListener = function (msgId, handler, target) {
            this._msg_dispatcher.removeEventListener(msgId, handler, target);
        };
        Net.prototype.unregisterMsgListeners = function (msgId) {
            this._msg_dispatcher.removeEventListeners(msgId);
        };
        Net.prototype.registerMsgListenerOnce = function (msgId, handler, target) {
            this._msg_dispatcher.once(msgId, handler, target);
        };
        Net.prototype.dispatchEvent = function (msgId, msg) {
            this._msg_dispatcher.emit(msgId, msg, this._socketType);
        };
        Object.defineProperty(Net.prototype, "connected", {
            get: function () {
                return this._connected;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Net.prototype, "type", {
            get: function () {
                return this._type;
            },
            set: function (value) {
                this._type = value;
                if (value == Net.TYPE_BINARY && !this._writeByte) {
                    this._readByte = new falcon.ByteArray();
                    this._writeByte = new falcon.ByteArray();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Net.prototype, "socketType", {
            get: function () {
                return this._socketType;
            },
            set: function (value) {
                this._socketType = value;
            },
            enumerable: true,
            configurable: true
        });
        Net.prototype.onMessage = function (callback) { };
        Net.CONNECT_SUCCESS = "CONNECT_SUCCESS";
        Net.CONNECT_CLOSE = "CONNECT_CLOSE";
        Net.CONNECT_FAILURE = "CONNECT_FAILURE";
        Net.TYPE_STRING = "webSocketTypeString";
        Net.TYPE_BINARY = "webSocketTypeBinary";
        Net.HB_TIME_CD = 8;
        Net.RE_CONNECT_TIME_INTERVAL = 3;
        return Net;
    }());
    falcon.Net = Net;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var Packet = (function () {
        function Packet() {
            this._msgOrder = 0;
            this._uuid = "187963411";
            this._secretKey = "3c6e0b8a9c15224a8228b9a98ca1531d";
            this._strVerifyKey = "";
        }
        Packet.prototype.pack = function (data, simple) {
            if (simple === void 0) { simple = true; }
            if (simple) {
                return this.simeplePack(data);
            }
            else {
                return this.complexPack(data);
            }
        };
        Packet.prototype.simeplePack = function (data) {
            var msgPackData = msgpack.pack(data, false);
            var msgLength = msgPackData.length;
            var len = this.toCByShort(msgLength);
            var curTime = Math.floor(Date.now() / 1000);
            var time = this.toCByInt(curTime);
            var msgId = this.toCByInt(data.m_msgId * ((curTime % 10000) + 1));
            var checksum = this.getCheckSum(time.concat(msgId), msgLength, msgPackData);
            var msgToSend = len
                .concat(checksum)
                .concat(time)
                .concat(msgId)
                .concat(msgPackData);
            return msgToSend;
        };
        Packet.prototype.complexPack = function (data) {
            var packMsgData = msgpack.pack(data, false);
            var packMsgHead = msgpack.pack(this.getMessageHead(packMsgData), false);
            packMsgData.unshift(0x01);
            var msgEntityLen = packMsgData.length;
            var msgEntityLenArr = [
                msgEntityLen % 256,
                Math.floor(msgEntityLen / 256)
            ];
            var msgHeadLen = packMsgHead.length;
            var msgHeadLenArr = [msgHeadLen % 256, Math.floor(msgHeadLen / 256)];
            var msgTotalLen = msgHeadLen + 2 + msgEntityLen + 2;
            var msgTotalLenHi = Math.floor(msgTotalLen / 256);
            var msgTotalLenLow = msgTotalLen % 256;
            var curTime = Math.floor(Date.now() / 1000);
            var time = this.toCByInt(curTime);
            var msgId = this.toCByInt(data.m_msgId * ((curTime % 10000) + 1));
            var msgEntity = time.concat(msgId, msgHeadLenArr, packMsgHead, msgEntityLenArr, packMsgData);
            var checksum = this.getCheckSumComplex(msgEntity);
            var msgToSend = [msgTotalLenLow, msgTotalLenHi].concat(checksum, msgEntity);
            return msgToSend;
        };
        Packet.prototype.getMessageHead = function (msgBody) {
            var msgEntityLen = msgBody.length;
            var beginPos = 0;
            if (msgEntityLen > 0) {
                beginPos = Math.floor(Math.random() * msgEntityLen) + 1;
            }
            var endPos = beginPos;
            var remainLen = msgEntityLen - beginPos;
            if (remainLen > 0) {
                endPos =
                    beginPos + Math.floor(Math.random() * Math.min(128, remainLen)) + 1;
            }
            var md5str = "";
            if (beginPos > 0 && endPos >= beginPos) {
                var stringMd5 = "";
                var testMd5 = "";
                for (var i = beginPos - 1; i < endPos; i++) {
                    var tmp = parseInt(msgBody[i]);
                    var upperCase = tmp.toString(16).toUpperCase();
                    var pre = tmp < 16 ? "0" : "";
                    stringMd5 = stringMd5 + pre + upperCase;
                }
                md5str = new MD5().hex_md5(stringMd5 + this._secretKey);
            }
            else {
                beginPos = 0;
                endPos = 0;
            }
            this._msgOrder += 1;
            var msgHeadData = {};
            msgHeadData.m_msgId = 500;
            msgHeadData.m_strUserId = this._uuid;
            msgHeadData.m_iMd5Begin = beginPos;
            msgHeadData.m_iMd5End = endPos;
            msgHeadData.m_strMd5 = md5str;
            msgHeadData.m_strVerifyKey = this._strVerifyKey;
            msgHeadData.m_lMsgOrder = this._msgOrder;
            return msgHeadData;
        };
        Packet.prototype.getCheckSumComplex = function (time) {
            var crc = this.calcCRC(time, 8);
            return this.toCByShort(crc);
        };
        Packet.prototype.getCheckSum = function (time, msgLenth, msgPackData) {
            var crc;
            var len = time.length + msgLenth;
            if (len < 8) {
                crc = this.calcCRC(time.concat(msgPackData), len);
            }
            else {
                crc = this.calcCRC(time.concat(msgPackData), 8);
            }
            return this.toCByShort(crc);
        };
        Packet.prototype.calcCRC = function (data, length) {
            var sum = 65535;
            for (var i = 0; i < length; i++) {
                var d = data[i];
                sum = this.byteCRC(sum, d);
            }
            return sum;
        };
        Packet.prototype.byteCRC = function (sum, data) {
            sum = sum ^ data;
            for (var i = 0; i <= 3; i++) {
                if ((sum & 1) == 0) {
                    sum /= 2;
                }
                else {
                    sum = (sum / 2) ^ 0x70b1;
                }
            }
            return sum;
        };
        Packet.prototype.toCByShort = function (value) {
            return [value & 0xff, value >> 8];
        };
        Packet.prototype.toCByInt = function (value) {
            var byte_part_f = value >> 24;
            var byte_part_s = (value >> 16) & 0xff;
            var byte_part_t = (value >> 8) & 0xff;
            var byte_part_o = value & 0xff;
            return [byte_part_o, byte_part_t, byte_part_s, byte_part_f];
        };
        Object.defineProperty(Packet.prototype, "msgOrder", {
            set: function (value) {
                this._msgOrder = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Packet.prototype, "strVerifyKey", {
            set: function (value) {
                this._strVerifyKey = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Packet.prototype, "uuid", {
            set: function (value) {
                this._uuid = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Packet.prototype, "secretKey", {
            set: function (value) {
                this._secretKey = value;
            },
            enumerable: true,
            configurable: true
        });
        return Packet;
    }());
    falcon.Packet = Packet;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var message_type_bits;
    (function (message_type_bits) {
        message_type_bits["request"] = "000";
        message_type_bits["response"] = "001";
        message_type_bits["notify"] = "010";
        message_type_bits["push"] = "011";
    })(message_type_bits || (message_type_bits = {}));
    var Packet_x = (function () {
        function Packet_x() {
        }
        Packet_x.prototype.pack = function (msg) {
            var pkg_pack = this._pack_pkg(msg);
            var ptype_packed = pkg_pack.ptype;
            var len_p_packed = pkg_pack.len_p;
            var msg_packed = pkg_pack.msg_packed;
            var pkg = ptype_packed.concat(len_p_packed);
            if (msg.ptype != falcon.PCK_TYPE.DATA) {
                return pkg.concat(msg_packed);
            }
            var flag_obj = this._get_message_header_flag(msg);
            var flag = flag_obj.bin;
            var fixed = flag_obj.fixed;
            var optional_obj = this._get_message_optional(msg, fixed);
            var optional = optional_obj.optional;
            var optional_len = optional_obj.len;
            var body = msg_packed;
            var total_len = this._value_to_three_byte(msg_packed.length + 6 + optional_len);
            var dest = ptype_packed.concat(total_len, flag, optional, body);
            return dest;
        };
        Packet_x.prototype._pack_pkg = function (msg) {
            var msg_packed;
            if (msg.codec == 1) {
                msg_packed = msg.pb_buf;
            }
            else {
                msg_packed = msgpack.pack(msg);
            }
            var ptype = this._value_to_one_byte(msg.ptype);
            var len = msg_packed.length;
            if (msg.ptype == falcon.PCK_TYPE.SHAKE_ACK || msg.ptype == falcon.PCK_TYPE.HEART_BEAT) {
                len = 0;
                msg_packed = [];
            }
            var len_p = this._value_to_three_byte(len);
            return {
                ptype: ptype,
                len_p: len_p,
                msg_packed: msg_packed
            };
        };
        Packet_x.prototype._get_message_header_flag = function (msg) {
            var dict_obj = this._get_message_header_flag_route_dict(msg);
            var route_dict_bit = dict_obj.dict;
            var fixed = dict_obj.zip;
            var preserved_bit = "0000";
            var message_type_bit = message_type_bits[msg.msg_type];
            var one_byte_pmr = parseInt(preserved_bit + route_dict_bit + route_dict_bit, 2);
            var bin = this._value_to_one_byte(one_byte_pmr);
            var codec_bit = this._get_message_header_flag_codec(msg);
            var one_byte_cr = parseInt(codec_bit + preserved_bit, 2);
            var bin_ = this._value_to_one_byte(one_byte_cr);
            var bin_server_id = this._value_to_four_byte(msg.server_id);
            bin = bin.concat(bin_, bin_server_id);
            return {
                bin: bin,
                fixed: fixed
            };
        };
        Packet_x.prototype._get_message_optional = function (msg, fixed) {
            var stream_id;
            var len = 0;
            if (msg.msg_type == "request") {
                stream_id = this._value_to_four_byte(msg.m_msgId);
                len = len + 4;
            }
            var route;
            var length;
            var route_packed_len = 0;
            if (msg.route) {
                var byte = new falcon.ByteArray();
                byte.writeUTF(msg.route);
                byte.position = 0;
                var route_packed = Array.from(byte.bytes.slice(2));
                route_packed_len = byte.readShort();
                if (fixed) {
                    route = route_packed;
                    route_packed_len = 2;
                    len += route_packed_len;
                }
                else {
                    length = this._value_to_one_byte(route_packed_len);
                    var content = route_packed;
                    route = length.concat(content);
                    len = len + 1 + route_packed_len;
                }
            }
            else {
                route = this._value_to_one_byte(route_packed_len);
                len = len + 1;
            }
            stream_id = stream_id || [];
            return {
                optional: stream_id.concat(route),
                len: len
            };
        };
        Packet_x.prototype._get_message_header_flag_codec = function (msg) {
            return (msg.codec == 1 && "0001") || "0000";
        };
        Packet_x.prototype._get_message_header_flag_route_dict = function (msg) {
            if (msg.fixed) {
                return {
                    dict: "1",
                    zip: true
                };
            }
            return {
                dict: "0",
                zip: false
            };
        };
        Packet_x.prototype.parser = function (buffer) {
            var out;
            var ptype = buffer[0];
            var len = buffer[1] + buffer[2] + buffer[3];
            if (ptype == falcon.PCK_TYPE.HEART_BEAT || ptype == falcon.PCK_TYPE.DISCONNECT) {
                return (out = {
                    body: buffer.slice(1),
                    ptype: ptype,
                    one_pack_len: 4
                });
            }
            if (ptype != falcon.PCK_TYPE.DATA) {
                return (out = {
                    body: buffer.slice(4),
                    ptype: ptype,
                    one_pack_len: 4 + len
                });
            }
            var message = buffer.slice(4);
            var flag_pmr_bits = message[0];
            var flag_cr_bits = message[1];
            var msg_type = (flag_pmr_bits & 0xf) >> 1;
            var serizalize_type = (flag_cr_bits & 0xf0) >> 4;
            if (msg_type == 1) {
                var body = message.slice(10, len);
                return (out = {
                    body: body,
                    ptype: ptype,
                    one_pack_len: len + 4,
                    serizalize_type: serizalize_type
                });
            }
            else if (msg_type == 3) {
                var body = message.slice(6, len);
                return (out = {
                    body: body,
                    ptype: ptype,
                    one_pack_len: len + 4,
                    serizalize_type: serizalize_type
                });
            }
            return null;
        };
        Packet_x.prototype._value_to_one_byte = function (value) {
            return [value & 0xff];
        };
        Packet_x.prototype._value_to_two_byte = function (value) {
            return [value & 0xff, value >> 8];
        };
        Packet_x.prototype._value_to_three_byte = function (value) {
            var byte_part_f = (value >> 16) & 0xff;
            var byte_part_s = (value >> 8) & 0xff;
            var byte_part_t = value & 0xff;
            return [byte_part_t, byte_part_s, byte_part_f];
        };
        Packet_x.prototype._value_to_four_byte = function (value) {
            var byte_part_f = value >> 24;
            var byte_part_s = (value >> 16) & 0xff;
            var byte_part_t = (value >> 8) & 0xff;
            var byte_part_o = value & 0xff;
            return [byte_part_o, byte_part_t, byte_part_s, byte_part_f];
        };
        Packet_x.prototype.str_to_binary_array = function (str) {
            var result = [];
            var list = str.split("");
            for (var i = 0; i < list.length; i++) {
                var item = list[i];
                var binaryStr = item.charCodeAt().toString(2);
                result.push(binaryStr);
            }
            return result;
        };
        return Packet_x;
    }());
    falcon.Packet_x = Packet_x;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var NetRoom = (function (_super) {
        __extends(NetRoom, _super);
        function NetRoom() {
            var _this = _super.call(this) || this;
            _this._list_msg = [];
            _this._bSimplePack = true;
            _this._adapter = null;
            _this._adapterReserve = null;
            _this._packet = new falcon.Packet();
            return _this;
        }
        NetRoom.prototype.onConnect = function () {
            console.log("net_room onConnect");
            _super.prototype.onConnect.call(this);
            this.tick_send();
        };
        NetRoom.prototype.onClose = function () {
            console.log("net_room onClose");
            _super.prototype.onClose.call(this);
            this.clearCache();
        };
        NetRoom.prototype.onSocketData = function (message) {
            var msg;
            if (typeof message == "string") {
                _super.prototype.onSocketData.call(this, message);
                this.type = falcon.Net.TYPE_STRING;
                var msg_1 = this.readUTF();
                var _data = [];
                var _msg = msg_1.substr(this._bSimplePack ? 12 : 13);
                for (var i = 0; i < _msg.length; i++) {
                    _data[i] = _msg.charCodeAt(i);
                }
                var decodeInstance = new massagepack.Decoder(massagepack.Decoder.toArrayBuffer(_data));
                msg_1 = decodeInstance.decode();
            }
            else {
                msg = new falcon.ByteArray(message).bytes.slice(this._bSimplePack ? 12 : 13);
                var decodeInstance = new massagepack.Decoder(msg);
                msg = decodeInstance.decode();
            }
            if (!msg) {
                return;
            }
            var code = msg["m_msgId"];
            falcon.EventManager.msgs[code] = msg;
            var eventVo = this.getNet2CClass(code);
            if (!eventVo) {
                console.error("=================没有为消息：" + code + "进行解析==================");
                return;
            }
            var EventClass = eventVo.eventClass;
            var net2C = new EventClass();
            net2C.decode(msg);
            net2C["_data"] = msg;
            falcon.EventManager.dispatchModuleEvent(net2C);
        };
        NetRoom.prototype.getNet2CClass = function (code) {
            return falcon.EventManager.net2Cs.get(code);
        };
        NetRoom.prototype.onError = function () {
            console.log("net_room onError");
            _super.prototype.onError.call(this);
        };
        NetRoom.prototype.clearCache = function () {
            this._list_msg.splice(0, this._list_msg.length);
        };
        NetRoom.prototype.send = function (code, data) {
            var _code = code;
            data["m_msgId"] = _code;
            var msgToSend = this._packet.pack(data, this._bSimplePack);
            this._list_msg.push(msgToSend);
            if (_code != 15) {
                var date = new Date();
                var comments = window["comments"];
                var comment = comments ? comments["cm" + code] : "";
                if (window['env'] && window['env']['isNativeIOS']) {
                    console.info("C->S\u3010" + code + "\u3011\u3010" + comment + "\u3011=>", data);
                }
                else {
                    console.log(date.toLocaleTimeString() + " " + date.getMilliseconds() + " %cC->S【" + code + "】【" + comment + "】=> ", "color:#e97200;background:#dddddd;", data);
                }
            }
        };
        NetRoom.prototype.doConnect = function (host, port) {
            this.connect(host, port);
        };
        NetRoom.prototype.disConnect = function () {
            console.log("net room disConnect");
            this.close();
        };
        NetRoom.prototype.tick_send = function () {
            var _this = this;
            this.stop_tick_send();
            this.timer_send = setInterval(function () {
                if (_this._list_msg.length <= 0) {
                    return;
                }
                var msg = _this._list_msg.shift();
                var byte = new falcon.ByteArray();
                byte._writeUint8Array(new Uint8Array(msg));
                _this.type = falcon.Net.TYPE_BINARY;
                _this.writeBytes(byte);
            }, 1000 / 30);
        };
        NetRoom.prototype.stop_tick_send = function () {
            if (this.timer_send) {
                clearInterval(this.timer_send);
            }
        };
        NetRoom.prototype.send_heart_beat_pack = function () {
            var timenow = Date.now();
            var m_sec_ = timenow / 1000;
            var m_secs = m_sec_.toString().split(".");
            var m_sec = +m_secs[0];
            var m_usec = Math.floor(+m_secs[1] * 1000);
            var test = {
                m_sec: m_sec,
                m_usec: m_usec
            };
            this.send(15, test);
        };
        Object.defineProperty(NetRoom.prototype, "packet", {
            get: function () {
                return this._packet;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NetRoom.prototype, "bSimplePack", {
            set: function (value) {
                this._bSimplePack = value;
            },
            enumerable: true,
            configurable: true
        });
        return NetRoom;
    }(falcon.Net));
    falcon.NetRoom = NetRoom;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var PCK_TYPE;
    (function (PCK_TYPE) {
        PCK_TYPE[PCK_TYPE["SHAKE"] = 1] = "SHAKE";
        PCK_TYPE[PCK_TYPE["SHAKE_ACK"] = 2] = "SHAKE_ACK";
        PCK_TYPE[PCK_TYPE["HEART_BEAT"] = 3] = "HEART_BEAT";
        PCK_TYPE[PCK_TYPE["DATA"] = 4] = "DATA";
        PCK_TYPE[PCK_TYPE["DISCONNECT"] = 5] = "DISCONNECT";
    })(PCK_TYPE = falcon.PCK_TYPE || (falcon.PCK_TYPE = {}));
    var NetGate = (function (_super) {
        __extends(NetGate, _super);
        function NetGate(host, port) {
            if (host === void 0) { host = ""; }
            if (port === void 0) { port = 0; }
            var _this = _super.call(this, host, port) || this;
            _this._list_package = [];
            _this._list_message = [];
            _this._msg_list_ready = false;
            _this.packet = new falcon.Packet_x();
            _this.type = falcon.Net.TYPE_BINARY;
            return _this;
        }
        NetGate.prototype.onConnect = function () {
            console.log("net_gate onConnect");
            _super.prototype.onConnect.call(this);
            this.tick_send();
            this.send_pacakge_shake();
        };
        NetGate.prototype.onClose = function () {
            console.log("net_gate onClose");
            _super.prototype.onClose.call(this);
            this.clearCache();
        };
        NetGate.prototype.onSocketData = function (message) {
            var ret = this.packet.parser(new falcon.ByteArray(message).bytes);
            var serizalize_type = ret.serizalize_type;
            var msg;
            if (serizalize_type == 1) {
                msg = ret.body;
            }
            else {
                msg = msgpack.unpack(ret.body);
            }
            if (msg == null) {
                return;
            }
            var ptype = ret.ptype;
            this.distribute_msg(msg, ptype, serizalize_type);
        };
        NetGate.prototype.onError = function () {
            console.log("net_gate onError");
            _super.prototype.onError.call(this);
        };
        NetGate.prototype.clearCache = function () {
            this._list_package.splice(0, this._list_package.length);
            this._list_message.splice(0, this._list_message.length);
        };
        NetGate.prototype.distribute_msg = function (msg, ptype, serizalize_type) {
            if (ptype == PCK_TYPE.SHAKE) {
                this.send_package_shake_ack();
                this._msg_list_ready = true;
            }
            else if (ptype == PCK_TYPE.HEART_BEAT) {
                this.on_net_msg_heart_beat(msg);
            }
            else if (ptype == PCK_TYPE.DISCONNECT) {
                this.disConnect();
                this.stop_tick_heart_beat();
                this.stop_tick_reconnect();
                console.log("server kicked you");
            }
            else if (ptype == PCK_TYPE.DATA) {
                var msg_id = msg.m_msgId;
                if (!msg_id) {
                    return;
                }
                this.dispatchEvent(msg_id, msg);
            }
        };
        NetGate.prototype.on_net_msg_heart_beat = function (msg) { };
        NetGate.prototype.tick_send = function () {
            var _this = this;
            this.stop_tick_send();
            this.timer_send = setInterval(function () {
                if (_this._list_package.length > 0) {
                    _this.socket_send(_this._list_package);
                }
                if (_this._list_message.length > 0 && _this._msg_list_ready) {
                    _this.socket_send(_this._list_message);
                }
            }, 1000 / 30);
        };
        NetGate.prototype.socket_send = function (list) {
            var msg = list.shift();
            var byte = new falcon.ByteArray();
            byte._writeUint8Array(new Uint8Array(msg));
            this.writeBytes(byte);
        };
        NetGate.prototype.stop_tick_send = function () {
            if (this.timer_send) {
                clearInterval(this.timer_send);
            }
        };
        NetGate.prototype.send = function (msgId, data) {
            data["m_msgId"] = msgId;
            this.send_package_data(data);
        };
        NetGate.prototype.send_pb = function (msgId, buf, method) {
            var msg = {
                codec: 1,
                m_msgId: msgId,
                route: "lm",
                msg_type: (method && method) || "request",
                pb_buf: Array.from(buf)
            };
            this.send_package_data(msg);
        };
        NetGate.prototype.doConnect = function (host, port) {
            this.connect(host, port);
        };
        NetGate.prototype.disConnect = function () {
            this.close();
        };
        NetGate.prototype.set_shake_package_data = function (app_id, gid, user_id, token) {
            this._shake_pkg = {
                sys: {
                    version: "1.0.0",
                    app_id: app_id
                },
                user: {
                    gid: gid,
                    user_id: user_id,
                    token: token
                }
            };
        };
        NetGate.prototype.send_pacakge_shake = function () {
            var msg = {
                ptype: 0x1,
                sys: this._shake_pkg.sys,
                user: this._shake_pkg.user
            };
            var pack = this.packet.pack(msg);
            this._list_package.push(pack);
        };
        NetGate.prototype.send_package_shake_ack = function () {
            var msg = {
                ptype: 0x2
            };
            var pack = this.packet.pack(msg);
            this._list_package.push(pack);
        };
        NetGate.prototype.send_heart_beat_pack = function () {
            var msg = {
                ptype: 0x3
            };
            var pack = this.packet.pack(msg);
            this._list_package.push(pack);
        };
        NetGate.prototype.send_package_data = function (msg) {
            msg.ptype = 0x4;
            var pack = this.packet.pack(msg);
            this._list_message.push(pack);
        };
        return NetGate;
    }(falcon.Net));
    falcon.NetGate = NetGate;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var _NetChan = (function () {
        function _NetChan() {
            this._socketMap = new Map();
        }
        _NetChan.getInstance = function () {
            if (!this._instance) {
                this._instance = new _NetChan();
            }
            return this._instance;
        };
        _NetChan.prototype.getSocket = function (key) {
            return this._socketMap.get(key);
        };
        _NetChan.prototype.addSocket = function (key, net) {
            net.socketType = key;
            this._socketMap.set(key, net);
        };
        _NetChan.prototype.removeSocket = function (key) {
            this._socketMap.delete(key);
        };
        _NetChan._instance = null;
        return _NetChan;
    }());
    falcon._NetChan = _NetChan;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var _UserDataMgr = (function () {
        function _UserDataMgr() {
            this._data = { userId: 0, gid: 0 };
            if (_UserDataMgr._instance) {
                throw new Error("Error: Instantiation failed: Use SingletonDemo.getInstance() instead of new.");
            }
            _UserDataMgr._instance = this;
        }
        _UserDataMgr.getInstance = function () {
            return _UserDataMgr._instance;
        };
        _UserDataMgr.prototype.isAccessTokenMayExpire = function () {
            var curTime = Math.floor(Date.now() / 1000);
            var curAccessTokenTime = this.getAccessTokenRefreshTime();
            if (curTime - curAccessTokenTime >= 13000) {
                return true;
            }
            return false;
        };
        _UserDataMgr.prototype.setGid = function (gid) {
            this._data.gid = gid;
        };
        _UserDataMgr.prototype.setActiveGame = function (activeGame) {
            this._data.activeGame = activeGame;
        };
        _UserDataMgr.prototype.setOpenId = function (openId) {
            this._data.openId = openId;
        };
        _UserDataMgr.prototype.setAccessToken = function (accessToken) {
            this._data.accessToken = accessToken;
        };
        _UserDataMgr.prototype.setRefreshToken = function (refreshToken) {
            this._data.refreshToken = refreshToken;
        };
        _UserDataMgr.prototype.setUnionId = function (unionId) {
            this._data.unionId = unionId;
        };
        _UserDataMgr.prototype.setLastLoginTime = function (lastLoginTime) {
            this._data.lastLoginTime = lastLoginTime;
        };
        _UserDataMgr.prototype.setRegTime = function (regTime) {
            this._data.regTime = regTime;
        };
        _UserDataMgr.prototype.setUserId = function (userId) {
            this._data.userId = userId;
        };
        _UserDataMgr.prototype.setHeadImgUrl = function (headImgUrl) {
            this._data.headImgUrl = headImgUrl;
        };
        _UserDataMgr.prototype.setNickName = function (nickName) {
            this._data.nickName = nickName;
        };
        _UserDataMgr.prototype.setSex = function (sex) {
            this._data.sex = sex;
        };
        _UserDataMgr.prototype.setUserRole = function (userRole) {
            this._data.userRole = userRole;
        };
        _UserDataMgr.prototype.setLoginType = function (loginType) {
            this._data.loginType = loginType;
        };
        _UserDataMgr.prototype.setIp = function (ip) {
            this._data.ip = ip;
        };
        _UserDataMgr.prototype.setExpiresIn = function (value) {
            this._data.expiresIn = value;
        };
        _UserDataMgr.prototype.setAccessTokenRefreshTime = function (time) {
            this._data.accessTokenRefreshTime = time;
        };
        ;
        _UserDataMgr.prototype.setRefreshTokenRefreshTime = function (time) {
            this._data.refreshTokenRefreshTime = time;
        };
        ;
        _UserDataMgr.prototype.getAccessTokenRefreshTime = function () {
            return this._data.accessTokenRefreshTime;
        };
        ;
        _UserDataMgr.prototype.getRefreshTokenRefreshTime = function () {
            return this._data.refreshTokenRefreshTime;
        };
        ;
        _UserDataMgr.prototype.getGid = function () {
            return this._data.gid;
        };
        _UserDataMgr.prototype.getActiveGame = function () {
            return this._data.activeGame;
        };
        _UserDataMgr.prototype.getOpenId = function () {
            return this._data.openId;
        };
        _UserDataMgr.prototype.getAccessToken = function () {
            return this._data.accessToken;
        };
        _UserDataMgr.prototype.getRefreshToken = function () {
            return this._data.refreshToken;
        };
        _UserDataMgr.prototype.getUnionId = function () {
            return this._data.unionId;
        };
        _UserDataMgr.prototype.getLastLoginTime = function () {
            return this._data.lastLoginTime;
        };
        _UserDataMgr.prototype.getRegTime = function () {
            return this._data.regTime;
        };
        _UserDataMgr.prototype.getUserId = function () {
            return this._data.userId;
        };
        _UserDataMgr.prototype.getHeadImgUrl = function () {
            return this._data.headImgUrl;
        };
        _UserDataMgr.prototype.getNickName = function () {
            return this._data.nickName;
        };
        _UserDataMgr.prototype.getSex = function () {
            return this._data.sex;
        };
        _UserDataMgr.prototype.getUserRole = function () {
            return this._data.userRole;
        };
        _UserDataMgr.prototype.getLoginType = function () {
            return this._data.loginType;
        };
        _UserDataMgr.prototype.getIp = function () {
            return this._data.ip;
        };
        _UserDataMgr.prototype.getExpiresIn = function () {
            return this._data.expiresIn;
        };
        _UserDataMgr.prototype.isNewPlayer = function () {
            return this.getUserRole() === 999;
        };
        _UserDataMgr.prototype.isEmpty = function () {
            return Object.keys(this._data).length === 0;
        };
        _UserDataMgr.prototype.accessTokenOverdue = function () {
            var timenow = new Date().getTime();
            return timenow <= this._data.expiresIn;
        };
        _UserDataMgr.prototype.setAllData = function (data) {
            this._data = data;
        };
        _UserDataMgr.prototype.writeStorage = function (loginType) {
            var saveKey = falcon.configMgr.getConfig().appid + "_userData_" + loginType;
            var data = JSON.stringify(this._data);
            console.log("-->>writeStorage", falcon.configMgr.getConfig().appid, saveKey, data);
            window['cc'].sys.localStorage.setItem(saveKey, data);
        };
        _UserDataMgr.prototype.readStorage = function (loginType) {
            var saveKey = falcon.configMgr.getConfig().appid + "_userData_" + loginType;
            var data = window['cc'].sys.localStorage.getItem(saveKey);
            console.log("--nsdk>>>readStorage", falcon.configMgr.getConfig().appid, saveKey, data);
            if (data) {
                return JSON.parse(data);
            }
            return data;
        };
        _UserDataMgr.prototype.clearByType = function (loginType) {
            console.log("--nsdk>>>clearByType", falcon.configMgr.getConfig().appid, loginType);
            var saveKey = falcon.configMgr.getConfig().appid + "_userData_" + loginType;
            window['cc'].sys.localStorage.setItem(saveKey, null);
        };
        ;
        _UserDataMgr.prototype.clear = function () {
            this._data = {};
            _UserDataMgr.prototype.clearByType("phone");
            _UserDataMgr.prototype.clearByType("wechat");
            _UserDataMgr.prototype.clearByType("guest");
        };
        ;
        _UserDataMgr._instance = new _UserDataMgr();
        return _UserDataMgr;
    }());
    falcon._UserDataMgr = _UserDataMgr;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var _GGMgr = (function () {
        function _GGMgr() {
            if (_GGMgr._instance) {
                throw new Error("Error: Instantiation failed: Use SingletonDemo.getInstance() instead of new.");
            }
            _GGMgr._instance = this;
        }
        _GGMgr.getInstance = function () {
            return _GGMgr._instance;
        };
        _GGMgr.prototype.getItemAct = function (itemType, baseurl) {
            var _this = this;
            return new Promise(function (ret, rej) {
                var act = "takePart";
                var param = {
                    gid: falcon.userMgr.getGid(),
                    itemType: itemType,
                    serverId: falcon.configMgr.getConfig().appid
                };
                var url = baseurl + act;
                falcon.XhrHttp.post(url, param, {
                    header: falcon.XhrHttp.getInterfHeader(falcon.configMgr.getConfig().appid, falcon.HttpMethod.POST, url, falcon.userMgr.getGid(), falcon.userMgr.getAccessToken())
                }, function (issuc, resp) {
                    _this.chk_httpreq(issuc, resp, ret, rej);
                }, {
                    tryTimes: 5
                });
            });
        };
        _GGMgr.prototype.chk_httpreq = function (issuc, resp, ret, rej) {
            return __awaiter(this, void 0, void 0, function () {
                var data;
                return __generator(this, function (_a) {
                    if (!issuc) {
                        if (rej) {
                            rej(resp);
                        }
                        return [2];
                    }
                    try {
                        data = JSON.parse(resp);
                        if (ret) {
                            ret(data);
                        }
                    }
                    catch (e) {
                        if (rej) {
                            rej(e.stack);
                        }
                    }
                    return [2];
                });
            });
        };
        _GGMgr._instance = new _GGMgr();
        return _GGMgr;
    }());
    falcon._GGMgr = _GGMgr;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var _UcMgr = (function () {
        function _UcMgr() {
            if (_UcMgr._instance) {
                throw new Error("Error: Instantiation failed: Use SingletonDemo.getInstance() instead of new.");
            }
            _UcMgr._instance = this;
        }
        _UcMgr.getInstance = function () {
            return _UcMgr._instance;
        };
        _UcMgr.prototype.getTravelTokenV1 = function (openId, baseurl) {
            var _this = this;
            console.log('------游客登录键值：-----', falcon.configMgr.getConfig().appid + "_openId_" + openId);
            console.log("openId：", openId);
            return new Promise(function (ret, rej) {
                var act = "login/guest";
                var cfg = falcon.configMgr.getConfig();
                var param = {
                    appId: cfg.appid,
                    openId: openId,
                    deviceId: cfg.deviceid,
                    deviceType: cfg.devicetype,
                    clientType: cfg.clientType,
                    chId: cfg.chId,
                    subChId: cfg.subChId,
                    idfa: cfg.idfa,
                    imei: cfg.android.imei,
                    androidId: cfg.android.androidId,
                    mac: cfg.android.mac,
                    oaid: cfg.android.oaid,
                    uuid: cfg.uuid || ""
                };
                var url = falcon.XhrHttp.crtUrlWithParms(baseurl, act, param);
                falcon.XhrHttp.get(url, {
                    header: falcon.XhrHttp.getInterfHeader(cfg.appid, falcon.HttpMethod.GET, url)
                }, function (issuc, resp) {
                    _this.chk_httpreq(issuc, resp, ret, rej);
                }, {
                    tryTimes: 5
                });
            });
        };
        _UcMgr.prototype.getTravelToken = function (username, baseurl) {
            var _this = this;
            console.log('------游客登录键值：-----', falcon.configMgr.getConfig().appid + "_openId_" + username);
            var openId = localStorage.getItem(falcon.configMgr.getConfig().appid + "_openId_" + username);
            openId = openId || "";
            console.log("openId：", openId);
            return new Promise(function (ret, rej) {
                var act = "login/guest";
                var cfg = falcon.configMgr.getConfig();
                var param = {
                    appId: cfg.appid,
                    openId: openId,
                    deviceId: cfg.deviceid,
                    deviceType: cfg.devicetype,
                    clientType: cfg.clientType,
                    chId: cfg.chId,
                    subChId: cfg.subChId,
                    idfa: cfg.idfa,
                    imei: cfg.android.imei,
                    androidId: cfg.android.androidId,
                    mac: cfg.android.mac,
                    oaid: cfg.android.oaid,
                    uuid: cfg.uuid || ""
                };
                var url = falcon.XhrHttp.crtUrlWithParms(baseurl, act, param);
                falcon.XhrHttp.get(url, {
                    header: falcon.XhrHttp.getInterfHeader(cfg.appid, falcon.HttpMethod.GET, url)
                }, function (issuc, resp) {
                    try {
                        if (issuc) {
                            var respData = JSON.parse(resp);
                            if (respData && respData.data) {
                                if (respData.data.openId) {
                                    localStorage.setItem(falcon.configMgr.getConfig().appid + "_openId_" + username, respData.data.openId);
                                }
                            }
                            else {
                                localStorage.removeItem(falcon.configMgr.getConfig().appid + "_openId_" + username);
                            }
                        }
                        else {
                            console.error("\u8BF7\u6C42\u6E38\u5BA2\u767B\u5F55\u5931\u8D25");
                        }
                    }
                    catch (err) {
                        console.error(err.stack);
                    }
                    _this.chk_httpreq(issuc, resp, ret, rej);
                }, {
                    tryTimes: 5
                });
            });
        };
        _UcMgr.prototype.getWxLoginData = function (openId, unionId, accessToken, refreshToken, baseUrl) {
            var _this = this;
            return new Promise(function (ret, rej) {
                var act = "/uc/v2/login/wechat";
                var cfg = falcon.configMgr.getConfig();
                var param = {
                    appId: cfg.appid,
                    openId: openId,
                    unionId: unionId,
                    wechatAccessToken: accessToken,
                    wechatRefreshToken: refreshToken,
                    deviceId: cfg.deviceid,
                    deviceType: cfg.devicetype,
                    clientType: cfg.clientType,
                    chId: cfg.chId,
                    subChId: cfg.subChId,
                    idfa: cfg.idfa,
                    imei: cfg.android.imei,
                    androidId: cfg.android.androidId,
                    mac: cfg.android.mac,
                    oaid: cfg.android.oaid,
                    uuid: cfg.uuid
                };
                var url = falcon.XhrHttp.crtUrlWithParms(baseUrl, act, param);
                falcon.XhrHttp.get(url, {
                    header: falcon.XhrHttp.getInterfHeader(cfg.appid, falcon.HttpMethod.GET, url)
                }, function (issuc, resp) {
                    _this.chk_httpreq(issuc, resp, ret, rej);
                }, {
                    tryTimes: 5
                });
            });
        };
        _UcMgr.prototype.getPhoneLoginData = function (phoneNum, confirmCode, baseUrl) {
            var _this = this;
            return new Promise(function (ret, rej) {
                var cfg = falcon.configMgr.getConfig();
                var act = "/uc/v1/login/phone";
                var param = {
                    appId: cfg.appid,
                    mobilePhone: phoneNum,
                    nation: "86",
                    captcha: confirmCode,
                    deviceId: cfg.deviceid,
                    deviceType: cfg.devicetype,
                    clientType: cfg.clientType,
                    chId: cfg.chId,
                    subChId: cfg.subChId,
                    idfa: cfg.idfa,
                    imei: cfg.android.imei,
                    androidId: cfg.android.androidId,
                    mac: cfg.android.mac,
                    oaid: cfg.android.oaid,
                    uuid: cfg.uuid
                };
                var url = falcon.XhrHttp.crtUrlWithParms(baseUrl, act, param);
                falcon.XhrHttp.get(url, {
                    header: falcon.XhrHttp.getInterfHeader(cfg.appid, falcon.HttpMethod.GET, url)
                }, function (issuc, resp) {
                    _this.chk_httpreq(issuc, resp, ret, rej);
                }, {
                    tryTimes: 5
                });
            });
        };
        _UcMgr.prototype.refreshToken = function (baseurl) {
            var _this = this;
            return new Promise(function (ret, rej) {
                var baseUrl = baseurl;
                var act = "/uc/v1/token";
                var param = {
                    gid: falcon.userMgr.getGid(),
                    refreshToken: falcon.userMgr.getRefreshToken()
                };
                var url = falcon.XhrHttp.crtUrlWithParms(baseUrl, act, param);
                falcon.XhrHttp.get(url, {
                    header: falcon.XhrHttp.getInterfHeader(falcon.configMgr.getConfig().appid, falcon.HttpMethod.GET, url, falcon.userMgr.getGid())
                }, function (issuc, resp) {
                    return __awaiter(_this, void 0, void 0, function () {
                        var result, sLoginData, err_6, err_7;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    if (!issuc) return [3, 12];
                                    _a.label = 1;
                                case 1:
                                    _a.trys.push([1, 10, , 11]);
                                    result = JSON.parse(resp);
                                    console.log("refreshUCUserAccessToken获取的最新数据", result);
                                    if (!(result && result.errCode == 0 && result.data)) return [3, 8];
                                    falcon.userMgr.setAccessToken(result.data.accessToken);
                                    falcon.userMgr.setRefreshToken(result.data.refreshToken);
                                    falcon.userMgr.setAccessTokenRefreshTime(Math.floor(Date.now() / 1000));
                                    falcon.userMgr.writeStorage(falcon.userMgr.getLoginType());
                                    _a.label = 2;
                                case 2:
                                    _a.trys.push([2, 6, , 7]);
                                    if (!(window['storage'] && window['storage'].getStorageInfoSync)) return [3, 5];
                                    return [4, window['storage'].getStorageInfoSync("loginData")];
                                case 3:
                                    sLoginData = (_a.sent());
                                    if (sLoginData) {
                                        sLoginData.accessToken = result.data.accessToken;
                                        sLoginData.refreshToken = result.data.refreshToken;
                                    }
                                    return [4, window['storage'].setStorageSync("loginData", sLoginData)];
                                case 4:
                                    _a.sent();
                                    _a.label = 5;
                                case 5: return [3, 7];
                                case 6:
                                    err_6 = _a.sent();
                                    console.error("刷新refreshToken成功后，数据保存失败：", err_6);
                                    return [3, 7];
                                case 7:
                                    ret(result.data);
                                    return [3, 9];
                                case 8:
                                    rej(result.errDesc);
                                    _a.label = 9;
                                case 9: return [3, 11];
                                case 10:
                                    err_7 = _a.sent();
                                    console.log("refreshUCUserAccessToken is null", err_7);
                                    rej("");
                                    return [3, 11];
                                case 11: return [3, 13];
                                case 12:
                                    console.log("refreshUCUserAccessToken请求失败");
                                    rej("netclose");
                                    _a.label = 13;
                                case 13: return [2];
                            }
                        });
                    });
                }, {
                    tryTimes: 5
                });
            });
        };
        _UcMgr.prototype.chk_httpreq = function (issuc, resp, ret, rej) {
            if (!issuc) {
                rej && rej(resp);
                return;
            }
            try {
                var data = JSON.parse(resp);
                ret && ret(data);
            }
            catch (e) {
                rej && rej(e.stack);
            }
        };
        _UcMgr._instance = new _UcMgr();
        return _UcMgr;
    }());
    falcon._UcMgr = _UcMgr;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var _AssetMgr = (function () {
        function _AssetMgr() {
            if (_AssetMgr._instance) {
                throw new Error("Error: Instantiation failed: Use SingletonDemo.getInstance() instead of new.");
            }
            _AssetMgr._instance = this;
        }
        _AssetMgr.getInstance = function () {
            return _AssetMgr._instance;
        };
        _AssetMgr.prototype.getAsset = function (baseurl) {
            var _this = this;
            return new Promise(function (ret, rej) {
                var act = falcon.userMgr.getGid().toString();
                var url = baseurl + act;
                falcon.XhrHttp.get(url, {
                    header: falcon.XhrHttp.getInterfHeader(falcon.configMgr.getConfig().appid, falcon.HttpMethod.GET, url, falcon.userMgr.getGid(), falcon.userMgr.getAccessToken())
                }, function (issuc, resp) {
                    _this.chk_httpreq(issuc, resp, ret, rej);
                }, {
                    tryTimes: 5
                });
            });
        };
        _AssetMgr.prototype.chk_httpreq = function (issuc, resp, ret, rej) {
            return __awaiter(this, void 0, void 0, function () {
                var data;
                return __generator(this, function (_a) {
                    if (!issuc) {
                        if (rej) {
                            rej(resp);
                        }
                        return [2];
                    }
                    try {
                        data = JSON.parse(resp);
                        if (ret) {
                            ret(data);
                        }
                    }
                    catch (e) {
                        if (rej) {
                            rej(e.stack);
                        }
                    }
                    return [2];
                });
            });
        };
        _AssetMgr._instance = new _AssetMgr();
        return _AssetMgr;
    }());
    falcon._AssetMgr = _AssetMgr;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    var _LoginMgr = (function () {
        function _LoginMgr() {
            if (_LoginMgr._instance) {
                throw new Error("Error: Instantiation failed: Use SingletonDemo.getInstance() instead of new.");
            }
            _LoginMgr._instance = this;
        }
        _LoginMgr.getInstance = function () {
            return _LoginMgr._instance;
        };
        _LoginMgr.prototype.startQueue = function (promises) {
            return __awaiter(this, void 0, void 0, function () {
                var _this = this;
                return __generator(this, function (_a) {
                    if (!promises || promises.length === 0) {
                        return [2];
                    }
                    promises.forEach(function (value) {
                        return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4, value];
                                    case 1:
                                        _a.sent();
                                        return [2];
                                }
                            });
                        });
                    });
                    return [2];
                });
            });
        };
        _LoginMgr.prototype.setUserInfo = function (data, loginType) {
            falcon.userMgr.setNickName(falcon.Utils.decodeURIComponent(data.nickName));
            if (data.name) {
                falcon.userMgr.setNickName(falcon.Utils.decodeURIComponent(data.name));
            }
            falcon.userMgr.setSex(data.sex);
            falcon.userMgr.setExpiresIn(data.expiresIn);
            falcon.userMgr.setHeadImgUrl(falcon.Utils.decodeURIComponent(data.headImgUrl));
            if (data.headUrl) {
                falcon.userMgr.setHeadImgUrl(falcon.Utils.decodeURIComponent(data.headUrl));
            }
            falcon.userMgr.setAccessToken(data.accessToken);
            falcon.userMgr.setRefreshToken(data.refreshToken);
            falcon.userMgr.setActiveGame(data.activeGame);
            falcon.userMgr.setGid(data.gid);
            falcon.userMgr.setLastLoginTime(data.lastLoginTime);
            falcon.userMgr.setRegTime(data.regTime);
            falcon.userMgr.setUserId(data.userId);
            falcon.userMgr.setIp(data.userIp);
            falcon.userMgr.setUserRole(data.userRole);
            falcon.userMgr.setUnionId(data.unionId);
            falcon.userMgr.setOpenId(data.openId);
            falcon.userMgr.setAccessTokenRefreshTime(data.accessTokenRefreshTime || Math.floor(Date.now() / 1000));
            falcon.userMgr.setRefreshTokenRefreshTime(data.refreshTokenRefreshTime || Math.floor(Date.now() / 1000));
            falcon.userMgr.setLoginType(loginType);
        };
        _LoginMgr.prototype.travelLoginV1 = function (openId, baseurl) {
            return __awaiter(this, void 0, void 0, function () {
                var _this = this;
                return __generator(this, function (_a) {
                    this._username = openId;
                    console.log('--------游客登录用户名--------：', openId);
                    return [2, new Promise(function (resolve, reject) {
                        return __awaiter(_this, void 0, void 0, function () {
                            var userInfo, err_8;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        _a.trys.push([0, 2, , 3]);
                                        return [4, falcon._UcMgr.getInstance().getTravelTokenV1(openId, baseurl)];
                                    case 1:
                                        userInfo = _a.sent();
                                        if (userInfo.errCode === 0) {
                                            userInfo.data.ip;
                                            this.setUserInfo(userInfo.data, 'guest');
                                            resolve(userInfo);
                                        }
                                        else {
                                            resolve(userInfo);
                                        }
                                        return [3, 3];
                                    case 2:
                                        err_8 = _a.sent();
                                        reject(err_8);
                                        return [3, 3];
                                    case 3: return [2];
                                }
                            });
                        });
                    })];
                });
            });
        };
        _LoginMgr.prototype.travelLogin = function (username, baseurl) {
            return __awaiter(this, void 0, void 0, function () {
                var _this = this;
                return __generator(this, function (_a) {
                    this._username = username;
                    console.log('--------游客登录用户名--------：', username);
                    return [2, new Promise(function (resolve, reject) {
                        return __awaiter(_this, void 0, void 0, function () {
                            var userInfo, err_9;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        _a.trys.push([0, 2, , 3]);
                                        return [4, falcon._UcMgr.getInstance().getTravelToken(username, baseurl)];
                                    case 1:
                                        userInfo = _a.sent();
                                        if (userInfo.errCode === 0) {
                                            userInfo.data.ip;
                                            this.setUserInfo(userInfo.data, 'guest');
                                            resolve(userInfo);
                                        }
                                        else {
                                            resolve(userInfo);
                                        }
                                        return [3, 3];
                                    case 2:
                                        err_9 = _a.sent();
                                        reject(err_9);
                                        return [3, 3];
                                    case 3: return [2];
                                }
                            });
                        });
                    })];
                });
            });
        };
        _LoginMgr.prototype.clearTravalLoginInfo = function () {
            localStorage.removeItem(falcon.configMgr.getConfig().appid + "_openId_" + this._username);
            console.log("清除后缓存游客OpenID数据：", falcon.configMgr.getConfig().appid + "_openId_" + this._username, localStorage.getItem(falcon.configMgr.getConfig().appid + "_openId_" + this._username));
        };
        _LoginMgr.prototype.wxLogin = function (openId, unionId, accessToken, refreshToken, baseUrl) {
            return __awaiter(this, void 0, void 0, function () {
                var _this = this;
                return __generator(this, function (_a) {
                    return [2, new Promise(function (resolve, reject) {
                        return __awaiter(_this, void 0, void 0, function () {
                            var userInfo, err_10;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        _a.trys.push([0, 2, , 3]);
                                        return [4, falcon._UcMgr.getInstance().getWxLoginData(openId, unionId, accessToken, refreshToken, baseUrl)];
                                    case 1:
                                        userInfo = _a.sent();
                                        if (userInfo.errCode === 0) {
                                            this.setUserInfo(userInfo.data, 'wechat');
                                            resolve(userInfo);
                                        }
                                        else {
                                            resolve(userInfo);
                                        }
                                        return [3, 3];
                                    case 2:
                                        err_10 = _a.sent();
                                        reject(err_10);
                                        return [3, 3];
                                    case 3: return [2];
                                }
                            });
                        });
                    })];
                });
            });
        };
        _LoginMgr.prototype.phoneLogin = function (phoneNum, confirmCode, baseUrl, isMessageLogin) {
            return __awaiter(this, void 0, void 0, function () {
                var _this = this;
                return __generator(this, function (_a) {
                    return [2, new Promise(function (resolve, reject) {
                        return __awaiter(_this, void 0, void 0, function () {
                            var userInfo, err_11;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        _a.trys.push([0, 2, , 3]);
                                        return [4, falcon._UcMgr.getInstance().getPhoneLoginData(phoneNum, confirmCode, baseUrl)];
                                    case 1:
                                        userInfo = _a.sent();
                                        if (userInfo.errCode === 0) {
                                            this.setUserInfo(userInfo.data, isMessageLogin ? 'phone' : 'wechat');
                                            resolve(userInfo);
                                        }
                                        else {
                                            resolve(userInfo);
                                        }
                                        return [3, 3];
                                    case 2:
                                        err_11 = _a.sent();
                                        reject(err_11);
                                        return [3, 3];
                                    case 3: return [2];
                                }
                            });
                        });
                    })];
                });
            });
        };
        _LoginMgr._instance = new _LoginMgr();
        return _LoginMgr;
    }());
    falcon._LoginMgr = _LoginMgr;
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    falcon.logger = new falcon._Logger("root");
    var sysout_h = new falcon.SysoutHandler();
    sysout_h.setFmter("[falcon_js]");
    falcon.logger.addHandler(sysout_h);
    falcon.logger.setLogLevel(falcon.ELOGLEVEL.DEBUG);
    falcon.netChan = falcon._NetChan.getInstance();
    falcon.configMgr = falcon._FalconConfigMgr.getInstance();
    falcon.userMgr = falcon._UserDataMgr.getInstance();
    falcon.ggMgr = falcon._GGMgr.getInstance();
    falcon.loginMgr = falcon._LoginMgr.getInstance();
    falcon.assetMgr = falcon._AssetMgr.getInstance();
    falcon.ucMgr = falcon._UcMgr.getInstance();
})(falcon || (falcon = {}));
var falcon;
(function (falcon) {
    window['falcon'] = falcon;
})(falcon || (falcon = {}));
