var env;
(function (env) {
    /** 是否是原生环境 */
    env.isNative = window['jsb'] &&
        window['jsb'].reflection &&
        window['cc'] &&
        window['cc'].sys &&
        window['cc'].sys.isNative;
    /** 是否是原生IOS环境 */
    env.isNativeIOS = env.isNative && window['cc'].sys.os == window['cc'].sys.OS_IOS;
    /** 是否是原生Andorid环境 */
    env.isNativeAndroid = env.isNative && window['cc'].sys.os == window['cc'].sys.OS_ANDROID;
})(env || (env = {}));
var _callbackId = 1;
var _callbacks = {};
/**
 *  用于与原生通讯的另外一种方式
 * @param {{errCode:number,errDesc:string,callbackId:number,data:{[key:string]:any}}} receivedMsg
 */
window['receivedFromApp'] = function (receivedMsg) {
    if (!receivedMsg) {
        console.error("接收的消息字符串不能为空");
        return;
    }
    try {
        var errCode = receivedMsg.errCode, callbackId = receivedMsg.callbackId, data = receivedMsg.data;
        /** 方法名 */
        if (callbackId) {
            //获取回调函数数据,Creator项目Console的消息没有进来，Creator项目其它消息进来了
            //将Creator其它消息返回给H5
            var _a = _callbacks[callbackId], callback = _a.callback, messageId = _a.messageId;
            if (callback) {
                //只有排除console之外的接口走这儿，console接口返回不走这儿
                if (env.isNative) {
                    _callbacks[callbackId] = { callback: callback, messageId: "console" };
                    //调用原生方法
                    callStaticMethod(JSON.stringify({ callbackId: callbackId, messageId: "console", data: { level: errCode === 0 ? "debug" : "error", message: [data], path: 1, sourceMessageId: messageId } }));
                }
                callback(data);
            }
            else {
                console.error("没有找到对应的函数");
            }
        }
        else {
            console.error("\u8FD4\u56DE\u7684" + callbackId + "\u4E0D\u5B58\u5728\uFF01");
        }
    }
    catch (err) {
        console.error("解析原生返回的数据有bug：", err.stack);
    }
};
/**
 * 发送消息给原生
 * @private
 */
function sendToApp() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var len = arguments.length;
    var messageId = arguments[0]; //消息号
    var data = len === 2 ? {} : arguments[1]; //消息体
    var callback = len === 2 ? arguments[1] : arguments[2]; //回调函数
    if (!messageId) {
        !env.isNative && console.error("消息号不能为空！");
        return;
    }
    if (typeof messageId !== "string") {
        !env.isNative && console.error("消息号只能为字符串！");
    }
    //获取当前的回调id
    var callbackId = getCallbackId();
    //这里只有IOS原生包支持
    if (env.isNative) {
        //输出日志
        if (messageId === "console") {
            //从Creator向H5发送消息
            if (env.isNative) {
                _callbacks[callbackId] = { callback: callback, messageId: "console" };
                //调用原生方法
                callStaticMethod(JSON.stringify({ callbackId: callbackId, messageId: "console", data: data }));
            }
        }
        else {
            //输出日志传给原生
            _callbacks[callbackId] = { callback: callback, messageId: "console" };
            //调用原生方法
            callStaticMethod(JSON.stringify({ callbackId: callbackId, messageId: "console", data: { level: "info", message: [data], path: 2, sourceMessageId: messageId } }));
            //指令传给原生
            _callbacks[callbackId] = { callback: callback, messageId: messageId };
            //调用原生方法
            callStaticMethod(JSON.stringify({ callbackId: callbackId, messageId: messageId, data: data }));
        }
    }
    else {
        //网页里面输出
        var sendData = Object.assign({ callbackId: callbackId, messageId: messageId }, { data: data });
        console.log("【H5->APP】", sendData);
    }
}
/**
 * 获取消息ID
 */
function getCallbackId() {
    return _callbackId++;
}
/**
 * 调用原生静态方法
 * @param data 传给原生的数据
 */
function callStaticMethod(data) {
    if (window['jsb'] && window['jsb'].reflection && window['jsb'].reflection.callStaticMethod) {
        if (env.isNativeIOS) {
            window['jsb'].reflection.callStaticMethod("AppDelegate", "receivedFromH5:", data);
        }
        else if (env.isNativeAndroid) {
            window['jsb'].reflection.callStaticMethod("com/protostar/libcocoscreator2dx/tsinterface/AppDelegate", "receivedFromH5", "(Ljava/lang/String;)V", data);
        }
    }
}
window['sendToApp'] = sendToApp;
/**
 * 广告SDK,包括：
 * 1、banner广告
 * 2、激励视频广告
 * 3、插屏广告
 */
var ad;
(function (ad) {
    /**
      * 创建banner广告
     * @param  x 水平坐标
     * @param  y 垂直坐标
     * @param  width 宽
     * @param  height 高
     * @param callback 回调
     */
    function createBannerAd(x, y, width, height, callback) {
        sendToApp("createBannerAd", { x: x, y: y, width: width, height: height }, callback);
    }
    ad.createBannerAd = createBannerAd;
    /**
     * 创建激励视频广告
     * @param  id 广告id
     * @param  callback
     */
    function createRewardedVideoAd(id, callback) {
        sendToApp("createRewardedVideoAd", { id: id }, function (data) {
            callback(data);
        });
    }
    ad.createRewardedVideoAd = createRewardedVideoAd;
    /**
     * 创建插屏广告
     * @param id 广告id
     * @param  callback
     */
    function createInterstitialAd(id, callback) {
        sendToApp("createInterstitialAd", { id: id }, function (data) {
            callback && callback(data);
        });
    }
    ad.createInterstitialAd = createInterstitialAd;
    /**
     * 创建信息流广告
     * @param  x 水平坐标
     * @param  y 垂直坐标
     * @param  width 宽
     * @param  height 高
     * @param callback 回调
     */
    function createInformationFlowAd(x, y, width, height, callback) {
        sendToApp("createInformationFlowAd", { x: x, y: y, width: width, height: height }, callback);
    }
    ad.createInformationFlowAd = createInformationFlowAd;
    /**
     * 创建信息流误点击
     * @param x 水平坐标
     * @param y 垂直坐标
     * @param width 宽
     * @param height 高
     * @param cx 关闭坐标水平坐标
     * @param cy 关闭坐标垂直坐标
     * @param cwidth 关闭坐标宽
     * @param cheight 关闭坐标高
     * @param callback 回调
     */
    function createInformationFlowCasualClick(x, y, width, height, cx, cy, cwidth, cheight, callback) {
        sendToApp("createInformationFlowCasualClick", { x: x, y: y, width: width, height: height, cx: cx, cy: cy, cwidth: cwidth, cheight: cheight }, callback);
    }
    ad.createInformationFlowCasualClick = createInformationFlowCasualClick;
    /**
     * 关闭信息流广告
     */
    function closeInformationFlowAd() {
        return new Promise(function (c, e) {
            sendToApp("closeInformationFlowAd", function (data) {
                c(data);
            });
        });
    }
    ad.closeInformationFlowAd = closeInformationFlowAd;
    /**
     * 关闭banner广告
     */
    function closeBannerAd() {
        return new Promise(function (c, e) {
            sendToApp("closeBannerAd", function (data) {
                c(data);
            });
        });
    }
    ad.closeBannerAd = closeBannerAd;
})(ad || (ad = {}));
/** appstore相关 */
var appstore;
(function (appstore) {
    /**
     * 跳转到appstore
     * @param appid
     */
    function onDownloadFromAppStore(appid) {
        return new Promise(function (c, e) {
            sendToApp("onDownloadFromAppStore", { appid: appid }, function (data) {
                c(data);
            });
        });
    }
    appstore.onDownloadFromAppStore = onDownloadFromAppStore;
})(appstore || (appstore = {}));
var authority;
(function (authority) {
    /**
     * 请求日历权限
     */
    function requestCalendarAuthority() {
        return new Promise(function (c, e) {
            sendToApp("requestCalendarAuthority", function (data) {
                c(data);
            });
        });
    }
    authority.requestCalendarAuthority = requestCalendarAuthority;
    /**
     * 请求地址权限
     */
    function requestLocationAuthority() {
        return new Promise(function (c, e) {
            sendToApp("requestLocationAuthority", function (data) {
                c(data);
            });
        });
    }
    authority.requestLocationAuthority = requestLocationAuthority;
    /**
     * 请求相册权限
     */
    function requestPhotoAuthority() {
        return new Promise(function (c, e) {
            sendToApp("requestPhotoAuthority", function (data) {
                c(data);
            });
        });
    }
    authority.requestPhotoAuthority = requestPhotoAuthority;
    /**
     * 请求通知权限
     */
    function requestNotificationsAuthority() {
        return new Promise(function (c, e) {
            sendToApp("requestNotificationsAuthority", function (data) {
                c(data);
            });
        });
    }
    authority.requestNotificationsAuthority = requestNotificationsAuthority;
})(authority || (authority = {}));
/**
 * 电池接口
 */
var battery;
(function (battery) {
    /**
     * 获取电池数据信息
     */
    function getBatteryInfo() {
        return new Promise(function (c, e) {
            sendToApp("getBatteryInfo", function (data) {
                c(data);
            });
        });
    }
    battery.getBatteryInfo = getBatteryInfo;
})(battery || (battery = {}));
var bugly;
(function (bugly) {
    /**
     * 处理上报给bugly错误功能
     * @param level 日志等级
     * @param str 日志数据
     */
    function buglyLog(level, str) {
        return new Promise(function (c, e) {
            sendToApp("buglyLog", { level: level, str: str }, function (data) {
                c(data);
            });
        });
    }
    bugly.buglyLog = buglyLog;
})(bugly || (bugly = {}));
/**
 * 处理原生缓存
 */
var cache;
(function (cache) {
    /**
     * 清除缓存
     */
    function clearCache() {
        return new Promise(function (c, e) {
            sendToApp("clearCache", function (data) {
                c(data);
            });
        });
    }
    cache.clearCache = clearCache;
})(cache || (cache = {}));
/**
 * 与原生交互的创蓝相关SDK
 * 1、初始化创蓝服务
 * 2、弹出手机号一键登录面板
 * @see http://wiki.xianlai.ren/pages/viewpage.action?pageId=86081541
 * @see http://wiki.xianlai.ren/pages/viewpage.action?pageId=22886835#id-%E3%80%90%E5%90%8E%E7%AB%AF%E3%80%91%E4%B8%AA%E4%BA%BA%E4%B8%AD%E5%BF%83%E6%8E%A5%E5%8F%A3%E6%96%87%E6%A1%A3-%E4%BA%8C%E5%8D%81%E4%BA%8C%E3%80%81%E5%BF%AB%E9%80%9F%E7%99%BB%E5%BD%95%EF%BC%88%E4%BD%BF%E7%94%A8%E7%AC%AC%E4%B8%89%E6%96%B9%E6%95%B0%E6%8D%AE%E7%99%BB%E5%BD%95%EF%BC%89
 */
var chuanglan;
(function (chuanglan) {
    /**
     * 初始化创蓝服务
     * @version 1.3.0
     * @returns 初始化创蓝是否成功
     */
    function initializeChuanglan() {
        return new Promise(function (c, e) {
            sendToApp("initializeChuanglan", function (data) {
                c(data);
            });
        });
    }
    chuanglan.initializeChuanglan = initializeChuanglan;
    /**
     * 弹出一键登录窗口
     * @param type 0:微信登录 1：手机号登录
     * @param callback 四种状态：onshow：面板弹出，onFastLogin：一键登录，onPhoneLogin：手机号登录，onClose:关闭 status:0为成功，1为失败
     * @version 1.3.0
     */
    function popupLoginWindow(type, callback) {
        sendToApp("popupLoginWindow", { type: type }, function (data) {
            callback(data);
        });
    }
    chuanglan.popupLoginWindow = popupLoginWindow;
})(chuanglan || (chuanglan = {}));
var clipboard;
(function (clipboard) {
    /**
     * 剪切板
     * 设置系统剪贴板的内容。调用成功后，会弹出 toast 提示"内容已复制"，持续 1.5s
     * @param copyStr 拷贝的数据
     */
    function setClipboardData(copyStr) {
        return new Promise(function (c, e) {
            sendToApp("setClipboardData", { copyStr: copyStr }, function (data) {
                c(data);
            });
        });
    }
    clipboard.setClipboardData = setClipboardData;
    /**
     * 获取剪切版内容
     * @returns  返回获取的剪切版数据
     */
    function getClipboardData() {
        return new Promise(function (c, e) {
            sendToApp("getClipboardData", function (data) {
                c(data);
            });
        });
    }
    clipboard.getClipboardData = getClipboardData;
})(clipboard || (clipboard = {}));
var device;
(function (device) {
    /**
     * 监听横竖屏切换事件
     * portrait：竖屏
     * landscape：横屏正方向，以 HOME 键在屏幕右侧为正方向
     * landscapeReverse：横屏反方向，以 HOME 键在屏幕左侧为反方向
     */
    function onDeviceOrientationChange() {
        return new Promise(function (c, e) {
            sendToApp("onDeviceOrientationChange", function (data) {
                c(data);
            });
        });
    }
    device.onDeviceOrientationChange = onDeviceOrientationChange;
})(device || (device = {}));
var download;
(function (download) {
    /**
     * 下载文件资源到本地。客户端直接发起一个 HTTPS GET 请求
     * @param  url
     * @param  header
     * @param  timeout
     * @param  filePath
    */
    function downloadFile(url, header, timeout, filePath) {
        return new Promise(function (c, e) {
            sendToApp("downloadFile", { url: url, header: header, timeout: timeout, filePath: filePath }, function (data) {
                c(data);
            });
        });
    }
    download.downloadFile = downloadFile;
})(download || (download = {}));
/**
 * 安装相关处理
 */
var install;
(function (install) {
    /**
     * 检测微信是否安装
     */
    function checkWxInstall() {
        return new Promise(function (c, e) {
            sendToApp("checkWxInstall", function (data) {
                c(data);
            });
        });
    }
    install.checkWxInstall = checkWxInstall;
})(install || (install = {}));
var lifeCycle;
(function (lifeCycle) {
    /**
     * 进入前台时发生
     * @param callback
     */
    function onShow(callback) {
        sendToApp("onShow", callback);
    }
    lifeCycle.onShow = onShow;
    /**
     * 进入后台时发生
     * @param callback
     */
    function onHide(callback) {
        sendToApp("onHide", callback);
    }
    lifeCycle.onHide = onHide;
})(lifeCycle || (lifeCycle = {}));
var ioslocation;
(function (ioslocation) {
    /**
     * 获取当前的地理位置、速度。
     * 工具中定位模拟使用IP定位，可能会有一定误差。且工具目前仅支持 gcj02 坐标
     * @param type wgs84 返回 gps 坐标，gcj02
     * @param altitude 传入 true 会返回高度信息，由于获取高度需要较高精确度，会减慢接口返回速度
     * @param isHighAccuracy 开启高精度定位
     * @param highAccuracyExpireTime 高精度定位超时时间(ms)，指定时间内返回最高精度，该值3000ms以上高精度定位才有效果
    */
    function getLocation(type, altitude, isHighAccuracy, highAccuracyExpireTime) {
        return new Promise(function (c, e) {
            sendToApp("getLocation", { type: type, altitude: altitude, isHighAccuracy: isHighAccuracy, highAccuracyExpireTime: highAccuracyExpireTime }, function (data) {
                c(data);
            });
        });
    }
    ioslocation.getLocation = getLocation;
})(ioslocation || (ioslocation = {}));
/**
 * 处理日志上报及调试功能
 */
var log;
(function (log) {
    /**
     * 由于原生那边没有dom,而又需要日志调试功能
     * 通过原生将creator那边的日志发送日志webview中
     * @param level 日志级别
     * @param message 传输的日志
     */
    function console(level, message) {
        return new Promise(function (c, e) {
            sendToApp("console", { level: level, message: message }, function (data) {
                c(data);
            });
        });
    }
    log.console = console;
    /**
     * 此API用于日志webview里
     * 接收从creator那边传过来的日志
     * @param callback
     */
    function onConsoleReceived(callback) {
        sendToApp("onConsoleReceived", callback);
    }
    log.onConsoleReceived = onConsoleReceived;
})(log || (log = {}));
var network;
(function (network) {
    /**
     * 获取网络状态
     * @param callBack
     */
    function onObserveNetStatus(callBack) {
        sendToApp("onObserveNetStatus", function (response) {
            callBack(response);
        });
    }
    network.onObserveNetStatus = onObserveNetStatus;
})(network || (network = {}));
var push;
(function (push) {
    /**
     * push点击时触发 默认actionType:走点击,所以successCount字段不需要了
     * @param callback 原生返回值
     * @see http://wiki.xianlai.ren/pages/viewpage.action?pageId=25273699
     */
    function onPushClick(callback) {
        sendToApp("onPushClick", function (response) {
            callback(response);
        });
    }
    push.onPushClick = onPushClick;
})(push || (push = {}));
var iosscreen;
(function (iosscreen) {
    /**
     * 设置屏幕亮度
     * @param brightness 屏幕亮度值，范围 0 ~ 1。0 最暗，1 最亮
     */
    function setScreenBrightness(brightness) {
        return new Promise(function (c, e) {
            sendToApp("setScreenBrightness", { brightness: brightness }, function (data) {
                c(data);
            });
        });
    }
    iosscreen.setScreenBrightness = setScreenBrightness;
    /**
     * 获取屏幕亮度
     * @returns 屏幕亮度值，范围 0 ~ 1，0 最暗，1 最亮
     */
    function getScreenBrightness() {
        return new Promise(function (c, e) {
            sendToApp("getScreenBrightness", function (data) {
                c(data);
            });
        });
    }
    iosscreen.getScreenBrightness = getScreenBrightness;
    /**
     * 设置是否保持常亮状态。
     * @param  keepScreenOn 是否保持屏幕常亮
     */
    function setKeepScreenOn(keepScreenOn) {
        return new Promise(function (c, e) {
            sendToApp("setKeepScreenOn", { keepScreenOn: keepScreenOn }, function (data) {
                c(data);
            });
        });
    }
    iosscreen.setKeepScreenOn = setKeepScreenOn;
    /**
     * 监听用户主动截屏事件。用户使用系统截屏按键截屏时触发，只能注册一个监听
     */
    function onUserCaptureScreen() {
        return new Promise(function (c, e) {
            sendToApp("onUserCaptureScreen", function (data) {
                c(data);
            });
        });
    }
    iosscreen.onUserCaptureScreen = onUserCaptureScreen;
})(iosscreen || (iosscreen = {}));
/**
 * 处理分享
 */
var share;
(function (share) {
    /**
     * 分享给朋友、群
     * @param title 分享标题
     * @param desc 分享描述
     * @param link 分享链接
     * @param imgUrl 分享图标
     */
    function onMenuShareAppMessage(title, desc, link, imgUrl) {
        return new Promise(function (c, e) {
            sendToApp("onMenuShareAppMessage", { title: title, desc: desc, link: link, imgUrl: imgUrl }, function (data) {
                c(data);
            });
        });
    }
    share.onMenuShareAppMessage = onMenuShareAppMessage;
    /**
     * 分享给朋友、群
     * @param title 分享标题
     * @param desc 分享描述
     * @param link 分享链接
     * @param imgUrl 分享图标
     */
    function onSystemShareAppMessage(title, desc, link, imgUrl) {
        return new Promise(function (c, e) {
            sendToApp("onSystemShareAppMessage", { title: title, desc: desc, link: link, imgUrl: imgUrl }, function (data) {
                c(data);
            });
        });
    }
    share.onSystemShareAppMessage = onSystemShareAppMessage;
})(share || (share = {}));
var sm;
(function (sm) {
    /**
     * 数美相关sdk
     * @returns 唯一标识符
     */
    function getUniqueIdentifier() {
        return new Promise(function (c, e) {
            sendToApp("getUniqueIdentifier", function (data) {
                c(data);
            });
        });
    }
    sm.getUniqueIdentifier = getUniqueIdentifier;
})(sm || (sm = {}));
/**
 * 处理h5数据存储到原生
 */
var storage;
(function (storage) {
    /**
     * 从APP同步获取相应键值的数据
     * 区别不同的项目
     * @param  key 键值
     */
    function getStorageInfoSync(key) {
        key = window['appid'] ? "" + window['appid'] + key : key;
        return new Promise(function (c, e) {
            if (env.isNativeIOS) {
                sendToApp("getStorageInfoSync", { key: key }, function (data) {
                    c(data);
                });
            }
            else {
                var data = window['cc'].sys.localStorage.getItem(key);
                try {
                    data = JSON.parse(data);
                    c(data);
                }
                catch (err) {
                    c(data);
                }
            }
        });
    }
    storage.getStorageInfoSync = getStorageInfoSync;
    /**
     * 从APP同步移除相应的键值的数据
     * @param key 键值
     */
    function removeStorageSync(key) {
        key = window['appid'] ? "" + window['appid'] + key : key;
        return new Promise(function (c, e) {
            if (env.isNativeIOS) {
                sendToApp("removeStorageSync", { key: key }, function (data) {
                    c(data);
                });
            }
            else {
                window['cc'].sys.localStorage.removeItem(key);
                c(undefined);
            }
        });
    }
    storage.removeStorageSync = removeStorageSync;
    /**
     * 从APP同步设置相应键值的存储数据
     * @param key
     * @param value
     */
    function setStorageSync(key, value) {
        key = window['appid'] ? "" + window['appid'] + key : key;
        return new Promise(function (c, e) {
            if (env.isNativeIOS) {
                sendToApp("setStorageSync", { key: key, value: value }, function (data) {
                    c(data);
                });
            }
            else {
                //如果是字符串，
                var isObject = Object.prototype.toString.call(value) === '[object Object]';
                var svalue = void 0;
                try {
                    svalue = isObject ? JSON.stringify(value) : value;
                }
                catch (err) {
                    svalue = value;
                }
                window['cc'].sys.localStorage.setItem(key, svalue);
                c(undefined);
            }
        });
    }
    storage.setStorageSync = setStorageSync;
    /**
     * 从APP同步清除所有存储数据
     */
    function clearStorageSync() {
        return new Promise(function (c, e) {
            if (env.isNativeIOS) {
                sendToApp("clearStorageSync", function (data) {
                    c(data);
                });
            }
            else {
                window['cc'].sys.localStorage.clear();
                c(undefined);
            }
        });
    }
    storage.clearStorageSync = clearStorageSync;
})(storage || (storage = {}));
var system;
(function (system) {
    /**
     * 获取系统信息
    */
    function getSystemInfo() {
        return new Promise(function (c, e) {
            sendToApp("getSystemInfo", function (data) {
                c(data);
            });
        });
    }
    system.getSystemInfo = getSystemInfo;
})(system || (system = {}));
/**
 * 处理token刷新问题
 */
var token;
(function (token) {
    /**
     * 刷新token
     */
    function refreshToken() {
        return new Promise(function (c, e) {
            sendToApp("refreshToken", function (data) {
                c(data);
            });
        });
    }
    token.refreshToken = refreshToken;
    /**
     * 获取设备Token
     */
    function getDeviceToken() {
        return new Promise(function (c, e) {
            sendToApp("getDeviceToken", function (data) {
                c(data);
            });
        });
    }
    token.getDeviceToken = getDeviceToken;
})(token || (token = {}));
var iosurl;
(function (iosurl) {
    /** 缓存当前base64图像信息 */
    var base64Cache = {};
    /**
     * 为了解决跨域的问题，将服务器的地址传给原生，让原生将其转化为base64,再传过来
     * 这里添加缓存机制，避免大量请求造成的原生压力过大
     * @param url
     */
    function transformUrlToBase64(url) {
        return new Promise(function (c, e) {
            if (!base64Cache[url]) {
                sendToApp("transformUrlToBase64", { url: url }, function (data) {
                    base64Cache[url] = data;
                    c(data);
                });
            }
            else {
                console.log("[\u4ECE\u7F13\u5B58\u5730\u5740:" + url + "\u4E2D\u8BFB\u53D6base64\u503C\uFF01]");
                c(base64Cache[url]);
            }
        });
    }
    iosurl.transformUrlToBase64 = transformUrlToBase64;
})(iosurl || (iosurl = {}));
var user;
(function (user) {
    /**
     * 设置用户信息
     * @param userInfo 用户信息 第一版暂时只添加userId
     */
    function setUserInfo(userInfo) {
        return new Promise(function (c, e) {
            sendToApp("setUserInfo", userInfo, function (data) {
                c(data);
            });
        });
    }
    user.setUserInfo = setUserInfo;
})(user || (user = {}));
var vibrate;
(function (vibrate) {
    /**
     * 使手机发生较短时间的振动（15 ms）。仅在 iPhone 7 / 7 Plus 以上机型生效
     * vibrateShort针对iOS13增加体验更好的软震动
     * iOS 自13.0开始在震动反馈 UIImpactFeedbackGenerator 中增加了软震动类型 UIImpactFeedbackStyleSoft，这种震动类型在游戏中常有更好的体验
     */
    function vibrateShort() {
        return new Promise(function (c, e) {
            sendToApp("vibrateShort", function (data) {
                c(data);
            });
        });
    }
    vibrate.vibrateShort = vibrateShort;
    /**
     * 使手机发生较长时间的振动（400 ms)
     */
    function vibrateLong() {
        return new Promise(function (c, e) {
            sendToApp("vibrateLong", function (data) {
                c(data);
            });
        });
    }
    vibrate.vibrateLong = vibrateLong;
})(vibrate || (vibrate = {}));
/**
 * 处理webview相关数据
 */
var webview;
(function (webview) {
    /**
     * 关闭当前webview
     */
    function closeWebview() {
        return new Promise(function (c, e) {
            sendToApp("closeWebview", function (data) {
                c(data);
            });
        });
    }
    webview.closeWebview = closeWebview;
    /**
     * 打开某个地址的webview
     * @param url
     */
    function openWebview(url) {
        return new Promise(function (c, e) {
            sendToApp("openWebview", { url: url }, function (data) {
                c(data);
            });
        });
    }
    webview.openWebview = openWebview;
})(webview || (webview = {}));
var withdraw;
(function (withdraw) {
    /**
     * 打开提现
     */
    function openWithdraw() {
        return new Promise(function (c, e) {
            sendToApp("openWithdraw", function (data) {
                c(data);
            });
        });
    }
    withdraw.openWithdraw = openWithdraw;
})(withdraw || (withdraw = {}));
/**
 * 微信登陆
 */
var ioswx;
(function (ioswx) {
    /**
     * 请求微信登陆
    */
    function login() {
        return new Promise(function (c, e) {
            sendToApp("login", function (data) {
                c(data);
            });
        });
    }
    ioswx.login = login;
    /**
    * 打开微信
    */
    function openWechat() {
        return new Promise(function (c, e) {
            sendToApp("openWechat", function (data) {
                c(data);
            });
        });
    }
    ioswx.openWechat = openWechat;
})(ioswx || (ioswx = {}));
