#ifdef GL_ES
precision mediump float;
#endif

varying vec2 v_texCoord;
uniform sampler2D u_texture;

void main()
{
    vec4 normalColor = texture2D(u_texture, v_texCoord);
    float r = normalColor.r;
    float g = normalColor.g;
    float b = normalColor.b;
    float sepiaDepth = 17.0;
    float sepiaIntensity = 23.0;
    if(normalColor.a >= 64.0/255.0)
    {
        float gray = (0.2 * normalColor.r) + (0.7 * normalColor.g) + (0.1 * normalColor.b);
        r = gray+2.0*sepiaDepth/255.0;
        if(r>1.0)
            r = 1.0;
        g = gray+sepiaDepth/255.0;
        if(g>1.0)
            g = 1.0;

        b = gray-sepiaIntensity/255.0;
        if(b>1.0)
            b = 1.0;
        if(b<0.0)
            b = 0.0;
    }
    gl_FragColor = vec4(r, g, b, normalColor.a);
}