// 1. Reads from a screen texture with a sin wave offset.
// 2. Applies a colour key.
// 3. Applies an alpha. 

#ifdef Z_SL_OPENGLES

	// --- Uniforms

	uniform highp mat4 u_ModelViewProjection;

	uniform highp mat4 u_Model;

	uniform lowp sampler2D u_ScreenTexture;

	uniform lowp sampler2D u_ColourKeyTexture;

	uniform lowp sampler2D u_AlphaTexture;

	uniform lowp sampler2D u_WavesOffsetMask;

	uniform lowp vec4 u_ColourKey;

	uniform lowp float u_Alpha;

	uniform lowp sampler2D u_SineTexture;

	uniform highp float u_WavesMaxOffset;

	uniform highp float u_WavesSinOffset;

	uniform highp vec2 u_WavesSinOffsetByPosition;

	// --- Attributes
	
	#ifdef Z_SHADER_VERTEX 

		attribute highp vec4 a_Position;

		attribute highp vec2 a_TexCoords;  // ColourKeyTexture

		attribute highp vec2 a_TexCoords2; // AlphaTexture
	
		attribute highp vec2 a_TexCoords3; // ScreenTexture

		attribute highp vec2 a_TexCoords4; // WavesOffsetMask
		
	#endif
		
	// --- Varyings
	
	varying highp vec2 v_SinOffset;
	varying highp vec2 v_TexCoords;
	varying highp vec2 v_TexCoords2;
	varying highp vec2 v_TexCoords3;
	varying highp vec2 v_TexCoords4;
		
	// --- Main
	
	#ifdef Z_SHADER_VERTEX

		void main()
		{
			gl_Position = u_ModelViewProjection * a_Position;
			highp vec4 worldPosition = u_Model * a_Position;
			v_SinOffset = vec2(u_WavesSinOffset + dot(u_WavesSinOffsetByPosition, worldPosition.xy), 0.0);
			v_TexCoords = a_TexCoords;
			v_TexCoords2 = a_TexCoords2;
			v_TexCoords3 = a_TexCoords3;
			v_TexCoords4 = a_TexCoords4;
		}
		
	#else
	
		lowp float Luminance(lowp vec3 colour)
		{
			lowp vec3 luminanceFunc = vec3(0.299, 0.587, 0.114);
			lowp float luminance = dot(luminanceFunc, colour);
			return luminance;
		}

		lowp vec3 ColourKey(lowp vec3 colour, lowp vec3 keyColour, lowp float intensity)
		{
			lowp float luminance = Luminance(colour);
			return mix(colour, luminance * keyColour, intensity);
		}

		void main()
		{
			highp vec2 screenTexCoords = v_TexCoords3;
			lowp float wavesOffsetTexValue = texture2D(u_WavesOffsetMask, v_TexCoords4).r;

			lowp float sineTexValue = texture2D(u_SineTexture, v_SinOffset).a;
            // lowp float sineValue = (2.0 * sineTexValue - 1.0); // 2.0 overflows lowp.
            lowp float sineValue = (sineTexValue - 1.0) + sineTexValue;
			screenTexCoords.x += wavesOffsetTexValue * u_WavesMaxOffset * sineValue;

			lowp vec3 screenTexValue = texture2D(u_ScreenTexture, screenTexCoords).rgb;

			lowp vec4 colourKeyTexValue = texture2D(u_ColourKeyTexture, v_TexCoords);
			lowp float alphaTexValue = texture2D(u_AlphaTexture, v_TexCoords2).r;

			lowp vec4 colourKey = colourKeyTexValue * u_ColourKey;
			lowp vec3 withColourKey = ColourKey(screenTexValue, colourKey.rgb, colourKey.a);
			
			lowp float alpha = u_Alpha * alphaTexValue;

			gl_FragColor = vec4(withColourKey, alpha);
			//gl_FragColor = vec4(wavesOffsetTexValue, wavesOffsetTexValue, wavesOffsetTexValue, 1.0);
			//gl_FragColor = vec4(alphaTexValue, alphaTexValue, alphaTexValue, 1.0);
		}
		
	#endif
		
#endif